/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.templates.list;

import com.nokia.lwuit.templates.list.BasicListItem;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class NokiaListCellRenderer
extends Component
implements ListCellRenderer {
    private int cache_size = 20;
    private NokiaListCellRenderer mFocusComponent;
    private String mText = "";
    private Image mImage;
    private String ellipsis = "...";
    private int ellipsisWidth = 0;
    private static Hashtable shorteningCache = new Hashtable(20);

    public NokiaListCellRenderer() {
        this.setUIID("ListRenderer");
        this.setCellRenderer(true);
        this.ellipsisWidth = this.getStyle().getFont().stringWidth(this.ellipsis);
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().setFG(g, this);
        Style style = this.getStyle();
        boolean rtl = this.isRTL();
        int gap = 5;
        int leftPadding = style.getPadding(rtl, 1);
        int rightPadding = style.getPadding(rtl, 3);
        int topPadding = style.getPadding(false, 0);
        int bottomPadding = style.getPadding(false, 2);
        Font font = style.getFont();
        int align = this.reverseAlignForBidi(style.getAlignment());
        int width = this.getWidth();
        int height = this.getHeight();
        int textSpace = width;
        if (this.mImage != null) {
            textSpace -= this.mImage.getWidth();
        }
        textSpace = textSpace - leftPadding - rightPadding;
        this.mText = this.shortenString(this.mText, textSpace, font);
        int textWidth = font.stringWidth(this.mText);
        int x = 0;
        int y = this.getY() + topPadding;
        switch (align) {
            case 1: {
                x = this.getX() + leftPadding;
                if (this.mImage == null) break;
                x += this.mImage.getWidth() + gap;
                break;
            }
            case 3: {
                x = this.getX() + width - leftPadding - textWidth;
                if (this.mImage == null || !rtl) break;
                x -= this.mImage.getWidth() - gap;
                break;
            }
            case 4: {
                x = this.getX() + width / 2 - textWidth / 2;
                if (this.mImage == null) break;
                if (rtl) {
                    x -= this.mImage.getWidth() - gap;
                    break;
                }
                x += this.mImage.getWidth() + gap;
                break;
            }
            default: {
                x = this.getX();
            }
        }
        if (this.mImage != null) {
            y = this.getY() + (this.getHeight() - bottomPadding - topPadding) / 2 - this.mImage.getHeight() / 2 + topPadding;
            if (rtl) {
                g.drawImage(this.mImage, this.getX() + this.getWidth() - rightPadding - this.mImage.getWidth(), y);
            } else {
                g.drawImage(this.mImage, this.getX() + leftPadding, y);
            }
            y = this.getY() + (this.getHeight() - bottomPadding - topPadding) / 2 - font.getHeight() / 2 + topPadding;
        }
        g.drawString(this.mText, x, y, this.getStyle().getTextDecoration());
    }

    public void repaint() {
    }

    public void repaint(int x, int y, int w, int h) {
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        if (!Display.getInstance().shouldRenderSelection(list)) {
            isSelected = false;
        }
        this.setFocus(isSelected);
        if (value instanceof BasicListItem) {
            BasicListItem data = (BasicListItem)value;
            this.mText = data.getText();
            this.mImage = data.getImage();
        } else if (value instanceof Command) {
            Command c = (Command)value;
            this.mText = c.getCommandName();
            this.mImage = c.getIcon();
        } else if (value != null) {
            this.mText = value.toString();
            this.mImage = null;
        } else {
            this.mText = "";
            this.mImage = null;
        }
        return this;
    }

    public Component getListFocusComponent(List list) {
        if (this.mFocusComponent == null) {
            this.mFocusComponent = new NokiaListCellRenderer();
            this.mFocusComponent.setUIID("ListRendererFocus");
            this.mFocusComponent.setFocus(true);
            this.mFocusComponent.setCellRenderer(true);
        }
        return this.mFocusComponent;
    }

    protected Dimension calcPreferredSize() {
        Style s = this.getStyle();
        Font f = s.getFont();
        int w = 0;
        int h = 0;
        w += s.getPadding(1) + s.getPadding(3) + f.stringWidth(this.mText);
        h += s.getPadding(0) + s.getPadding(2) + f.getHeight();
        if (this.mImage != null) {
            h = Math.max(h, this.mImage.getHeight() + s.getPadding(0) + s.getPadding(2));
            w = Math.max(w, this.mImage.getWidth() + f.stringWidth(this.mText) + s.getPadding(1) + s.getPadding(3));
        }
        return new Dimension(w, h);
    }

    private int reverseAlignForBidi(int align) {
        if (this.isRTL()) {
            switch (align) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return align;
    }

    private String shortenString(String original, int width, Font font) {
        if (font.stringWidth(original) <= width) {
            return original;
        }
        if (shorteningCache.containsKey(original)) {
            return (String)shorteningCache.get(original);
        }
        int widestCharWidth = font.charWidth('W');
        int index = original.length() - 1;
        int targetWidth = width - this.ellipsisWidth;
        while (!this.doesStringFit(original, index, widestCharWidth, targetWidth, font)) {
            --index;
        }
        String ret = original.substring(0, index) + this.ellipsis;
        if (shorteningCache.size() > this.cache_size) {
            shorteningCache.clear();
        }
        shorteningCache.put(original, ret);
        return ret;
    }

    private boolean doesStringFit(String s, int length, int widestCharWidth, int width, Font f) {
        if (length * widestCharWidth < width) {
            return true;
        }
        return f.stringWidth(s.substring(0, length)) < width;
    }

    public void setStringCache(int c) {
        this.cache_size = c;
    }
}

