/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class Image {
    private Object rgbCache;
    private Object image;
    int transform;
    private boolean opaqueTested = false;
    private boolean opaque;
    private Object scaleCache;
    private boolean animated;
    private long imageTime = -1L;
    private String svgBaseURL;
    private byte[] svgData;

    protected Image(Object image) {
        this.image = image;
        this.animated = Display.getInstance().getImplementation().isAnimation(image);
    }

    Image(int[] imageArray, int w, int h) {
        this(Display.getInstance().getImplementation().createImage(imageArray, w, h));
    }

    private Hashtable getScaleCache() {
        if (this.scaleCache == null) {
            Hashtable h = new Hashtable();
            this.scaleCache = Display.getInstance().createSoftWeakRef(h);
            return h;
        }
        Hashtable h = (Hashtable)Display.getInstance().extractHardRef(this.scaleCache);
        if (h == null) {
            h = new Hashtable();
            this.scaleCache = Display.getInstance().createSoftWeakRef(h);
        }
        return h;
    }

    Image getCachedImage(Dimension size) {
        Object w = this.getScaleCache().get(size);
        return (Image)Display.getInstance().extractHardRef(w);
    }

    void cacheImage(Dimension size, Image i) {
        Object w = Display.getInstance().createSoftWeakRef(i);
        this.getScaleCache().put(size, w);
    }

    public void lock() {
    }

    public void unlock() {
    }

    void setImage(Object image) {
        this.image = image;
    }

    void setOpaque(boolean opaque) {
        this.opaque = opaque;
        this.opaqueTested = true;
    }

    public static boolean isSVGSupported() {
        return Display.getInstance().getImplementation().isSVGSupported();
    }

    public Object getSVGDocument() {
        return Display.getInstance().getImplementation().getSVGDocument(this.image);
    }

    public static Image createSVG(String baseURL, boolean animated, byte[] data) throws IOException {
        Image i = new Image(Display.getInstance().getImplementation().createSVGImage(baseURL, data));
        i.animated = animated;
        i.svgBaseURL = baseURL;
        i.svgData = data;
        return i;
    }

    public boolean isSVG() {
        return this.svgData != null;
    }

    public Object createMask() {
        int[] rgb = this.getRGBCached();
        byte[] mask = new byte[rgb.length];
        for (int iter = 0; iter < rgb.length; ++iter) {
            mask[iter] = (byte)(rgb[iter] & 0xFF);
        }
        return new IndexedImage(this.getWidth(), this.getHeight(), null, mask);
    }

    public Image applyMask(Object mask, int x, int y) {
        int[] rgb = this.getRGB();
        byte[] maskData = ((IndexedImage)mask).getImageDataByte();
        int mWidth = ((IndexedImage)mask).getWidth();
        int mHeight = ((IndexedImage)mask).getHeight();
        int imgWidth = this.getWidth();
        int aWidth = imgWidth - x;
        int aHeight = this.getHeight() - y;
        if (aWidth > mWidth) {
            aWidth = mWidth;
        }
        if (aHeight > mHeight) {
            aHeight = mHeight;
        }
        for (int xPos = 0; xPos < aWidth; ++xPos) {
            for (int yPos = 0; yPos < aHeight; ++yPos) {
                int aX = x + xPos;
                int aY = y + yPos;
                int imagePos = aX + aY * imgWidth;
                int maskAlpha = maskData[aX + aY * mWidth] & 0xFF;
                maskAlpha = maskAlpha << 24 & 0xFF000000;
                rgb[imagePos] = rgb[imagePos] & 0xFFFFFF | maskAlpha;
            }
        }
        return Image.createImage(rgb, imgWidth, this.getHeight());
    }

    public Image applyMask(Object mask) {
        int[] rgb = this.getRGB();
        byte[] maskData = ((IndexedImage)mask).getImageDataByte();
        int mWidth = ((IndexedImage)mask).getWidth();
        int mHeight = ((IndexedImage)mask).getHeight();
        if (mWidth != this.getWidth() || mHeight != this.getHeight()) {
            throw new IllegalArgumentException("Mask and image sizes don't match");
        }
        for (int iter = 0; iter < maskData.length; ++iter) {
            int maskAlpha = maskData[iter] & 0xFF;
            maskAlpha = maskAlpha << 24 & 0xFF000000;
            rgb[iter] = rgb[iter] & 0xFFFFFF | maskAlpha;
        }
        return Image.createImage(rgb, mWidth, mHeight);
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        int[] arr = new int[width * height];
        this.getRGB(arr, 0, x, y, width, height);
        Image i = new Image(Display.getInstance().getImplementation().createImage(arr, width, height));
        i.opaque = this.opaque;
        i.opaqueTested = this.opaqueTested;
        return i;
    }

    public Image rotate(int degrees) {
        LWUITImplementation i = Display.getInstance().getImplementation();
        if (i.isRotationDrawingSupported()) {
            if (degrees >= 90) {
                int newTransform = 0;
                newTransform = this.transform != 0 ? (this.transform + degrees) % 360 : degrees % 360;
                newTransform -= (degrees %= 90);
                if (degrees != 0) {
                    Image newImage = new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
                    newImage.transform = newTransform;
                    return newImage;
                }
                Image newImage = new Image(this.image);
                newImage.transform = newTransform;
                return newImage;
            }
            if (degrees != 0) {
                return new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
            }
            return this;
        }
        return new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
    }

    public static Image createIndexed(int width, int height, int[] palette, byte[] data) {
        IndexedImage i = new IndexedImage(width, height, palette, data);
        LWUITImplementation impl = Display.getInstance().getImplementation();
        if (impl.isNativeIndexed()) {
            return new Image(impl.createNativeIndexed(i));
        }
        return i;
    }

    public Image modifyAlpha(byte alpha) {
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w * h;
        int[] arr = this.getRGB();
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < size; ++iter) {
            int currentAlpha = arr[iter] >> 24 & 0xFF;
            if (currentAlpha == 0) continue;
            arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
        }
        Image i = new Image(arr, w, h);
        i.opaqueTested = true;
        i.opaque = false;
        return i;
    }

    public Image modifyAlphaWithTranslucency(byte alpha) {
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w * h;
        int[] arr = this.getRGB();
        int alphaInt = alpha << 24 & 0xFF000000;
        float alphaRatio = alpha & 0xFF;
        alphaRatio = (float)(alpha & 0xFF) / 255.0f;
        for (int iter = 0; iter < size; ++iter) {
            int currentAlpha = arr[iter] >> 24 & 0xFF;
            if (currentAlpha == 0) continue;
            if (currentAlpha == 255) {
                arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
                continue;
            }
            int relative = (int)((float)currentAlpha * alphaRatio);
            relative = relative << 24 & 0xFF000000;
            arr[iter] = arr[iter] & 0xFFFFFF | relative;
        }
        Image i = new Image(arr, w, h);
        i.opaqueTested = true;
        i.opaque = false;
        return i;
    }

    public Image modifyAlpha(byte alpha, int removeColor) {
        removeColor &= 0xFFFFFF;
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w * h;
        int[] arr = new int[size];
        this.getRGB(arr, 0, 0, 0, w, h);
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < size; ++iter) {
            if ((arr[iter] & 0xFF000000) == 0) continue;
            arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
            if (removeColor != (0xFFFFFF & arr[iter])) continue;
            arr[iter] = 0;
        }
        Image i = new Image(arr, w, h);
        i.opaqueTested = true;
        i.opaque = false;
        return i;
    }

    public static Image createImage(String path) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(path));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(path));
        }
    }

    public static Image createImage(Object nativeImage) {
        return new Image(nativeImage);
    }

    public static Image createImage(InputStream stream) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(stream));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(stream));
        }
    }

    public static Image createImage(int[] rgb, int width, int height) {
        try {
            Image i = new Image(Display.getInstance().getImplementation().createImage(rgb, width, height));
            return i;
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(rgb, width, height));
        }
    }

    public static Image createImage(int width, int height) {
        return Image.createImage(width, height, -1);
    }

    public static boolean isAlphaMutableImageSupported() {
        return Display.getInstance().getImplementation().isAlphaMutableImageSupported();
    }

    public static Image createImage(int width, int height, int fillColor) {
        try {
            return new Image(Display.getInstance().getImplementation().createMutableImage(width, height, fillColor));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createMutableImage(width, height, fillColor));
        }
    }

    public static Image createImage(byte[] bytes, int offset, int len) {
        try {
            Object o = Display.getInstance().getImplementation().createImage(bytes, offset, len);
            if (o == null) {
                throw new IllegalArgumentException("create image failed for the given image data of length: " + len);
            }
            return new Image(o);
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(bytes, offset, len));
        }
    }

    public Graphics getGraphics() {
        return new Graphics(Display.getInstance().getImplementation().getNativeGraphics(this.image));
    }

    public int getWidth() {
        if (this.transform != 0 && (this.transform == 90 || this.transform == 270)) {
            return Display.getInstance().getImplementation().getImageHeight(this.image);
        }
        return Display.getInstance().getImplementation().getImageWidth(this.image);
    }

    public int getHeight() {
        if (this.transform != 0 && (this.transform == 90 || this.transform == 270)) {
            return Display.getInstance().getImplementation().getImageWidth(this.image);
        }
        return Display.getInstance().getImplementation().getImageHeight(this.image);
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        g.drawImage(this.image, x, y, this.transform);
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
        g.drawImageWH(this.image, x, y, w, h);
    }

    void drawImageArea(Graphics g, Object nativeGraphics, int x, int y, int imageX, int imageY, int imageWidth, int imageHeight) {
        Display.getInstance().getImplementation().drawImageArea(nativeGraphics, this.image, x, y, imageX, imageY, imageWidth, imageHeight);
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        Display.getInstance().getImplementation().getRGB(this.image, rgbData, offset, x, y, width, height);
    }

    public void toRGB(RGBImage image, int destX, int destY, int x, int y, int width, int height) {
        this.getRGB(image.getRGB(), destX * destY, x, y, width, height);
    }

    public int[] getRGB() {
        return this.getRGBImpl();
    }

    public int[] getRGBCached() {
        int[] r = this.getRGBCache();
        if (r == null) {
            r = this.getRGBImpl();
            this.rgbCache = Display.getInstance().createSoftWeakRef(r);
        }
        return r;
    }

    int[] getRGBCache() {
        if (this.rgbCache != null) {
            int[] rgb = (int[])Display.getInstance().extractHardRef(this.rgbCache);
            return rgb;
        }
        return null;
    }

    int[] getRGBImpl() {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] rgbData = new int[width * height];
        this.getRGB(rgbData, 0, 0, 0, width, height);
        return rgbData;
    }

    public Image scaledWidth(int width) {
        float ratio = (float)width / (float)this.getWidth();
        return this.scaled(width, Math.max(1, (int)((float)this.getHeight() * ratio)));
    }

    public Image scaledHeight(int height) {
        float ratio = (float)height / (float)this.getHeight();
        return this.scaled(Math.max(1, (int)((float)this.getWidth() * ratio)), height);
    }

    public Image scaledSmallerRatio(int width, int height) {
        float wRatio;
        float hRatio = (float)height / (float)this.getHeight();
        if (hRatio < (wRatio = (float)width / (float)this.getWidth())) {
            return this.scaled((int)((float)this.getWidth() * hRatio), (int)((float)this.getHeight() * hRatio));
        }
        return this.scaled((int)((float)this.getWidth() * wRatio), (int)((float)this.getHeight() * wRatio));
    }

    public Image scaled(int width, int height) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return this;
        }
        if (width == -1) {
            return this.scaledHeight(height);
        }
        if (height == -1) {
            return this.scaledWidth(width);
        }
        Dimension d = new Dimension(width, height);
        Image i = this.getCachedImage(d);
        if (i != null) {
            return i;
        }
        if (this.svgData != null) {
            try {
                i = Image.createSVG(this.svgBaseURL, this.animated, this.svgData);
            }
            catch (IOException ex) {
                i = new Image(this.image);
            }
        } else {
            i = new Image(this.image);
        }
        i.scaleCache = this.scaleCache;
        i.scale(width, height);
        i.transform = this.transform;
        i.animated = this.animated;
        i.svgBaseURL = this.svgBaseURL;
        i.svgData = this.svgData;
        this.cacheImage(new Dimension(width, height), i);
        return i;
    }

    public Object getImage() {
        return this.image;
    }

    public void scale(int width, int height) {
        this.image = Display.getInstance().getImplementation().scale(this.image, width, height);
    }

    boolean scaleArray(int srcWidth, int srcHeight, int height, int width, int[] currentArray, int[] destinationArray) {
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int xPos = xRatio / 2;
        int yPos = yRatio / 2;
        boolean testOpaque = Display.getInstance().numColors() <= 65536 && !this.opaqueTested;
        boolean currentOpaque = true;
        for (int y = 0; y < height; ++y) {
            int srcY = yPos >> 16;
            this.getRGB(currentArray, 0, 0, srcY, srcWidth, 1);
            for (int x = 0; x < width; ++x) {
                int srcX = xPos >> 16;
                int destPixel = x + y * width;
                if (destPixel >= 0 && destPixel < destinationArray.length && srcX < currentArray.length) {
                    destinationArray[destPixel] = currentArray[srcX];
                    currentOpaque = testOpaque && currentOpaque && (currentArray[srcX] & 0xFF000000) == -16777216;
                }
                xPos += xRatio;
            }
            yPos += yRatio;
            xPos = xRatio / 2;
        }
        if (testOpaque) {
            this.opaque = currentOpaque;
        }
        return this.opaque;
    }

    public boolean isAnimation() {
        return this.animated;
    }

    public boolean animate() {
        if (this.imageTime == -1L) {
            this.imageTime = System.currentTimeMillis();
        }
        boolean val = Display.getInstance().getImplementation().animateImage(this.image, this.imageTime);
        this.imageTime = System.currentTimeMillis();
        return val;
    }

    public boolean isOpaque() {
        if (!this.opaqueTested) {
            this.opaque = Display.getInstance().getImplementation().isOpaque(this, this.image);
            this.opaqueTested = true;
        }
        return this.opaque;
    }
}

