/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.nokia.lwuit.TextEditorProvider;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.s40.S40Implementation;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class TextArea
extends Component
implements TextEditorProvider.TextEditorListener,
FocusListener {
    private static int defaultValign = 0;
    private int valign = defaultValign;
    private static int defaultMaxSize = 124;
    private static boolean autoDegradeMaxSize = false;
    private static boolean hadSuccessfulEdit = false;
    private int linesToScroll = 1;
    private static final char ENTER_KEY = '\n';
    private String unsupportedChars = "\t\r";
    private static boolean useStringWidth;
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    private int constraint = 0;
    private String text = "";
    private boolean editable = true;
    private int maxSize = defaultMaxSize;
    private int rows = 1;
    private int columns = 3;
    private Vector rowStrings;
    private int widthForRowCalculations = -1;
    private int rowsGap = 2;
    private boolean triggerClose;
    private Vector actionListeners = null;
    private boolean growByContent = true;
    private static char widestChar;
    private boolean singleLineTextArea;
    private int currentRowWidth;
    private int caretPosition = -1;
    private Label hintLabel;
    private TextEditorProvider textEditor;
    private int visibleContentPosition;
    private boolean textEditorEnabled = true;
    private boolean dontWaitForKeyReleased = false;
    int leftPadding;
    int rightPadding;
    int topPadding;
    int bottomPadding;
    private Command clearCommand;
    private String clearText = UIManager.getInstance().localize("clear", "Clear");
    private Command selectCommand;
    private ActionListener dragListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (TextArea.this.isTextEditorActive()) {
                TextArea.this.hideTextEditor();
            }
        }
    };
    private ActionListener showListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (Display.getInstance().getDeviceType() != 0) {
                TextArea.this.ensureTextEditorIsShown();
            }
        }
    };

    public static int getDefaultValign() {
        return defaultValign;
    }

    public static void setDefaultValign(int aDefaultValign) {
        defaultValign = aDefaultValign;
    }

    public TextArea(int rows, int columns) {
        this("", defaultMaxSize, rows, columns, 0);
    }

    public TextArea(int rows, int columns, int constraint) {
        this("", defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, defaultMaxSize, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int constraint) {
        this(text, defaultMaxSize, rows, columns, constraint);
    }

    public TextArea(String text, int maxSize) {
        this(text, maxSize, 1, 3, 0);
    }

    public TextArea(String text) {
        this(text, Math.max(defaultMaxSize, text.length()), 1, 3, 0);
    }

    public TextArea() {
        this("");
    }

    private TextArea(String text, int maxSize, int rows, int columns, int constraint) {
        this.setUIID("TextArea");
        this.setSelectCommandText(UIManager.getInstance().localize("edit", "Edit"));
        this.maxSize = maxSize;
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be positive");
        }
        if (columns <= 1 && rows != 1) {
            throw new IllegalArgumentException("columns must be larger than 1");
        }
        this.rows = rows;
        this.columns = columns;
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
        try {
            this.setText(text);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        this.addFocusListener(this);
        this.setGrowByContent(false);
        this.setConstraint(constraint);
    }

    public void setConstraint(int constraint) {
        this.constraint = constraint;
        if (this.textEditor != null) {
            this.textEditor.setConstraints(constraint);
        }
    }

    public int getConstraint() {
        return this.constraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String t) {
        String string = this.text = t != null ? t : "";
        if (this.maxSize < this.text.length()) {
            this.maxSize = this.text.length() + 1;
            if (this.textEditor != null) {
                this.textEditor.setMaxSize(this.maxSize);
            }
        }
        TextArea textArea = this;
        synchronized (textArea) {
            this.rowStrings = null;
        }
        if (this.isTextEditorActive() && !this.textEditor.getContent().equals(this.text)) {
            this.textEditor.setContent(this.text);
            this.textEditor.setCaret(this.text.length());
        }
        this.setShouldCalcPreferredSize(true);
    }

    public String getText() {
        return this.text;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        if (!b) {
            this.constraint |= 0x20000;
        } else if ((this.constraint & 0x20000) != 0) {
            this.constraint &= 0xFFFDFFFF;
        }
        this.setConstraint(this.constraint);
        this.editable = b;
        this.setEnabled(this.editable);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (this.textEditor != null) {
            this.textEditor.setMaxSize(maxSize);
        }
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int action = Display.getInstance().getGameAction(keyCode);
        this.triggerClose = action == 8;
        Rectangle rect = new Rectangle(this.getScrollX(), this.getScrollY(), this.getWidth(), this.getHeight());
        Font textFont = this.getStyle().getFont();
        if (action == 6) {
            if (this.getScrollY() + this.getHeight() < (this.rowsGap + this.getStyle().getFont().getHeight()) * this.getLines()) {
                rect.setY(rect.getY() + (textFont.getHeight() + this.rowsGap) * this.linesToScroll);
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        } else if (action == 1) {
            if (this.getScrollY() > 0) {
                rect.setY(Math.max(0, rect.getY() - (textFont.getHeight() + this.rowsGap) * this.linesToScroll));
                this.scrollRectToVisible(rect, this);
            } else {
                this.setHandlesInput(false);
            }
        }
        if (action == 5 || action == 2) {
            this.setHandlesInput(false);
        }
    }

    protected void fireClicked() {
        this.onClick();
    }

    protected boolean isSelectableInteraction() {
        return this.editable;
    }

    public void keyReleased(int keyCode) {
        if (!this.textEditorEnabled) {
            int action = Display.getInstance().getGameAction(keyCode);
            if (this.isEditable()) {
                if (this.triggerClose && (action == 8 || this.isEnterKey(keyCode))) {
                    this.triggerClose = false;
                    this.onClick();
                    return;
                }
                if (action == 0 && keyCode > 0) {
                    Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText(), keyCode);
                }
            }
        }
    }

    public boolean isScrollableY() {
        if (this.textEditorEnabled) {
            return false;
        }
        return this.isFocusable() && this.getScrollDimension().getHeight() > this.getHeight();
    }

    void onClick() {
        if (this.isEditable()) {
            this.editString();
        }
    }

    void editString() {
        if (this.textEditor == null) {
            if (autoDegradeMaxSize && !hadSuccessfulEdit && this.maxSize > 1024) {
                try {
                    Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
                }
                catch (IllegalArgumentException err) {
                    this.maxSize -= 1024;
                    TextArea.setDefaultMaxSize(this.maxSize);
                    this.editString();
                }
            } else {
                Display.getInstance().editString(this, this.getMaxSize(), this.getConstraint(), this.getText());
            }
        } else if (Display.getInstance().getDeviceType() == 0) {
            if (!this.isTextEditorActive()) {
                this.setOkAsSelectCommand();
                this.focusTextEditor();
            } else {
                this.setEditAsSelectCommand();
                this.hideTextEditor();
            }
        }
    }

    private void setOkAsSelectCommand() {
        if (this.selectCommand != null) {
            this.getComponentForm().removeCommand(this.selectCommand);
        }
        this.getComponentForm().removeCommand(this.getComponentForm().getMenuBar().getSelectCommand());
        this.getComponentForm().getMenuBar().addSelectCommand(UIManager.getInstance().localize("OK", "OK"));
        this.selectCommand = this.getComponentForm().getMenuBar().getSelectCommand();
    }

    private void setEditAsSelectCommand() {
        if (this.selectCommand != null) {
            this.getComponentForm().removeCommand(this.selectCommand);
        }
        this.getComponentForm().removeCommand(this.getComponentForm().getMenuBar().getSelectCommand());
        this.getComponentForm().getMenuBar().addSelectCommand(UIManager.getInstance().localize("Edit", "Edit"));
        this.selectCommand = this.getComponentForm().getMenuBar().getSelectCommand();
    }

    private void changeEditBackIfOkInSelect() {
        if (this.selectCommand != null && this.selectCommand.getCommandName().equals(UIManager.getInstance().localize("OK", "OK"))) {
            this.setEditAsSelectCommand();
        }
    }

    public void pointerHover(int[] x, int[] y) {
        if (!this.textEditorEnabled) {
            this.requestFocus();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerReleased(int x, int y) {
        if (this.textEditor != null && this.textEditor.hasFocus()) {
            return;
        }
        if (this.isDragActivated()) {
            super.pointerReleased(x, y);
        } else {
            super.pointerReleased(x, y);
            if (this.isEditable() && this.isEnabled() && !this.isCellRenderer()) {
                if (this.textEditorEnabled) {
                    this.onClick();
                } else if (Display.getInstance().isTouchScreenDevice()) {
                    if (!Display.getInstance().isVirtualKeyboardShowing()) {
                        Display.getInstance().setShowVirtualKeyboard(true);
                    }
                } else {
                    this.onClick();
                }
            }
            if (this.isInitialized()) {
                this.focusTextEditor();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.setDragActivated(false);
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.setDragActivated(true);
        this.hideTextEditor();
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        this.setHandlesInput(this.isScrollableY());
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.setHandlesInput(false);
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized int getLines() {
        int l = this.getRowStrings().size();
        return l;
    }

    public int getActualRows() {
        if (this.growByContent) {
            return Math.max(this.rows, this.getLines());
        }
        return this.rows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        this.setShouldCalcPreferredSize(true);
        this.columns = columns;
    }

    public void setRows(int rows) {
        this.setShouldCalcPreferredSize(true);
        this.rows = rows;
        if (this.textEditor != null) {
            this.textEditor.setMultiline(rows > 1);
        }
    }

    void initComponentImpl() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.addPointerDraggedListener(this.dragListener);
            f.addShowListener(this.showListener);
        }
        this.initTextEditor();
        super.initComponentImpl();
        this.setShouldCalcPreferredSize(true);
    }

    private void initTextEditor() {
        if (this.textEditor == null && Display.getInstance().getImplementation() instanceof S40Implementation) {
            S40Implementation impl = (S40Implementation)Display.getInstance().getImplementation();
            this.textEditor = impl.requestNewNativeTextEditor(this.maxSize, this.constraint, 100, this.rows);
        }
        if (this.textEditor != null) {
            this.setRowsGap(this.textEditor.getLineMarginHeight());
            this.updateTextAreaStyles();
            this.clearCommand = new Command(this.clearText){

                public void actionPerformed(ActionEvent evt) {
                    super.actionPerformed(evt);
                    int c = TextArea.this.textEditor.getCaretPosition();
                    if (c != 0) {
                        try {
                            TextArea.this.textEditor.delete(c - 1, 1);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        TextArea.this.textEditor.setCaret(c - 1);
                        if (TextArea.this.textEditor.getContent().length() == 0) {
                            TextArea.this.removeClearCommandFromForm();
                        }
                    }
                    evt.consume();
                }
            };
        }
    }

    private synchronized Vector getRowStrings() {
        this.updatePaddings();
        if (this.rowStrings == null || this.widthForRowCalculations != this.getWidth() - this.leftPadding - this.rightPadding) {
            this.initRowString();
            this.setShouldCalcPreferredSize(true);
        }
        return this.rowStrings;
    }

    public boolean isTextEditorActive() {
        return this.textEditor != null && this.textEditorEnabled && this.hasFocus() && this.textEditor.isVisible();
    }

    public TextEditorProvider getTextEditorProvider() {
        return this.textEditor;
    }

    public String getTextAt(int line) {
        Vector rowsV = this.getRowStrings();
        int size = rowsV.size();
        if (size == 0) {
            return "";
        }
        if (line >= size) {
            return (String)rowsV.elementAt(size - 1);
        }
        return (String)rowsV.elementAt(line);
    }

    private int indexOf(char[] t, char c, int offset, int length) {
        for (int iter = offset; iter < t.length && iter < offset + length; ++iter) {
            if (t[iter] != c) continue;
            return iter;
        }
        return -1;
    }

    protected char[] preprocess(String text) {
        return text.toCharArray();
    }

    private int updateRowWidth(char c, Font font) {
        this.currentRowWidth += font.charWidth(c);
        return this.currentRowWidth;
    }

    private boolean fastCharWidthCheck(char[] chrs, int off, int length, int width, int charWidth, Font f) {
        if (length * charWidth < width) {
            return true;
        }
        return f.charsWidth(chrs, off, length = Math.min(chrs.length, length)) < width;
    }

    private synchronized void initRowString() {
        Style style = this.getStyle();
        this.rowStrings = new Vector();
        this.widthForRowCalculations = this.getWidth() - this.leftPadding - this.rightPadding;
        if (this.widthForRowCalculations <= 0) {
            this.rowStrings.addElement(this.getText());
            return;
        }
        if (this.text == null || this.text.equals("")) {
            return;
        }
        char[] text = this.preprocess(this.getText());
        Font font = style.getFont();
        int charWidth = font.charWidth(widestChar);
        int textAreaWidth = this.getWidth() - this.leftPadding - this.rightPadding;
        int minCharactersInRow = Math.max(1, textAreaWidth / charWidth);
        int rowIndex = 0;
        int from = 0;
        int to = from + minCharactersInRow;
        int textLength = text.length;
        String rowText = null;
        String unsupported = this.getUnsupportedChars();
        to = Math.max(Math.min(textLength - 1, to), 0);
        while (to < textLength) {
            int i;
            if (to > textLength) {
                to = textLength;
            }
            int spaceIndex = -1;
            rowText = "";
            int maxLength = to;
            if (useStringWidth) {
                String currentRow = "";
                for (i = to; i < textLength && this.fastCharWidthCheck(text, from, i - from + 1, textAreaWidth, charWidth, font); ++i) {
                    int c = text[i];
                    if (font.stringWidth(currentRow = currentRow + (char)c) >= textAreaWidth) break;
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            } else {
                int c;
                this.currentRowWidth = 0;
                if (to != from) {
                    this.currentRowWidth = font.charsWidth(text, from, to - from);
                }
                for (i = to; i < textLength && this.updateRowWidth((char)(c = text[i]), font) < textAreaWidth; ++i) {
                    if (unsupported.indexOf(c) > -1) {
                        text[i] = 32;
                        c = 32;
                    }
                    if (c == 32 || c == 10) {
                        spaceIndex = i;
                        if (c == 10) break;
                    }
                    ++maxLength;
                }
            }
            if (i == textLength || text[i] == ' ' || text[i] == '\n') {
                spaceIndex = i;
            }
            if (spaceIndex != -1) {
                int newLine = this.indexOf(text, '\n', from, spaceIndex - from);
                if (newLine > -1 && newLine < spaceIndex) {
                    spaceIndex = newLine;
                }
                rowText = new String(text, from, spaceIndex - from);
                from = spaceIndex + 1;
            } else {
                for (i = to; spaceIndex == -1 && i >= from; --i) {
                    char chr = text[i];
                    if (chr != ' ' && chr != '\n' && chr != '\t') continue;
                    spaceIndex = i;
                    int newLine = this.indexOf(text, '\n', from, i - from);
                    if (newLine > -1 && newLine < spaceIndex) {
                        spaceIndex = newLine;
                    }
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex + 1;
                }
                if (spaceIndex == -1) {
                    if (maxLength <= 0) {
                        maxLength = 1;
                    }
                    spaceIndex = maxLength;
                    rowText = new String(text, from, spaceIndex - from);
                    from = spaceIndex;
                }
            }
            this.rowStrings.addElement(rowText);
            to = from;
            ++rowIndex;
        }
        if (text[text.length - 1] == '\n') {
            this.rowStrings.addElement("");
        }
    }

    public int getRowsGap() {
        return this.rowsGap;
    }

    public void setRowsGap(int rowsGap) {
        this.rowsGap = rowsGap;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawTextArea(g, this);
        this.paintHint(g);
    }

    protected void updateNativeComponentPosition() {
        this.updateTextEditorPosition();
    }

    protected Dimension calcPreferredSize() {
        Dimension d = UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, true);
        return d;
    }

    protected Dimension calcScrollSize() {
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, false);
    }

    public void addActionListener(ActionListener a2) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (!this.actionListeners.contains(a2)) {
            this.actionListeners.addElement(a2);
        }
    }

    public void removeActionListener(ActionListener a2) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.removeElement(a2);
    }

    void fireActionEvent() {
        if (this.actionListeners != null) {
            ActionEvent evt = new ActionEvent(this);
            for (int iter = 0; iter < this.actionListeners.size(); ++iter) {
                ActionListener a2 = (ActionListener)this.actionListeners.elementAt(iter);
                a2.actionPerformed(evt);
            }
        }
    }

    void onEditComplete(String text) {
        this.setText(text);
        if (this.getParent() != null) {
            this.getParent().revalidate();
        }
    }

    public static void setDefaultMaxSize(int value) {
        defaultMaxSize = value;
    }

    public boolean isGrowByContent() {
        return this.growByContent;
    }

    public void setGrowByContent(boolean growByContent) {
        this.growByContent = growByContent;
        this.setShouldCalcPreferredSize(true);
        Form f = this.getComponentForm();
        if (f != null) {
            f.layoutContainer();
            f.repaint();
        }
    }

    public static void setAutoDegradeMaxSize(boolean value) {
        autoDegradeMaxSize = value;
    }

    public static boolean isAutoDegradeMaxSize() {
        return autoDegradeMaxSize;
    }

    public String getUnsupportedChars() {
        return this.unsupportedChars;
    }

    public void setUnsupportedChars(String unsupportedChars) {
        this.unsupportedChars = unsupportedChars;
    }

    public int getLinesToScroll() {
        return this.linesToScroll;
    }

    public void setLinesToScroll(int linesToScroll) {
        if (linesToScroll < 1) {
            throw new IllegalArgumentException("lines to scroll has to be >= 1");
        }
        this.linesToScroll = linesToScroll;
    }

    public static void setWidestChar(char widestC) {
        widestChar = widestC;
    }

    public static char getWidestChar() {
        return widestChar;
    }

    public void setSingleLineTextArea(boolean singleLineTextArea) {
        this.singleLineTextArea = singleLineTextArea;
    }

    public boolean isSingleLineTextArea() {
        return this.rows == 1;
    }

    public void setAlignment(int align) {
        this.getStyle().setAlignment(align);
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public int getAbsoluteAlignment() {
        int a2 = this.getAlignment();
        if (this.isRTL()) {
            switch (a2) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return a2;
    }

    public boolean isPendingCommit() {
        return false;
    }

    public int getCursorPosition() {
        return -1;
    }

    public int getCursorY() {
        return -1;
    }

    public int getCursorX() {
        return -1;
    }

    public boolean isQwertyInput() {
        return false;
    }

    public String getInputMode() {
        return null;
    }

    public String[] getInputModeOrder() {
        return null;
    }

    public boolean isEnableInputScroll() {
        return false;
    }

    protected boolean isEnterKey(int keyCode) {
        return keyCode == 10;
    }

    public static void autoDetectWidestChar(String s) {
        Font f = UIManager.getInstance().getComponentStyle("TextArea").getFont();
        int widest = 0;
        for (int iter = 0; iter < s.length(); ++iter) {
            char c = s.charAt(iter);
            int w = f.charWidth(c);
            if (w <= widest) continue;
            widest = w;
            TextArea.setWidestChar(c);
        }
    }

    public static boolean isUseStringWidth() {
        return useStringWidth;
    }

    public static void setUseStringWidth(boolean aUseStringWidth) {
        useStringWidth = aUseStringWidth;
    }

    public void setHint(String hint) {
        super.setHint(hint, this.getHintIcon());
    }

    public String getHint() {
        return super.getHint();
    }

    public void setHintIcon(Image icon) {
        this.setHint(this.getHint(), icon);
    }

    public Image getHintIcon() {
        return super.getHintIcon();
    }

    public void setHint(String hint, Image icon) {
        super.setHint(hint, icon);
    }

    Label getHintLabelImpl() {
        return this.hintLabel;
    }

    void setHintLabelImpl(Label hintLabel) {
        this.hintLabel = hintLabel;
    }

    boolean shouldShowHint() {
        boolean showHint = this.getText().equals("");
        if (this.isTextEditorActive()) {
            String content = this.textEditor.getContent();
            showHint = content.length() == 0;
        }
        return showHint;
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 4 && valign != 0 && valign != 2) {
            throw new IllegalArgumentException("Alignment can't be set to " + valign);
        }
        this.valign = valign;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public void inputAction(TextEditorProvider textEditor, int actions) {
        if ((actions & 0x20) != 0 || (actions & 1) != 0) {
            this.repaint();
        }
        if ((actions & 0x800) != 0) {
            this.visibleContentPosition = textEditor.getVisibleContentPosition();
        }
        if ((actions & 1) != 0) {
            int rowsHeight = this.rows * (textEditor.getFont().getHeight() + textEditor.getLineMarginHeight());
            if (this.growByContent) {
                this.updatePaddings();
                textEditor.setSize(this.getWidth() - this.leftPadding - this.rightPadding, Math.max(textEditor.getContentHeight(), rowsHeight));
                this.setShouldCalcPreferredSize(true);
                Form f = this.getComponentForm();
                if (f != null) {
                    f.repaint();
                }
            }
        }
        if (this.isTextEditorActive()) {
            this.text = textEditor.getContent();
            if (this.text.length() > 0) {
                this.addClearCommandToForm();
            }
            if (this.text.length() == 0) {
                this.removeClearCommandFromForm();
            }
        }
    }

    public boolean isNativeTextEditorVisible() {
        if (this.textEditor != null) {
            return this.textEditor.isVisible();
        }
        return false;
    }

    public void setX(int x) {
        super.setX(x);
        this.updateTextEditorPosition();
    }

    public void setY(int y) {
        super.setY(y);
        this.updateTextEditorPosition();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.isTextEditorActive()) {
            this.updatePaddings();
            int width = d.getWidth() - this.leftPadding - this.rightPadding;
            int height = d.getHeight() - this.topPadding - this.bottomPadding;
            this.textEditor.setSize(width, height);
        }
    }

    public void setWidth(int width) {
        if (width == this.getWidth()) {
            return;
        }
        super.setWidth(width);
        this.setShouldCalcPreferredSize(true);
        if (this.isTextEditorActive()) {
            this.updatePaddings();
            this.textEditor.setSize(width - this.leftPadding - this.rightPadding, this.textEditor.getHeight());
        }
    }

    public void setHeight(int height) {
        if (height == this.getHeight()) {
            return;
        }
        super.setHeight(height);
        if (this.isTextEditorActive()) {
            this.updatePaddings();
            this.textEditor.setSize(this.textEditor.getWidth(), height - this.topPadding - this.bottomPadding);
        }
    }

    protected void deinitialize() {
        if (this.isTextEditorActive()) {
            this.hideTextEditor();
        }
        super.deinitialize();
        Form f = this.getComponentForm();
        if (f != null) {
            f.removePointerDraggedListener(this.dragListener);
            f.removeShowListener(this.showListener);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setFocus(boolean focused) {
        super.setFocus(focused);
    }

    public void focusGained(Component cmp) {
    }

    protected synchronized void focusTextEditor() {
        if (this.textEditor != null && this.textEditorEnabled) {
            this.dontWaitForKeyReleased = false;
            if ((this.constraint & 0x20000) == 0) {
                if (this.getText().length() > 0) {
                    this.addClearCommandToForm();
                }
                this.updatePaddings();
                this.updateTextAreaStyles();
                this.textEditor.setFocus(true);
                this.textEditor.setConstraints(this.constraint);
                this.textEditor.setMaxSize(this.maxSize);
                if (this.growByContent) {
                    this.textEditor.setMultiline(true);
                } else {
                    this.textEditor.setMultiline(this.rows > 1);
                }
                this.textEditor.setTextEditorListener(this);
                this.textEditor.setContent(this.getText());
                this.textEditor.setPosition(this.getAbsoluteX() + this.leftPadding - 1, this.getAbsoluteY() + this.topPadding);
                if (this.caretPosition > -1 && this.caretPosition <= this.textEditor.size()) {
                    this.textEditor.setCaret(this.caretPosition);
                } else {
                    this.textEditor.setCaret(this.textEditor.size());
                }
                int minHeight = this.rows * (this.textEditor.getFont().getHeight() + this.textEditor.getLineMarginHeight());
                if (this.growByContent) {
                    this.textEditor.setSize(this.getWidth() - this.leftPadding - this.rightPadding, Math.max(this.textEditor.getContentHeight(), minHeight));
                } else {
                    this.textEditor.setSize(this.getWidth() - this.leftPadding - this.rightPadding, minHeight);
                }
                this.textEditor.setVisible(true);
                this.setShouldCalcPreferredSize(true);
                Form f = this.getComponentForm();
                if (f != null) {
                    f.repaint();
                }
            }
        }
    }

    public void updateTextAreaStyles() {
        Style s = this.getStyle();
        Font editorFont = this.getUnselectedStyle().getFont();
        this.getSelectedStyle().setFont(editorFont);
        javax.microedition.lcdui.Font nativeFont = (javax.microedition.lcdui.Font)editorFont.getNativeFont();
        if (nativeFont == null) {
            nativeFont = javax.microedition.lcdui.Font.getFont((int)1);
        }
        this.textEditor.setFont(nativeFont);
        this.textEditor.setForegroundColor(0xFF000000 | s.getFgColor());
    }

    private void addClearCommandToForm() {
        Form f = this.getComponentForm();
        if (f == null || f.getClearCommand() == this.clearCommand) {
            return;
        }
        LWUITImplementation impl = Display.getInstance().getImplementation();
        if (impl instanceof S40Implementation && !((S40Implementation)impl).shouldHideMenu() && (this.constraint & 0x20000) == 0 && f.getClearCommand() != this.clearCommand) {
            f.addCommand(this.clearCommand);
            f.setClearCommand(this.clearCommand);
            f.repaint();
        }
    }

    public void focusLost(Component cmp) {
        if (this.textEditor != null && this.textEditorEnabled) {
            this.textEditor.setFocus(false);
            this.hideTextEditor();
        }
    }

    protected synchronized void hideTextEditor() {
        if (this.textEditor != null && this.textEditor.isVisible()) {
            int c;
            if (Display.getInstance().getDeviceType() == 0) {
                this.changeEditBackIfOkInSelect();
            }
            this.textEditor.setTextEditorListener(null);
            this.setText(this.textEditor.getContent());
            this.caretPosition = c = this.textEditor.getCaretPosition();
            if (!this.growByContent) {
                int s;
                int h = this.textEditor.getHeight();
                int ch = this.textEditor.getContentHeight();
                if (ch > h && c == (s = this.textEditor.size())) {
                    this.visibleContentPosition = ch - h;
                }
            }
            this.textEditor.setVisible(false);
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    TextArea.this.removeClearCommandFromForm();
                }
            });
            this.setShouldCalcPreferredSize(true);
            Form f = this.getComponentForm();
            if (f != null) {
                f.repaint();
            }
        }
    }

    private void removeClearCommandFromForm() {
        Form p = this.getComponentForm();
        if (p != null && p.getClearCommand() == this.clearCommand) {
            p.removeCommand(this.clearCommand);
        }
    }

    public int getVisibleContentPosition() {
        return this.visibleContentPosition;
    }

    public void setTextEditorEnabled(boolean enable) {
        this.textEditorEnabled = enable;
        if (!enable && this.textEditor != null) {
            this.textEditor.setFocus(false);
            this.setText(this.textEditor.getContent());
            this.textEditor.setVisible(false);
        }
    }

    public boolean getTextEditorEnabled() {
        return this.textEditorEnabled;
    }

    private void updateTextEditorPosition() {
        if (this.isTextEditorActive()) {
            this.updatePaddings();
            int x = this.getAbsoluteX() + this.leftPadding - 1;
            int y = this.getAbsoluteY() + this.topPadding;
            this.textEditor.setPosition(x, y);
        }
    }

    private void updatePaddings() {
        Style style = this.getStyle();
        this.leftPadding = style.getPadding(this.isRTL(), 1);
        this.rightPadding = style.getPadding(this.isRTL(), 3);
        this.topPadding = style.getPadding(false, 0);
        this.bottomPadding = style.getPadding(false, 2);
    }

    private void ensureTextEditorIsShown() {
        if (this.hasFocus()) {
            this.focusTextEditor();
        }
    }

    public void setClearText(String text) {
        this.clearText = text;
        if (text != null && text.length() > 0) {
            this.clearCommand.setCommandName(this.clearText);
        }
    }

    public String getClearText() {
        return this.clearText;
    }

    public Style getStyle() {
        if (Display.getInstance().getDeviceType() == 3 && this.isTextEditorActive()) {
            return this.getSelectedStyle();
        }
        return super.getStyle();
    }

    static {
        widestChar = (char)87;
    }
}

