/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.Painter;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.VirtualKeyboardInterface;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VirtualKeyboard
extends Dialog
implements VirtualKeyboardInterface {
    private static final String MARKER_COMMIT_ON_DISPOSE = "$VKB_COM$";
    private static final String MARKER_TINT_COLOR = "$VKB_TINT$";
    private static final String MARKER_VKB = "$VKB$";
    private static Transition transitionIn = CommonTransitions.createSlide(1, true, 500);
    private static Transition transitionOut = CommonTransitions.createSlide(1, false, 500);
    private int inputType;
    public static final String[][] DEFAULT_QWERTY = new String[][]{{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p"}, {"a", "s", "d", "f", "g", "h", "j", "k", "l"}, {"$Shift$", "z", "x", "c", "v", "b", "n", "m", "$Delete$"}, {"$Mode$", "$T9$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}, {"*", "0", "#"}, {"$Mode$", "$Space$", "$Delete$", "$OK$"}};
    public static final String[][] DEFAULT_NUMBERS_SYMBOLS = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"}, {"-", "/", ":", ";", "(", ")", "$", "&", "@"}, {".", ",", "?", "!", "'", "\"", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String[][] DEFAULT_SYMBOLS = new String[][]{{"[", "]", "{", "}", "#", "%", "^", "*", "+", "="}, {"_", "\\", "|", "~", "<", ">", "\u00a3", "\u00a5"}, {":-0", ";-)", ":-)", ":-(", ":P", ":D", "$Delete$"}, {"$Mode$", "$Space$", "$OK$"}};
    public static final String QWERTY_MODE = "ABC";
    public static final String NUMBERS_MODE = "123";
    public static final String NUMBERS_SYMBOLS_MODE = ".,123";
    public static final String SYMBOLS_MODE = ".,?";
    private static Hashtable modesMap = new Hashtable();
    private static String[] defaultInputModeOrder = new String[]{"ABC", ".,123", "123", ".,?"};
    private String currentMode = defaultInputModeOrder[0];
    private String[] inputModeOrder = defaultInputModeOrder;
    private TextField inputField;
    private Container buttons = new Container(new BoxLayout(2));
    private TextPainter txtPainter = new TextPainter();
    private boolean upperCase = false;
    private Button currentButton;
    public static final int INSERT_CHAR = 1;
    public static final int DELETE_CHAR = 2;
    public static final int CHANGE_MODE = 3;
    public static final int SHIFT = 4;
    public static final int OK = 5;
    public static final int SPACE = 6;
    public static final int T9 = 7;
    private Hashtable specialButtons = new Hashtable();
    private TextArea field;
    private boolean finishedT9Edit = true;
    private String originalText;
    private boolean useSoftKeys = false;
    private static boolean showTooltips = true;
    private boolean okPressed;
    private static Class vkbClass;
    private VirtualKeyboard vkb;
    public static final String NAME = "LWUIT_VirtualKeyboard";
    private boolean isShowing = false;
    private static Hashtable defaultInputModes;

    public VirtualKeyboard() {
        this.setLayout(new BorderLayout());
        this.setDialogUIID("VKB");
        this.setAutoDispose(false);
        this.setDisposeWhenPointerOutOfBounds(true);
        this.setTransitionInAnimator(transitionIn);
        this.setTransitionOutAnimator(transitionOut);
        if (showTooltips) {
            this.setGlassPane(this.txtPainter);
        }
    }

    public void setInputType(int inputType) {
        switch (inputType) {
            case 2: 
            case 3: {
                this.setInputModeOrder(new String[]{NUMBERS_MODE});
                break;
            }
            case 5: {
                this.setInputModeOrder(new String[]{NUMBERS_SYMBOLS_MODE});
                break;
            }
            default: {
                this.setInputModeOrder(defaultInputModeOrder);
            }
        }
    }

    public void setTextField(TextArea field) {
        this.field = field;
        this.removeAll();
        this.okPressed = false;
        if (field instanceof TextField) {
            this.useSoftKeys = ((TextField)field).isUseSoftkeys();
            ((TextField)field).setUseSoftkeys(false);
        }
        this.originalText = field.getText();
        this.inputField = new InputField(field);
        this.inputField.setText(this.originalText);
        this.inputField.setCursorPosition(field.getCursorPosition());
        this.inputField.setConstraint(field.getConstraint());
        this.inputField.setInputModeOrder(new String[]{QWERTY_MODE});
        this.inputField.setMaxSize(field.getMaxSize());
        this.initModes();
        this.setInputType(field.getConstraint());
        this.initSpecialButtons();
        this.addComponent("North", (Component)this.inputField);
        this.buttons.getStyle().setPadding(0, 0, 0, 0);
        this.addComponent("Center", (Component)this.buttons);
        this.initInputButtons(this.upperCase);
        this.inputField.setUseSoftkeys(false);
        this.applyRTL(false);
    }

    public void show() {
        super.showPacked("South", true);
    }

    protected void autoAdjust(int w, int h) {
        if (this.finishedT9Edit) {
            this.setTransitionOutAnimator(CommonTransitions.createEmpty());
            this.dispose();
        }
    }

    protected void initModes() {
        this.addInputMode(QWERTY_MODE, DEFAULT_QWERTY);
        this.addInputMode(NUMBERS_SYMBOLS_MODE, DEFAULT_NUMBERS_SYMBOLS);
        this.addInputMode(SYMBOLS_MODE, DEFAULT_SYMBOLS);
        this.addInputMode(NUMBERS_MODE, DEFAULT_NUMBERS);
        if (defaultInputModes != null) {
            Enumeration e = defaultInputModes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.addInputMode(key, (String[][])defaultInputModes.get(key));
            }
        }
    }

    protected void setCurrentMode(String mode) {
        this.currentMode = mode;
    }

    protected String getCurrentMode() {
        return this.currentMode;
    }

    private void initInputButtons(boolean upperCase) {
        this.buttons.removeAll();
        int largestLine = 0;
        String[][] currentKeyboardChars = (String[][])modesMap.get(this.currentMode);
        for (int i = 1; i < currentKeyboardChars.length; ++i) {
            if (currentKeyboardChars[i].length <= currentKeyboardChars[largestLine].length) continue;
            largestLine = i;
        }
        int length = currentKeyboardChars[largestLine].length;
        if (length == 0) {
            return;
        }
        Button dummy = this.createButton(new Command("dummy"), 0);
        int buttonMargins = dummy.getUnselectedStyle().getMargin(dummy.isRTL(), 1) + dummy.getUnselectedStyle().getMargin(dummy.isRTL(), 3);
        Container row = null;
        int rowW = Display.getInstance().getDisplayWidth() - this.getDialogStyle().getPadding(false, 1) - this.getDialogStyle().getPadding(false, 3) - this.getDialogStyle().getMargin(false, 1) - this.getDialogStyle().getMargin(false, 3);
        int availableSpace = rowW - length * buttonMargins;
        int buttonSpace = availableSpace / length;
        for (int i = 0; i < currentKeyboardChars.length; ++i) {
            int rowWidth = rowW;
            row = new Container(new BoxLayout(1));
            row.getUnselectedStyle().setMargin(0, 0, 0, 0);
            Vector<Button> specialsButtons = new Vector<Button>();
            for (int j = 0; j < currentKeyboardChars[i].length; ++j) {
                String txt = currentKeyboardChars[i][j];
                Button b = null;
                if (txt.startsWith("$") && txt.endsWith("$") && txt.length() > 1) {
                    Button cmd = (Button)this.specialButtons.get(txt.substring(1, txt.length() - 1));
                    Command c = null;
                    int prefW = 0;
                    if (cmd != null) {
                        c = cmd.getCommand();
                        int space = (Integer)cmd.getClientProperty("space");
                        if (space != -1) {
                            prefW = availableSpace * space / 100;
                        }
                    }
                    b = this.createButton(c, prefW, "VKBSpecialButton");
                    if (prefW != 0) {
                        rowWidth -= b.getPreferredW() + buttonMargins;
                    } else {
                        specialsButtons.addElement(b);
                    }
                } else {
                    if (upperCase) {
                        txt = txt.toUpperCase();
                    }
                    b = this.createInputButton(txt, buttonSpace);
                    rowWidth -= b.getPreferredW() + buttonMargins;
                }
                if (this.currentButton != null) {
                    if (this.currentButton.getCommand() != null && b.getCommand() != null && this.currentButton.getCommand().getId() == b.getCommand().getId()) {
                        this.currentButton = b;
                    }
                    if (this.currentButton.getText().equals(b.getText())) {
                        this.currentButton = b;
                    }
                }
                row.addComponent(b);
            }
            int emptySpace = Math.max(rowWidth, 0);
            if (specialsButtons.size() > 0) {
                int prefW = emptySpace / specialsButtons.size();
                for (int j = 0; j < specialsButtons.size(); ++j) {
                    Button special = (Button)specialsButtons.elementAt(j);
                    special.setPreferredW(prefW);
                }
            } else {
                row.getUnselectedStyle().setPadding(1, 0);
                row.getUnselectedStyle().setPadding(3, 0);
                row.getUnselectedStyle().setMargin(1, emptySpace / 2);
                row.getUnselectedStyle().setMargin(3, emptySpace / 2);
            }
            this.buttons.addComponent(row);
        }
        this.applyRTL(false);
    }

    private Button createInputButton(String text, int prefSize) {
        Button b = this.createButton(new Command(text, 1), prefSize);
        b.putClientProperty("glasspane", "true");
        return b;
    }

    private Button createButton(Command cmd, int prefSize) {
        return this.createButton(cmd, prefSize, "VKBButton");
    }

    private Button createButton(Command cmd, int prefSize, String uiid) {
        Button btn;
        if (cmd != null) {
            btn = new Button(cmd);
        } else {
            btn = new Button();
            btn.setVisible(false);
        }
        final Button b = btn;
        b.setUIID(uiid);
        b.setEndsWith3Points(false);
        b.setAlignment(4);
        prefSize = Math.max(prefSize, b.getPreferredW());
        b.setPreferredW(prefSize);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboard.this.currentButton = b;
            }
        });
        return b;
    }

    public static void addDefaultInputMode(String mode, String[][] inputChars) {
        if (defaultInputModes == null) {
            defaultInputModes = new Hashtable();
        }
        defaultInputModes.put(mode, inputChars);
    }

    public void addInputMode(String mode, String[][] inputChars) {
        modesMap.put(mode, inputChars);
    }

    public void addSpecialButton(String key, Command cmd) {
        this.addSpecialButton(key, cmd, -1);
    }

    public void addSpecialButton(String key, Command cmd, int space) {
        Button b = new Button(cmd);
        b.putClientProperty("space", new Integer(space));
        this.specialButtons.put(key, b);
    }

    private String getNextMode(String current) {
        for (int i = 0; i < this.inputModeOrder.length - 1; ++i) {
            String mode = this.inputModeOrder[i];
            if (!mode.equals(current)) continue;
            return this.inputModeOrder[i + 1];
        }
        return this.inputModeOrder[0];
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        Component cmp = this.getComponentAt(x, y);
        if (showTooltips && cmp != null && cmp instanceof Button && cmp.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)cmp);
        }
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        Component cmp = this.getComponentAt(x, y);
        if (showTooltips && cmp != null && cmp instanceof Button && cmp.getClientProperty("glasspane") != null) {
            this.txtPainter.showButtonOnGlasspane((Button)cmp);
        }
    }

    public void pointerReleased(int x, int y) {
        if (showTooltips) {
            this.txtPainter.clear();
        }
        super.pointerReleased(x, y);
    }

    protected void initSpecialButtons() {
        this.addSpecialButton("Shift", new Command("SH", 4), 15);
        this.addSpecialButton("Delete", new Command("Del", 2), 15);
        this.addSpecialButton("T9", new Command("T9", 7), 15);
        this.addSpecialButton("Mode", new Command(this.getNextMode(this.currentMode), 3));
        this.addSpecialButton("Space", new Command("Space", 6), 50);
        this.addSpecialButton("OK", new Command("Ok", 5));
    }

    public String[] getInputModeOrder() {
        return this.inputModeOrder;
    }

    public void setInputModeOrder(String[] order) {
        this.inputModeOrder = order;
        this.setCurrentMode(order[0]);
    }

    public static String[] getDefaultInputModeOrder() {
        return defaultInputModeOrder;
    }

    public static void setDefaultInputModeOrder(String[] order) {
        defaultInputModeOrder = order;
    }

    private void updateText(String txt) {
        this.field.setText(txt);
        if (this.field instanceof TextField) {
            ((TextField)this.field).setCursorPosition(txt.length());
        }
        if (this.okPressed) {
            this.field.fireActionEvent();
        }
    }

    protected void actionCommand(Command cmd) {
        super.actionCommand(cmd);
        switch (cmd.getId()) {
            case 5: {
                this.okPressed = true;
                this.updateText(this.inputField.getText());
                this.dispose();
                break;
            }
            case 1: {
                Button btn = this.currentButton;
                String text = btn.getText();
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(text);
                    this.inputField.setCursorPosition(text.length());
                    break;
                }
                this.inputField.insertChars(text);
                break;
            }
            case 6: {
                if (this.inputField.getText().length() == 0) {
                    this.inputField.setText(" ");
                    break;
                }
                this.inputField.insertChars(" ");
                break;
            }
            case 2: {
                this.inputField.deleteChar();
                break;
            }
            case 3: {
                this.currentMode = this.getNextMode(this.currentMode);
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                        String next = VirtualKeyboard.this.getNextMode(VirtualKeyboard.this.currentMode);
                        VirtualKeyboard.this.currentButton.setText(next);
                        VirtualKeyboard.this.currentButton.getCommand().setCommandName(next);
                        VirtualKeyboard.this.setTransitionOutAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.setTransitionInAnimator(CommonTransitions.createEmpty());
                        VirtualKeyboard.this.revalidate();
                        VirtualKeyboard.this.show();
                    }
                });
                return;
            }
            case 4: {
                if (this.currentMode.equals(QWERTY_MODE)) {
                    this.upperCase = !this.upperCase;
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            VirtualKeyboard.this.initInputButtons(VirtualKeyboard.this.upperCase);
                            VirtualKeyboard.this.revalidate();
                        }
                    });
                }
                return;
            }
            case 7: {
                this.finishedT9Edit = false;
                if (this.field != null) {
                    Display.getInstance().editString(this.field, this.field.getMaxSize(), this.field.getConstraint(), this.field.getText());
                } else {
                    Display.getInstance().editString(this.inputField, this.inputField.getMaxSize(), this.inputField.getConstraint(), this.inputField.getText());
                }
                this.dispose();
                this.finishedT9Edit = true;
            }
        }
    }

    public void dispose() {
        if (this.field != null) {
            if (!this.okPressed && !VirtualKeyboard.isCommitOnDispose(this.field) && this.finishedT9Edit) {
                this.field.setText(this.originalText);
            }
            if (this.field instanceof TextField) {
                ((TextField)this.field).setUseSoftkeys(this.useSoftKeys);
            }
            this.setTransitionInAnimator(transitionIn);
            this.field = null;
        }
        this.currentMode = this.inputModeOrder[0];
        super.dispose();
    }

    protected void onShow() {
        super.onShow();
        this.setTransitionOutAnimator(transitionOut);
    }

    protected TextField getInputField() {
        return this.inputField;
    }

    public static void setCommitOnDispose(TextField tf, boolean b) {
        tf.putClientProperty(MARKER_COMMIT_ON_DISPOSE, new Boolean(b));
    }

    public static void bindVirtualKeyboard(TextArea t, VirtualKeyboard vkb) {
        t.putClientProperty(MARKER_VKB, vkb);
    }

    public static VirtualKeyboard getVirtualKeyboard(TextArea t) {
        return (VirtualKeyboard)t.getClientProperty(MARKER_VKB);
    }

    public static boolean isCommitOnDispose(TextArea tf) {
        Boolean b = (Boolean)tf.getClientProperty(MARKER_COMMIT_ON_DISPOSE);
        return b != null && b != false;
    }

    public static void setVKBTint(TextField tf, int tint) {
        tf.putClientProperty(MARKER_TINT_COLOR, new Integer(tint));
    }

    public static int getVKBTint(TextArea tf) {
        Integer v = (Integer)tf.getClientProperty(MARKER_TINT_COLOR);
        if (v != null) {
            return v;
        }
        return UIManager.getInstance().getLookAndFeel().getDefaultFormTintColor();
    }

    public static boolean isShowTooltips() {
        return showTooltips;
    }

    public static void setShowTooltips(boolean aShowTooltips) {
        showTooltips = aShowTooltips;
    }

    public static Transition getTransitionIn() {
        return transitionIn;
    }

    public static void setTransitionIn(Transition aTransitionIn) {
        transitionIn = aTransitionIn;
    }

    public static Transition getTransitionOut() {
        return transitionOut;
    }

    public static void setTransitionOut(Transition aTransitionOut) {
        transitionOut = aTransitionOut;
    }

    public void showKeyboard(boolean show) {
        TextArea txtCmp;
        this.isShowing = show;
        Form current = Display.getInstance().getCurrent();
        if (show && (txtCmp = (TextArea)current.getFocused()) != null) {
            if (this.vkb != null && this.vkb.contains(txtCmp)) {
                return;
            }
            this.vkb = VirtualKeyboard.getVirtualKeyboard(txtCmp);
            if (this.vkb == null) {
                this.vkb = this.createVirtualKeyboard();
            }
            this.vkb.setTextField(txtCmp);
            int oldTint = current.getTintColor();
            current.setTintColor(VirtualKeyboard.getVKBTint(txtCmp));
            boolean third = Display.getInstance().isThirdSoftButton();
            Display.getInstance().setThirdSoftButton(false);
            boolean qwerty = txtCmp.isQwertyInput();
            if (txtCmp instanceof TextField) {
                ((TextField)txtCmp).setQwertyInput(true);
            }
            this.vkb.showDialog();
            if (txtCmp instanceof TextField) {
                ((TextField)txtCmp).setQwertyInput(qwerty);
            }
            Display.getInstance().setThirdSoftButton(third);
            current.setTintColor(oldTint);
        }
    }

    public static void setDefaultVirtualKeyboardClass(Class vkbClazz) {
        vkbClass = vkbClazz;
    }

    private VirtualKeyboard createVirtualKeyboard() {
        try {
            if (vkbClass != null) {
                return (VirtualKeyboard)vkbClass.newInstance();
            }
            return new VirtualKeyboard();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new VirtualKeyboard();
        }
    }

    public String getVirtualKeyboardName() {
        return NAME;
    }

    public boolean isVirtualKeyboardShowing() {
        return this.isShowing;
    }

    static {
        defaultInputModes = null;
    }

    class TextPainter
    implements Painter {
        private Label label = new Label();
        private boolean paint = true;

        public TextPainter() {
            this.label.setUIID("VKBtooltip");
        }

        public void showButtonOnGlasspane(Button button) {
            if (this.label.getText().equals(button.getText())) {
                return;
            }
            this.paint = true;
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getWidth() + 4, this.label.getHeight() + 4);
            this.label.setText(button.getText());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setX(button.getAbsoluteX() + (button.getWidth() - this.label.getWidth()) / 2);
            this.label.setY(button.getAbsoluteY() - this.label.getPreferredH() * 4 / 3);
            VirtualKeyboard.this.repaint(this.label.getAbsoluteX() - 2, this.label.getAbsoluteY() - 2, this.label.getPreferredW() + 4, this.label.getPreferredH() + 4);
        }

        public void paint(Graphics g, Rectangle rect) {
            if (this.paint) {
                this.label.paintComponent(g);
            }
        }

        private void clear() {
            this.paint = false;
            VirtualKeyboard.this.repaint();
        }
    }

    static class InputField
    extends TextField {
        private TextArea field;

        InputField(TextArea field) {
            this.setTextEditorEnabled(false);
            field.setTextEditorEnabled(false);
            this.field = field;
            this.setInputMode(field.getInputMode());
            this.setConstraint(field.getConstraint());
        }

        public boolean hasFocus() {
            return true;
        }

        public String getUIID() {
            return "VKBTextInput";
        }

        public void deleteChar() {
            super.deleteChar();
            this.field.setText(this.getText());
            if (this.field instanceof TextField) {
                ((TextField)this.field).setCursorPosition(this.getCursorPosition());
            }
        }

        public void setCursorPosition(int i) {
            super.setCursorPosition(i);
            if (this.field != null && this.field.getText().length() > i && this.field instanceof TextField) {
                ((TextField)this.field).setCursorPosition(i);
            }
        }

        public void setText(String t) {
            super.setText(t);
            if (this.field != null) {
                this.field.setText(t);
            }
        }

        public boolean validChar(String c) {
            if (this.field instanceof TextField) {
                return ((TextField)this.field).validChar(c);
            }
            return true;
        }
    }
}

