/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class GridLayout
extends Layout {
    private boolean fillLastRow;
    private int rows;
    private int columns;
    private boolean autoFit;

    public GridLayout(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException("rows and columns must be greater then zero");
        }
    }

    private void autoSizeCols(Container parent, int width) {
        if (this.isAutoFit()) {
            int numOfcomponents = parent.getComponentCount();
            int maxWidth = 0;
            for (int iter = 0; iter < numOfcomponents; ++iter) {
                Component cmp = parent.getComponentAt(iter);
                maxWidth = Math.max(cmp.getPreferredW(), maxWidth);
            }
            if (width < maxWidth) {
                width = Display.getInstance().getDisplayWidth();
            }
            this.columns = maxWidth <= 0 ? 1 : Math.max(width / maxWidth, 1);
        }
    }

    public void layoutContainer(Container parent) {
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(false, 3) - parent.getStyle().getPadding(false, 1);
        int height = parent.getLayoutHeight() - parent.getBottomGap() - parent.getStyle().getPadding(false, 2) - parent.getStyle().getPadding(false, 0);
        int numOfcomponents = parent.getComponentCount();
        this.autoSizeCols(parent, width);
        int x = parent.getStyle().getPadding(parent.isRTL(), 1);
        int y = parent.getStyle().getPadding(false, 0);
        boolean rtl = parent.isRTL();
        if (rtl) {
            x += parent.getSideGap();
        }
        int localColumns = this.columns;
        int cmpWidth = width / this.columns;
        int cmpHeight = numOfcomponents > this.rows * this.columns ? height / (numOfcomponents / this.columns + (numOfcomponents % this.columns == 0 ? 0 : 1)) : height / this.rows;
        int row = 0;
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style cmpStyle = cmp.getStyle();
            int marginLeft = cmpStyle.getMargin(parent.isRTL(), 1);
            int marginTop = cmpStyle.getMargin(false, 0);
            cmp.setWidth(cmpWidth - marginLeft - cmpStyle.getMargin(parent.isRTL(), 3));
            cmp.setHeight(cmpHeight - marginTop - cmpStyle.getMargin(false, 2));
            if (rtl) {
                cmp.setX(x + (localColumns - 1 - i % localColumns) * cmpWidth + marginLeft);
            } else {
                cmp.setX(x + i % localColumns * cmpWidth + marginLeft);
            }
            cmp.setY(y + row * cmpHeight + marginTop);
            if ((i + 1) % this.columns != 0 || !this.fillLastRow || ++row != this.rows - 1) continue;
            localColumns = numOfcomponents % this.columns;
            if (localColumns == 0) {
                localColumns = this.columns;
            }
            cmpWidth = width / localColumns;
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            width = Math.max(width, cmp.getPreferredW() + cmp.getStyle().getMargin(false, 1) + cmp.getStyle().getMargin(false, 3));
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMargin(false, 0) + cmp.getStyle().getMargin(false, 2));
        }
        this.autoSizeCols(parent, parent.getWidth());
        if (this.columns > 1) {
            width *= this.columns;
        }
        if (this.rows > 1) {
            height = numOfcomponents > this.rows * this.columns ? (height *= numOfcomponents / this.columns + (numOfcomponents % this.columns == 0 ? 0 : 1)) : (height *= this.rows);
        }
        return new Dimension(width + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3), height + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
    }

    public String toString() {
        return "GridLayout";
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((GridLayout)o).getRows() == this.getRows() && ((GridLayout)o).getColumns() == this.getColumns() && ((GridLayout)o).autoFit == this.autoFit;
    }

    public boolean isFillLastRow() {
        return this.fillLastRow;
    }

    public void setFillLastRow(boolean fillLastRow) {
        this.fillLastRow = fillLastRow;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }
}

