/*
 * Decompiled with CFR 0.152.
 */
package com.divum.googleanalyticsme;

import com.divum.googleanalyticsme.util.StringUtil;
import com.divum.googleanalyticsme.util.URLEncoder;
import com.divum.screens.MidletScreen;
import java.util.Random;
import java.util.Vector;

public final class TrackingURL {
    private static final Random random = new Random(System.currentTimeMillis());
    private static final int cookie = random.nextInt();
    private static final String urlPreffix = "http://www.google-analytics.com/__utm.gif";
    private Vector keys = new Vector();
    private Vector values = new Vector();

    static String getCookie() {
        return "__utma=1." + MidletScreen.visitorId + "." + MidletScreen.visitorId + "." + MidletScreen.visitorId + "." + cookie + "." + cookie + ";";
    }

    static String getProperty(String key, String defaultValue) {
        return (key = System.getProperty(key)) != null ? key : defaultValue;
    }

    public TrackingURL(String trackingCode) {
        if (StringUtil.isEmpty(trackingCode)) {
            throw new IllegalArgumentException("Tracking code must not be empty.");
        }
        this.keys = new Vector(15);
        this.values = new Vector(15);
        this.addParameter("utmwv", "1");
        this.addParameter("utmn", String.valueOf(random.nextInt()));
        this.addParameter("utmcs", TrackingURL.getProperty("microedition.encoding", "UTF-8"));
        this.addParameter("utmul", TrackingURL.getProperty("microedition.locale", "en-us"));
        this.addParameter("utmdt", "");
        this.addParameter("utmhn", URLEncoder.encode("divum.in"));
        this.addParameter("utmr", URLEncoder.encode("http://divum.in"));
        this.addParameter("utmt", "");
        this.addParameter("utme", "");
        this.addParameter("utmp", "");
        this.addParameter("utmac", trackingCode);
        this.addParameter("utmcc", TrackingURL.getCookie());
    }

    public void addParameter(String key, String value) {
        if (this.keys.contains(key)) {
            this.values.setElementAt(value, this.keys.indexOf(key));
        } else {
            this.keys.addElement(key);
            this.values.addElement(value);
        }
    }

    public void removeParameter(String key) {
        if (this.keys.contains(key)) {
            int ix = this.keys.indexOf(key);
            this.values.removeElementAt(ix);
            this.keys.removeElementAt(ix);
        }
    }

    public String getParameter(String key) {
        if (this.keys.contains(key)) {
            int ix = this.keys.indexOf(key);
            return (String)this.values.elementAt(ix);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TrackingURL)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "http://www.google-analytics.com/__utm.gif?" + this.queryString();
    }

    private String queryString() {
        StringBuffer query = new StringBuffer();
        int size = this.keys.size();
        int i = 0;
        while (i < size) {
            String key = (String)this.keys.elementAt(i);
            String value = (String)this.values.elementAt(i);
            if (!StringUtil.isEmpty(key) && !StringUtil.isEmpty(value)) {
                query.append(key);
                query.append("=");
                query.append(value);
                query.append("&");
            }
            ++i;
        }
        String queryStr = query.toString();
        if (queryStr.endsWith("&")) {
            queryStr = queryStr.substring(0, queryStr.length() - 1);
        }
        return queryStr;
    }
}

