/*
 * Decompiled with CFR 0.152.
 */
package com.divum.parsers;

import com.divum.configs.Log;
import com.divum.parsers.MoreGamesDataType;
import com.divum.parsers.XmlCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import org.kxml2.io.KXmlParser;

public class LeaderBoardParser {
    XmlCallback listener;

    public void setRSSListener(XmlCallback listener) {
        this.listener = listener;
    }

    public void parser(final String url) {
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("url==" + url);
                    LeaderBoardParser.this.parse(url);
                }
                catch (IOException ioe) {
                    LeaderBoardParser.this.listener.MoreGamesParserException(ioe);
                }
                catch (Exception e) {
                    System.out.println("caught in parsing:" + e);
                }
            }
        };
        t.start();
    }

    public void parse(String rssUrl) throws Exception {
        try {
            KXmlParser parser = new KXmlParser();
            Log.debug("opening http connection");
            HttpConnection conn = (HttpConnection)Connector.open((String)rssUrl);
            Log.debug("opening http connection");
            InputStream rssStream = conn.openInputStream();
            Log.debug("opening http connection");
            InputStreamReader isr = new InputStreamReader(rssStream);
            Log.debug("opening http connection");
            parser.setInput(isr);
            parser.nextTag();
            parser.require(2, null, "content");
            parser.nextTag();
            while (parser.getEventType() != 3) {
                String nodeName = parser.getName();
                if (nodeName.equalsIgnoreCase("user")) {
                    this.parseRssItem(parser);
                } else {
                    parser.skipSubTree();
                }
                parser.nextTag();
            }
            isr.close();
        }
        catch (Exception e) {
            System.out.println("exception in parsing:" + e);
        }
        this.listener.MoreGamesParseDidFinish();
    }

    public void parseRssItem(KXmlParser parser) throws Exception {
        MoreGamesDataType moregamesdata = new MoreGamesDataType();
        parser.nextTag();
        while (parser.getEventType() != 3) {
            String nodeName = parser.getName();
            if (nodeName.equalsIgnoreCase("device")) {
                moregamesdata.setDeviceName(parser.nextText());
                System.out.println();
            } else if (nodeName.equalsIgnoreCase("Rank")) {
                moregamesdata.setRank(parser.nextText());
                System.out.println();
            } else if (nodeName.equalsIgnoreCase("Score")) {
                moregamesdata.setScore(parser.nextText());
                System.out.println();
            } else {
                parser.skipSubTree();
            }
            parser.nextTag();
        }
        this.listener.MoreGames_listeneritemParsed(moregamesdata);
    }
}

