/*
 * Decompiled with CFR 0.152.
 */
package com.divum.screens;

import com.divum.configs.AssetsConfig;
import com.divum.configs.GameConfig;
import com.divum.configs.ImageNamesConfig;
import com.divum.configs.Log;
import com.divum.configs.SetterGetter;
import com.divum.configs.StringUtil;
import com.divum.configs.Utilities;
import com.divum.objects.Car;
import com.divum.objects.MovingObjects;
import com.divum.objects.Wheel;
import com.divum.screens.BaseScreen;
import com.divum.screens.GameController;
import com.divum.screens.GarageScreen;
import com.divum.screens.LeaderBoardScreen;
import com.divum.screens.MidletScreen;
import com.divum.screens.NextLevelScreen;
import com.divum.screens.SplashScreen;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class RaceScreen
extends BaseScreen {
    MovingObjects sprite_building;
    MovingObjects sprite_building2;
    MovingObjects sprite_road_mark;
    MovingObjects sprite_road_mark2;
    MovingObjects sprite_back_poster;
    MovingObjects sprite_back_poster2;
    Car userCar;
    Car enemyCar;
    Wheel wheel_1_userCar;
    Wheel wheel_2_userCar;
    Wheel wheel_1_enemyCar;
    Wheel wheel_2_enemyCar;
    Sprite sprite_accelerater;
    Sprite pauseSprite;
    Sprite sprite_gear_down;
    Sprite sprite_gear_up;
    Sprite[] sprite_indicator = new Sprite[5];
    Sprite[] sprite_signs = new Sprite[2];
    String[] str_level_details;
    String[] scoreValue;
    Utilities obj_utilities = new Utilities();
    String levelValues;
    float default_bg_speed;
    int increment_score_by;
    int vary_min_speed = 1;
    int vary_max_speed = 1;
    float max_speed_user;
    float max_speed_enemy;
    Graphics g;
    boolean isAccelerated;
    int variable_speed_user;
    int variable_speed_enemy;
    float current_bg_speed;
    public static float default_speed_ratio;
    double max_threshold = -82.0;
    double min_threshold = -85.5;
    double currentSpeed_speedometer = -85.5;
    double variable_speed = 0.05;
    double speed_limit_speedometer = -83.0;
    double speed_good_shift = -83.0;
    double speed_perfect_shift = -82.5;
    double speed_bad_shift = -82.25;
    double speed_after_gearshift = -84.0;
    boolean isMycarWon = true;
    boolean raceFinished;
    int yCoord_message;
    int RPM_METER_VALUE;
    int seconds_over;
    int rem;
    String milliLeftIndex;
    String secondIndex;
    boolean gearUp;
    boolean gearDown;
    boolean showIndicator;
    int which_gearShift;
    int x_img_finish;
    int game_end_point;
    Timer timer_race;
    Timer countDownTimer;
    Image img_building;
    Image img_road_mark;
    Image img_back_poster;
    Image img_timer_bg;
    Image img_gearshift_indicator;
    Image img_score;
    Image img_one;
    Image img_two;
    Image img_three;
    Image img_go;
    Image img_speedo_meter;
    Image img_gear_shift_down;
    Image img_gear_shift_up;
    Image img_accelerometer;
    Image img_gearPlus;
    Image img_gearMinus;
    Image img_meter_arrow;
    Image img_finish;
    Image car_lagging_forward;
    Image car_lagging_behind;
    Image img_enemycar;
    Image img_usercar;
    Image img_enemy;
    Image wheel_img_slowmoving;
    Image wheel_img_fastmoving;
    Timer timer_car_ahead;
    int carAheadCount = 1;
    int milli_sec_count = 0;
    int indicatorCount;
    int startCount;

    public RaceScreen() {
        this.obj_utilities.showAlertLoading();
        SplashScreen.sound_race.stopPlaying();
        this.InitRaceValues();
        try {
            int user_tyre2_x;
            int user_tyre1_x;
            int enemy__tyre2_x;
            int enemy_tyre1_x;
            this.levelValues = this.readFile(GameConfig.team_main_level, GameConfig.team_sub_level);
            this.str_level_details = StringUtil.split(this.levelValues, ",");
            this.variable_speed = Double.parseDouble(this.str_level_details[0]);
            this.game_end_point = Integer.parseInt(this.str_level_details[1]);
            this.max_speed_user = Float.parseFloat(this.str_level_details[2]);
            this.max_speed_enemy = Float.parseFloat(this.str_level_details[3]);
            default_speed_ratio = Float.parseFloat(this.str_level_details[4]);
            this.vary_max_speed = Integer.parseInt(this.str_level_details[5]);
            this.vary_min_speed = Integer.parseInt(this.str_level_details[6]);
            this.x_img_finish = this.getRandomInteger(this.game_end_point - 100, this.game_end_point);
            this.current_bg_speed = this.default_bg_speed = this.max_speed_user * default_speed_ratio / 100.0f;
            this.variable_speed_user = this.vary_max_speed;
            this.variable_speed_enemy = this.vary_max_speed;
            this.img_building = Image.createImage((String)ImageNamesConfig.BUILDING);
            this.img_road_mark = Image.createImage((String)ImageNamesConfig.ROAD_MARK);
            this.img_back_poster = Image.createImage((String)ImageNamesConfig.BACK_POSTER);
            this.img_timer_bg = Image.createImage((String)ImageNamesConfig.TIMER_BG);
            this.img_gearshift_indicator = Image.createImage((String)ImageNamesConfig.GEARSHIFT_INDICATOR);
            this.img_one = Image.createImage((String)ImageNamesConfig.ONE);
            this.img_two = Image.createImage((String)ImageNamesConfig.TWO);
            this.img_three = Image.createImage((String)ImageNamesConfig.THREE);
            this.img_go = Image.createImage((String)ImageNamesConfig.GO);
            this.img_score = Image.createImage((String)ImageNamesConfig.SCORE);
            this.img_speedo_meter = Image.createImage((String)ImageNamesConfig.SPEEDO_METER);
            this.img_gear_shift_down = Image.createImage((String)ImageNamesConfig.GEAR_SHIFT_DOWN);
            this.img_gear_shift_up = Image.createImage((String)ImageNamesConfig.GEAR_SHIFT_UP);
            this.img_accelerometer = Image.createImage((String)ImageNamesConfig.ACCELEROMETER);
            this.img_gearPlus = Image.createImage((String)ImageNamesConfig.GEAR_PLUS);
            this.img_gearMinus = Image.createImage((String)ImageNamesConfig.GEAR_DOWN);
            this.car_lagging_forward = Image.createImage((String)"/gamescreen/tacho0_major_g.png");
            this.car_lagging_behind = Image.createImage((String)"/gamescreen/tacho0_major_r.png");
            int i = 0;
            while (i < this.sprite_indicator.length) {
                this.sprite_indicator[i] = new Sprite(Image.createImage((String)ImageNamesConfig.INDICATOR), 45, 45);
                this.sprite_indicator[i].setFrame(i);
                ++i;
            }
            i = 0;
            while (i < this.sprite_signs.length) {
                this.sprite_signs[i] = new Sprite(Image.createImage((String)ImageNamesConfig.SIGNS), 210, 50);
                this.sprite_signs[i].setFrame(i);
                ++i;
            }
            this.img_finish = Image.createImage((String)ImageNamesConfig.FINISH);
            this.sprite_gear_down = new Sprite(this.img_gear_shift_down);
            this.sprite_gear_up = new Sprite(this.img_gear_shift_up);
            this.sprite_gear_down.setPosition(60, GameConfig.dispHeight - this.sprite_gear_down.getHeight() + 10);
            this.sprite_gear_up.setPosition(285, GameConfig.dispHeight - this.sprite_gear_down.getHeight() + 10);
            this.sprite_accelerater = new Sprite(this.img_accelerometer, 30, 58);
            this.sprite_accelerater.setPosition(GameConfig.dispWidth - 40, GameConfig.dispHeight / 2);
            this.sprite_accelerater.setFrame(0);
            this.img_enemy = Image.createImage((String)("/teamscreen/player-" + GameConfig.team_main_level + "-" + GameConfig.team_sub_level + ".png"));
            this.img_enemy = this.scaleImage(this.img_enemy, 70, 70);
            this.img_enemycar = Image.createImage((String)("/gamescreen/car_" + GameConfig.team_main_level + "_" + GameConfig.team_sub_level + ".png"));
            this.img_usercar = Image.createImage((String)("/gamescreen/car_" + GarageScreen.main_level + "_" + GarageScreen.sub_level + ".png"));
            this.wheel_img_slowmoving = Image.createImage((String)ImageNamesConfig.WHEEL_COMMON);
            this.wheel_img_fastmoving = Image.createImage((String)ImageNamesConfig.WHEEL_COMMON2);
            this.sprite_building = new MovingObjects(this.img_building, 0, 0);
            this.sprite_back_poster = new MovingObjects(this.img_back_poster, 0, 50, this.img_back_poster.getWidth(), this.img_back_poster.getHeight() / 3);
            this.sprite_road_mark = new MovingObjects(this.img_road_mark, 0, 80);
            this.sprite_building2 = new MovingObjects(this.img_building, this.sprite_building.x + this.sprite_building.getWidth(), 0);
            this.sprite_back_poster2 = new MovingObjects(this.img_back_poster, this.sprite_back_poster.x + this.sprite_back_poster.getWidth(), 50, this.img_back_poster.getWidth(), this.img_back_poster.getHeight() / 3);
            this.sprite_road_mark2 = new MovingObjects(this.img_road_mark, this.sprite_road_mark.x + this.sprite_road_mark.getWidth(), 80);
            this.userCar = new Car(this.img_usercar, 10, 125);
            this.userCar.setMaxSpeed(this.max_speed_user);
            this.userCar.setGearLimitSpeed((int)this.current_bg_speed);
            this.enemyCar = new Car(this.img_enemycar, 10, 75);
            this.enemyCar.setMaxSpeed(this.max_speed_enemy);
            this.enemyCar.setGearLimitSpeed((int)this.obj_utilities.getRatioOfMaxSpeed(this.enemyCar.gearNumber, this.max_speed_enemy));
            int x1_limit_car = 10;
            int x2_limit_enemycar = GameConfig.dispWidth - (int)((double)this.userCar.getWidth() * 1.5);
            int x2_limit_userCar = GameConfig.dispWidth - (int)((double)this.userCar.getWidth() * 0.5);
            this.userCar.setLimits(x1_limit_car, x2_limit_userCar);
            this.enemyCar.setLimits(x1_limit_car, x2_limit_enemycar);
            if (GameConfig.team_main_level == 2) {
                enemy_tyre1_x = 33;
                enemy__tyre2_x = 110;
            } else if (GameConfig.team_main_level == 3) {
                enemy_tyre1_x = 29;
                enemy__tyre2_x = 114;
            } else if (GameConfig.team_main_level == 4) {
                enemy_tyre1_x = 32;
                enemy__tyre2_x = 112;
            } else {
                enemy_tyre1_x = 33;
                enemy__tyre2_x = 113;
            }
            if (GarageScreen.main_level == 0) {
                user_tyre1_x = 31;
                user_tyre2_x = 111;
            } else if (GarageScreen.main_level == 2) {
                user_tyre1_x = 33;
                user_tyre2_x = 110;
            } else if (GarageScreen.main_level == 3) {
                user_tyre1_x = 29;
                user_tyre2_x = 114;
            } else if (GarageScreen.main_level == 4) {
                user_tyre1_x = 32;
                user_tyre2_x = 112;
            } else {
                user_tyre1_x = 33;
                user_tyre2_x = 113;
            }
            this.wheel_1_enemyCar = new Wheel(this.wheel_img_slowmoving, enemy_tyre1_x, 105);
            this.wheel_2_enemyCar = new Wheel(this.wheel_img_slowmoving, enemy__tyre2_x, 105);
            this.wheel_1_enemyCar.setLimits(enemy_tyre1_x, x2_limit_enemycar + (enemy_tyre1_x - 10));
            this.wheel_2_enemyCar.setLimits(enemy__tyre2_x, x2_limit_enemycar + (enemy__tyre2_x - 10));
            this.wheel_1_userCar = new Wheel(this.wheel_img_slowmoving, user_tyre1_x, 155);
            this.wheel_2_userCar = new Wheel(this.wheel_img_slowmoving, user_tyre2_x, 155);
            this.wheel_1_userCar.setLimits(user_tyre1_x, x2_limit_userCar + (user_tyre1_x - 10));
            this.wheel_2_userCar.setLimits(user_tyre2_x, x2_limit_userCar + (user_tyre2_x - 10));
        }
        catch (Exception e) {
            System.out.println("caught while reading images in RS.." + e);
        }
        this.setBGImagesSpeed();
        MidletScreen.pingAnalytics("RaceScreen");
    }

    public void draw(Graphics g) {
        this.g = g;
        if (this.sprite_road_mark.x + this.sprite_road_mark.getWidth() < 0) {
            this.sprite_building.x = this.sprite_building2.x + this.sprite_building2.getWidth();
            this.sprite_back_poster.x = this.sprite_back_poster2.x + this.sprite_back_poster2.getWidth();
            this.sprite_road_mark.x = this.sprite_road_mark2.x + this.sprite_road_mark2.getWidth();
        }
        if (this.sprite_road_mark2.x + this.sprite_road_mark2.getWidth() < 0) {
            this.sprite_building2.x = this.sprite_building.x + this.sprite_building.getWidth();
            this.sprite_back_poster2.x = this.sprite_back_poster.x + this.sprite_back_poster.getWidth();
            this.sprite_road_mark2.x = this.sprite_road_mark.x + this.sprite_road_mark.getWidth();
        }
        this.sprite_building.move(g);
        this.sprite_road_mark.move(g);
        this.sprite_back_poster.move(g);
        this.sprite_building2.move(g);
        this.sprite_road_mark2.move(g);
        this.sprite_back_poster2.move(g);
        this.enemyCar.reachSpeedLimit();
        this.enemyCar.updateGearLimitSpeed();
        if (!this.isAccelerated) {
            this.sprite_accelerater.nextFrame();
            this.sprite_accelerater.paint(g);
        }
        g.drawImage(this.img_enemy, GameConfig.dispWidth - this.img_enemy.getWidth(), -10, 20);
        g.drawImage(this.img_speedo_meter, 70, GameConfig.dispHeight - this.img_speedo_meter.getHeight() + 5, 20);
        if (GameConfig.moveBg) {
            int factor = 100;
            int scaled_and_rounded = (int)(this.currentSpeed_speedometer * (double)factor);
            this.currentSpeed_speedometer = (double)scaled_and_rounded / (double)factor;
            if (this.currentSpeed_speedometer > this.speed_limit_speedometer) {
                this.currentSpeed_speedometer -= this.variable_speed;
            } else if (this.currentSpeed_speedometer < this.speed_limit_speedometer) {
                this.currentSpeed_speedometer += this.variable_speed;
            } else if (this.currentSpeed_speedometer == this.speed_limit_speedometer) {
                this.showIndicator = true;
                this.variable_speed = 0.025;
            }
        }
        if (this.userCar.gearNumber < 6) {
            g.drawImage(this.img_gearshift_indicator, 199, 177, 20);
        }
        this.findXYCoordinatesOfNeedle(this.currentSpeed_speedometer);
        this.sprite_gear_down.paint(g);
        this.sprite_gear_up.paint(g);
        this.showTime();
        if (GameConfig.moveBg) {
            this.DrawFinishingPoint();
        }
        this.userCar.reachSpeedLimit();
        if (this.userCar.getCurrentSpeed() < this.enemyCar.getCurrentSpeed()) {
            this.variable_speed_user = this.vary_min_speed;
            this.variable_speed_enemy = this.vary_max_speed;
            this.moveEnemyCarForward();
            this.moveUserCarBack();
        } else if (this.userCar.getCurrentSpeed() > this.enemyCar.getCurrentSpeed()) {
            this.variable_speed_user = this.vary_max_speed;
            this.variable_speed_enemy = this.vary_min_speed;
            this.moveEnemyCarBack();
            this.moveUserCarForward();
        } else {
            this.moveUserCarForward();
            this.moveEnemyCarForward();
        }
        this.userCar.move(g);
        this.enemyCar.move(g);
        this.wheel_1_enemyCar.move(g);
        this.wheel_2_enemyCar.move(g);
        this.wheel_1_userCar.move(g);
        this.wheel_2_userCar.move(g);
        g.setColor(GameConfig.RED_COLOR);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.drawString(Integer.toString(this.userCar.gearNumber), 250, GameConfig.dispHeight - 15, 20);
        g.drawString(Integer.toString(this.userCar.getCurrentSpeed()), 115, GameConfig.dispHeight - 15, 20);
        g.drawImage(this.img_gearPlus, 298, 188, 20);
        g.drawImage(this.img_gearMinus, 75, 190, 20);
        if (this.startCount != 0) {
            this.countingDown();
        }
        if (this.raceFinished) {
            this.sprite_back_poster.setFrame(0);
            this.sprite_back_poster2.setFrame(0);
            this.showIndicator = false;
            this.showScore();
            if (this.yCoord_message >= -40) {
                if (this.isMycarWon) {
                    this.sprite_signs[0].setPosition(GameConfig.dispWidth / 2 - 100, this.yCoord_message -= 10);
                    this.sprite_signs[0].paint(g);
                } else {
                    this.sprite_signs[1].setPosition(GameConfig.dispWidth / 2 - 100, this.yCoord_message -= 10);
                    this.sprite_signs[1].paint(g);
                }
            } else {
                this.stopTheRace();
            }
        } else {
            this.getScore();
            this.showScore();
            if (this.enemyCar.collidesWith(this.img_finish, this.x_img_finish, 90, false)) {
                Log.debug("enemyCar won!!");
                this.isMycarWon = false;
            }
            if (this.userCar.collidesWith(this.img_finish, this.x_img_finish, 90, false)) {
                this.raceFinished = true;
                if (this.isMycarWon) {
                    Log.debug("userCar won! time is: " + this.seconds_over + ":" + this.rem);
                    if (!GameConfig.moveToNextLevel) {
                        GameConfig.moveToNextLevel = true;
                        if (GameConfig.sub_level < GameConfig.total_sub_level) {
                            GameConfig.team_sub_level = ++GameConfig.sub_level;
                        } else {
                            GameConfig.sub_level = 1;
                            GameConfig.team_main_level = ++GameConfig.main_level;
                            GameConfig.team_sub_level = GameConfig.sub_level;
                        }
                    }
                }
            }
        }
        if (this.showIndicator && this.userCar.gearNumber < 6) {
            this.showIndicators();
        }
    }

    void showScore() {
        this.g.drawImage(this.img_score, 0, 0, 20);
        this.scoreValue = this.obj_utilities.getScoreFrames(GameConfig.gameScore);
        this.obj_utilities.drawScores(this.scoreValue, 55, 10, this.g);
    }

    private String readFile(int main_level, int sub_level) {
        InputStream is = this.getClass().getResourceAsStream("/levels/level_" + main_level + "_" + sub_level + ".txt");
        StringBuffer sb = new StringBuffer();
        try {
            int chars;
            while ((chars = is.read()) != -1) {
                sb.append((char)chars);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private void getScore() {
        switch (this.increment_score_by) {
            case 0: {
                break;
            }
            case 1: {
                GameConfig.gameScore += 10;
                break;
            }
            case 2: {
                GameConfig.gameScore += 20;
                break;
            }
            case 3: {
                GameConfig.gameScore += 30;
                break;
            }
        }
    }

    private void startLessVibration() {
    }

    private void stopVibration() {
    }

    private void countingDown() {
        if (this.startCount == 100) {
            this.g.drawImage(this.img_three, GameConfig.dispWidth / 2 - this.img_three.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_three.getHeight() / 2, 20);
        } else if (this.startCount == 200) {
            this.g.drawImage(this.img_two, GameConfig.dispWidth / 2 - this.img_three.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_three.getHeight() / 2, 20);
        } else if (this.startCount == 300) {
            this.g.drawImage(this.img_one, GameConfig.dispWidth / 2 - this.img_three.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_three.getHeight() / 2, 20);
        } else if (this.startCount == 400) {
            this.g.drawImage(this.img_go, GameConfig.dispWidth / 2 - this.img_three.getWidth() / 2, GameConfig.dispHeight / 2 - this.img_three.getHeight() / 2, 20);
        }
    }

    public Image getGrayScaleImage(Image image) {
        int[] rgbData = new int[image.getWidth() * image.getHeight()];
        image.getRGB(rgbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int x = 0;
        while (x < image.getWidth() * image.getHeight()) {
            rgbData[x] = this.getGrayScale(rgbData[x]);
            ++x;
        }
        Image grayImage = Image.createRGBImage((int[])rgbData, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
        return grayImage;
    }

    private int getGrayScale(int c) {
        int nc;
        int[] p = new int[]{(c & 0xFF000000) >>> 24, (c & 0xFF0000) >>> 16, (c & 0xFF00) >>> 8, c & 0xFF};
        p[1] = nc = p[1] / 3 + p[2] / 3 + p[3] / 3;
        p[2] = nc;
        p[3] = nc;
        int gc = p[0] << 24 | p[1] << 16 | p[2] << 8 | p[3];
        return gc;
    }

    private void findXYCoordinatesOfNeedle(double theta) {
        int x1 = 190;
        int y1 = 218;
        int r = 30;
        double x2point = (double)r * Math.cos(theta);
        double y2point = (double)r * Math.sin(theta);
        double x2 = (double)x1 + x2point;
        double y2 = (double)y1 + y2point;
        int x2_int = (int)x2;
        int y2_int = (int)y2;
        this.g.setColor(0xFF0000);
        this.g.drawLine(x1, y1, x2_int, y2_int);
    }

    private void showIndicators() {
        if (this.currentSpeed_speedometer >= this.speed_good_shift && this.currentSpeed_speedometer < this.speed_perfect_shift) {
            this.speed_limit_speedometer = this.speed_perfect_shift;
            this.sprite_indicator[0].setPosition(GameConfig.dispWidth / 2 - 15, GameConfig.dispHeight / 2 - 15);
            this.sprite_indicator[0].paint(this.g);
            this.which_gearShift = 1;
        } else if (this.currentSpeed_speedometer >= this.speed_perfect_shift && this.currentSpeed_speedometer < this.speed_bad_shift) {
            this.speed_limit_speedometer = this.speed_bad_shift;
            this.sprite_indicator[2].setPosition(GameConfig.dispWidth / 2 - 15, GameConfig.dispHeight / 2 - 15);
            this.sprite_indicator[2].paint(this.g);
            this.which_gearShift = 2;
        } else if (this.currentSpeed_speedometer >= this.speed_bad_shift) {
            this.speed_limit_speedometer = this.max_threshold;
            this.sprite_indicator[3].setPosition(GameConfig.dispWidth / 2 - 15, GameConfig.dispHeight / 2 - 15);
            this.sprite_indicator[3].paint(this.g);
            this.which_gearShift = 3;
            this.startLessVibration();
            this.moveUserCarBack();
            this.moveEnemyCarForward();
        }
    }

    private void showTime() {
        if (!this.raceFinished) {
            this.seconds_over = this.milli_sec_count / 1000;
            this.secondIndex = this.seconds_over < 10 ? "0" + this.seconds_over : "" + this.seconds_over;
            int left_milli = this.milli_sec_count % 1000;
            this.rem = left_milli / 10;
            this.milliLeftIndex = this.rem < 10 ? "0" + this.rem : "" + this.rem;
        }
        this.g.drawImage(this.img_timer_bg, GameConfig.dispWidth / 3, -2, 20);
        this.g.setColor(GameConfig.WHITE_COLOR);
        this.obj_utilities.drawTime(String.valueOf(this.secondIndex) + this.milliLeftIndex, GameConfig.dispWidth / 3 + 20, 10, this.g);
    }

    public void freeAllSounds() {
        this.stopMaxSound();
        this.stopMinSound();
    }

    public SetterGetter getAction(int x, int y) {
        SetterGetter obj = new SetterGetter();
        if (AssetsConfig.pointerSprite.collidesWith(this.sprite_accelerater, false)) {
            SplashScreen.sound_engine_start.play();
            this.sprite_accelerater.setPosition(GameConfig.dispWidth + 100, 0);
            this.sprite_accelerater.paint(this.g);
            this.isAccelerated = true;
            this.countDownStarts();
        } else if (GameConfig.moveBg) {
            if (AssetsConfig.pointerSprite.collidesWith(this.sprite_gear_up, false)) {
                this.gearUp = true;
                if (this.userCar.gearNumber < 6) {
                    ++this.userCar.gearNumber;
                    this.shiftGearUp();
                }
                this.userCar.setGearLimitSpeed((int)this.current_bg_speed);
            } else if (AssetsConfig.pointerSprite.collidesWith(this.sprite_gear_down, false)) {
                this.gearDown = true;
                this.soundBrake();
                this.stopMinSound();
                this.stopMaxSound();
                if (this.userCar.gearNumber > 1) {
                    --this.userCar.gearNumber;
                    this.shiftGearDown();
                }
                this.userCar.setGearLimitSpeed((int)this.current_bg_speed);
            }
        } else if (!this.isAccelerated) {
            this.obj_utilities.showAlert("Start the game with the accelerater.");
        }
        return obj;
    }

    private void countDownStarts() {
        if (this.countDownTimer == null) {
            this.countDownTimer = new Timer();
            this.countDownTimer.schedule((TimerTask)new CountDownTimer(), 0L, 1000L);
        }
    }

    public void actionReleased() {
        this.gearUp = false;
        this.gearDown = false;
    }

    private float getSpeed(int pGearNumber, int pWhichGearShift) {
        float bMax_speed = 0.0f;
        if (this.gearDown) {
            bMax_speed = (int)this.current_bg_speed;
            return this.obj_utilities.getRatioOfMaxSpeed(pGearNumber, bMax_speed);
        }
        bMax_speed = this.max_speed_user;
        float ratioSpeed = this.obj_utilities.getRatioOfMaxSpeed(pGearNumber, bMax_speed);
        if (pWhichGearShift == 1) {
            return ratioSpeed * 2.0f / 3.0f;
        }
        if (pWhichGearShift == 2) {
            return ratioSpeed;
        }
        if (pWhichGearShift == 3) {
            return ratioSpeed * 1.0f / 2.0f;
        }
        float current_speed = this.current_bg_speed - this.current_bg_speed / 10.0f;
        if (!(current_speed < this.default_bg_speed)) {
            return current_speed;
        }
        current_speed = this.default_bg_speed;
        return ratioSpeed;
    }

    private void shiftGearDown() {
        if (this.sprite_back_poster.getFrame() > 0) {
            this.sprite_back_poster.prevFrame();
            this.sprite_back_poster2.prevFrame();
        }
        this.current_bg_speed = this.getSpeed(this.userCar.gearNumber, 0);
        this.increment_score_by = 1;
        this.showIndicator = true;
        System.out.println("user car current speed: " + this.userCar.current_speed + ",user car gear speed limit: " + this.userCar.speed_limit);
        if (this.userCar.current_speed <= this.userCar.speed_limit) {
            this.currentSpeed_speedometer += 0.5;
        }
        this.wheel_1_userCar.setImage(this.wheel_img_slowmoving);
        this.wheel_2_userCar.setImage(this.wheel_img_slowmoving);
        this.wheel_1_enemyCar.setImage(this.wheel_img_fastmoving);
        this.wheel_2_enemyCar.setImage(this.wheel_img_fastmoving);
    }

    private void shiftGearUp() {
        this.stopVibration();
        if (this.showIndicator) {
            this.showIndicator = false;
            this.speed_limit_speedometer = this.userCar.gearNumber < 6 ? this.speed_good_shift : this.speed_perfect_shift;
            this.playGearChangeMusic();
            if (this.which_gearShift == 1) {
                this.increment_score_by = 3;
                if (SplashScreen.sound_engine_middle.player.getState() != 400) {
                    this.stopMaxSound();
                }
                this.currentSpeed_speedometer = this.speed_after_gearshift;
                this.current_bg_speed = this.getSpeed(this.userCar.gearNumber, this.which_gearShift);
                this.wheel_1_userCar.setImage(this.wheel_img_slowmoving);
                this.wheel_2_userCar.setImage(this.wheel_img_slowmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_slowmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_slowmoving);
                if (this.sprite_back_poster.getFrame() < 2) {
                    this.sprite_back_poster.nextFrame();
                    this.sprite_back_poster2.nextFrame();
                }
                this.setBGImagesSpeed();
            } else if (this.which_gearShift == 2) {
                this.increment_score_by = 2;
                this.currentSpeed_speedometer = this.speed_after_gearshift;
                this.current_bg_speed = this.getSpeed(this.userCar.gearNumber, this.which_gearShift);
                this.wheel_1_userCar.setImage(this.wheel_img_fastmoving);
                this.wheel_2_userCar.setImage(this.wheel_img_fastmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_slowmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_slowmoving);
                if (this.sprite_back_poster.getFrame() < 2) {
                    this.sprite_back_poster.nextFrame();
                    this.sprite_back_poster2.nextFrame();
                }
                this.setBGImagesSpeed();
            } else if (this.which_gearShift == 3) {
                this.increment_score_by = 0;
                this.currentSpeed_speedometer = this.speed_after_gearshift;
                if (SplashScreen.sound_engine_middle.player.getState() != 400) {
                    this.stopMaxSound();
                    this.PlayMinSound();
                }
                this.wheel_1_userCar.setImage(this.wheel_img_slowmoving);
                this.wheel_2_userCar.setImage(this.wheel_img_slowmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_fastmoving);
                this.wheel_1_enemyCar.setImage(this.wheel_img_fastmoving);
                this.current_bg_speed = this.getSpeed(this.userCar.gearNumber, this.which_gearShift);
                if (this.sprite_back_poster.getFrame() > 0) {
                    this.sprite_back_poster.prevFrame();
                    this.sprite_back_poster2.prevFrame();
                }
                this.setBGImagesSpeed();
            }
        } else {
            this.increment_score_by = 1;
            if (this.userCar.current_speed <= this.userCar.speed_limit && this.currentSpeed_speedometer > this.min_threshold) {
                this.currentSpeed_speedometer -= 0.5;
            }
            if (SplashScreen.sound_engine_middle.player.getState() != 400) {
                this.stopMaxSound();
                this.PlayMinSound();
            }
            this.soundBrake();
            this.current_bg_speed = this.getSpeed(this.userCar.gearNumber, 0);
            this.wheel_1_userCar.setImage(this.wheel_img_slowmoving);
            this.wheel_2_userCar.setImage(this.wheel_img_slowmoving);
            this.wheel_1_enemyCar.setImage(this.wheel_img_fastmoving);
            this.wheel_1_enemyCar.setImage(this.wheel_img_fastmoving);
            if (this.sprite_back_poster.getFrame() > 0) {
                this.sprite_back_poster.prevFrame();
                this.sprite_back_poster2.prevFrame();
            }
            this.setBGImagesSpeed();
        }
    }

    private void playGearChangeMusic() {
    }

    public void PlayMaxSound() {
    }

    public void stopMaxSound() {
    }

    public void PlayMinSound() {
        SplashScreen.sound_engine_middle.play();
    }

    public void stopMinSound() {
    }

    private void soundBrake() {
    }

    private void moveEnemyCarForward() {
        this.wheel_1_enemyCar.moveForward(this.variable_speed_enemy);
        this.wheel_2_enemyCar.moveForward(this.variable_speed_enemy);
        this.enemyCar.moveForward(this.variable_speed_enemy);
    }

    private void moveEnemyCarBack() {
        this.wheel_1_enemyCar.moveBack(this.variable_speed_enemy);
        this.wheel_2_enemyCar.moveBack(this.variable_speed_enemy);
        this.enemyCar.moveBack(this.variable_speed_enemy);
    }

    private void moveUserCarBack() {
        this.wheel_1_userCar.moveBack(this.variable_speed_user);
        this.wheel_2_userCar.moveBack(this.variable_speed_user);
        this.userCar.moveBack(this.variable_speed_user);
    }

    private void moveUserCarForward() {
        this.wheel_1_userCar.moveForward(this.variable_speed_user);
        this.wheel_2_userCar.moveForward(this.variable_speed_user);
        this.userCar.moveForward(this.variable_speed_user);
    }

    private void stopTheRace() {
        if (this.timer_race != null) {
            this.timer_race.cancel();
        }
        SplashScreen.sound_engine_middle.stopPlaying();
        SplashScreen.sound_race.play();
        GameConfig.moveBg = false;
        this.stopVibration();
        GameController.currentScreen = this.isMycarWon && GameConfig.moveToNextLevel ? new NextLevelScreen() : new LeaderBoardScreen();
    }

    private void setBGImagesSpeed() {
        this.sprite_back_poster.setSpeed(this.current_bg_speed);
        this.sprite_back_poster2.setSpeed(this.current_bg_speed);
        this.sprite_building.setSpeed(this.current_bg_speed);
        this.sprite_building2.setSpeed(this.current_bg_speed);
        this.sprite_road_mark.setSpeed(this.current_bg_speed);
        this.sprite_road_mark2.setSpeed(this.current_bg_speed);
    }

    public void DrawFinishingPoint() {
        if (this.x_img_finish > -20) {
            this.x_img_finish = (int)((float)this.x_img_finish - this.current_bg_speed);
        }
        this.g.drawImage(this.img_finish, this.x_img_finish, 90, 20);
    }

    private void startRaceTimer() {
        this.timer_race = new Timer();
        this.timer_race.schedule((TimerTask)new RaceTimer(), 0L, 100L);
    }

    private void InitRaceValues() {
        this.isAccelerated = false;
        GameConfig.moveBg = false;
        GameConfig.gameScore = 0;
        this.milli_sec_count = 0;
        this.yCoord_message = 120;
    }

    public void startCarAheadTimer() {
        this.timer_car_ahead = new Timer();
        this.timer_car_ahead.schedule((TimerTask)new CarAheadTimer(), 0L, 500L);
    }

    private int getRandomInteger(int aStart, int aEnd) {
        Random generator = new Random();
        generator.setSeed(System.currentTimeMillis());
        if (aStart > aEnd) {
            throw new IllegalArgumentException("Start cannot exceed End.");
        }
        long range = (long)aEnd - (long)aStart + 1L;
        long fraction = (long)((double)range * generator.nextDouble());
        return (int)(fraction + (long)aStart);
    }

    Image scaleImage(Image sourceImage, int newImageWidth, int newImageHeight) {
        int srcWidth = sourceImage.getWidth();
        int srcHeight = sourceImage.getHeight();
        int[] rgbSource = new int[srcWidth * srcHeight];
        int[] rgb2Scaled = new int[newImageWidth * newImageHeight];
        sourceImage.getRGB(rgbSource, 0, srcWidth, 0, 0, srcWidth, srcHeight);
        int tempScaleRatioWidth = (srcWidth << 16) / newImageWidth;
        int tempScaleRatioHeight = (srcHeight << 16) / newImageHeight;
        int i = 0;
        int y = 0;
        while (y < newImageHeight) {
            int x = 0;
            while (x < newImageWidth) {
                rgb2Scaled[i++] = rgbSource[srcWidth * (y * tempScaleRatioHeight >> 16) + (x * tempScaleRatioWidth >> 16)];
                ++x;
            }
            ++y;
        }
        return Image.createRGBImage((int[])rgb2Scaled, (int)newImageWidth, (int)newImageHeight, (boolean)true);
    }

    public void freeMemory() {
        try {
            this.img_building = null;
            this.img_road_mark = null;
            this.img_back_poster = null;
            this.img_timer_bg = null;
            this.img_gearshift_indicator = null;
            this.img_score = null;
            this.img_one = null;
            this.img_two = null;
            this.img_three = null;
            this.img_go = null;
            this.img_speedo_meter = null;
            this.img_gear_shift_down = null;
            this.img_gear_shift_up = null;
            this.img_accelerometer = null;
            this.img_gearPlus = null;
            this.img_gearMinus = null;
            this.img_meter_arrow = null;
            this.img_finish = null;
            this.car_lagging_forward = null;
            this.car_lagging_behind = null;
            this.img_enemycar = null;
            this.img_usercar = null;
            this.wheel_img_slowmoving = null;
            this.wheel_img_fastmoving = null;
            this.sprite_building = null;
            this.sprite_building2 = null;
            this.sprite_road_mark = null;
            this.sprite_road_mark2 = null;
            this.sprite_back_poster = null;
            this.sprite_back_poster2 = null;
            this.userCar = null;
            this.enemyCar = null;
            this.wheel_1_userCar = null;
            this.wheel_2_userCar = null;
            this.wheel_1_enemyCar = null;
            this.wheel_2_enemyCar = null;
            this.sprite_accelerater = null;
            this.pauseSprite = null;
            this.sprite_gear_down = null;
            this.sprite_gear_up = null;
            this.sprite_indicator = null;
            this.sprite_signs = null;
            this.str_level_details = null;
            this.scoreValue = null;
            this.obj_utilities = null;
            Runtime.getRuntime().freeMemory();
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CarAheadTimer
    extends TimerTask {
        CarAheadTimer() {
        }

        public void run() {
            try {
                ++RaceScreen.this.carAheadCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CountDownTimer
    extends TimerTask {
        CountDownTimer() {
        }

        public void run() {
            RaceScreen.this.startCount += 100;
            if (RaceScreen.this.startCount == 500) {
                this.startRace();
            }
        }

        private void startRace() {
            RaceScreen.this.startCount = 0;
            GameConfig.moveBg = true;
            RaceScreen.this.moveUserCarForward();
            RaceScreen.this.moveEnemyCarForward();
            RaceScreen.this.increment_score_by = 1;
            RaceScreen.this.PlayMinSound();
            RaceScreen.this.startRaceTimer();
            this.cancel();
        }
    }

    class IndicatorTimer
    extends TimerTask {
        IndicatorTimer() {
        }

        public void run() {
            RaceScreen.this.indicatorCount += 500;
            if (RaceScreen.this.indicatorCount == 1500) {
                this.cancel();
            }
        }
    }

    class RaceTimer
    extends TimerTask {
        RaceTimer() {
        }

        public void run() {
            try {
                RaceScreen.this.milli_sec_count += 100;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

