/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.UIManager;

public class InfiniteProgressIndicator
extends Component {
    public static final int SPINNER_SMALL = 0;
    public static final int SPINNER_MED = 1;
    public static final int SPINNER_LARGE = 2;
    private static final int SPINNER_CUSTOM = 3;
    private int angle;
    private int compWidth = 0;
    private int compHeight = 0;
    private long lastInvoke;
    private Image[] angles;

    public InfiniteProgressIndicator(int type) throws NullPointerException {
        this._initComponent(type, null);
    }

    public InfiniteProgressIndicator(Image image) throws NullPointerException {
        if (image == null) {
            throw new NullPointerException("Image is Null");
        }
        this._initComponent(3, image);
    }

    private void _initComponent(int type, Image image) throws NullPointerException {
        switch (type) {
            case 1: {
                image = UIManager.getInstance().getThemeImageConstant("spinnerMedImage");
                break;
            }
            case 2: {
                image = UIManager.getInstance().getThemeImageConstant("spinnerLargeImage");
                break;
            }
            case 0: {
                image = UIManager.getInstance().getThemeImageConstant("spinnerSmallImage");
            }
        }
        if (image == null) {
            throw new NullPointerException("Theme file dosent contain the images ");
        }
        Image fourtyFiveDeg = image.rotate(45);
        this.angles = new Image[]{image, fourtyFiveDeg, image.rotate(90), fourtyFiveDeg.rotate(90), image.rotate(180), fourtyFiveDeg.rotate(180), image.rotate(270), fourtyFiveDeg.rotate(270)};
        this.getStyle().setBgTransparency(0);
        this.compWidth = this.angles[0].getWidth();
        this.compHeight = this.angles[0].getHeight();
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(this.compWidth, this.compHeight);
    }

    public void initComponent() {
        this.getComponentForm().registerAnimated(this);
    }

    public void paint(Graphics g) {
        g.drawImage(this.angles[Math.abs(this.angle % this.angles.length)], this.getX(), this.getY());
    }

    public boolean animate() {
        long current = System.currentTimeMillis();
        if (current - this.lastInvoke > 100L) {
            this.lastInvoke = current;
            ++this.angle;
            return true;
        }
        return false;
    }

    public void deinitialize() {
        Form f = this.getComponentForm();
        if (f != null) {
            f.deregisterAnimated(this);
        }
    }
}

