/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.lwuit.components;

import com.nokia.lwuit.components.InfiniteProgressIndicator;
import com.nokia.lwuit.components.RefreshLoadBarListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;

public class RefreshLoadBar
extends Container {
    private Image icon;
    private Image top_border;
    private Image bottom_border;
    private Label labelText;
    private Label labelIcon;
    private String text = "Drag down to refresh";
    private boolean dragActivated;
    private int state;
    private int dragged = 0;
    final int preferredH;
    private int tensileLength = 20;
    private final int STATE_DRAG;
    private final int STATE_START;
    private final int STATE_PROGRESS;
    private Form parent;
    private Container placeHolder;
    private InfiniteProgressIndicator pIndicator = null;
    private RefreshLoadBarListener listener = null;
    private Border border = null;

    public RefreshLoadBar() {
        super(new BoxLayout(2));
        this.preferredH = 60;
        this.STATE_DRAG = 0;
        this.STATE_START = 1;
        this.STATE_PROGRESS = 2;
        this.setUIID("RefreshLoadBar");
        this._initComponentImpl();
        this.state = 0;
    }

    private void _initComponentImpl() {
        this.labelText = new Label(this.text);
        this.labelText.getStyle().setBgTransparency(0);
        this.icon = UIManager.getInstance().getThemeImageConstant("refreshLoadBarDownImage");
        this.labelIcon = new Label(this.icon);
        this.labelIcon.getStyle().setMargin(0, 0, 0, 0);
        this.labelIcon.getStyle().setBgTransparency(0);
        this.placeHolder = new Container(new BorderLayout());
        this.placeHolder.addComponent("Center", (Component)this.labelText);
        this.placeHolder.addComponent("East", (Component)this.labelIcon);
        this.placeHolder.getStyle().setBgTransparency(0);
        this.top_border = UIManager.getInstance().getThemeImageConstant("refreshShadowTopImage");
        this.bottom_border = UIManager.getInstance().getThemeImageConstant("refreshShadowBottomImage");
        this.getStyle().setPadding(0, 0, 0, 0);
        this.addComponent(this.placeHolder);
        this.setAlwaysTensile(true);
        this.setTensileLength(this.tensileLength);
        this.setScrollable(true);
        this.setScrollVisible(false);
    }

    public void setTensileLength(int tensileLength) {
        this.tensileLength = tensileLength;
    }

    public int getTensileLength() {
        return this.tensileLength;
    }

    public void pointerDragged(int x, int y) {
        if (!this.dragActivated) {
            this.dragActivated = false;
            this.parent = this.getComponentForm();
            this.parent.getComponentAt(x, y);
            this.dragged = this.parent.getY();
        }
        if (y >= this.dragged && y - this.dragged <= this.getPreferredH() + this.tensileLength && this.state == 0) {
            super.pointerDragged(x, y);
            this.setPreferredH(60);
            this.revalidate();
        }
        if (y - this.dragged >= this.getPreferredH() + this.tensileLength) {
            this.state = 1;
            this.setNextScreen();
        }
    }

    public void pointerReleased(int x, int y) {
        this.state = 2;
        super.pointerReleased(x, y);
        this.setNextScreen();
    }

    protected Dimension calcScrollSize() {
        return super.calcPreferredSize();
    }

    protected void paintGlass(Graphics g) {
        if (this.top_border != null && this.bottom_border != null && this.isVisible() && this.state != 2) {
            this.top_border = this.top_border.scaled(this.top_border.getWidth(), 6);
            this.bottom_border = this.bottom_border.scaled(this.bottom_border.getWidth(), 6);
            g.drawImage(this.top_border, this.getX() - this.getStyle().getPadding(1), this.getY());
            g.drawImage(this.bottom_border, this.getX() - this.getStyle().getPadding(1), this.getY() + this.getPreferredH() - this.bottom_border.getHeight());
        }
    }

    public void refreshFinished() {
        this.state = 0;
        if (this.pIndicator != null) {
            this.pIndicator.deinitialize();
        }
        this.setNextScreen();
        this.repaint();
    }

    public void setListener(RefreshLoadBarListener listener) {
        this.listener = listener;
    }

    private void setNextScreen() {
        if (this.state == 2) {
            this.placeHolder.removeComponent(this.labelIcon);
            if (this.pIndicator == null) {
                this.pIndicator = new InfiniteProgressIndicator(UIManager.getInstance().getThemeImageConstant("refreshLoadingImage"));
            }
            this.labelText.setText("Refreshing");
            this.placeHolder.addComponent("East", (Component)this.pIndicator);
            this.placeHolder.getStyle().setBgTransparency(255);
            this.placeHolder.getStyle().setBgColor(2729932);
            this.placeHolder.getStyle().setBorder(null);
            this.dragActivated = true;
            this.setPreferredSize(null);
            this.setShouldCalcPreferredSize(true);
            this.setShouldLayout(true);
            this.layoutContainer();
            this.revalidate();
            this.repaint();
            if (this.listener != null) {
                this.listener.notifyProgressInitialized();
            }
        } else if (this.state == 0) {
            this.placeHolder.removeComponent(this.pIndicator);
            this.icon = UIManager.getInstance().getThemeImageConstant("refreshLoadBarDownImage");
            this.labelIcon.setIcon(this.icon);
            this.labelText.setText("Drag down to refresh");
            this.placeHolder.getStyle().setBgTransparency(0);
            this.placeHolder.addComponent("East", (Component)this.labelIcon);
            this.setShouldCalcPreferredSize(true);
            this.setShouldLayout(true);
            this.layoutContainer();
            this.revalidate();
            this.repaint();
        } else if (this.state == 1) {
            this.labelText.setText("Release to start refresh");
            this.labelText.setEndsWith3Points(true);
            this.icon = UIManager.getInstance().getThemeImageConstant("refreshLoadBarUpImage");
            this.labelIcon.setIcon(this.icon);
        }
    }
}

