/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.PeerComponent;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;

public class BrowserComponent
extends Container {
    private Hashtable listeners;
    private PeerComponent internal;

    public BrowserComponent() {
        this.setUIID("BrowserComponent");
        PeerComponent c = Display.getInstance().getImplementation().createBrowserComponent(this);
        this.setLayout(new BorderLayout());
        this.addComponent("Center", (Component)c);
        this.internal = c;
    }

    public static boolean isNativeBrowserSupported() {
        return Display.getInstance().getImplementation().isNativeBrowserComponentSupported();
    }

    public void setProperty(String key, Object value) {
        Display.getInstance().getImplementation().setBrowserProperty(this.internal, key, value);
    }

    public String getTitle() {
        return Display.getInstance().getImplementation().getBrowserTitle(this.internal);
    }

    public String getURL() {
        return Display.getInstance().getImplementation().getBrowserURL(this.internal);
    }

    public void setURL(String url) {
        Display.getInstance().getImplementation().setBrowserURL(this.internal, url);
    }

    public void reload() {
        Display.getInstance().getImplementation().browserReload(this.internal);
    }

    public boolean hasBack() {
        return Display.getInstance().getImplementation().browserHasBack(this.internal);
    }

    public boolean hasForward() {
        return Display.getInstance().getImplementation().browserHasForward(this.internal);
    }

    public void back() {
        Display.getInstance().getImplementation().browserBack(this.internal);
    }

    public void forward() {
        Display.getInstance().getImplementation().browserForward(this.internal);
    }

    public void clearHistory() {
        Display.getInstance().getImplementation().browserClearHistory(this.internal);
    }

    public void setPage(String html, String baseUrl) {
        Display.getInstance().getImplementation().setBrowserPage(this.internal, html, baseUrl);
    }

    private EventDispatcher getEventDispatcher(String type, boolean autoCreate) {
        if (this.listeners == null) {
            if (!autoCreate) {
                return null;
            }
            this.listeners = new Hashtable();
            EventDispatcher ev = new EventDispatcher();
            this.listeners.put(type, ev);
            return ev;
        }
        EventDispatcher ev = (EventDispatcher)this.listeners.get(type);
        if (ev == null && autoCreate) {
            ev = new EventDispatcher();
            this.listeners.put(type, ev);
        }
        return ev;
    }

    public void addWebEventListener(String type, ActionListener listener) {
        this.getEventDispatcher(type, true).addListener(listener);
    }

    public void removeWebEventListener(String type, ActionListener listener) {
        EventDispatcher e = this.getEventDispatcher(type, false);
        if (e != null) {
            e.removeListener(listener);
            if (!e.hasListeners()) {
                this.listeners.remove(type);
            }
        }
    }

    public void fireWebEvent(String type, ActionEvent ev) {
        EventDispatcher e = this.getEventDispatcher(type, false);
        if (e != null) {
            e.fireActionEvent(ev);
        }
    }

    public void execute(String javaScript) {
        Display.getInstance().getImplementation().browserExecute(this.internal, javaScript);
    }

    public void exposeInJavaScript(Object o, String name) {
        Display.getInstance().getImplementation().browserExposeInJavaScript(this.internal, o, name);
    }
}

