/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Button
extends Label {
    public static final int STATE_ROLLOVER = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DEFAULT = 2;
    private EventDispatcher dispatcher = new EventDispatcher();
    private int state = 2;
    private Image pressedIcon;
    private Image rolloverIcon;
    private Image rolloverPressedIcon;
    private Image disabledIcon;
    private Command cmd;
    private boolean toggle;
    private int pressedX = -1;
    private int pressedY = -1;

    public Button() {
        this("");
    }

    public Button(String text) {
        this(text, (Image)null);
    }

    public Button(Command cmd) {
        this(cmd.getCommandName(), cmd.getIcon());
        this.addActionListener(cmd);
        this.cmd = cmd;
        this.setEnabled(cmd.isEnabled());
        this.updateCommand();
    }

    private void updateCommand() {
        this.setRolloverIcon(this.cmd.getRolloverIcon());
        this.setDisabledIcon(this.cmd.getDisabledIcon());
        this.setPressedIcon(this.cmd.getPressedIcon());
    }

    public void setCommand(Command cmd) {
        if (this.cmd != null) {
            this.removeActionListener(this.cmd);
        }
        this.cmd = cmd;
        this.setText(cmd.getCommandName());
        this.setIcon(cmd.getIcon());
        this.setEnabled(cmd.isEnabled());
        this.updateCommand();
        this.addActionListener(cmd);
    }

    public Button(Image icon) {
        this("", icon);
    }

    public Button(String text, Image icon) {
        super(text);
        this.setUIID("Button");
        this.setFocusable(true);
        this.setIcon(icon);
        this.pressedIcon = icon;
        this.rolloverIcon = icon;
        if (Display.getInstance().getDeviceType() == 3) {
            this.setEndsWith3Points(true);
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.state != 1) {
            this.state = 0;
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
        this.state = 2;
    }

    public int getState() {
        return this.state;
    }

    public Image getPressedIcon() {
        return this.pressedIcon;
    }

    public Image getRolloverPressedIcon() {
        return this.rolloverPressedIcon;
    }

    public void setRolloverPressedIcon(Image rolloverPressedIcon) {
        this.rolloverPressedIcon = rolloverPressedIcon;
    }

    public Image getDisabledIcon() {
        return this.disabledIcon;
    }

    public Image getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Image rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setPressedIcon(Image pressedIcon) {
        this.pressedIcon = pressedIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    public void setDisabledIcon(Image disabledIcon) {
        this.disabledIcon = disabledIcon;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if ((this.pressedIcon != null && this.pressedIcon.isAnimation() || this.rolloverIcon != null && this.rolloverIcon.isAnimation() || this.disabledIcon != null && this.disabledIcon.isAnimation()) && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public Image getIconFromState() {
        Image icon = this.getIcon();
        if (!this.isEnabled() && this.getDisabledIcon() != null) {
            return this.getDisabledIcon();
        }
        if (this.isToggle() && this.isSelected()) {
            icon = this.rolloverPressedIcon;
            if (icon == null && (icon = this.getPressedIcon()) == null) {
                icon = this.getIcon();
            }
            return icon;
        }
        switch (this.getState()) {
            case 2: {
                break;
            }
            case 1: {
                icon = this.getPressedIcon();
                if (icon != null) break;
                icon = this.getIcon();
                break;
            }
            case 0: {
                if (!Display.getInstance().shouldRenderSelection(this) || (icon = this.getRolloverIcon()) != null) break;
                icon = this.getIcon();
            }
        }
        return icon;
    }

    void fireActionEvent(int x, int y) {
        super.fireActionEvent();
        if (this.cmd != null) {
            Form f;
            ActionEvent ev = new ActionEvent(this.cmd, this, x, y);
            this.dispatcher.fireActionEvent(ev);
            if (!ev.isConsumed() && (f = this.getComponentForm()) != null) {
                f.actionCommandImpl(this.cmd, ev);
            }
        } else {
            this.dispatcher.fireActionEvent(new ActionEvent(this, x, y));
        }
        Display d = Display.getInstance();
        if (d.isBuiltinSoundsEnabled()) {
            d.playBuiltinSound("press");
        }
    }

    public void pressed() {
        this.state = 1;
        this.repaint();
    }

    public void released() {
        this.released(-1, -1);
    }

    public void released(int x, int y) {
        this.state = 0;
        this.fireActionEvent(x, y);
        this.repaint();
    }

    public void keyPressed(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.pressed();
        }
    }

    public void keyReleased(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.released();
        }
    }

    public void keyRepeated(int keyCode) {
    }

    protected void fireClicked() {
        this.pressed();
        this.released();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void pointerHover(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.requestFocus();
    }

    public void pointerPressed(int x, int y) {
        this.pressedX = x;
        this.pressedY = y;
        this.clearDrag();
        this.setDragActivated(false);
        this.pressed();
    }

    public void pointerReleased(int x, int y) {
        if (this.state == 1) {
            this.released(x, y);
        }
    }

    protected void dragInitiated() {
        this.state = Display.getInstance().shouldRenderSelection(this) ? 0 : 2;
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        int threshold = 10;
        if (x > this.pressedX + 10 || x < this.pressedX - 10 || y > this.pressedY + 10 || y < this.pressedY - 10) {
            this.pressedX = x;
            this.pressedY = y;
            if (Display.getInstance().shouldRenderSelection(this)) {
                if (this.state != 0) {
                    this.state = 0;
                    this.repaint();
                }
            } else {
                this.state = 2;
                this.repaint();
            }
        }
        super.pointerDragged(x, y);
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawButton(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getButtonPreferredSize(this);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    boolean isPressedStyle() {
        if (this.toggle && this.isSelected()) {
            if (this.hasFocus()) {
                return !Display.getInstance().shouldRenderSelection(this);
            }
            return true;
        }
        return this.state == 1;
    }

    public Command getCommand() {
        return this.cmd;
    }

    public boolean isSelected() {
        throw new RuntimeException();
    }

    public void setAlignment(int align) {
        super.setAlignment(align);
        this.getPressedStyle().setAlignment(align);
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
        if (toggle && this.getUIID().equals("CheckBox") || this.getUIID().equals("RadioButton")) {
            this.setUIID("ToggleButton");
        }
    }

    public boolean animate() {
        boolean a2 = super.animate();
        if (!this.isEnabled() && this.disabledIcon != null) {
            a2 = this.disabledIcon.isAnimation() && this.disabledIcon.animate() || a2;
        } else {
            switch (this.state) {
                case 0: {
                    a2 = this.rolloverIcon != null && this.rolloverIcon.isAnimation() && this.rolloverIcon.animate() || a2;
                    break;
                }
                case 1: {
                    a2 = this.pressedIcon != null && this.pressedIcon.isAnimation() && this.pressedIcon.animate() || a2;
                }
            }
        }
        return a2;
    }

    public boolean isOppositeSide() {
        return false;
    }

    public void resetState() {
        this.state = 2;
        this.repaint();
    }
}

