/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.RadioButton;
import java.util.Vector;

public class ButtonGroup {
    private Vector buttons = new Vector();
    private int selectedIndex = -1;

    public void add(RadioButton rb) {
        if (rb == null) {
            return;
        }
        if (!this.buttons.contains(rb)) {
            this.buttons.addElement(rb);
            if (rb.isSelected()) {
                this.setSelected(this.buttons.indexOf(rb));
            }
            rb.setButtonGroup(this);
        }
    }

    public void remove(RadioButton rb) {
        if (rb == null) {
            return;
        }
        this.buttons.removeElement(rb);
        if (rb.isSelected()) {
            this.clearSelection();
        }
        rb.setButtonGroup(null);
    }

    public void clearSelection() {
        if (this.selectedIndex != -1) {
            if (this.selectedIndex < this.buttons.size()) {
                ((RadioButton)this.buttons.elementAt(this.selectedIndex)).setSelected(false);
            }
            this.selectedIndex = -1;
        }
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public boolean isSelected() {
        return this.selectedIndex != -1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public RadioButton getRadioButton(int index) {
        if (index >= 0 && index < this.getButtonCount()) {
            return (RadioButton)this.buttons.elementAt(index);
        }
        return null;
    }

    public void setSelected(RadioButton rb) {
        if (rb != null) {
            int index = this.buttons.indexOf(rb);
            if (index < 0) {
                this.add(rb);
                index = this.buttons.indexOf(rb);
            }
            this.setSelected(index);
        } else {
            this.clearSelection();
        }
    }

    public void setSelected(int index) {
        if (index < 0 || index >= this.getButtonCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (this.selectedIndex == index) {
            return;
        }
        if (this.selectedIndex != -1) {
            ((RadioButton)this.buttons.elementAt(this.selectedIndex)).setSelectedImpl(false);
        }
        ((RadioButton)this.buttons.elementAt(index)).setSelectedImpl(true);
        this.selectedIndex = index;
    }
}

