/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public class Calendar
extends Container {
    private ComboBox month;
    private ComboBox year;
    private MonthView mv;
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] LABELS = new String[]{"Su", "M", "Tu", "W", "Th", "F", "Sa"};
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final long WEEK = 604800000L;
    private EventDispatcher dispatcher = new EventDispatcher();
    private EventDispatcher dataChangeListeners = new EventDispatcher();
    private long[] dates = new long[42];
    private boolean changesSelectedDateEnabled = true;
    private TimeZone tmz;

    public Calendar(long time) {
        this(time, TimeZone.getDefault());
    }

    public Calendar() {
        this(System.currentTimeMillis());
    }

    public Calendar(long time, TimeZone tmz) {
        super(new BorderLayout());
        this.tmz = tmz;
        this.setUIID("Calendar");
        Container upper = new Container(new FlowLayout(4));
        this.month = new ComboBox();
        this.year = new ComboBox();
        this.mv = new MonthView(time);
        Vector<String> months = new Vector<String>();
        for (int i = 0; i < MONTHS.length; ++i) {
            months.addElement("" + this.getLocalizedMonth(i));
        }
        DefaultListModel monthsModel = new DefaultListModel(months);
        int selected = months.indexOf(this.getLocalizedMonth(this.mv.getMonth()));
        this.month.setModel(monthsModel);
        this.month.setSelectedIndex(selected);
        this.month.addActionListener(this.mv);
        java.util.Calendar cal = java.util.Calendar.getInstance(tmz);
        cal.setTime(new Date(time));
        this.month.getStyle().setBgTransparency(0);
        int y = cal.get(1);
        Vector<String> years = new Vector<String>();
        for (int i = 2100; i > 1900; --i) {
            years.addElement("" + i);
        }
        DefaultListModel yearModel = new DefaultListModel(years);
        selected = years.indexOf("" + y);
        this.year.setModel(yearModel);
        this.year.setSelectedIndex(selected);
        this.year.getStyle().setBgTransparency(0);
        this.year.addActionListener(this.mv);
        Container cnt = new Container(new BoxLayout(1));
        cnt.setRTL(false);
        Container dateCnt = new Container(new BoxLayout(1));
        dateCnt.setUIID("CalendarDate");
        dateCnt.addComponent(this.month);
        dateCnt.addComponent(this.year);
        cnt.addComponent(dateCnt);
        upper.addComponent(cnt);
        this.addComponent("North", (Component)upper);
        this.addComponent("Center", (Component)this.mv);
    }

    public long getSelectedDay() {
        return this.mv.getSelectedDay();
    }

    private String getLocalizedMonth(int i) {
        Object o;
        Hashtable t = UIManager.getInstance().getResourceBundle();
        String text = MONTHS[i];
        if (t != null && (o = t.get("Calendar." + text)) != null) {
            text = (String)o;
        }
        return text;
    }

    void componentChanged() {
        java.util.Calendar cal = java.util.Calendar.getInstance(this.tmz);
        cal.set(1, this.mv.getYear());
        cal.set(2, this.mv.getMonth());
        cal.set(5, this.mv.getDayOfMonth());
        this.month.getParent().revalidate();
    }

    public Date getDate() {
        return new Date(this.mv.getSelectedDay());
    }

    public void setDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
        this.mv.setCurrentDay(d.getTime(), true);
        this.componentChanged();
    }

    public void setSelectedDate(Date d) {
        this.mv.setSelectedDay(d.getTime());
    }

    public void setCurrentDate(Date d) {
        this.mv.setCurrentDay(d.getTime(), true);
        this.componentChanged();
    }

    public void setTimeZone(TimeZone tmz) {
        this.tmz = tmz;
    }

    public TimeZone getTimeZone() {
        return this.tmz;
    }

    public void setMonthViewSelectedStyle(Style s) {
        this.mv.setSelectedStyle(s);
    }

    public void setMonthViewUnSelectedStyle(Style s) {
        this.mv.setUnselectedStyle(s);
    }

    public Style getMonthViewSelectedStyle() {
        return this.mv.getSelectedStyle();
    }

    public Style getMonthViewUnSelectedStyle() {
        return this.mv.getUnselectedStyle();
    }

    public void addActionListener(ActionListener l) {
        this.mv.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.mv.removeActionListener(l);
    }

    public void addDataChangeListener(DataChangedListener l) {
        this.mv.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangedListener l) {
        this.mv.removeDataChangeListener(l);
    }

    public void setChangesSelectedDateEnabled(boolean changesSelectedDateEnabled) {
        this.changesSelectedDateEnabled = changesSelectedDateEnabled;
    }

    public boolean isChangesSelectedDateEnabled() {
        return this.changesSelectedDateEnabled;
    }

    protected Button createDay() {
        Button day = new Button();
        day.setAlignment(4);
        day.setUIID("CalendarDay");
        day.setEndsWith3Points(false);
        day.setTickerEnabled(false);
        return day;
    }

    protected Label createDayTitle(int day) {
        String value = UIManager.getInstance().localize("Calendar." + DAYS[day], LABELS[day]);
        Label dayh = new Label(value, "CalendarTitle");
        dayh.setEndsWith3Points(false);
        dayh.setTickerEnabled(false);
        return dayh;
    }

    protected void updateButtonDayDate(Button dayButton, int currentMonth, int day) {
        dayButton.setText("" + day);
    }

    class MonthView
    extends Container
    implements ActionListener {
        private long currentDay;
        private Button[] buttons = new Button[42];
        private Button selected;
        private long selectedDay = -1L;

        public MonthView(long time) {
            super(new GridLayout(7, 7));
            int iter;
            this.setUIID("MonthView");
            for (iter = 0; iter < DAYS.length; ++iter) {
                this.addComponent(Calendar.this.createDayTitle(iter));
            }
            for (iter = 0; iter < this.buttons.length; ++iter) {
                this.buttons[iter] = Calendar.this.createDay();
                this.addComponent(this.buttons[iter]);
                if (iter <= 7) {
                    this.buttons[iter].setNextFocusUp(Calendar.this.year);
                }
                this.buttons[iter].addActionListener(this);
            }
            this.setCurrentDay(time);
        }

        public void setCurrentDay(long day) {
            this.setCurrentDay(day, false);
        }

        private void setCurrentDay(long day, boolean force) {
            this.repaint();
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearOld = cal.get(1);
            int monthOld = cal.get(2);
            int dayOld = cal.get(5);
            cal.setTime(new Date(day));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int yearNew = cal.get(1);
            int monthNew = cal.get(2);
            int dayNew = cal.get(5);
            Calendar.this.year.setSelectedItem("" + yearNew);
            Calendar.this.month.setSelectedIndex(monthNew);
            if (yearNew != yearOld || monthNew != monthOld || dayNew != dayOld || force) {
                int j;
                this.currentDay = cal.getTime().getTime();
                if (this.selectedDay == -1L) {
                    this.selectedDay = this.currentDay;
                }
                int month = cal.get(2);
                cal.set(5, 1);
                long startDate = cal.getTime().getTime();
                int dow = cal.get(7);
                cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                cal.set(10, 1);
                cal.set(11, 1);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                int lastDay = cal.get(5);
                int i = 0;
                if (dow > 1) {
                    while (dow > 1) {
                        cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                        dow = cal.get(7);
                    }
                    int previousMonthSunday = cal.get(5);
                    while (i <= lastDay - previousMonthSunday) {
                        this.buttons[i].setUIID("CalendarDay");
                        this.buttons[i].setEnabled(false);
                        this.buttons[i].setText("" + (previousMonthSunday + i));
                        ++i;
                    }
                }
                cal.set(2, (month + 1) % 12);
                cal.set(5, 1);
                cal.setTime(new Date(cal.getTime().getTime() - 86400000L));
                lastDay = cal.get(5);
                for (j = i; j < this.buttons.length && j - i + 1 <= lastDay; ++j) {
                    this.buttons[j].setEnabled(true);
                    ((Calendar)Calendar.this).dates[j] = startDate;
                    if (Calendar.this.dates[j] == this.selectedDay) {
                        this.buttons[j].setUIID("CalendarSelectedDay");
                        this.selected = this.buttons[j];
                    } else {
                        this.buttons[j].setUIID("CalendarDay");
                    }
                    Calendar.this.updateButtonDayDate(this.buttons[j], month, j - i + 1);
                    startDate += 86400000L;
                }
                int d = 1;
                while (j < this.buttons.length) {
                    this.buttons[j].setUIID("CalendarDay");
                    this.buttons[j].setEnabled(false);
                    this.buttons[j].setText("" + d++);
                    ++j;
                }
            }
        }

        public int getDayOfMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(5);
        }

        public int getMonth() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(2);
        }

        public void incrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (++month > 11) {
                month = 0;
                ++year;
            }
            this.setMonth(year, month);
        }

        private long getSelectedDay() {
            return this.selectedDay;
        }

        public void setSelectedDay(long selectedDay) {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(selectedDay));
            cal.set(10, 1);
            cal.set(11, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.selectedDay = cal.getTime().getTime();
        }

        private void setMonth(int year, int month) {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTimeZone(TimeZone.getDefault());
            cal.set(2, month);
            cal.set(5, 1);
            cal.set(1, year);
            Date date = cal.getTime();
            long d = date.getTime();
            while (cal.get(2) != month) {
                cal.setTime(new Date(d -= 86400000L));
            }
            this.setCurrentDay(d);
        }

        public void decrementMonth() {
            int month = this.getMonth();
            int year = this.getYear();
            if (--month < 0) {
                month = 11;
                --year;
            }
            this.setMonth(year, month);
        }

        public int getYear() {
            java.util.Calendar cal = java.util.Calendar.getInstance(Calendar.this.tmz);
            cal.setTime(new Date(this.currentDay));
            return cal.get(1);
        }

        public void addActionListener(ActionListener l) {
            Calendar.this.dispatcher.addListener(l);
        }

        public void removeActionListener(ActionListener l) {
            Calendar.this.dispatcher.removeListener(l);
        }

        public void addDataChangeListener(DataChangedListener l) {
            Calendar.this.dataChangeListeners.addListener(l);
        }

        public void removeDataChangeListener(DataChangedListener l) {
            Calendar.this.dataChangeListeners.removeListener(l);
        }

        protected void fireActionEvent() {
            Calendar.this.componentChanged();
            super.fireActionEvent();
            Calendar.this.dispatcher.fireActionEvent(new ActionEvent(Calendar.this));
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src instanceof ComboBox) {
                this.setMonth(Integer.parseInt((String)Calendar.this.year.getSelectedItem()), Calendar.this.month.getSelectedIndex());
                Calendar.this.componentChanged();
                return;
            }
            if (Calendar.this.changesSelectedDateEnabled) {
                for (int iter = 0; iter < this.buttons.length; ++iter) {
                    if (src != this.buttons[iter]) continue;
                    this.selected.setUIID("CalendarDay");
                    this.buttons[iter].setUIID("CalendarSelectedDay");
                    this.selectedDay = Calendar.this.dates[iter];
                    this.selected = this.buttons[iter];
                    this.fireActionEvent();
                    if (!this.getComponentForm().isSingleFocusMode()) {
                        this.setHandlesInput(false);
                    }
                    return;
                }
            }
        }
    }
}

