/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.UIManager;

public class ComponentGroup
extends Container {
    private String elementUIID = "GroupElement";
    private String groupFlag = "ComponentGroupBool";
    private boolean uiidsDirty;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ComponentGroup() {
        super(new BoxLayout(2));
        this.setUIID("ComponentGroup");
    }

    private void reverseRadio(Component cmp) {
        if (cmp instanceof ComboBox) {
            ((ComboBox)cmp).setActAsSpinnerDialog(this.uiidsDirty);
        }
    }

    void insertComponentAt(int index, Component cmp) {
        super.insertComponentAt(index, cmp);
        this.updateUIIDs();
    }

    public void refreshTheme() {
        super.refreshTheme();
        if (!UIManager.getInstance().isThemeConstant(this.groupFlag, false)) {
            if (this.uiidsDirty) {
                this.uiidsDirty = false;
                int count = this.getComponentCount();
                for (int iter = 0; iter < count; ++iter) {
                    this.restoreUIID(this.getComponentAt(iter));
                }
            }
        } else {
            this.updateUIIDs();
        }
    }

    void removeComponentImpl(Component cmp) {
        super.removeComponentImpl(cmp);
        Object o = cmp.getClientProperty("$origUIID");
        if (o != null) {
            cmp.setUIID((String)o);
        }
        this.updateUIIDs();
    }

    private void updateUIIDs() {
        if (!UIManager.getInstance().isThemeConstant(this.groupFlag, false)) {
            return;
        }
        int count = this.getComponentCount();
        if (count > 0) {
            this.uiidsDirty = true;
            if (count == 1) {
                this.updateUIID(this.elementUIID + "Only", this.getComponentAt(0));
            } else {
                this.updateUIID(this.elementUIID + "First", this.getComponentAt(0));
                if (count > 1) {
                    this.updateUIID(this.elementUIID + "Last", this.getComponentAt(count - 1));
                    for (int iter = 1; iter < count - 1; ++iter) {
                        this.updateUIID(this.elementUIID, this.getComponentAt(iter));
                    }
                }
            }
        }
    }

    private void updateUIID(String newUIID, Component c) {
        Object o = c.getClientProperty("$origUIID");
        if (o == null) {
            c.putClientProperty("$origUIID", c.getUIID());
        }
        c.setUIID(newUIID);
        this.reverseRadio(c);
    }

    private void restoreUIID(Component c) {
        String o = (String)c.getClientProperty("$origUIID");
        if (o != null) {
            c.setUIID(o);
        }
        this.reverseRadio(c);
    }

    public boolean isHorizontal() {
        return this.getLayout() instanceof BoxLayout && ((BoxLayout)this.getLayout()).getAxis() == 1;
    }

    public void setHorizontal(boolean horizontal) {
        if (horizontal) {
            this.setLayout(new BoxLayout(1));
        } else {
            this.setLayout(new BoxLayout(2));
        }
    }

    public String getElementUIID() {
        return this.elementUIID;
    }

    public void setElementUIID(String elementUIID) {
        this.elementUIID = elementUIID;
    }

    public String[] getPropertyNames() {
        return new String[]{"elementUIID", "displayName", "horizontal", "groupFlag"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ComponentGroup.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ComponentGroup.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ComponentGroup.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = ComponentGroup.class$("java.lang.String")) : class$java$lang$String};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("elementUIID")) {
            return this.getElementUIID();
        }
        if (name.equals("horizontal")) {
            if (this.isHorizontal()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("groupFlag")) {
            return this.groupFlag;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("elementUIID")) {
            this.setElementUIID((String)value);
            return null;
        }
        if (name.equals("horizontal")) {
            this.setHorizontal((Boolean)value);
            return null;
        }
        if (name.equals("groupFlag")) {
            this.setGroupFlag(this.groupFlag);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public String getGroupFlag() {
        return this.groupFlag;
    }

    public void setGroupFlag(String groupFlag) {
        this.groupFlag = groupFlag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

