/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.nokia.mid.ui.LCDUIUtil;
import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.VirtualKeyboard;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.ImplementationFactory;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.VirtualKeyboardInterface;
import com.sun.lwuit.impl.s40.S40Implementation;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import com.sun.lwuit.util.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

public class Display {
    private EventDispatcher errorHandler;
    boolean lwuitExited;
    public static final String SOUND_TYPE_ALARM = "alarm";
    public static final String SOUND_TYPE_CONFIRMATION = "confirmation";
    public static final String SOUND_TYPE_ERROR = "error";
    public static final String SOUND_TYPE_INFO = "info";
    public static final String SOUND_TYPE_WARNING = "warning";
    public static final String SOUND_TYPE_BUTTON_PRESS = "press";
    public static final int KEYBOARD_TYPE_UNKNOWN = 0;
    public static final int KEYBOARD_TYPE_NUMERIC = 1;
    public static final int KEYBOARD_TYPE_QWERTY = 2;
    public static final int KEYBOARD_TYPE_VIRTUAL = 3;
    public static final int KEYBOARD_TYPE_HALF_QWERTY = 4;
    private static final int POINTER_PRESSED = 1;
    private static final int POINTER_RELEASED = 2;
    private static final int POINTER_DRAGGED = 3;
    private static final int POINTER_HOVER = 8;
    private static final int POINTER_HOVER_RELEASED = 11;
    private static final int POINTER_HOVER_PRESSED = 12;
    private static final int KEY_PRESSED = 4;
    private static final int KEY_RELEASED = 5;
    private static final int KEY_LONG_PRESSED = 6;
    private static final int SIZE_CHANGED = 7;
    private static final int HIDE_NOTIFY = 9;
    private static final int SHOW_NOTIFY = 10;
    public static final int DENSITY_VERY_LOW = 10;
    public static final int DENSITY_LOW = 20;
    public static final int DENSITY_MEDIUM = 30;
    public static final int DENSITY_HIGH = 40;
    public static final int DENSITY_VERY_HIGH = 50;
    public static final int DENSITY_HD = 60;
    public static final int NON_TOUCH_DEVICE = 0;
    public static final int TOUCH_AND_TYPE_DEVICE = 1;
    public static final int FULL_TOUCH_DEVICE = 2;
    public static final int ASHA_DEVICE = 3;
    private static boolean pureTouch;
    private Graphics lwuitGraphics;
    private boolean touchScreen;
    private Hashtable localProperties;
    private boolean noSleep = false;
    private boolean autoFoldVKBOnFormSwitch = true;
    private int framerateLock = 30;
    public static final int GAME_FIRE = 8;
    public static final int GAME_LEFT = 2;
    public static final int GAME_RIGHT = 5;
    public static final int GAME_UP = 1;
    public static final int GAME_DOWN = 6;
    public static final int KEY_POUND = 35;
    private static final Display INSTANCE;
    static int transitionDelay;
    private LWUITImplementation impl;
    private boolean lwuitRunning = false;
    private Vector pendingSerialCalls = new Vector();
    private Thread edt;
    private Vector animationQueue;
    private boolean thirdSoftButton = false;
    private boolean editingText;
    public static final int SHOW_DURING_EDIT_IGNORE = 1;
    public static final int SHOW_DURING_EDIT_EXCEPTION = 2;
    public static final int SHOW_DURING_EDIT_ALLOW_DISCARD = 3;
    public static final int SHOW_DURING_EDIT_ALLOW_SAVE = 4;
    public static final int SHOW_DURING_EDIT_SET_AS_NEXT = 5;
    private int showDuringEdit;
    static final Object lock;
    private Vector inputEvents = new Vector();
    private boolean longPointerCharged;
    private boolean pointerPressedAndNotReleasedOrDragged;
    private int pointerX;
    private int pointerY;
    private boolean keyRepeatCharged;
    private boolean longPressCharged;
    private long longKeyPressTime;
    private int longPressInterval = 800;
    private long nextKeyRepeatEvent;
    private int keyRepeatValue;
    private int keyRepeatInitialIntervalTime = 800;
    private int keyRepeatNextIntervalTime = 10;
    private boolean lastInteractionWasKeypad;
    private boolean dragOccured;
    private boolean processingSerialCalls;
    private int PATHLENGTH;
    private float[] dragPathX;
    private float[] dragPathY;
    private long[] dragPathTime;
    private int dragPathOffset = 0;
    private int dragPathLength = 0;
    private long displayInitTime = 0L;
    private boolean allowMinimizing;
    public static final int COMMAND_BEHAVIOR_DEFAULT = 1;
    public static final int COMMAND_BEHAVIOR_SOFTKEY = 2;
    public static final int COMMAND_BEHAVIOR_TOUCH_MENU = 3;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR = 4;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_BACK = 5;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_RIGHT = 6;
    public static final int COMMAND_BEHAVIOR_NATIVE = 10;
    private int commandBehavior = 1;
    private static String selectedVirtualKeyboard;
    private static Hashtable virtualKeyboards;
    private boolean dropEvents;
    private static Resources nokiaResource;
    public static final String RES_FILENAME_ASHA_DEVICE = "/asha2013_theme.res";
    long time;
    FPSPainter fpspainter = new FPSPainter();
    private int previousKeyPressed;
    private int lastKeyPressed;
    private int devType = -1;

    private Display() {
    }

    Vector getAnimationQueue() {
        return this.animationQueue;
    }

    public static void init(Object m) {
        if (!Display.INSTANCE.lwuitRunning) {
            Display.INSTANCE.lwuitRunning = true;
            Display.INSTANCE.displayInitTime = System.currentTimeMillis();
            Display.INSTANCE.impl = ImplementationFactory.getInstance().createImplementation();
            Display.INSTANCE.impl.setDisplayLock(lock);
            Display.INSTANCE.impl.init(m);
            Display.INSTANCE.lwuitGraphics = new Graphics(Display.INSTANCE.impl.getNativeGraphics());
            Display.INSTANCE.impl.setLWUITGraphics(Display.INSTANCE.lwuitGraphics);
            if (Display.INSTANCE.impl.isThirdSoftButton()) {
                Display.INSTANCE.thirdSoftButton = true;
            }
            if (Display.INSTANCE.impl.getSoftkeyCount() > 0) {
                MenuBar.leftSK = Display.INSTANCE.impl.getSoftkeyCode(0)[0];
                if (Display.INSTANCE.impl.getSoftkeyCount() > 1) {
                    MenuBar.rightSK = Display.INSTANCE.impl.getSoftkeyCode(1)[0];
                    if (Display.INSTANCE.impl.getSoftkeyCode(1).length > 1) {
                        MenuBar.rightSK2 = Display.INSTANCE.impl.getSoftkeyCode(1)[1];
                    }
                }
                MenuBar.backSK = Display.INSTANCE.impl.getBackKeyCode();
                MenuBar.backspaceSK = Display.INSTANCE.impl.getBackspaceKeyCode();
                MenuBar.clearSK = Display.INSTANCE.impl.getClearKeyCode();
            }
            Display.INSTANCE.PATHLENGTH = Display.INSTANCE.impl.getDragPathLength();
            Display.INSTANCE.dragPathX = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathY = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathTime = new long[Display.INSTANCE.PATHLENGTH];
            int devtype = INSTANCE.getDeviceType();
            boolean bl = pureTouch = devtype != 0;
            if (Display.INSTANCE.edt == null) {
                Display.INSTANCE.touchScreen = Display.INSTANCE.impl.isTouchDevice();
                Display.INSTANCE.edt = new Thread((Runnable)new RunnableWrapper(null, 3), "EDT");
                Display.INSTANCE.edt.setPriority(6);
                Display.INSTANCE.edt.start();
            }
            try {
                javax.microedition.lcdui.Display nativeDisplay = javax.microedition.lcdui.Display.getDisplay((MIDlet)((MIDlet)m));
                UIManager.getInstance().setNativeDisplay(nativeDisplay);
                UIManager.getInstance().loadThemeForDeviceType(RES_FILENAME_ASHA_DEVICE, 3, "NokiaTheme");
                UIManager.getInstance().loadThemeForDeviceType("/full_touch_theme.res", 2, "NokiaTheme");
                UIManager.getInstance().loadThemeForDeviceType("/nokia_theme.res", 1, "NokiaTheme");
                UIManager.getInstance().loadThemeForDeviceType("/nokia_non_touch_theme.res", 0, "NokiaTheme");
            }
            catch (IOException e) {
                System.out.println("Can't load Nokia Theme");
                e.printStackTrace();
            }
            VirtualKeyboard vkb = new VirtualKeyboard();
            INSTANCE.registerVirtualKeyboard(vkb);
            if (INSTANCE.getDeviceType() == 2 || INSTANCE.getDeviceType() == 3) {
                INSTANCE.setCommandBehavior(10);
                if (Display.INSTANCE.impl instanceof S40Implementation) {
                    ((S40Implementation)Display.INSTANCE.impl).setHideMenu(true);
                }
            }
        } else {
            Display.INSTANCE.impl.confirmControlView();
        }
        UIManager.getInstance().loadLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinitialize() {
        Display.INSTANCE.lwuitRunning = false;
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public static boolean isInitialized() {
        return Display.INSTANCE.lwuitRunning;
    }

    public static Display getInstance() {
        return INSTANCE;
    }

    public void setForceFullScreen(boolean mode) {
        if (Display.INSTANCE.impl instanceof S40Implementation) {
            ((S40Implementation)Display.INSTANCE.impl).setForceFullScreen(mode);
        }
    }

    public boolean isForceFullScreen() {
        if (Display.INSTANCE.impl instanceof S40Implementation) {
            return ((S40Implementation)Display.INSTANCE.impl).isForceFullScreen();
        }
        return false;
    }

    public int getDragStartPercentage() {
        return this.getImplementation().getDragStartPercentage();
    }

    public void setDragStartPercentage(int dragStartPercentage) {
        this.getImplementation().setDragStartPercentage(dragStartPercentage);
    }

    public LWUITImplementation getImplementation() {
        return this.impl;
    }

    public void setFramerate(int rate) {
        this.framerateLock = 1000 / rate;
    }

    public void vibrate(int duration) {
        this.impl.vibrate(duration);
    }

    public void flashBacklight(int duration) {
        this.impl.flashBacklight(duration);
    }

    public void setShowDuringEditBehavior(int showDuringEdit) {
        this.showDuringEdit = showDuringEdit;
    }

    public int getShowDuringEditBehavior() {
        return this.showDuringEdit;
    }

    public int getFrameRate() {
        return 1000 / this.framerateLock;
    }

    public boolean isEdt() {
        return this.edt == Thread.currentThread();
    }

    void playDialogSound(int type) {
        this.impl.playDialogSound(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable r) {
        Object object = lock;
        synchronized (object) {
            this.pendingSerialCalls.addElement(r);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r) {
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        this.flushEdt();
        Object object = lock;
        synchronized (object) {
            while (!c.isDone()) {
                try {
                    lock.wait(50L);
                }
                catch (InterruptedException err) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r, int timeout) {
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        Object object = lock;
        synchronized (object) {
            long t = System.currentTimeMillis();
            while (!c.isDone()) {
                try {
                    lock.wait(20L);
                }
                catch (InterruptedException err) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - t < (long)timeout) continue;
                return;
            }
        }
    }

    void flushEdt() {
        if (!this.isEdt()) {
            return;
        }
        while (!this.shouldEDTSleepNoFormAnimation()) {
            this.edtLoopImpl();
        }
        while (this.animationQueue != null && this.animationQueue.size() > 0) {
            this.edtLoopImpl();
        }
    }

    private void restoreMenu(Form f) {
        if (f != null) {
            f.restoreMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTransitionAnimation() {
        Animation ani = (Animation)this.animationQueue.elementAt(0);
        if (!ani.animate()) {
            this.animationQueue.removeElementAt(0);
            if (ani instanceof Transition) {
                Form source = (Form)((Transition)ani).getSource();
                this.restoreMenu(source);
                if (this.animationQueue.size() > 0) {
                    ani = (Animation)this.animationQueue.elementAt(0);
                    if (ani instanceof Transition) {
                        ((Transition)ani).initTransition();
                    }
                } else {
                    Form f = (Form)((Transition)ani).getDestination();
                    this.restoreMenu(f);
                    if (source == null || source == this.impl.getCurrentForm() || source == this.getCurrent()) {
                        this.setCurrentForm(f);
                    }
                    ((Transition)ani).cleanup();
                }
                return;
            }
        }
        ani.paint(this.lwuitGraphics);
        this.impl.flushGraphics();
        if (transitionDelay > 0) {
            try {
                Object source = lock;
                synchronized (source) {
                    lock.wait(transitionDelay);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainEDTLoop() {
        block17: {
            this.impl.initEDT();
            try {
                Object object = lock;
                synchronized (object) {
                    while (this.impl.getCurrentForm() == null) {
                        if (this.shouldEDTSleep()) {
                            lock.wait();
                        }
                        if (this.animationQueue != null && this.animationQueue.size() > 0) {
                            this.paintTransitionAnimation();
                            continue;
                        }
                        this.processSerialCalls();
                    }
                }
            }
            catch (Throwable err) {
                if (this.impl.handleEDTException(err)) break block17;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent(err));
                }
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        while (this.lwuitRunning) {
            try {
                Object err = lock;
                synchronized (err) {
                    if (this.shouldEDTSleep()) {
                        this.impl.edtIdle(true);
                        lock.wait();
                        this.impl.edtIdle(false);
                    }
                }
                this.edtLoopImpl();
            }
            catch (Throwable err) {
                err.printStackTrace();
                if (this.impl.handleEDTException(err)) continue;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent(err));
                    continue;
                }
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        Display.INSTANCE.impl.deinitialize();
        Display.INSTANCE.edt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edtLoopImpl() {
        block19: {
            try {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    if (this.noSleep) break block19;
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(Math.max(1L, (long)this.framerateLock - this.time));
                        break block19;
                    }
                }
                this.paintTransitionAnimation();
                Object object = lock;
                synchronized (object) {
                    lock.wait(Math.max(1L, (long)this.framerateLock - this.time));
                }
                return;
            }
            catch (OutOfMemoryError err) {
                System.out.println("outofMemory error");
            }
            catch (Exception ignor) {
                ignor.printStackTrace();
            }
        }
        long currentTime = System.currentTimeMillis();
        while (this.inputEvents.size() > 0) {
            int[] i = (int[])this.inputEvents.elementAt(0);
            this.inputEvents.removeElementAt(0);
            this.handleEvent(i);
        }
        try {
            this.lwuitGraphics.setGraphics(this.impl.getNativeGraphics());
            this.impl.paintDirty();
        }
        catch (OutOfMemoryError err) {
            System.out.println("outofmemory error");
        }
        Form current = this.impl.getCurrentForm();
        if (current != null) {
            try {
                current.repaintAnimations();
                long t = System.currentTimeMillis();
                if (this.keyRepeatCharged && this.nextKeyRepeatEvent <= t) {
                    current.keyRepeated(this.keyRepeatValue);
                    this.nextKeyRepeatEvent = t + (long)this.keyRepeatNextIntervalTime;
                }
                if (this.longPressCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
                    this.longPressCharged = false;
                    current.longKeyPress(this.keyRepeatValue);
                }
                if (this.longPointerCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
                    this.longPointerCharged = false;
                    current.longPointerPress(this.pointerX, this.pointerY);
                }
            }
            catch (OutOfMemoryError err) {
                // empty catch block
            }
            this.processSerialCalls();
        }
        this.time = System.currentTimeMillis() - currentTime;
    }

    boolean hasNoSerialCallsPending() {
        return this.pendingSerialCalls.size() == 0;
    }

    public void onEditingComplete(Component c, String text) {
        c.onEditComplete(text);
        c.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSerialCalls() {
        this.processingSerialCalls = true;
        int size = this.pendingSerialCalls.size();
        if (size > 0) {
            Object[] array = null;
            Object object = lock;
            synchronized (object) {
                size = this.pendingSerialCalls.size();
                array = new Runnable[size];
                this.pendingSerialCalls.copyInto(array);
                if (size == this.pendingSerialCalls.size()) {
                    this.pendingSerialCalls.removeAllElements();
                } else {
                    for (int iter = 0; iter < size; ++iter) {
                        this.pendingSerialCalls.removeElementAt(0);
                    }
                }
            }
            for (int iter = 0; iter < size; ++iter) {
                array[iter].run();
            }
            Object object2 = lock;
            synchronized (object2) {
                lock.notify();
            }
        }
        this.processingSerialCalls = false;
    }

    boolean isProcessingSerialCalls() {
        return this.processingSerialCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDisplay() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndBlock(Runnable r, boolean dropEvents) {
        this.dropEvents = dropEvents;
        if (this.isEdt()) {
            RunnableWrapper w = new RunnableWrapper(r, 1);
            RunnableWrapper.pushToThreadPool(w);
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(2L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            while (!w.isDone() && this.lwuitRunning) {
                this.edtLoopImpl();
            }
            if (w.getErr() != null) {
                throw w.getErr();
            }
        } else {
            r.run();
        }
        this.dropEvents = false;
    }

    public void invokeAndBlock(Runnable r) {
        this.invokeAndBlock(r, false);
    }

    public boolean isTouchScreenDevice() {
        return this.touchScreen;
    }

    public void setTouchScreenDevice(boolean touchScreen) {
        this.touchScreen = touchScreen;
    }

    public void setNoSleep(boolean noSleep) {
        this.noSleep = noSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Form newForm, boolean reverse) {
        if (this.edt == null) {
            throw new IllegalStateException("Initialize must be invoked before setCurrent!");
        }
        if (this.autoFoldVKBOnFormSwitch && !(newForm instanceof Dialog)) {
            this.setShowVirtualKeyboard(false);
        }
        if (this.editingText) {
            switch (this.showDuringEdit) {
                case 3: {
                    break;
                }
                case 4: {
                    this.impl.saveTextEditingState();
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Show during edit");
                }
                case 1: {
                    return;
                }
                case 5: {
                    this.impl.setCurrentForm(newForm);
                    return;
                }
            }
        }
        if (!this.isEdt()) {
            this.callSerially(new RunnableWrapper(newForm, null, reverse));
            return;
        }
        Form current = this.impl.getCurrentForm();
        if (current != null && current.isInitialized()) {
            current.deinitializeImpl();
        }
        if (!newForm.isInitialized()) {
            newForm.initComponentImpl();
            if (this.impl instanceof S40Implementation) {
                ((S40Implementation)this.impl).setCurrentGestureListener(newForm);
            }
        }
        if (newForm.getWidth() != this.getDisplayWidth() || newForm.getHeight() != this.getDisplayHeight()) {
            newForm.setSize(new Dimension(this.getDisplayWidth(), this.getDisplayHeight()));
            newForm.setShouldCalcPreferredSize(true);
            newForm.layoutContainer();
        }
        Object object = lock;
        synchronized (object) {
            Transition t;
            Object o;
            boolean transitionExists = false;
            if (this.animationQueue != null && this.animationQueue.size() > 0 && (o = this.animationQueue.lastElement()) instanceof Transition) {
                current = (Form)((Transition)o).getDestination();
                this.impl.setCurrentForm(current);
            }
            if (current != null) {
                if (current instanceof Dialog && ((Dialog)current).isMenu()) {
                    t = current.getTransitionOutAnimator();
                    if (t != null && ((Dialog)current).getPreviousForm() != null) {
                        this.initTransition(t.copy(false), current, ((Dialog)current).getPreviousForm());
                    }
                    current = ((Dialog)current).getPreviousForm();
                    this.impl.setCurrentForm(current);
                }
                if (newForm != current && (current != null && current.getTransitionOutAnimator() != null || newForm.getTransitionInAnimator() != null)) {
                    if (this.animationQueue == null) {
                        this.animationQueue = new Vector();
                    }
                    if (current != null && !(newForm instanceof Dialog)) {
                        t = current.getTransitionOutAnimator();
                        if (current != null && t != null) {
                            transitionExists = this.initTransition(t.copy(reverse), current, newForm);
                        }
                    }
                    if (current != null && !(current instanceof Dialog) && (t = newForm.getTransitionInAnimator()) != null) {
                        transitionExists = this.initTransition(t.copy(reverse), current, newForm);
                    }
                }
            }
            lock.notify();
            if (!transitionExists) {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    this.setCurrentForm(newForm);
                } else {
                    t = CommonTransitions.createEmpty();
                    this.initTransition(t, current, newForm);
                }
            }
        }
    }

    private boolean initTransition(Transition transition, Form source, Form dest) {
        try {
            dest.setVisible(true);
            transition.init(source, dest);
            this.animationQueue.addElement(transition);
            if (this.animationQueue.size() == 1) {
                transition.initTransition();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            transition.cleanup();
            this.animationQueue.removeElement(transition);
            return false;
        }
        return true;
    }

    void setCurrentForm(Form newForm) {
        boolean forceShow = false;
        Form current = this.impl.getCurrentForm();
        if (current != null) {
            current.setVisible(false);
        } else {
            forceShow = true;
        }
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        current = newForm;
        this.impl.setCurrentForm(current);
        current.setVisible(true);
        if (forceShow || !this.allowMinimizing) {
            this.impl.confirmControlView();
        }
        int w = current.getWidth();
        int h = current.getHeight();
        if (this.isEdt() && (w != this.impl.getDisplayWidth() || h != this.impl.getDisplayHeight())) {
            current.sizeChangedInternal(this.impl.getDisplayWidth(), this.impl.getDisplayHeight());
        } else {
            this.repaint(current);
        }
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        if (Display.getInstance().isNativeCommands()) {
            Display.getInstance().getImplementation().setNativeCommands(newForm.getMenuBar().getCommands());
        }
        newForm.onShowCompletedImpl();
    }

    public void setTransitionYield(int transitionD) {
        transitionDelay = transitionD;
    }

    public void editString(Component cmp, int maxSize, int constraint, String text) {
        this.editString(cmp, maxSize, constraint, text, 0);
    }

    public void editString(Component cmp, int maxSize, int constraint, String text, int initiatingKeycode) {
        this.editingText = true;
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        this.impl.editString(cmp, maxSize, constraint, text, initiatingKeycode);
        this.editingText = false;
    }

    public boolean minimizeApplication() {
        return this.getImplementation().minimizeApplication();
    }

    public boolean isMinimized() {
        return this.getImplementation().isMinimized();
    }

    public void restoreMinimizedApplication() {
        this.getImplementation().restoreMinimizedApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInputEvent(int[] ev) {
        Object object = lock;
        synchronized (object) {
            if (this.dropEvents && (ev[0] == 4 || ev[0] == 5 || ev[0] == 1 || ev[0] == 2 || ev[0] == 3 || ev[0] == 8)) {
                return;
            }
            this.inputEvents.addElement(ev);
            lock.notify();
        }
    }

    private int[] createPointerEvent(int[] x, int[] y, int eventType) {
        int stamp = (int)(System.currentTimeMillis() - this.displayInitTime);
        if (x.length == 1) {
            return new int[]{eventType, x[0], y[0], stamp};
        }
        int[] arr = new int[2 + x.length * 2];
        arr[0] = eventType;
        int arrayOffset = 1;
        for (int iter = 0; iter < x.length; ++iter) {
            arr[arrayOffset] = x[iter];
            arr[++arrayOffset] = y[iter];
            ++arrayOffset;
        }
        arr[arrayOffset] = stamp;
        return arr;
    }

    private int[] createKeyEvent(int keyCode, boolean pressed) {
        if (pressed) {
            return new int[]{4, keyCode};
        }
        return new int[]{5, keyCode};
    }

    public void keyPressed(int keyCode) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createKeyEvent(keyCode, true));
        this.lastInteractionWasKeypad = this.lastInteractionWasKeypad || keyCode != MenuBar.leftSK && keyCode != MenuBar.clearSK && keyCode != MenuBar.backSK;
        this.longPressCharged = this.keyRepeatCharged = keyCode >= 0 || this.getGameAction(keyCode) > 0 || keyCode == this.impl.getClearKeyCode();
        this.longKeyPressTime = System.currentTimeMillis();
        this.keyRepeatValue = keyCode;
        this.nextKeyRepeatEvent = System.currentTimeMillis() + (long)this.keyRepeatInitialIntervalTime;
        this.previousKeyPressed = this.lastKeyPressed;
        this.lastKeyPressed = keyCode;
    }

    public void keyReleased(int keyCode) {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        if (keyCode != this.lastKeyPressed) {
            if (keyCode != this.previousKeyPressed) {
                return;
            }
            this.previousKeyPressed = 0;
        } else {
            this.lastKeyPressed = 0;
        }
        this.addInputEvent(this.createKeyEvent(keyCode, false));
    }

    void keyRepeatedInternal(int keyCode) {
    }

    public void pointerDragged(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.longPointerCharged = false;
        this.addInputEvent(this.createPointerEvent(x, y, 3));
    }

    public void pointerHover(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 8));
    }

    public void pointerHoverPressed(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 12));
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 11));
    }

    public void pointerPressed(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.lastInteractionWasKeypad = false;
        this.longPointerCharged = true;
        this.longKeyPressTime = System.currentTimeMillis();
        this.pointerX = x[0];
        this.pointerY = y[0];
        this.addInputEvent(this.createPointerEvent(x, y, 1));
    }

    public void pointerReleased(int[] x, int[] y) {
        this.longPointerCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 2));
    }

    public void sizeChanged(int w, int h) {
        Form current = this.impl.getCurrentForm();
        if (current == null) {
            return;
        }
        this.addInputEvent(this.createSizeChangedEvent(w, h));
    }

    private int[] createSizeChangedEvent(int w, int h) {
        return new int[]{7, w, h};
    }

    public void hideNotify() {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        this.pointerPressedAndNotReleasedOrDragged = false;
        this.addInputEvent(new int[]{9});
    }

    public void showNotify() {
        this.addInputEvent(new int[]{10});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEDTSleepNoFormAnimation() {
        boolean b;
        Object object = lock;
        synchronized (object) {
            b = this.inputEvents.size() == 0 && this.hasNoSerialCallsPending() && (!this.keyRepeatCharged || !this.longPressCharged);
        }
        return b;
    }

    private void updateDragSpeedStatus(int[] ev) {
        this.dragPathX[this.dragPathOffset] = this.pointerEvent(1, ev)[0];
        this.dragPathY[this.dragPathOffset] = this.pointerEvent(2, ev)[0];
        this.dragPathTime[this.dragPathOffset] = this.displayInitTime + (long)ev[ev.length - 1];
        if (this.dragPathLength < this.PATHLENGTH) {
            ++this.dragPathLength;
        }
        ++this.dragPathOffset;
        if (this.dragPathOffset >= this.PATHLENGTH) {
            this.dragPathOffset = 0;
        }
    }

    private void handleEvent(int[] ev) {
        Form f = this.getCurrentUpcomingForm(true);
        if (f == null) {
            return;
        }
        switch (ev[0]) {
            case 4: {
                f.keyPressed(ev[1]);
                break;
            }
            case 5: {
                f.keyReleased(ev[1]);
                break;
            }
            case 1: {
                this.dragOccured = false;
                this.dragPathLength = 0;
                this.pointerPressedAndNotReleasedOrDragged = true;
                f.pointerPressed(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 2: {
                this.pointerPressedAndNotReleasedOrDragged = false;
                f.pointerReleased(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 3: {
                this.dragOccured = true;
                this.updateDragSpeedStatus(ev);
                this.pointerPressedAndNotReleasedOrDragged = false;
                f.pointerDragged(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 8: {
                this.updateDragSpeedStatus(ev);
                f.pointerHover(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 11: {
                f.pointerHoverReleased(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 12: {
                f.pointerHoverPressed(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 7: {
                f.sizeChangedInternal(ev[1], ev[2]);
                break;
            }
            case 9: {
                f.hideNotify();
                break;
            }
            case 10: {
                f.showNotify();
            }
        }
    }

    public boolean hasDragOccured() {
        return this.dragOccured;
    }

    private int[] pointerEvent(int off, int[] event) {
        int[] peX = new int[(event.length - 1) / 2];
        int offset = 0;
        for (int iter = off; iter < event.length - 1; iter += 2) {
            peX[offset] = event[iter];
            ++offset;
        }
        return peX;
    }

    boolean shouldEDTSleep() {
        Form current = this.impl.getCurrentForm();
        return !(current != null && current.hasAnimations() || this.animationQueue != null && this.animationQueue.size() != 0 || this.inputEvents.size() != 0 || this.impl.hasPendingPaints() || !this.hasNoSerialCallsPending() || this.keyRepeatCharged || this.longPointerCharged);
    }

    Object getVideoControl(Object player) {
        return this.impl.getVideoControl(player);
    }

    Form getCurrentInternal() {
        return this.impl.getCurrentForm();
    }

    Form getCurrentUpcoming() {
        return this.getCurrentUpcomingForm(false);
    }

    private Form getCurrentUpcomingForm(boolean includeMenus) {
        Form upcoming = null;
        if (this.animationQueue != null) {
            int size = this.animationQueue.size();
            for (int iter = 0; iter < size; ++iter) {
                Object o = this.animationQueue.elementAt(iter);
                if (!(o instanceof Transition)) continue;
                upcoming = (Form)((Transition)o).getDestination();
            }
        }
        if (upcoming == null) {
            if (includeMenus) {
                Form f = this.impl.getCurrentForm();
                if (f instanceof Dialog && ((Dialog)f).isDisposed()) {
                    return this.getCurrent();
                }
                return f;
            }
            return this.getCurrent();
        }
        return upcoming;
    }

    public Form getCurrent() {
        Form current = this.impl.getCurrentForm();
        if (current != null && current instanceof Dialog && (((Dialog)current).isMenu() || ((Dialog)current).isDisposed())) {
            Form p = current.getPreviousForm();
            if (p != null) {
                return p;
            }
            if (this.animationQueue != null) {
                int size = this.animationQueue.size();
                for (int iter = 0; iter < size; ++iter) {
                    Object o = this.animationQueue.elementAt(iter);
                    if (!(o instanceof Transition)) continue;
                    return (Form)((Transition)o).getDestination();
                }
            }
        }
        return current;
    }

    public int numAlphaLevels() {
        return this.impl.numAlphaLevels();
    }

    public int numColors() {
        return this.impl.numColors();
    }

    public int getDisplayWidth() {
        return this.impl.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.impl.getDisplayHeight();
    }

    void repaint(Animation cmp) {
        this.impl.repaint(cmp);
    }

    public int convertToPixels(int dipCount, boolean horizontal) {
        return this.impl.convertToPixels(dipCount, horizontal);
    }

    public int getGameAction(int keyCode) {
        return this.impl.getGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return this.impl.getKeyCode(gameAction);
    }

    public boolean isThirdSoftButton() {
        return this.thirdSoftButton;
    }

    public void setThirdSoftButton(boolean thirdSoftButton) {
        this.thirdSoftButton = thirdSoftButton;
    }

    public void setShowVirtualKeyboard(boolean show) {
        VirtualKeyboardInterface vkb;
        if (this.isTouchScreenDevice() && (vkb = this.getDefaultVirtualKeyboard()) != null) {
            vkb.showKeyboard(show);
        }
    }

    public boolean isVirtualKeyboardShowing() {
        if (!this.isTouchScreenDevice()) {
            return false;
        }
        return this.getDefaultVirtualKeyboard() != null && this.getDefaultVirtualKeyboard().isVirtualKeyboardShowing();
    }

    public String[] getSupportedVirtualKeyboard() {
        String[] retVal = new String[virtualKeyboards.size()];
        int index = 0;
        Enumeration keys = virtualKeyboards.keys();
        while (keys.hasMoreElements()) {
            retVal[index++] = (String)keys.nextElement();
        }
        return retVal;
    }

    public void registerVirtualKeyboard(VirtualKeyboardInterface vkb) {
        virtualKeyboards.put(vkb.getVirtualKeyboardName(), vkb);
    }

    public void setDefaultVirtualKeyboard(VirtualKeyboardInterface vkb) {
        if (vkb != null) {
            selectedVirtualKeyboard = vkb.getVirtualKeyboardName();
            if (!virtualKeyboards.containsKey(selectedVirtualKeyboard)) {
                this.registerVirtualKeyboard(vkb);
            }
        } else {
            selectedVirtualKeyboard = null;
        }
    }

    public VirtualKeyboardInterface getDefaultVirtualKeyboard() {
        if (selectedVirtualKeyboard == null) {
            return null;
        }
        return (VirtualKeyboardInterface)virtualKeyboards.get(selectedVirtualKeyboard);
    }

    public int getKeyboardType() {
        return this.impl.getKeyboardType();
    }

    public boolean isNativeInputSupported() {
        return this.impl.isNativeInputSupported();
    }

    public boolean isMultiTouch() {
        return this.impl.isMultiTouch();
    }

    public boolean isClickTouchScreen() {
        return this.impl.isClickTouchScreen();
    }

    public float getDragSpeed(boolean yAxis) {
        float speed = yAxis ? this.impl.getDragSpeed(this.dragPathY, this.dragPathTime, this.dragPathOffset, this.dragPathLength) : this.impl.getDragSpeed(this.dragPathX, this.dragPathTime, this.dragPathOffset, this.dragPathLength);
        return speed;
    }

    public boolean isBidiAlgorithm() {
        return this.impl.isBidiAlgorithm();
    }

    public void setBidiAlgorithm(boolean activate) {
        this.impl.setBidiAlgorithm(activate);
    }

    public String convertBidiLogicalToVisual(String s) {
        return this.impl.convertBidiLogicalToVisual(s);
    }

    public int getCharLocation(String source, int index) {
        return this.impl.getCharLocation(source, index);
    }

    public boolean isRTL(char c) {
        return this.impl.isRTL(c);
    }

    public InputStream getResourceAsStream(Class cls, String resource) {
        return this.impl.getResourceAsStream(cls, resource);
    }

    public void addEdtErrorHandler(ActionListener e) {
        if (this.errorHandler == null) {
            this.errorHandler = new EventDispatcher();
        }
        this.errorHandler.addListener(e);
    }

    public void removeEdtErrorHandler(ActionListener e) {
        if (this.errorHandler != null) {
            this.errorHandler.removeListener(e);
            Vector v = this.errorHandler.getListenerVector();
            if (v == null || v.size() == 0) {
                this.errorHandler = null;
            }
        }
    }

    public void setAllowMinimizing(boolean allowMinimizing) {
        this.allowMinimizing = allowMinimizing;
    }

    public boolean isAllowMinimizing() {
        return this.allowMinimizing;
    }

    public boolean shouldRenderSelection() {
        boolean shouldrender = this.getDeviceType() == 0;
        return shouldrender || this.pointerPressedAndNotReleasedOrDragged || this.lastInteractionWasKeypad;
    }

    public boolean shouldRenderSelection(Component c) {
        boolean shouldrender;
        boolean bl = shouldrender = this.getDeviceType() == 0;
        if (c.isCellRenderer()) {
            return this.shouldRenderSelection();
        }
        return shouldrender || this.lastInteractionWasKeypad || this.pointerPressedAndNotReleasedOrDragged && c.contains(this.pointerX, this.pointerY);
    }

    public boolean isPureTouch() {
        return pureTouch;
    }

    public void setPureTouch(boolean pureTouch) {
        System.out.println("[DISPLAY] Warning: setPureTouch is disabled!");
    }

    public boolean isNativeCommands() {
        return this.getCommandBehavior() == 10;
    }

    public void setNativeCommands(boolean nativeCommands) {
        this.setCommandBehavior(10);
    }

    public void exitApplication() {
        this.lwuitExited = true;
        this.impl.exitApplication();
    }

    public void showNativeScreen(Object nativeFullScreenPeer) {
        this.impl.showNativeScreen(nativeFullScreenPeer);
    }

    public boolean isAutoFoldVKBOnFormSwitch() {
        return this.autoFoldVKBOnFormSwitch;
    }

    public void setAutoFoldVKBOnFormSwitch(boolean autoFoldVKBOnFormSwitch) {
        this.autoFoldVKBOnFormSwitch = autoFoldVKBOnFormSwitch;
    }

    public int getCommandBehavior() {
        return this.commandBehavior;
    }

    public void setCommandBehavior(int commandBehavior) {
        this.commandBehavior = commandBehavior;
        this.impl.notifyCommandBehavior(commandBehavior);
    }

    public String getProperty(String key, String defaultValue) {
        String v;
        if (this.localProperties != null && (v = (String)this.localProperties.get(key)) != null) {
            return v;
        }
        return this.impl.getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        if (this.localProperties == null) {
            this.localProperties = new Hashtable();
        }
        this.localProperties.put(key, value);
    }

    public void execute(String url) {
        this.impl.execute(url);
    }

    public int getDeviceDensity() {
        return this.impl.getDeviceDensity();
    }

    public void playBuiltinSound(String soundIdentifier) {
        this.impl.playBuiltinSound(soundIdentifier);
    }

    public void installBuiltinSound(String soundIdentifier, InputStream data) throws IOException {
        this.impl.installBuiltinSound(soundIdentifier, data);
    }

    public boolean isBuiltinSoundAvailable(String soundIdentifier) {
        return this.impl.isBuiltinSoundAvailable(soundIdentifier);
    }

    public void setBuiltinSoundsEnabled(boolean enabled) {
        this.impl.setBuiltinSoundsEnabled(enabled);
    }

    public boolean isBuiltinSoundsEnabled() {
        return this.impl.isBuiltinSoundsEnabled();
    }

    public Object createAudio(String uri) throws IOException {
        return this.createAudio(uri, null);
    }

    public Object createAudio(InputStream stream, String mimeType) throws IOException {
        return this.createAudio(stream, mimeType);
    }

    public Object createAudio(String uri, Runnable onCompletion) throws IOException {
        return this.impl.createAudio(uri, onCompletion);
    }

    public Object createAudio(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return this.impl.createAudio(stream, mimeType, onCompletion);
    }

    public void playAudio(Object handle) {
        this.impl.playAudio(handle);
    }

    public void pauseAudio(Object handle) {
        this.impl.pauseAudio(handle);
    }

    public void cleanupAudio(Object handle) {
        this.impl.cleanupAudio(handle);
    }

    public int getAudioTime(Object handle) {
        return this.impl.getAudioTime(handle);
    }

    public void setAudioTime(Object handle, int time) {
        this.impl.setAudioTime(handle, time);
    }

    public int getAudioDuration(Object handle) {
        return this.impl.getAudioDuration(handle);
    }

    public void setVolume(int vol) {
        this.impl.setVolume(vol);
    }

    public int getVolume() {
        return this.impl.getVolume();
    }

    public Object createSoftWeakRef(Object o) {
        return this.impl.createSoftWeakRef(o);
    }

    public Object extractHardRef(Object o) {
        return this.impl.extractHardRef(o);
    }

    public boolean hasNativeTheme() {
        return this.impl.hasNativeTheme();
    }

    public void installNativeTheme() {
        this.impl.installNativeTheme();
    }

    public void copyToClipboard(Object obj) {
        this.impl.copyToClipboard(obj);
    }

    public Object getPasteDataFromClipboard() {
        return this.impl.getPasteDataFromClipboard();
    }

    public boolean isPortrait() {
        return this.impl.isPortrait();
    }

    public boolean canForceOrientation() {
        return this.impl.canForceOrientation();
    }

    public void lockOrientation(boolean portrait) {
        this.impl.lockOrientation(portrait);
    }

    public boolean isTablet() {
        return this.impl.isTablet();
    }

    public Resources getNokiaResource() {
        return nokiaResource;
    }

    public int getDeviceType() {
        if (this.devType == -1) {
            String keyboard = System.getProperty("com.nokia.keyboard.type");
            if (keyboard == null) {
                keyboard = "None";
            }
            this.devType = 0;
            if (Display.INSTANCE.impl.isTouchDevice()) {
                this.devType = keyboard.equalsIgnoreCase("OnekeyBack") ? 3 : (!keyboard.equals("None") ? 1 : 2);
            }
        }
        return this.devType;
    }

    public static Object getObjectTrait(Object target, String traitName) {
        try {
            Class<?> c = Class.forName("com.nokia.mid.ui.LCDUIUtil");
            if (target instanceof S40Implementation) {
                return ((S40Implementation)target).getCanvasTrait(traitName);
            }
            return LCDUIUtil.getObjectTrait((Object)target, (String)traitName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static boolean setObjectTrait(Object target, String traitName, Object value) {
        try {
            Class<?> c = Class.forName("com.nokia.mid.ui.LCDUIUtil");
            if (target instanceof S40Implementation) {
                ((S40Implementation)target).setCanvasTrait(traitName, value);
            } else {
                LCDUIUtil.setObjectTrait((Object)target, (String)traitName, (Object)value);
            }
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static {
        INSTANCE = new Display();
        transitionDelay = -1;
        lock = new Object();
        selectedVirtualKeyboard = "LWUIT_VirtualKeyboard";
        virtualKeyboards = new Hashtable();
    }

    private class FPSPainter
    implements Painter {
        private long mFPS;

        private FPSPainter() {
        }

        public void setFPS(long fps) {
            this.mFPS = fps;
        }

        public void paint(Graphics g, Rectangle rect) {
            int c = g.getColor();
            g.setColor(0xFF0000);
            g.drawString("" + this.mFPS, rect.getX(), rect.getY());
            g.setColor(c);
        }
    }
}

