/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.nokia.lwuit.DirectUtilsProvider;
import com.sun.lwuit.CustomFont;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class Font {
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int STYLE_PLAIN = 0;
    private static Font defaultFont = new Font(null);
    private static Hashtable bitmapCache = new Hashtable();
    private static boolean enableBitmapFont = true;
    private Object font;

    Font() {
    }

    Font(Object nativeFont) {
        this.font = nativeFont;
    }

    Font(int face, int style, int size) {
        this.font = Display.getInstance().getImplementation().createFont(face, style, size);
    }

    public static Font getBitmapFont(String fontName) {
        return (Font)bitmapCache.get(fontName);
    }

    public static void clearBitmapCache() {
        bitmapCache.clear();
    }

    public static boolean isTrueTypeFileSupported() {
        return Display.getInstance().getImplementation().isTrueTypeSupported();
    }

    public static boolean isCreationByStringSupported() {
        return Display.getInstance().getImplementation().isLookupFontSupported();
    }

    public static Font createTrueTypeFont(InputStream stream) throws IOException {
        return new Font(Display.getInstance().getImplementation().loadTrueTypeFont(stream));
    }

    public static Font create(String lookup) {
        Object n = Display.getInstance().getImplementation().loadNativeFont(lookup);
        if (n == null) {
            return null;
        }
        return new Font(n);
    }

    public static Font createDirectUtilsSystemFont(int face, int style, int size) {
        javax.microedition.lcdui.Font font = DirectUtilsProvider.getDirectUtils().getFont(face, style, size);
        return new Font(font);
    }

    public void addContrast(byte value) {
    }

    public static Font createBitmapFont(String name, Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        Font f = Font.createBitmapFont(bitmap, cutOffsets, charWidth, charsets);
        bitmapCache.put(name, f);
        return f;
    }

    public static Font createBitmapFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        return new CustomFont(bitmap, cutOffsets, charWidth, charsets);
    }

    public static Font createSystemFont(int face, int style, int size) {
        return new Font(face, style, size);
    }

    public int charsWidth(char[] ch, int offset, int length) {
        return Display.getInstance().getImplementation().charsWidth(this.font, ch, offset, length);
    }

    public int substringWidth(String str, int offset, int len) {
        return Display.getInstance().getImplementation().stringWidth(this.font, str.substring(offset, offset + len));
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return Display.getInstance().getImplementation().stringWidth(this.font, str);
    }

    public int charWidth(char ch) {
        return Display.getInstance().getImplementation().charWidth(this.font, ch);
    }

    public int getHeight() {
        return Display.getInstance().getImplementation().getHeight(this.font);
    }

    void drawChar(Graphics g, char character, int x, int y) {
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font f) {
        if (f != null) {
            defaultFont = f;
        }
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
    }

    public int getFace() {
        return Display.getInstance().getImplementation().getFace(this.font);
    }

    public int getSize() {
        return Display.getInstance().getImplementation().getSize(this.font);
    }

    public int getStyle() {
        return Display.getInstance().getImplementation().getStyle(this.font);
    }

    public String getCharset() {
        return null;
    }

    public static void setBitmapFontEnabled(boolean enabled) {
        enableBitmapFont = enabled;
    }

    public static boolean isBitmapFontEnabled() {
        return enableBitmapFont;
    }

    public Object getNativeFont() {
        return this.font;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Font f = (Font)o;
            return f.getFace() == this.getFace() && f.getSize() == this.getSize() && f.getStyle() == this.getStyle();
        }
        return false;
    }
}

