/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Timeline;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.plaf.UIManager;

public final class CommonTransitions
extends Transition {
    private Motion motion;
    private Motion motion2;
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_SLIDE = 1;
    private static final int TYPE_FADE = 2;
    private static final int TYPE_FAST_SLIDE = 3;
    private static final int TYPE_TIMELINE = 4;
    private static final int TYPE_SLIDE_AND_FADE = 5;
    private static final int TYPE_PULSATE_DIALOG = 6;
    public static final int SLIDE_HORIZONTAL = 0;
    public static final int SLIDE_VERTICAL = 1;
    private long startTime;
    private int slideType;
    private int speed;
    private int position;
    private int transitionType;
    private Image buffer;
    private Image secondaryBuffer;
    private Image timeline;
    private byte pulseState;
    private static boolean defaultLinearMotion = false;
    private boolean linearMotion = defaultLinearMotion;
    private boolean motionSetManually;
    private int originalWidth;
    private int originalHeight;
    private int originalX;
    private int originalY;
    private RGBImage rgbBuffer;
    private boolean forward;
    private boolean drawDialogMenu;
    private boolean firstFinished;

    private CommonTransitions(int type) {
        this.transitionType = type;
    }

    public static CommonTransitions createEmpty() {
        CommonTransitions t = new CommonTransitions(0);
        return t;
    }

    public static CommonTransitions createSlideFadeTitle(boolean forward, int duration) {
        CommonTransitions c = new CommonTransitions(5);
        c.forward = forward;
        c.speed = duration;
        return c;
    }

    public static CommonTransitions createDialogPulsate() {
        CommonTransitions c = new CommonTransitions(6);
        return c;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration) {
        return CommonTransitions.createFastSlide(type, forward, duration, false);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration) {
        return CommonTransitions.createSlide(type, forward, duration, false);
    }

    public static CommonTransitions createSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(1);
        t.slideType = type;
        t.forward = forward;
        if (type == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            t.forward = !t.forward;
        }
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createFastSlide(int type, boolean forward, int duration, boolean drawDialogMenu) {
        CommonTransitions t = new CommonTransitions(3);
        t.slideType = type;
        t.forward = forward;
        if (type == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
            t.forward = !t.forward;
        }
        t.speed = duration;
        t.position = 0;
        t.drawDialogMenu = drawDialogMenu;
        return t;
    }

    public static CommonTransitions createFade(int duration) {
        CommonTransitions t = new CommonTransitions(2);
        t.speed = duration;
        return t;
    }

    public static CommonTransitions createTimeline(Image animation) {
        CommonTransitions t = new CommonTransitions(4);
        t.timeline = animation;
        t.transitionType = 4;
        return t;
    }

    private Container getDialogParent(Component dlg) {
        if (Dialog.isDialogTitleCompatibilityMode()) {
            return ((Dialog)dlg).getContentPane();
        }
        return ((Dialog)dlg).getDialogComponent();
    }

    public void initTransition() {
        this.firstFinished = false;
        if (this.transitionType == 0) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        Component source = this.getSource();
        Component destination = this.getDestination();
        this.position = 0;
        int w = source.getWidth();
        int h = source.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        if (this.transitionType == 5) {
            this.motion = this.createMotion(100, 200, this.speed);
            this.motion2 = this.createMotion(0, this.getDestination().getWidth(), this.speed);
            this.motion.start();
            this.motion2.start();
            Container sourcePane = ((Form)this.getSource()).getContentPane();
            Container destPane = ((Form)this.getDestination()).getContentPane();
            this.buffer = this.createMutableImage(sourcePane.getWidth(), sourcePane.getHeight());
            this.paint(this.buffer.getGraphics(), sourcePane, -sourcePane.getAbsoluteX() - sourcePane.getScrollX(), -sourcePane.getAbsoluteY() - sourcePane.getScrollY(), true);
            this.secondaryBuffer = this.createMutableImage(destPane.getWidth(), destPane.getHeight());
            this.paint(this.secondaryBuffer.getGraphics(), destPane, -destPane.getAbsoluteX() - destPane.getScrollX(), -destPane.getAbsoluteY() - destPane.getScrollY(), true);
            return;
        }
        if (this.transitionType == 6) {
            if (this.getDestination() instanceof Dialog) {
                this.motion = this.createMotion(600, 1100, 200);
                this.motion.start();
                this.motion2 = this.createMotion(100, 255, 300);
                this.motion2.start();
                this.pulseState = 0;
                Container c = this.getDialogParent(this.getDestination());
                this.originalX = c.getX();
                this.originalY = c.getY();
                this.originalWidth = c.getWidth();
                this.originalHeight = c.getHeight();
                return;
            }
            this.motion = this.createMotion(0, 0, 0);
            this.pulseState = (byte)3;
            return;
        }
        if (this.buffer == null) {
            this.buffer = this.createMutableImage(w, h);
        } else if (this.buffer.getWidth() != w || this.buffer.getHeight() != h) {
            this.buffer = this.createMutableImage(w, h);
            this.rgbBuffer = null;
            this.motion = null;
        }
        if (this.transitionType == 2) {
            this.motion = this.createMotion(0, 256, this.speed);
            this.motion.start();
            Graphics g = this.buffer.getGraphics();
            g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
            if (this.getSource().getParent() != null) {
                this.getSource().getComponentForm().paintComponent(g);
            }
            this.getSource().paintBackgrounds(g);
            g.setClip(0, 0, this.buffer.getWidth() + source.getAbsoluteX(), this.buffer.getHeight() + source.getAbsoluteY());
            this.paint(g, this.getDestination(), 0, 0);
            this.rgbBuffer = new RGBImage(this.buffer.getRGBCached(), this.buffer.getWidth(), this.buffer.getHeight());
            this.paint(g, this.getSource(), 0, 0);
            g.translate(source.getAbsoluteX(), source.getAbsoluteY());
            return;
        }
        if (this.transitionType == 4) {
            Graphics g = this.buffer.getGraphics();
            g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
            g.setClip(0, 0, this.buffer.getWidth() + source.getAbsoluteX(), this.buffer.getHeight() + source.getAbsoluteY());
            if (this.timeline.getWidth() != this.buffer.getWidth() || this.timeline.getHeight() != this.buffer.getHeight()) {
                this.timeline = this.timeline.scaled(this.buffer.getWidth(), this.buffer.getHeight());
            }
            if (this.timeline instanceof Timeline) {
                ((Timeline)this.timeline).setTime(0);
                ((Timeline)this.timeline).setLoop(false);
                ((Timeline)this.timeline).setAnimationDelay(0);
            }
            this.paint(g, this.getDestination(), 0, 0);
            g.translate(source.getAbsoluteX(), source.getAbsoluteY());
            return;
        }
        if (this.transitionType == 4) {
            Graphics g = this.buffer.getGraphics();
            g.translate(-source.getAbsoluteX(), -source.getAbsoluteY());
            g.setClip(0, 0, this.buffer.getWidth() + source.getAbsoluteX(), this.buffer.getHeight() + source.getAbsoluteY());
            if (this.timeline.getWidth() != this.buffer.getWidth() || this.timeline.getHeight() != this.buffer.getHeight()) {
                this.timeline = this.timeline.scaled(this.buffer.getWidth(), this.buffer.getHeight());
            }
            if (this.timeline instanceof Timeline) {
                ((Timeline)this.timeline).setTime(0);
                ((Timeline)this.timeline).setLoop(false);
                ((Timeline)this.timeline).setAnimationDelay(0);
            }
            this.paint(g, this.getDestination(), 0, 0);
            g.translate(source.getAbsoluteX(), source.getAbsoluteY());
            return;
        }
        if (this.transitionType == 1 || this.transitionType == 3) {
            int dest;
            int startOffset = 0;
            if (this.slideType == 0) {
                dest = w;
                if (destination instanceof Dialog) {
                    startOffset = w - this.getDialogParent(destination).getWidth();
                    startOffset = this.forward ? (startOffset -= this.getDialogParent(destination).getStyle().getMargin(destination.isRTL(), 1)) : (startOffset -= this.getDialogParent(destination).getStyle().getMargin(destination.isRTL(), 3));
                } else if (source instanceof Dialog) {
                    dest = this.getDialogParent(source).getWidth();
                    dest = this.forward ? (dest += this.getDialogParent(source).getStyle().getMargin(source.isRTL(), 1)) : (dest += this.getDialogParent(source).getStyle().getMargin(source.isRTL(), 3));
                }
            } else {
                Container p;
                dest = h;
                if (destination instanceof Dialog) {
                    startOffset = h - this.getDialogParent(destination).getHeight() - this.getDialogTitleHeight((Dialog)destination);
                    if (this.forward) {
                        startOffset -= this.getDialogParent(destination).getStyle().getMargin(false, 2);
                    } else {
                        startOffset -= this.getDialogParent(destination).getStyle().getMargin(false, 0);
                        startOffset -= ((Dialog)destination).getTitleStyle().getMargin(false, 0);
                        if (!this.drawDialogMenu && ((Dialog)destination).getCommandCount() > 0 && (p = ((Dialog)destination).getSoftButton(0).getParent()) != null) {
                            startOffset -= p.getHeight();
                        }
                    }
                } else if (source instanceof Dialog) {
                    dest = this.getDialogParent(source).getHeight() + this.getDialogTitleHeight((Dialog)source);
                    if (this.forward) {
                        dest += this.getDialogParent(source).getStyle().getMargin(false, 2);
                    } else {
                        dest += this.getDialogParent(source).getStyle().getMargin(false, 0);
                        dest += ((Dialog)source).getTitleStyle().getMargin(false, 0);
                        if (((Dialog)source).getCommandCount() > 0 && (p = ((Dialog)source).getSoftButton(0).getParent()) != null) {
                            dest += p.getHeight();
                        }
                    }
                }
            }
            this.motion = this.createMotion(startOffset, dest, this.speed);
            Graphics g = this.buffer.getGraphics();
            if (this.getSource() instanceof Dialog) {
                this.paint(g, this.getDestination(), 0, 0);
                if (this.transitionType == 3 && !(destination instanceof Dialog)) {
                    Dialog d = (Dialog)source;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(d).getWidth(), this.getDialogParent(d).getHeight() + this.getDialogTitleHeight(d));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else if (this.getDestination() instanceof Dialog) {
                this.paint(g, this.getSource(), 0, 0);
                if (this.transitionType == 3 && !(source instanceof Dialog)) {
                    Dialog d = (Dialog)destination;
                    this.secondaryBuffer = this.createMutableImage(this.getDialogParent(d).getWidth(), d.getContentPane().getParent().getHeight() + this.getDialogTitleHeight(d));
                    this.drawDialogCmp(this.secondaryBuffer.getGraphics(), d);
                }
            } else {
                this.paint(g, source, -source.getAbsoluteX(), -source.getAbsoluteY());
                if (this.transitionType == 3) {
                    this.secondaryBuffer = this.createMutableImage(destination.getWidth(), destination.getHeight());
                    this.paint(this.secondaryBuffer.getGraphics(), destination, -destination.getAbsoluteX(), -destination.getAbsoluteY());
                }
            }
            this.motion.start();
        }
    }

    private Image createMutableImage(int w, int h) {
        Display d = Display.getInstance();
        return Image.createImage(Math.min(d.getDisplayWidth(), w), Math.min(d.getDisplayHeight(), h));
    }

    protected Motion createMotion(int startOffset, int dest, int speed) {
        if (this.motionSetManually) {
            return this.motion;
        }
        if (this.linearMotion) {
            return Motion.createLinearMotion(startOffset, dest, speed);
        }
        return Motion.createSplineMotion(startOffset, dest, speed);
    }

    public boolean animate() {
        if (this.timeline != null) {
            boolean val = this.timeline.animate();
            return val;
        }
        if (this.motion == null) {
            return false;
        }
        this.position = this.motion.getValue();
        if (this.firstFinished) {
            return false;
        }
        boolean finished = this.motion.isFinished();
        if (finished) {
            if (this.transitionType == 6) {
                switch (this.pulseState) {
                    case 0: {
                        this.pulseState = 1;
                        this.motion = this.createMotion(1100, 900, 90);
                        this.motion.start();
                        return true;
                    }
                    case 1: {
                        this.pulseState = (byte)2;
                        this.motion = this.createMotion(900, 1000, 180);
                        this.motion.start();
                        return true;
                    }
                }
            }
            if (!this.firstFinished) {
                this.firstFinished = true;
            }
        }
        return true;
    }

    public void paint(Graphics g) {
        try {
            switch (this.transitionType) {
                case 1: {
                    if (this.slideType == 0) {
                        this.paintSlideAtPosition(g, this.position, 0);
                    } else {
                        this.paintSlideAtPosition(g, 0, this.position);
                    }
                    return;
                }
                case 3: {
                    if (this.slideType == 0) {
                        this.paintFastSlideAtPosition(g, this.position, 0);
                    } else {
                        this.paintFastSlideAtPosition(g, 0, this.position);
                    }
                    return;
                }
                case 2: {
                    this.paintAlpha(g);
                    return;
                }
                case 4: {
                    Object mask = this.timeline.createMask();
                    this.paint(g, this.getSource(), 0, 0);
                    g.drawImage(this.buffer.applyMask(mask), 0, 0);
                    return;
                }
                case 5: {
                    Form sourceForm = (Form)this.getSource();
                    Form destForm = (Form)this.getDestination();
                    int alpha = this.position;
                    int slidePos = this.motion2.getValue();
                    int clipX = g.getClipX();
                    int clipY = g.getClipY();
                    int clipW = g.getClipWidth();
                    int clipH = g.getClipHeight();
                    g.translate(0, sourceForm.getTitleArea().getHeight());
                    this.paintFastSlideAtPosition(g, slidePos, 0);
                    g.translate(0, -sourceForm.getTitleArea().getHeight());
                    g.setClip(clipX, clipY, clipW, clipH);
                    sourceForm.getTitleArea().paintBackground(g);
                    this.paintShiftFadeHierarchy(sourceForm.getTitleArea(), 255 - alpha, g, false);
                    this.paintShiftFadeHierarchy(destForm.getTitleArea(), alpha, g, true);
                    return;
                }
                case 6: {
                    this.paint(g, this.getSource(), 0, 0);
                    int alpha = g.getAlpha();
                    g.setAlpha(this.motion2.getValue());
                    Container c = this.getDialogParent(this.getDestination());
                    float ratio = (float)this.position / 1000.0f;
                    if (g.isAffineSupported()) {
                        g.scale(ratio, ratio);
                        int w = (int)((float)this.originalWidth * ratio);
                        int h = (int)((float)this.originalHeight * ratio);
                        c.setX(this.originalX + (this.originalWidth - w) / 2);
                        c.setY(this.originalY + (this.originalHeight - h) / 2);
                        this.paint(g, c, 0, 0);
                        g.resetAffine();
                    } else {
                        c.setWidth((int)((float)this.originalWidth * ratio));
                        c.setHeight((int)((float)this.originalHeight * ratio));
                        c.setX(this.originalX + (this.originalWidth - c.getWidth()) / 2);
                        c.setY(this.originalY + (this.originalHeight - c.getHeight()) / 2);
                        this.paint(g, c, 0, 0);
                    }
                    g.setAlpha(alpha);
                    return;
                }
            }
        }
        catch (Throwable t) {
            System.out.println("An exception occurred during transition paint this might be valid in case of a resize in the middle of a transition");
        }
    }

    private void paintShiftFadeHierarchy(Container c, int alpha, Graphics g, boolean incoming) {
        int componentCount = c.getComponentCount();
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container) {
                this.paintShiftFadeHierarchy((Container)current, alpha, g, incoming);
                continue;
            }
            g.setAlpha(alpha);
            Motion m = this.getComponentShiftMotion(current, incoming);
            int tval = m.getValue();
            g.translate(tval, 0);
            current.paintComponent(g, false);
            g.translate(-tval, 0);
            g.setAlpha(255);
        }
    }

    private Motion getComponentShiftMotion(Component c, boolean incoming) {
        Motion m = (Motion)c.getClientProperty("$shm");
        if (m == null) {
            int travelDestination = this.getDestination().getWidth() - c.getWidth() - c.getAbsoluteX();
            if (this.getDestination().getWidth() - c.getWidth() < 10) {
                travelDestination = c.getWidth() / 2 - c.getPreferredW() / 2;
            }
            m = incoming ? (this.forward ? Motion.createSplineMotion(-travelDestination, 0, this.speed) : Motion.createSplineMotion(travelDestination, 0, this.speed)) : (this.forward ? Motion.createSplineMotion(0, travelDestination, this.speed) : Motion.createSplineMotion(0, -travelDestination, this.speed));
            m.start();
            c.putClientProperty("$shm", m);
        }
        return m;
    }

    private void paintAlpha(Graphics graphics) {
        if (this.rgbBuffer != null || this.secondaryBuffer != null) {
            Component src = this.getSource();
            int w = src.getWidth();
            int h = src.getHeight();
            int position = this.position;
            if (position > 255) {
                position = 255;
            } else if (position < 0) {
                position = 0;
            }
            if (this.secondaryBuffer != null) {
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.setAlpha(position);
                graphics.drawImage(this.secondaryBuffer, x, y);
                graphics.setAlpha(255);
            } else {
                int alpha = position << 24;
                int size = w * h;
                int[] bufferArray = this.rgbBuffer.getRGB();
                for (int iter = 0; iter < size; ++iter) {
                    bufferArray[iter] = bufferArray[iter] & 0xFFFFFF | alpha;
                }
                Component dest = this.getDestination();
                int x = dest.getAbsoluteX();
                int y = dest.getAbsoluteY();
                graphics.drawImage(this.buffer, x, y);
                graphics.drawImage(this.rgbBuffer, x, y);
            }
        }
    }

    private void removeConstant(Container c) {
        int componentCount = c.getComponentCount();
        c.putClientProperty("$shm", null);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component cmp = c.getComponentAt(iter);
            cmp.putClientProperty("$shm", null);
            if (!(cmp instanceof Container)) continue;
            this.removeConstant((Container)cmp);
        }
    }

    public void cleanup() {
        if (this.transitionType == 5) {
            this.removeConstant((Container)this.getSource());
            this.removeConstant((Container)this.getDestination());
        }
        super.cleanup();
        this.buffer = null;
        this.rgbBuffer = null;
        this.secondaryBuffer = null;
        this.timeline = null;
    }

    private void paintSlideAtPosition(Graphics g, int slideX, int slideY) {
        Component source = this.getSource();
        if (source == null) {
            return;
        }
        Component dest = this.getDestination();
        int w = source.getWidth();
        int h = source.getHeight();
        if (this.slideType == 0) {
            h = 0;
        } else {
            w = 0;
        }
        if (this.forward) {
            w = -w;
            h = -h;
        } else {
            slideX = -slideX;
            slideY = -slideY;
        }
        g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
        if (source instanceof Dialog) {
            g.drawImage(this.buffer, 0, 0);
            this.paint(g, source, -slideX, -slideY);
            return;
        }
        if (dest instanceof Dialog) {
            g.drawImage(this.buffer, 0, 0);
            this.paint(g, dest, -slideX - w, -slideY - h);
            return;
        }
        if (source.getParent() != null) {
            source.paintBackgrounds(g);
            this.paint(g, source, slideX, slideY);
        } else {
            g.drawImage(this.buffer, slideX, slideY);
        }
        this.paint(g, dest, slideX + w, slideY + h);
    }

    private void paintFastSlideAtPosition(Graphics g, int slideX, int slideY) {
        if (this.secondaryBuffer != null) {
            Component source = this.getSource();
            if (source == null) {
                return;
            }
            Component dest = this.getDestination();
            int w = this.buffer.getWidth();
            int h = this.buffer.getHeight();
            if (this.slideType == 0) {
                h = 0;
            } else {
                w = 0;
            }
            if (this.forward) {
                w = -w;
                h = -h;
            } else {
                slideX = -slideX;
                slideY = -slideY;
            }
            g.setClip(source.getAbsoluteX() + source.getScrollX(), source.getAbsoluteY() + source.getScrollY(), source.getWidth(), source.getHeight());
            if (source instanceof Dialog) {
                g.drawImage(this.buffer, 0, 0);
                g.drawImage(this.secondaryBuffer, -(slideX -= this.getDialogParent(source).getX()), -(slideY -= this.getDialogParent(source).getY()));
                return;
            }
            if (dest instanceof Dialog) {
                g.drawImage(this.buffer, 0, 0);
                g.drawImage(this.secondaryBuffer, -(slideX -= this.getDialogParent(dest).getX()) - w, -(slideY -= this.getDialogParent(dest).getY()) - h);
                return;
            }
            g.drawImage(this.buffer, slideX, slideY);
            g.drawImage(this.secondaryBuffer, slideX + w, slideY + h);
        } else {
            this.paintSlideAtPosition(g, slideX, slideY);
        }
    }

    private int getDialogTitleHeight(Dialog d) {
        if (Dialog.isDialogTitleCompatibilityMode()) {
            return d.getTitleComponent().getHeight();
        }
        return 0;
    }

    private void drawDialogCmp(Graphics g, Dialog dlg) {
        Container menuBar;
        Painter p = dlg.getStyle().getBgPainter();
        dlg.getStyle().setBgPainter(null);
        if (Dialog.isDialogTitleCompatibilityMode()) {
            g.translate(-dlg.getTitleComponent().getX(), -dlg.getTitleComponent().getY());
            dlg.getTitleComponent().paintComponent(g, false);
            g.translate(dlg.getTitleComponent().getX(), dlg.getTitleComponent().getY());
        }
        g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
        g.translate(-this.getDialogParent(dlg).getX(), -this.getDialogParent(dlg).getY() + this.getDialogTitleHeight(dlg));
        this.getDialogParent(dlg).paintComponent(g, false);
        if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
            g.setClip(0, 0, dlg.getWidth(), dlg.getHeight());
            menuBar.paintComponent(g, false);
        }
        dlg.getStyle().setBgPainter(p);
    }

    private void paint(Graphics g, Component cmp, int x, int y) {
        this.paint(g, cmp, x, y, false);
    }

    private void paint(Graphics g, Component cmp, int x, int y, boolean background) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (cmp instanceof Dialog) {
            if (!(this.transitionType == 2 || this.getSource() instanceof Dialog && this.getDestination() instanceof Dialog && cmp == this.getDestination())) {
                Container menuBar;
                Painter p = cmp.getStyle().getBgPainter();
                cmp.getStyle().setBgPainter(null);
                g.translate(x, y);
                Dialog dlg = (Dialog)cmp;
                if (Dialog.isDialogTitleCompatibilityMode()) {
                    g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                    dlg.getTitleComponent().paintComponent(g, false);
                }
                g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                this.getDialogParent(dlg).paintComponent(g, false);
                g.translate(-x, -y);
                if (this.drawDialogMenu && dlg.getCommandCount() > 0 && (menuBar = dlg.getSoftButton(0).getParent()) != null) {
                    g.setClip(0, 0, cmp.getWidth(), cmp.getHeight());
                    menuBar.paintComponent(g, false);
                }
                g.setClip(cx, cy, cw, ch);
                cmp.getStyle().setBgPainter(p);
                return;
            }
            cmp.paintComponent(g, background);
            return;
        }
        g.translate(x, y);
        cmp.paintComponent(g, background);
        g.translate(-x, -y);
        g.setClip(cx, cy, cw, ch);
    }

    public Motion getMotion() {
        return this.motion;
    }

    public void setMotion(Motion motion) {
        this.motionSetManually = true;
        this.motion = motion;
    }

    public Transition copy(boolean reverse) {
        CommonTransitions retVal = null;
        switch (this.transitionType) {
            case 4: {
                retVal = CommonTransitions.createTimeline(this.timeline);
                break;
            }
            case 2: {
                retVal = CommonTransitions.createFade(this.speed);
                break;
            }
            case 1: {
                boolean fwd = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl = fwd = !fwd;
                }
                if (reverse) {
                    retVal = CommonTransitions.createSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 5: {
                boolean fwd = this.forward;
                if (UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl = fwd = !fwd;
                }
                if (reverse) {
                    retVal = CommonTransitions.createSlideFadeTitle(!fwd, this.speed);
                    break;
                }
                retVal = CommonTransitions.createSlideFadeTitle(fwd, this.speed);
                break;
            }
            case 3: {
                boolean fwd = this.forward;
                if (this.slideType == 0 && UIManager.getInstance().getLookAndFeel().isRTL()) {
                    boolean bl = fwd = !fwd;
                }
                if (reverse) {
                    retVal = CommonTransitions.createFastSlide(this.slideType, !fwd, this.speed, this.drawDialogMenu);
                    break;
                }
                retVal = CommonTransitions.createFastSlide(this.slideType, fwd, this.speed, this.drawDialogMenu);
                break;
            }
            case 0: {
                retVal = CommonTransitions.createEmpty();
                break;
            }
            case 6: {
                retVal = CommonTransitions.createDialogPulsate();
            }
        }
        retVal.linearMotion = this.linearMotion;
        return retVal;
    }

    public boolean isLinearMotion() {
        return this.linearMotion;
    }

    public void setLinearMotion(boolean linearMotion) {
        this.linearMotion = linearMotion;
    }

    public static boolean isDefaultLinearMotion() {
        return defaultLinearMotion;
    }

    public static void setDefaultLinearMotion(boolean aDefaultLinearMotion) {
        defaultLinearMotion = aDefaultLinearMotion;
    }
}

