/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.util.Hashtable;

public class BorderLayout
extends Layout {
    public static final int CENTER_BEHAVIOR_SCALE = 0;
    public static final int CENTER_BEHAVIOR_CENTER = 1;
    public static final int CENTER_BEHAVIOR_CENTER_ABSOLUTE = 2;
    private Component portaraitNorth;
    private Component portaraitSouth;
    private Component portaraitCenter;
    private Component portaraitWest;
    private Component portaraitEast;
    private Hashtable landscapeSwap;
    private int centerBehavior;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";

    public void addLayoutComponent(Object name, Component comp, Container c) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        Component previous = null;
        if (CENTER.equals(name)) {
            previous = this.portaraitCenter;
            this.portaraitCenter = comp;
        } else if (NORTH.equals(name)) {
            previous = this.portaraitNorth;
            this.portaraitNorth = comp;
        } else if (SOUTH.equals(name)) {
            previous = this.portaraitSouth;
            this.portaraitSouth = comp;
        } else if (EAST.equals(name)) {
            previous = this.portaraitEast;
            this.portaraitEast = comp;
        } else if (WEST.equals(name)) {
            previous = this.portaraitWest;
            this.portaraitWest = comp;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
        }
        if (previous != null && previous != comp) {
            c.removeComponent(previous);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.portaraitCenter) {
            this.portaraitCenter = null;
        } else if (comp == this.portaraitNorth) {
            this.portaraitNorth = null;
        } else if (comp == this.portaraitSouth) {
            this.portaraitSouth = null;
        } else if (comp == this.portaraitEast) {
            this.portaraitEast = null;
        } else if (comp == this.portaraitWest) {
            this.portaraitWest = null;
        }
    }

    public Object getComponentConstraint(Component comp) {
        if (comp == this.portaraitCenter) {
            return CENTER;
        }
        if (comp == this.portaraitNorth) {
            return NORTH;
        }
        if (comp == this.portaraitSouth) {
            return SOUTH;
        }
        if (comp == this.portaraitEast) {
            return EAST;
        }
        if (comp == this.portaraitWest) {
            return WEST;
        }
        return null;
    }

    public void layoutContainer(Container target) {
        Component c;
        Component c2;
        Style s = target.getStyle();
        int top = s.getPadding(false, 0);
        int bottom = target.getLayoutHeight() - target.getBottomGap() - s.getPadding(false, 2);
        int left = s.getPadding(target.isRTL(), 1);
        int right = target.getLayoutWidth() - target.getSideGap() - s.getPadding(target.isRTL(), 3);
        int targetWidth = target.getWidth();
        int targetHeight = target.getHeight();
        boolean rtl = target.isRTL();
        if (rtl) {
            left += target.getSideGap();
        }
        Component east = this.getEast();
        Component west = this.getWest();
        Component south = this.getSouth();
        Component north = this.getNorth();
        Component center = this.getCenter();
        if (north != null) {
            c2 = north;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(top + c2.getStyle().getMargin(false, 0));
            top += c2.getHeight() + c2.getStyle().getMargin(false, 0) + c2.getStyle().getMargin(false, 2);
        }
        if (south != null) {
            c2 = south;
            this.positionTopBottom(target, c2, right, left, targetHeight);
            c2.setY(bottom - c2.getHeight() - c2.getStyle().getMargin(false, 2));
            bottom -= c2.getHeight() + c2.getStyle().getMargin(false, 0) + c2.getStyle().getMargin(false, 2);
        }
        Component realEast = east;
        Component realWest = west;
        if (rtl) {
            realEast = west;
            realWest = east;
        }
        if (realEast != null) {
            c = realEast;
            this.positionLeftRight(realEast, targetWidth, bottom, top);
            c.setX(right - c.getWidth() - c.getStyle().getMargin(target.isRTL(), 3));
            right -= c.getWidth() + c.getStyle().getMargin(false, 1) + c.getStyle().getMargin(false, 3);
        }
        if (realWest != null) {
            c = realWest;
            this.positionLeftRight(realWest, targetWidth, bottom, top);
            c.setX(left + c.getStyle().getMargin(target.isRTL(), 1));
            left += c.getWidth() + c.getStyle().getMargin(false, 1) + c.getStyle().getMargin(false, 3);
        }
        if (center != null) {
            c = center;
            int w = right - left - c.getStyle().getMargin(false, 1) - c.getStyle().getMargin(false, 3);
            int h = bottom - top - c.getStyle().getMargin(false, 0) - c.getStyle().getMargin(false, 2);
            int x = left + c.getStyle().getMargin(target.isRTL(), 1);
            int y = top + c.getStyle().getMargin(false, 0);
            switch (this.centerBehavior) {
                case 2: {
                    Dimension d = c.getPreferredSize();
                    if (d.getWidth() < w) {
                        int newX = targetWidth / 2 - d.getWidth() / 2;
                        if (newX > x) {
                            x = newX;
                        }
                        w = d.getWidth();
                    }
                    if (d.getHeight() >= h) break;
                    int newY = targetHeight / 2 - d.getHeight() / 2;
                    if (newY > y) {
                        y = newY;
                    }
                    h = d.getHeight();
                    break;
                }
                case 1: {
                    Dimension d = c.getPreferredSize();
                    if (d.getWidth() < w) {
                        x += w / 2 - d.getWidth() / 2;
                        w = d.getWidth();
                    }
                    if (d.getHeight() >= h) break;
                    y += h / 2 - d.getHeight() / 2;
                    h = d.getHeight();
                }
            }
            c.setWidth(w);
            c.setHeight(h);
            c.setX(x);
            c.setY(y);
        }
    }

    private void positionLeftRight(Component c, int targetWidth, int bottom, int top) {
        c.setWidth(Math.min(targetWidth, c.getPreferredW()));
        c.setHeight(bottom - top - c.getStyle().getMargin(false, 0) - c.getStyle().getMargin(false, 2));
        c.setY(top + c.getStyle().getMargin(false, 0));
    }

    private void positionTopBottom(Component target, Component c, int right, int left, int targetHeight) {
        c.setWidth(right - left - c.getStyle().getMargin(false, 1) - c.getStyle().getMargin(false, 3));
        c.setHeight(Math.min(targetHeight, c.getPreferredH()));
        c.setX(left + c.getStyle().getMargin(target.isRTL(), 1));
    }

    public Dimension getPreferredSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        Component east = this.getEast();
        Component west = this.getWest();
        Component south = this.getSouth();
        Component north = this.getNorth();
        Component center = this.getCenter();
        if (east != null) {
            dim.setWidth(east.getPreferredW() + east.getStyle().getMargin(false, 1) + east.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(east.getPreferredH() + east.getStyle().getMargin(false, 0) + east.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (west != null) {
            dim.setWidth(dim.getWidth() + west.getPreferredW() + west.getStyle().getMargin(false, 1) + west.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(west.getPreferredH() + west.getStyle().getMargin(false, 0) + west.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (center != null) {
            dim.setWidth(dim.getWidth() + center.getPreferredW() + center.getStyle().getMargin(false, 1) + center.getStyle().getMargin(false, 3));
            dim.setHeight(Math.max(center.getPreferredH() + center.getStyle().getMargin(false, 0) + center.getStyle().getMargin(false, 2), dim.getHeight()));
        }
        if (north != null) {
            dim.setWidth(Math.max(north.getPreferredW() + north.getStyle().getMargin(false, 1) + north.getStyle().getMargin(false, 3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + north.getPreferredH() + north.getStyle().getMargin(false, 0) + north.getStyle().getMargin(false, 2));
        }
        if (south != null) {
            dim.setWidth(Math.max(south.getPreferredW() + south.getStyle().getMargin(false, 1) + south.getStyle().getMargin(false, 3), dim.getWidth()));
            dim.setHeight(dim.getHeight() + south.getPreferredH() + south.getStyle().getMargin(false, 0) + south.getStyle().getMargin(false, 2));
        }
        dim.setWidth(dim.getWidth() + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3));
        dim.setHeight(dim.getHeight() + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
        return dim;
    }

    private boolean isLandscape() {
        Display d = Display.getInstance();
        return d.getDisplayWidth() > d.getDisplayHeight();
    }

    private Component getComponentAtIgnoreLandscape(String constraint) {
        if (constraint != null) {
            if (constraint.equals(NORTH)) {
                return this.portaraitNorth;
            }
            if (constraint.equals(SOUTH)) {
                return this.portaraitSouth;
            }
            if (constraint.equals(EAST)) {
                return this.portaraitEast;
            }
            if (constraint.equals(WEST)) {
                return this.portaraitWest;
            }
            if (constraint.equals(CENTER)) {
                return this.portaraitCenter;
            }
        }
        return null;
    }

    private Component getComponentImpl(Component noLandscape, String orientation) {
        String s;
        if (this.landscapeSwap != null && this.isLandscape() && (s = (String)this.landscapeSwap.get(orientation)) != null) {
            return this.getComponentAtIgnoreLandscape(s);
        }
        return noLandscape;
    }

    public Component getSouth() {
        return this.getComponentImpl(this.portaraitSouth, SOUTH);
    }

    public Component getCenter() {
        return this.getComponentImpl(this.portaraitCenter, CENTER);
    }

    public Component getNorth() {
        return this.getComponentImpl(this.portaraitNorth, NORTH);
    }

    public Component getEast() {
        return this.getComponentImpl(this.portaraitEast, EAST);
    }

    public Component getWest() {
        return this.getComponentImpl(this.portaraitWest, WEST);
    }

    public String toString() {
        return "BorderLayout";
    }

    public void defineLandscapeSwap(String portraitPosition, String landscapePosition) {
        if (this.landscapeSwap == null) {
            this.landscapeSwap = new Hashtable();
        }
        this.landscapeSwap.put(portraitPosition, landscapePosition);
        this.landscapeSwap.put(landscapePosition, portraitPosition);
    }

    public String getLandscapeSwap(String portraitPosition) {
        if (this.landscapeSwap == null) {
            return null;
        }
        return (String)this.landscapeSwap.get(portraitPosition);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && this.centerBehavior == ((BorderLayout)o).centerBehavior) {
            if (this.landscapeSwap == ((BorderLayout)o).landscapeSwap) {
                return true;
            }
            if (this.landscapeSwap != null) {
                return ((Object)this.landscapeSwap).equals(((BorderLayout)o).landscapeSwap);
            }
        }
        return false;
    }

    public boolean isAbsoluteCenter() {
        return this.centerBehavior == 1;
    }

    public void setAbsoluteCenter(boolean absoluteCenter) {
        if (absoluteCenter) {
            this.setCenterBehavior(1);
        } else {
            this.setCenterBehavior(0);
        }
    }

    public int getCenterBehavior() {
        return this.centerBehavior;
    }

    public void setCenterBehavior(int centerBehavior) {
        this.centerBehavior = centerBehavior;
    }
}

