/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextField;
import com.sun.lwuit.VirtualKeyboard;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.impl.s40.S40Implementation;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.PlatformColorBlender;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.util.EventDispatcher;
import com.sun.lwuit.util.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UIManager {
    private LookAndFeel current = new DefaultLookAndFeel();
    private Hashtable styles = new Hashtable();
    private Hashtable selectedStyles = new Hashtable();
    private Hashtable themeProps;
    private Hashtable themeConstants = new Hashtable();
    static UIManager instance;
    private Style defaultStyle = new Style();
    private Style defaultSelectedStyle = new Style();
    static boolean accessible;
    static boolean localeAccessible;
    private Hashtable imageCache = new Hashtable();
    private Hashtable resourceBundle;
    private EventDispatcher themelisteners;
    private javax.microedition.lcdui.Display nativeDisplay;
    private Resources localeResource = null;
    private String selectedResFileName = null;

    UIManager() {
    }

    public static UIManager getInstance() {
        if (instance == null) {
            instance = new UIManager();
            instance.resetThemeProps(null);
        }
        return instance;
    }

    public LookAndFeel getLookAndFeel() {
        return this.current;
    }

    public void setLookAndFeel(LookAndFeel plaf) {
        this.current.uninstall();
        this.current = plaf;
    }

    public void setComponentStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.styles.put(id, style);
    }

    public void setComponentSelectedStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.selectedStyles.put(id, style);
    }

    public Style getComponentStyle(String id) {
        return this.getComponentStyleImpl(id, false, "");
    }

    public Style getComponentSelectedStyle(String id) {
        return this.getComponentStyleImpl(id, true, "sel#");
    }

    public Style getComponentCustomStyle(String id, String type) {
        return this.getComponentStyleImpl(id, false, type + "#");
    }

    private Style getComponentStyleImpl(String id, boolean selected, String prefix) {
        try {
            Style style = null;
            id = id == null || id.length() == 0 ? "" : id + ".";
            if (selected) {
                style = (Style)this.selectedStyles.get(id);
                if (style == null) {
                    style = this.createStyle(id, prefix, true);
                    this.selectedStyles.put(id, style);
                }
            } else if (prefix.length() == 0) {
                style = (Style)this.styles.get(id);
                if (style == null) {
                    style = this.createStyle(id, prefix, false);
                    this.styles.put(id, style);
                }
            } else {
                return this.createStyle(id, prefix, false);
            }
            return new Style(style);
        }
        catch (OutOfMemoryError err) {
            System.gc();
            return new Style(this.defaultStyle);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return new Style(this.defaultStyle);
        }
    }

    public String getThemeName() {
        if (this.themeProps != null) {
            return (String)this.themeProps.get("name");
        }
        return null;
    }

    Hashtable getThemeProps() {
        return this.themeProps;
    }

    private void resetThemeProps(Hashtable installedTheme) {
        this.themeProps = new Hashtable();
        String disabledColor = Integer.toHexString(this.getLookAndFeel().getDisableColor());
        Integer centerAlign = new Integer(4);
        Integer rightAlign = new Integer(3);
        this.themeProps.put("sel#transparency", "255");
        this.themeProps.put("dis#fgColor", disabledColor);
        if (installedTheme == null || !installedTheme.containsKey("Button.derive")) {
            this.themeProps.put("Button.border", Border.getDefaultBorder());
            this.themeProps.put("Button.padding", "4,4,4,4");
        }
        if (installedTheme == null || !installedTheme.containsKey("Button.press#derive")) {
            this.themeProps.put("Button.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("Button.press#derive", "Button");
        }
        this.themeProps.put("Button.sel#derive", "Button");
        this.themeProps.put("Button.dis#derive", "Button");
        if (this.selectedResFileName != null && this.selectedResFileName.equals("/asha2013_theme.res") && Display.getInstance().getDeviceType() == 3) {
            this.themeProps.put("Button.font", Font.createDirectUtilsSystemFont(0, 0, 18));
        }
        if (installedTheme == null || !installedTheme.containsKey("CalendarTitle.derive")) {
            this.themeProps.put("CalendarTitle.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("CalendarSelectedDay.derive")) {
            this.themeProps.put("CalendarSelectedDay.border", Border.getDefaultBorder());
            this.themeProps.put("CalendarSelectedDay.align", centerAlign);
        }
        this.themeProps.put("CalendarSelectedDay.sel#derive", "CalendarSelectedDay");
        if (installedTheme == null || !installedTheme.containsKey("CalendarDay.derive")) {
            this.themeProps.put("CalendarDay.align", centerAlign);
        }
        this.themeProps.put("CalendarDay.dis#derive", "CalendarDay");
        this.themeProps.put("CalendarDay.press#derive", "CalendarDay");
        if (installedTheme == null || !installedTheme.containsKey("CalendarDay.sel#derive")) {
            this.themeProps.put("CalendarDay.sel#align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBox.derive")) {
            this.themeProps.put("ComboBox.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBox.sel#derive", "ComboBox");
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxItem.derive")) {
            this.themeProps.put("ComboBoxItem.margin", "0,0,0,0");
            this.themeProps.put("ComboBoxItem.transparency", "0");
        }
        this.themeProps.put("ComboBoxItem.sel#derive", "ComboBoxItem");
        this.themeProps.put("ComboBoxItem.dis#derive", "ComboBoxItem");
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxList.derive")) {
            this.themeProps.put("ComboBoxList.margin", "2,2,2,2");
            this.themeProps.put("ComboBoxList.padding", "0,0,0,0");
            this.themeProps.put("ComboBoxList.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxList.sel#derive")) {
            this.themeProps.put("ComboBoxList.sel#margin", "2,2,2,2");
            this.themeProps.put("ComboBoxList.sel#padding", "0,0,0,0");
            this.themeProps.put("ComboBoxList.sel#transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ComboBoxPopup.derive")) {
            this.themeProps.put("ComboBoxPopup.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBoxPopup.sel#derive", "ComboBoxPopup");
        if (installedTheme == null || !installedTheme.containsKey("Command.derive")) {
            this.themeProps.put("Command.margin", "0,0,0,0");
            this.themeProps.put("Command.transparency", "0");
        }
        this.themeProps.put("Command.sel#derive", "Command");
        this.themeProps.put("Command.dis#derive", "Command");
        if (installedTheme == null || !installedTheme.containsKey("CommandList.derive")) {
            this.themeProps.put("CommandList.margin", "0,0,0,0");
            this.themeProps.put("CommandList.padding", "0,0,0,0");
            this.themeProps.put("CommandList.transparency", "0");
        }
        this.themeProps.put("CommandList.sel#derive", "CommandList");
        if (installedTheme == null || !installedTheme.containsKey("ComponentGroup.derive")) {
            this.themeProps.put("ComponentGroup.derive", "Container");
        }
        if (installedTheme == null || !installedTheme.containsKey("Container.derive")) {
            this.themeProps.put("Container.transparency", "0");
            this.themeProps.put("Container.margin", "0,0,0,0");
            this.themeProps.put("Container.padding", "0,0,0,0");
        }
        this.themeProps.put("Container.sel#derive", "Container");
        this.themeProps.put("Container.dis#derive", "Container");
        if (installedTheme == null || !installedTheme.containsKey("ContentPane.derive")) {
            this.themeProps.put("ContentPane.transparency", "0");
            this.themeProps.put("ContentPane.margin", "0,0,0,0");
            this.themeProps.put("ContentPane.padding", "0,0,0,0");
        }
        this.themeProps.put("ContentPane.sel#derive", "ContentPane");
        if (installedTheme == null || !installedTheme.containsKey("DialogContentPane.derive")) {
            this.themeProps.put("DialogContentPane.margin", "0,0,0,0");
            this.themeProps.put("DialogContentPane.padding", "0,0,0,0");
            this.themeProps.put("DialogContentPane.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("DialogTitle.derive")) {
            this.themeProps.put("DialogTitle.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("Form.derive")) {
            this.themeProps.put("Form.padding", "0,0,0,0");
            this.themeProps.put("Form.margin", "0,0,0,0");
        }
        this.themeProps.put("Form.sel#derive", "Form");
        if (installedTheme == null || !installedTheme.containsKey("HorizontalScroll.derive")) {
            this.themeProps.put("HorizontalScroll.margin", "0,0,0,0");
            this.themeProps.put("HorizontalScroll.padding", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("HorizontalScrollThumb.derive")) {
            this.themeProps.put("HorizontalScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("HorizontalScrollThumb.bgColor", "0");
            this.themeProps.put("HorizontalScrollThumb.margin", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("List.derive")) {
            this.themeProps.put("List.transparency", "0");
            this.themeProps.put("List.margin", "0,0,0,0");
        }
        this.themeProps.put("List.sel#derive", "List");
        if (installedTheme == null || !installedTheme.containsKey("ListRenderer.derive")) {
            this.themeProps.put("ListRenderer.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("ListRenderer.sel#derive")) {
            this.themeProps.put("ListRenderer.sel#transparency", "100");
        }
        this.themeProps.put("ListRenderer.dis#derive", "ListRenderer");
        if (installedTheme == null || !installedTheme.containsKey("Menu.derive")) {
            this.themeProps.put("Menu.padding", "0,0,0,0");
        }
        this.themeProps.put("Menu.sel#derive", "Menu");
        if (installedTheme == null || !installedTheme.containsKey("PopupContentPane.derive")) {
            this.themeProps.put("PopupContentPane.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("Scroll.derive")) {
            this.themeProps.put("Scroll.margin", "0,0,0,0");
            this.themeProps.put("Scroll.padding", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("ScrollThumb.derive")) {
            this.themeProps.put("ScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("ScrollThumb.margin", "0,0,0,0");
            this.themeProps.put("ScrollThumb.bgColor", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("SliderFull.derive")) {
            this.themeProps.put("SliderFull.bgColor", "0");
        }
        this.themeProps.put("SliderFull.sel#derive", "SliderFull");
        if (installedTheme == null || !installedTheme.containsKey("SoftButton.derive")) {
            this.themeProps.put("SoftButton.transparency", "255");
            this.themeProps.put("SoftButton.margin", "0,0,0,0");
            this.themeProps.put("SoftButton.padding", "0,0,0,0");
        }
        this.themeProps.put("SoftButton.sel#derive", "SoftButton");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonCenter.derive")) {
            this.themeProps.put("SoftButtonCenter.align", centerAlign);
            this.themeProps.put("SoftButtonCenter.transparency", "0");
            this.themeProps.put("SoftButtonCenter.derive", "SoftButton");
            this.themeProps.put("SoftButtonCenter.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonCenter.sel#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.press#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.dis#derive", "SoftButtonCenter");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonLeft.derive")) {
            this.themeProps.put("SoftButtonLeft.transparency", "0");
            this.themeProps.put("SoftButtonLeft.derive", "SoftButton");
            this.themeProps.put("SoftButtonLeft.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonLeft.sel#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.press#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.dis#derive", "SoftButtonLeft");
        if (installedTheme == null || !installedTheme.containsKey("SoftButtonRight.derive")) {
            this.themeProps.put("SoftButtonRight.align", rightAlign);
            this.themeProps.put("SoftButtonRight.transparency", "0");
            this.themeProps.put("SoftButtonRight.derive", "SoftButton");
            this.themeProps.put("SoftButtonRight.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonRight.sel#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.press#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.dis#derive", "SoftButtonRight");
        if (installedTheme == null || !installedTheme.containsKey("Spinner.derive")) {
            this.themeProps.put("Spinner.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Spinner.sel#derive", "Spinner");
        if (installedTheme == null || !installedTheme.containsKey("SpinnerOverlay.derive")) {
            this.themeProps.put("SpinnerOverlay.transparency", "0");
        }
        if (installedTheme == null || !installedTheme.containsKey("Tab.derive")) {
            this.themeProps.put("Tab.margin", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("Tab.sel#derive")) {
            this.themeProps.put("Tab.sel#derive", "Tab");
            this.themeProps.put("Tab.sel#border", Border.createLineBorder(1));
        }
        this.themeProps.put("TabbedPane.margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.padding", "0,0,0,0");
        this.themeProps.put("TabbedPane.transparency", "0");
        this.themeProps.put("TabbedPane.sel#margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.sel#padding", "0,0,0,0");
        if (installedTheme == null || !installedTheme.containsKey("Table.derive")) {
            this.themeProps.put("Table.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Table.sel#derive", "Table");
        if (installedTheme == null || !installedTheme.containsKey("TableCell.derive")) {
            this.themeProps.put("TableCell.transparency", "0");
        }
        this.themeProps.put("TableCell.sel#derive", "TableCell");
        if (installedTheme == null || !installedTheme.containsKey("TableHeader.derive")) {
            this.themeProps.put("TableHeader.transparency", "0");
        }
        this.themeProps.put("TableHeader.sel#derive", "TableHeader");
        if (installedTheme == null || !installedTheme.containsKey("Tabs.derive")) {
            this.themeProps.put("Tabs.bgColor", "a0a0a0");
            this.themeProps.put("Tabs.padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TabsContainer.derive")) {
            this.themeProps.put("TabsContainer.padding", "0,0,0,0");
            this.themeProps.put("TabsContainer.margin", "0,0,0,0");
            this.themeProps.put("TabsContainer.bgColor", "a0a0a0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TabSelected.derive")) {
            this.themeProps.put("TabSelected.bgColor", "a0a0a0");
            this.themeProps.put("TabSelected.fgColor", "ffffff");
            this.themeProps.put("TabSelected.margin", "1,1,1,1");
        }
        if (installedTheme == null || !installedTheme.containsKey("TabSelected.sel#derive")) {
            this.themeProps.put("TabSelected.sel#derive", "TabSelected");
            this.themeProps.put("TabSelected.sel#border", Border.createLineBorder(1));
        }
        if (installedTheme == null || !installedTheme.containsKey("TextArea.derive")) {
            this.themeProps.put("TextArea.border", Border.getDefaultBorder());
        }
        this.themeProps.put("TextArea.sel#derive", "TextArea");
        this.themeProps.put("TextArea.dis#derive", "TextArea");
        if (installedTheme == null || !installedTheme.containsKey("TextField.derive")) {
            this.themeProps.put("TextField.border", Border.getDefaultBorder());
        }
        this.themeProps.put("TextField.sel#derive", "TextField");
        this.themeProps.put("TextField.dis#derive", "TextField");
        if (installedTheme == null || !installedTheme.containsKey("TextHint.derive")) {
            this.themeProps.put("TextHint.transparency", "0");
            this.themeProps.put("TextHint.fgColor", "cccccc");
            this.themeProps.put("TextHint.font", Font.createSystemFont(0, 2, 0));
        }
        if (installedTheme == null || !installedTheme.containsKey("Title.derive")) {
            this.themeProps.put("Title.margin", "0,0,0,0");
            this.themeProps.put("Title.transparency", "255");
            this.themeProps.put("Title.align", centerAlign);
        }
        this.themeProps.put("Title.sel#derive", "Title");
        if (installedTheme == null || !installedTheme.containsKey("TitleArea.derive")) {
            this.themeProps.put("TitleArea.transparency", "0");
            this.themeProps.put("TitleArea.margin", "0,0,0,0");
            this.themeProps.put("TitleArea.padding", "0,0,0,0");
        }
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.derive")) {
            this.themeProps.put("TouchCommand.border", Border.getDefaultBorder());
            this.themeProps.put("TouchCommand.padding", "10,10,10,10");
            this.themeProps.put("TouchCommand.margin", "0,0,0,0");
            this.themeProps.put("TouchCommand.align", centerAlign);
        }
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.press#derive")) {
            this.themeProps.put("TouchCommand.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("TouchCommand.press#derive", "TouchCommand");
        }
        this.themeProps.put("TouchCommand.sel#derive", "TouchCommand");
        if (installedTheme == null || !installedTheme.containsKey("TouchCommand.dis#derive")) {
            this.themeProps.put("TouchCommand.dis#derive", "TouchCommand");
            this.themeProps.put("TouchCommand.dis#fgColor", disabledColor);
        }
        if (installedTheme == null || !installedTheme.containsKey("VKB.derive")) {
            this.themeProps.put("VKB.bgColor", "666666");
            this.themeProps.put("VKB.padding", "3,6,3,3");
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBtooltip.derive")) {
            this.themeProps.put("VKBtooltip.padding", "8,8,8,8");
            this.themeProps.put("VKBtooltip.font", Font.createSystemFont(0, 1, 16));
            this.themeProps.put("VKBtooltip.bgColor", "FFFFFF");
            this.themeProps.put("VKBtooltip.fgColor", "0");
            this.themeProps.put("VKBtooltip.border", Border.createRoundBorder(8, 8));
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBButton.derive")) {
            this.themeProps.put("VKBButton.fgColor", "FFFFFF");
            this.themeProps.put("VKBButton.bgColor", "0");
            this.themeProps.put("VKBButton.border", Border.createRoundBorder(8, 8));
            this.themeProps.put("VKBButton.margin", "2,2,1,1");
            this.themeProps.put("VKBButton.padding", "8,8,4,4");
            this.themeProps.put("VKBButton.font", Font.createSystemFont(0, 1, 0));
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBButton.sel#derive")) {
            this.themeProps.put("VKBButton.sel#derive", "VKBButton");
            this.themeProps.put("VKBButton.sel#bgType", new Byte(6));
            this.themeProps.put("VKBButton.sel#bgGradient", new Object[]{new Integer(0x666666), new Integer(0), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBButton.press#derive")) {
            this.themeProps.put("VKBButton.press#derive", "VKBButton");
            this.themeProps.put("VKBButton.press#bgType", new Byte(6));
            this.themeProps.put("VKBButton.press#bgGradient", new Object[]{new Integer(0), new Integer(0x666666), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBSpecialButton.derive")) {
            this.themeProps.put("VKBSpecialButton.fgColor", "FFFFFF");
            this.themeProps.put("VKBSpecialButton.bgColor", "0");
            this.themeProps.put("VKBSpecialButton.border", Border.createRoundBorder(8, 8));
            this.themeProps.put("VKBSpecialButton.bgType", new Byte(6));
            this.themeProps.put("VKBSpecialButton.bgGradient", new Object[]{new Integer(0xCCCCCC), new Integer(0x666666), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
            this.themeProps.put("VKBSpecialButton.margin", "2,2,1,1");
            this.themeProps.put("VKBSpecialButton.padding", "6,6,4,4");
            this.themeProps.put("VKBSpecialButton.font", Font.createSystemFont(0, 1, 0));
        }
        this.themeProps.put("VKBSpecialButton.sel#derive", "VKBSpecialButton");
        if (installedTheme == null || !installedTheme.containsKey("VKBSpecialButton.press#derive")) {
            this.themeProps.put("VKBSpecialButton.press#derive", "VKBSpecialButton");
            this.themeProps.put("VKBSpecialButton.press#bgType", new Byte(6));
            this.themeProps.put("VKBSpecialButton.press#bgGradient", new Object[]{new Integer(0x666666), new Integer(0xCCCCCC), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (installedTheme == null || !installedTheme.containsKey("VKBTextInput.derive")) {
            this.themeProps.put("VKBTextInput.fgColor", "FFFFFF");
            this.themeProps.put("VKBTextInput.bgColor", "0");
            this.themeProps.put("VKBTextInput.font", Font.createSystemFont(0, 1, 0));
            this.themeProps.put("VKBTextInput.border", Border.getDefaultBorder());
        }
        this.themeProps.put("VKBTextInput.sel#derive", "VKBTextInput");
        if (installedTheme == null || !installedTheme.containsKey("AdsComponent.sel#derive")) {
            this.themeProps.put("AdsComponent.sel#border", Border.getDefaultBorder());
            this.themeProps.put("AdsComponent.sel#padding", "2,2,2,2");
            this.themeProps.put("AdsComponent.sel#transparency", "0");
        }
        this.themeProps.put("AdsComponent#derive", "Container");
        this.themeProps.put("WebBrowser#derive", "Container");
    }

    public void setThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.setThemePropsImpl(themeProps);
        }
    }

    public void loadThemeForDeviceType(String resRef, int deviceType, String themeId) throws IOException {
        if (deviceType == Display.getInstance().getDeviceType()) {
            this.selectedResFileName = resRef;
            long time = System.currentTimeMillis();
            Resources r = Resources.open(resRef);
            time = System.currentTimeMillis() - time;
            System.out.println(resRef + " load time:" + time);
            UIManager.getInstance().setThemeProps(r.getTheme(themeId));
        }
    }

    public void addThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.buildTheme(themeProps);
            this.current.refreshTheme();
        }
    }

    public int getThemeConstant(String constantName, int def) {
        String v = (String)this.themeConstants.get(constantName);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException err) {
                err.printStackTrace();
            }
        }
        return def;
    }

    public String getThemeConstant(String constantName, String def) {
        String v = (String)this.themeConstants.get(constantName);
        if (v != null) {
            return v;
        }
        return def;
    }

    public boolean isThemeConstant(String constantName, boolean def) {
        String c = this.getThemeConstant(constantName, null);
        if (c == null) {
            return def;
        }
        return c.equalsIgnoreCase("true") || c.equals("1");
    }

    public Boolean isThemeConstant(String constantName) {
        String c = this.getThemeConstant(constantName, null);
        if (c == null) {
            return null;
        }
        if (c.equalsIgnoreCase("true") || c.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Image getThemeImageConstant(String constantName) {
        return (Image)this.themeConstants.get(constantName);
    }

    void setThemePropsImpl(Hashtable themeProps) {
        Border b;
        int theme_color;
        String usePlatformColors;
        this.resetThemeProps(themeProps);
        this.styles.clear();
        this.themeConstants.clear();
        this.selectedStyles.clear();
        this.imageCache.clear();
        if (this.themelisteners != null) {
            this.themelisteners.fireActionEvent(new ActionEvent(themeProps));
        }
        if (Display.getInstance().getDeviceType() == 2) {
            usePlatformColors = (String)themeProps.get("@NokiaPlatformColors");
            themeProps.put("bgColor", Integer.toHexString(this.nativeDisplay.getColor(0)));
            String fg = Integer.toHexString(this.nativeDisplay.getColor(1));
            themeProps.put("fgColor", fg);
            if (usePlatformColors != null && usePlatformColors.equals("true")) {
                PlatformColorBlender blender = PlatformColorBlender.getInstance();
                theme_color = this.nativeDisplay.getColor(5);
                b = (Border)themeProps.get("Button.press#border");
                Border buttonMask = (Border)themeProps.get("ButtonMask.border");
                blender.applyColorToBorder(b, theme_color, buttonMask.images);
                b = (Border)themeProps.get("Button.border");
                blender.applyColorToBorder(b, theme_color, buttonMask.images);
                this.themeConstants.put("dlgCommandGridBool", "true");
                blender.applyBackgroundColorToThemeProp(themeProps, "ListRendererFocus.bgImage", theme_color);
                b = (Border)themeProps.get("ComboBox.border");
                blender.applyColorToBorder(b, theme_color, ((Border)themeProps.get((Object)"ComboBoxMask.border")).images);
                b = (Border)themeProps.get("TabSelected.sel#border");
                blender.applyColorToBorder(b, theme_color);
                themeProps.put("TabSelected.sel#fgColor", Integer.toHexString(theme_color));
            }
        }
        if (Display.getInstance().getDeviceType() == 3 && (usePlatformColors = (String)themeProps.get("@NokiaPlatformColors")) != null && usePlatformColors.equals("true")) {
            PlatformColorBlender blender = PlatformColorBlender.getInstance();
            String bgColor = (String)themeProps.get("bgColor");
            theme_color = Integer.parseInt(bgColor, 16);
            blender.applyBackgroundColorToThemeProp(themeProps, "ListRendererFocus.bgImage", theme_color);
            b = (Border)themeProps.get("ComboBox.border");
            blender.applyColorToBorder(b, theme_color, ((Border)themeProps.get((Object)"ComboBoxMask.border")).images);
            b = (Border)themeProps.get("TabSelected.sel#border");
            blender.applyColorToBorder(b, theme_color);
            themeProps.put("TabSelected.sel#fgColor", Integer.toHexString(theme_color));
        }
        this.buildTheme(themeProps);
        this.current.refreshTheme();
        if (Display.getInstance().getDeviceType() == 2 || Display.getInstance().getDeviceType() == 3) {
            Display.getInstance().setCommandBehavior(10);
            if (Display.getInstance().getImplementation() instanceof S40Implementation) {
                ((S40Implementation)Display.getInstance().getImplementation()).setHideMenu(true);
            }
        }
    }

    private void buildTheme(Hashtable themeProps) {
        Enumeration e = themeProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("@")) {
                this.themeConstants.put(key.substring(1, key.length()), themeProps.get(key));
                continue;
            }
            this.themeProps.put(key, themeProps.get(key));
        }
        this.defaultStyle = new Style();
        this.defaultStyle = this.createStyle("", "", false);
        this.defaultSelectedStyle = new Style(this.defaultStyle);
        this.defaultSelectedStyle = this.createStyle("", "sel#", true);
    }

    private Style createStyle(String id, String prefix, boolean selected) {
        Style style;
        String baseStyle;
        String originalId = id;
        if (prefix != null && prefix.length() > 0) {
            id = id + prefix;
        }
        if ((baseStyle = (String)this.themeProps.get(id + "derive")) != null) {
            if (baseStyle.indexOf(46) > -1 && baseStyle.indexOf(35) < 0) {
                baseStyle = baseStyle + "#";
            }
            if (!(baseStyle + ".").equals(id)) {
                int pos = baseStyle.indexOf(46);
                if (pos > -1) {
                    String baseId = baseStyle.substring(0, pos);
                    String basePrefix = baseStyle.substring(pos + 1);
                    style = new Style(this.getComponentStyleImpl(baseId, basePrefix.indexOf("sel") > -1, basePrefix));
                } else {
                    style = new Style(this.getComponentStyle(baseStyle));
                }
            } else {
                baseStyle = null;
                style = selected ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
            }
        } else {
            style = selected ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
        }
        if (this.themeProps != null) {
            String bgColor = (String)this.themeProps.get(id + "bgColor");
            String fgColor = (String)this.themeProps.get(id + "fgColor");
            Object border = this.themeProps.get(id + "border");
            Object bgImage = this.themeProps.get(id + "bgImage");
            String transperency = (String)this.themeProps.get(id + "transparency");
            String margin = (String)this.themeProps.get(id + "margin");
            String padding = (String)this.themeProps.get(id + "padding");
            Object font = this.themeProps.get(id + "font");
            Integer alignment = (Integer)this.themeProps.get(id + "align");
            Integer textDecoration = (Integer)this.themeProps.get(id + "textDecoration");
            Byte backgroundType = (Byte)this.themeProps.get(id + "bgType");
            Byte backgroundAlignment = (Byte)this.themeProps.get(id + "bgAlign");
            Object[] backgroundGradient = (Object[])this.themeProps.get(id + "bgGradient");
            byte[] paddingUnit = (byte[])this.themeProps.get(id + "padUnit");
            byte[] marginUnit = (byte[])this.themeProps.get(id + "marUnit");
            if (bgColor != null) {
                style.setBgColor(Integer.valueOf(bgColor, 16));
            }
            if (fgColor != null) {
                style.setFgColor(Integer.valueOf(fgColor, 16));
            }
            if (transperency != null) {
                style.setBgTransparency(Integer.valueOf(transperency));
            } else if (selected && (transperency = (String)this.themeProps.get(originalId + "transparency")) != null) {
                style.setBgTransparency(Integer.valueOf(transperency));
            }
            if (margin != null) {
                int[] marginArr = this.toIntArray(margin.trim());
                style.setMargin(marginArr[0], marginArr[1], marginArr[2], marginArr[3]);
            }
            if (padding != null) {
                int[] paddingArr = this.toIntArray(padding.trim());
                style.setPadding(paddingArr[0], paddingArr[1], paddingArr[2], paddingArr[3]);
            }
            if (paddingUnit != null) {
                style.setPaddingUnit(paddingUnit);
            }
            if (marginUnit != null) {
                style.setMarginUnit(marginUnit);
            }
            if (alignment != null) {
                style.setAlignment(alignment);
            }
            if (textDecoration != null) {
                style.setTextDecoration(textDecoration);
            }
            if (backgroundType != null) {
                style.setBackgroundType(backgroundType);
            }
            if (backgroundAlignment != null) {
                style.setBackgroundAlignment(backgroundAlignment);
            }
            if (backgroundGradient != null) {
                if (backgroundGradient.length < 5) {
                    Object[] a2 = new Object[5];
                    System.arraycopy(backgroundGradient, 0, a2, 0, backgroundGradient.length);
                    backgroundGradient = a2;
                    backgroundGradient[4] = new Float(1.0f);
                }
                style.setBackgroundGradient(backgroundGradient);
            }
            if (bgImage != null) {
                Image im = null;
                if (bgImage instanceof String) {
                    try {
                        String bgImageStr = (String)bgImage;
                        if (this.imageCache.containsKey(bgImageStr)) {
                            im = (Image)this.imageCache.get(bgImageStr);
                        } else {
                            im = bgImageStr.startsWith("/") ? Image.createImage(bgImageStr) : UIManager.parseImage((String)bgImage);
                            this.imageCache.put(bgImageStr, im);
                        }
                        this.themeProps.put(id + "bgImage", im);
                    }
                    catch (IOException ex) {
                        System.out.println("failed to parse image for id = " + id + "bgImage");
                    }
                } else if (bgImage instanceof Image) {
                    im = (Image)bgImage;
                }
                if (id.indexOf("Form") > -1 && (im.getWidth() != Display.getInstance().getDisplayWidth() || im.getHeight() != Display.getInstance().getDisplayHeight()) && style.getBackgroundType() == 1 && accessible) {
                    im.scale(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                }
                style.setBgImage(im);
            }
            if (font != null) {
                if (font instanceof String) {
                    style.setFont(UIManager.parseFont((String)font));
                } else {
                    style.setFont((Font)font);
                }
            }
            if (border != null) {
                style.setBorder((Border)border);
            }
            style.resetModifiedFlag();
        }
        return style;
    }

    private int[] toIntArray(String str) {
        int[] retVal = new int[4];
        str = str + ",";
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = Integer.parseInt(str.substring(0, str.indexOf(",")));
            str = str.substring(str.indexOf(",") + 1, str.length());
        }
        return retVal;
    }

    private static Image parseImage(String value) throws IOException {
        byte[] imageData = new byte[value.length() / 2];
        for (int index = 0; index < value.length(); index += 2) {
            String byteStr = value.substring(index, index + 2);
            imageData[index / 2] = Integer.valueOf(byteStr, 16).byteValue();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        Image image = Image.createImage(in);
        in.close();
        return image;
    }

    private static Font parseFont(String fontStr) {
        if (fontStr.startsWith("System")) {
            int face = 0;
            int style = 0;
            int size = 0;
            String sysFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
            String faceStr = sysFont.substring(0, sysFont.indexOf(";"));
            sysFont = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            String styleStr = sysFont.substring(0, sysFont.indexOf(";"));
            String sizeStr = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            if (faceStr.indexOf("FACE_SYSTEM") > -1) {
                face = 0;
            } else if (faceStr.indexOf("FACE_MONOSPACE") > -1) {
                face = 32;
            } else if (faceStr.indexOf("FACE_PROPORTIONAL") > -1) {
                face = 64;
            }
            if (styleStr.indexOf("STYLE_PLAIN") > -1) {
                style = 0;
            } else {
                if (styleStr.indexOf("STYLE_BOLD") > -1) {
                    style = 1;
                }
                if (styleStr.indexOf("STYLE_ITALIC") > -1) {
                    style |= 2;
                }
                if (styleStr.indexOf("STYLE_UNDERLINED") > -1) {
                    style |= 4;
                }
            }
            if (sizeStr.indexOf("SIZE_SMALL") > -1) {
                size = 8;
            } else if (sizeStr.indexOf("SIZE_MEDIUM") > -1) {
                size = 0;
            } else if (sizeStr.indexOf("SIZE_LARGE") > -1) {
                size = 16;
            }
            return Font.createSystemFont(face, style, size);
        }
        if (fontStr.toLowerCase().startsWith("bitmap")) {
            try {
                String bitmapFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
                String nameStr = bitmapFont.substring(0, bitmapFont.length());
                if (nameStr.toLowerCase().startsWith("highcontrast")) {
                    nameStr = nameStr.substring(nameStr.indexOf(";") + 1, nameStr.length());
                    Font f = Font.getBitmapFont(nameStr);
                    f.addContrast((byte)30);
                    return f;
                }
                return Font.getBitmapFont(nameStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Hashtable getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable resourceBundle) {
        if (localeAccessible) {
            if (this.resourceBundle == null) {
                this.resourceBundle = resourceBundle;
            } else if (resourceBundle != null) {
                Enumeration e = resourceBundle.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.resourceBundle.put(key, resourceBundle.get(key));
                }
            }
            if (resourceBundle != null) {
                String textFieldInputMode;
                String vkbInputMode;
                String v = (String)resourceBundle.get("@rtl");
                if (v != null) {
                    this.getLookAndFeel().setRTL(v.equalsIgnoreCase("true"));
                    this.current.refreshTheme();
                }
                if ((vkbInputMode = (String)resourceBundle.get("@vkb")) != null && vkbInputMode.length() > 0) {
                    String[] tokenized = this.toStringArray(this.tokenizeString(vkbInputMode, '|'));
                    VirtualKeyboard.setDefaultInputModeOrder(tokenized);
                    for (int iter = 0; iter < tokenized.length; ++iter) {
                        String val = tokenized[iter];
                        String[][] res = this.getInputMode("@vkb-", tokenized[iter], resourceBundle);
                        if (res == null) continue;
                        VirtualKeyboard.addDefaultInputMode(val, res);
                    }
                }
                if ((textFieldInputMode = (String)resourceBundle.get("@im")) != null && textFieldInputMode.length() > 0) {
                    String[] tokenized = this.toStringArray(this.tokenizeString(textFieldInputMode, '|'));
                    TextField.setDefaultInputModeOrder(tokenized);
                    for (int iter = 0; iter < tokenized.length; ++iter) {
                        String val = tokenized[iter];
                        String actual = (String)resourceBundle.get("@im-" + val);
                        if (actual == null) continue;
                        TextField.addInputMode(val, this.parseTextFieldInputMode(actual), Character.isUpperCase(val.charAt(0)));
                    }
                }
            }
        }
    }

    private Hashtable parseTextFieldInputMode(String s) {
        Vector tokens = this.tokenizeString(s, '|');
        Hashtable<Integer, String> response = new Hashtable<Integer, String>();
        int count = tokens.size();
        for (int iter = 0; iter < count; ++iter) {
            String t = (String)tokens.elementAt(iter);
            int pos = t.indexOf(61);
            String key = t.substring(0, pos);
            String val = t.substring(pos + 1);
            response.put(Integer.valueOf(key), val);
        }
        return response;
    }

    private String[][] getInputMode(String prefix, String val, Hashtable resourceBundle) {
        if (resourceBundle.containsKey(prefix + val)) {
            return this.tokenizeMultiArray((String)resourceBundle.get(prefix + val), '|', '\n');
        }
        return null;
    }

    private String[] toStringArray(Vector v) {
        String[] arr = new String[v.size()];
        for (int iter = 0; iter < arr.length; ++iter) {
            arr[iter] = (String)v.elementAt(iter);
        }
        return arr;
    }

    private String[][] tokenizeMultiArray(String s, char separator, char lineBreak) {
        Vector lines = this.tokenizeString(s, lineBreak);
        int lineCount = lines.size();
        String[][] result = new String[lineCount][];
        for (int iter = 0; iter < lineCount; ++iter) {
            String currentString = (String)lines.elementAt(iter);
            result[iter] = this.toStringArray(this.tokenizeString(currentString, separator));
        }
        return result;
    }

    private Vector tokenizeString(String s, char separator) {
        Vector<String> tokenized = new Vector<String>();
        int len = s.length();
        boolean lastSeparator = false;
        StringBuffer buf = new StringBuffer();
        for (int iter = 0; iter < len; ++iter) {
            char current = s.charAt(iter);
            if (current == separator) {
                if (lastSeparator) {
                    buf.append(separator);
                    lastSeparator = false;
                    continue;
                }
                lastSeparator = true;
                if (buf.length() <= 0) continue;
                tokenized.addElement(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            lastSeparator = false;
            buf.append(current);
        }
        if (buf.length() > 0) {
            tokenized.addElement(buf.toString());
        }
        return tokenized;
    }

    public String localize(String key, String defaultValue) {
        Object o;
        if (this.resourceBundle != null && key != null && (o = this.resourceBundle.get(key)) != null) {
            return (String)o;
        }
        return defaultValue;
    }

    public void addThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            this.themelisteners = new EventDispatcher();
        }
        this.themelisteners.addListener(l);
    }

    public void removeThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            return;
        }
        this.themelisteners.removeListener(l);
    }

    public void setNativeDisplay(javax.microedition.lcdui.Display d) {
        this.nativeDisplay = d;
    }

    public void loadLocalization() {
        String devlocale = System.getProperty("microedition.locale");
        if (devlocale == null) {
            devlocale = "en";
        }
        if (this.localeResource == null) {
            try {
                this.localeResource = Resources.open("/locale/locale.res");
            }
            catch (IOException ioe) {
                System.out.println("no localization file: locale/locale.res. Load localization manually.");
            }
        }
        if (this.localeResource != null) {
            Hashtable h = this.localeResource.getL10N("locale", devlocale);
            this.setResourceBundle(h);
        }
    }

    static {
        accessible = true;
        localeAccessible = true;
    }
}

