/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.tree;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.tree.TreeModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class Tree
extends Container {
    private static final String KEY_OBJECT = "TREE_OBJECT";
    private static final String KEY_PARENT = "TREE_PARENT";
    private static final String KEY_EXPANDED = "TREE_NODE_EXPANDED";
    private static final String KEY_DEPTH = "TREE_DEPTH";
    private EventDispatcher leafListener = new EventDispatcher();
    private ActionListener expansionListener = new Handler();
    private TreeModel model;
    private static Image folder;
    private static Image openFolder;
    private static Image nodeImage;
    private int depthIndent = 15;
    static /* synthetic */ Class array$$Ljava$lang$String;

    public Tree() {
        this(new StringArrayTreeModel(new String[][]{{"Colors", "Letters", "Numbers"}, {"Red", "Green", "Blue"}, {"A", "B", "C"}, {"1", "2", "3"}}));
    }

    public String[] getPropertyNames() {
        return new String[]{"data"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$$Ljava$lang$String == null ? (array$$Ljava$lang$String = Tree.class$("[[Ljava.lang.String;")) : array$$Ljava$lang$String};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("data")) {
            return ((StringArrayTreeModel)this.model).arr;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("data")) {
            this.setModel(new StringArrayTreeModel((String[][])value));
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Tree(TreeModel model) {
        this.model = model;
        this.setLayout(new BoxLayout(2));
        if (folder == null) {
            Tree.setFolderIcon(UIManager.getInstance().getThemeImageConstant("treeExpandNodeImage"));
        }
        if (openFolder == null) {
            Tree.setFolderOpenIcon(UIManager.getInstance().getThemeImageConstant("treeCollapseNodeImage"));
        }
        this.buildBranch(null, 0, this);
        this.setScrollableY(true);
        this.setUIID("Tree");
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.model = model;
        this.removeAll();
        this.buildBranch(null, 0, this);
    }

    public static void setFolderIcon(Image folderIcon) {
        folder = folderIcon;
    }

    public static void setFolderOpenIcon(Image folderIcon) {
        openFolder = folderIcon;
    }

    public static void setNodeIcon(Image nodeIcon) {
        nodeImage = nodeIcon;
    }

    private void expandNode(Component c) {
        c.putClientProperty(KEY_EXPANDED, "true");
        c.setUIID("TreeExpandableNode");
        ((Button)c).setIcon(openFolder);
        int depth = (Integer)c.getClientProperty(KEY_DEPTH);
        Container parent = c.getParent();
        Object o = c.getClientProperty(KEY_OBJECT);
        Container dest = new Container(new BoxLayout(2));
        Label dummy = new Label();
        parent.addComponent("Center", (Component)dummy);
        this.buildBranch(o, depth, dest);
        parent.replace((Component)dummy, (Component)dest, CommonTransitions.createSlide(1, true, 300));
    }

    private void collapseNode(Component c) {
        c.putClientProperty(KEY_EXPANDED, null);
        c.setUIID("TreeNode");
        ((Button)c).setIcon(folder);
        Container p = c.getParent();
        for (int iter = 0; iter < p.getComponentCount(); ++iter) {
            if (p.getComponentAt(iter) == c) continue;
            Label dummy = new Label();
            p.replaceAndWait(p.getComponentAt(iter), (Component)dummy, (Transition)CommonTransitions.createSlide(1, false, 300), true);
            p.removeComponent(dummy);
        }
    }

    public Object getSelectedItem() {
        Component c = this.getComponentForm().getFocused();
        if (c != null) {
            return c.getClientProperty(KEY_OBJECT);
        }
        return null;
    }

    private void buildBranch(Object parent, int depth, Container destination) {
        Vector children = this.model.getChildren(parent);
        int size = children.size();
        Integer depthVal = new Integer(depth + 1);
        for (int iter = 0; iter < size; ++iter) {
            Object current = children.elementAt(iter);
            Button nodeComponent = this.createNodeComponent(current, depth);
            if (this.model.isLeaf(current)) {
                destination.addComponent(nodeComponent);
                nodeComponent.addActionListener(new Handler(current));
            } else {
                Container componentArea = new Container(new BorderLayout());
                componentArea.addComponent("North", (Component)nodeComponent);
                destination.addComponent(componentArea);
                nodeComponent.addActionListener(this.expansionListener);
            }
            nodeComponent.putClientProperty(KEY_OBJECT, current);
            nodeComponent.putClientProperty(KEY_PARENT, parent);
            nodeComponent.putClientProperty(KEY_DEPTH, depthVal);
        }
    }

    protected Button createNodeComponent(Object node, int depth) {
        Button cmp = new Button(this.childToDisplayLabel(node));
        cmp.setUIID("TreeNode");
        cmp.setGap(5);
        if (this.model.isLeaf(node)) {
            cmp.setIcon(nodeImage);
        } else {
            cmp.setIcon(folder);
        }
        if (Display.getInstance().getDeviceType() == 3 && this.model.isLeaf(node)) {
            this.depthIndent = 35;
        }
        this.updateNodeComponentStyle(cmp.getSelectedStyle(), depth);
        this.updateNodeComponentStyle(cmp.getUnselectedStyle(), depth);
        this.updateNodeComponentStyle(cmp.getPressedStyle(), depth);
        return cmp;
    }

    private void updateNodeComponentStyle(Style s, int depth) {
        s.setMargin(1, depth * this.depthIndent);
    }

    protected String childToDisplayLabel(Object child) {
        return child.toString();
    }

    public void addLeafListener(ActionListener l) {
        this.leafListener.addListener(l);
    }

    public void removeLeafListener(ActionListener l) {
        this.leafListener.removeListener(l);
    }

    protected Dimension calcPreferredSize() {
        Dimension d = super.calcPreferredSize();
        int count = this.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            if (!(this.getComponentAt(iter) instanceof Container)) continue;
            return d;
        }
        int size = this.model.getChildren(null).size();
        if (size < 6) {
            return new Dimension(Math.max(d.getWidth(), Display.getInstance().getDisplayWidth() / 4 * 3), d.getHeight() / size * 6);
        }
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Handler
    implements ActionListener {
        private Object current;

        public Handler() {
        }

        public Handler(Object current) {
            this.current = current;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.current != null) {
                Tree.this.leafListener.fireActionEvent(new ActionEvent(this.current));
                return;
            }
            Component c = (Component)evt.getSource();
            Object e = c.getClientProperty(Tree.KEY_EXPANDED);
            if (e != null && e.equals("true")) {
                Tree.this.collapseNode(c);
            } else {
                Tree.this.expandNode(c);
            }
        }
    }

    static class StringArrayTreeModel
    implements TreeModel {
        String[][] arr;

        StringArrayTreeModel(String[][] arr) {
            this.arr = arr;
        }

        public Vector getChildren(Object parent) {
            if (parent == null) {
                Vector<String> v = new Vector<String>();
                for (int iter = 0; iter < this.arr[0].length; ++iter) {
                    v.addElement(this.arr[0][iter]);
                }
                return v;
            }
            Vector<String> v = new Vector<String>();
            for (int iter = 0; iter < this.arr[0].length; ++iter) {
                if (parent != this.arr[0][iter] || this.arr.length <= iter + 1 || this.arr[iter + 1] == null) continue;
                for (int i = 0; i < this.arr[iter + 1].length; ++i) {
                    v.addElement(this.arr[iter + 1][i]);
                }
            }
            return v;
        }

        public boolean isLeaf(Object node) {
            Vector v = this.getChildren(node);
            return v == null || v.size() == 0;
        }
    }
}

