/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    private boolean textElement;
    private String name;
    private Vector children;
    private Element parent;
    private Hashtable attributes;
    boolean isComment;

    protected Element() {
    }

    public Element(String tagName) {
        this.name = tagName;
    }

    public Element(String tagName, boolean isTextElement) {
        this(tagName);
        this.textElement = isTextElement;
    }

    public boolean isTextElement() {
        return this.textElement;
    }

    public String getTagName() {
        if (this.textElement) {
            throw new IllegalStateException("Text elements do not have a tag name");
        }
        return this.name;
    }

    protected Hashtable getAttributes() {
        return this.attributes;
    }

    protected void setAttribute(Object id, String value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(id, value);
    }

    public void addChild(Element childElement) {
        this.setChildParent(childElement);
        this.children.addElement(childElement);
    }

    protected void setParent(Element parent) {
        this.parent = parent;
    }

    public Element getParent() {
        return this.parent;
    }

    public int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    protected Vector getChildren() {
        return this.children;
    }

    protected void setChildren(Vector children) {
        this.children = children;
    }

    protected void setTagName(String name) {
        this.name = name;
    }

    protected void setTextElement(boolean textElement) {
        this.textElement = textElement;
    }

    public Element getChildAt(int index) {
        if (index < 0 || this.children == null || index >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Element)this.children.elementAt(index);
    }

    public Element getFirstChildByTagName(String name) {
        if (this.children == null) {
            return null;
        }
        int i = 0;
        Element found = null;
        while (found == null && i < this.children.size()) {
            Element child = (Element)this.children.elementAt(i);
            if (!child.textElement && child.getTagName().equalsIgnoreCase(name)) {
                found = child;
                continue;
            }
            ++i;
        }
        return found;
    }

    public Element getElementById(String id) {
        String thisId = this.getAttribute("id");
        if (thisId != null && thisId.equals(id)) {
            return this;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = (Element)this.children.elementAt(i);
                Element match = child.getElementById(id);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    private void getDescendantsByTagNameInternal(Vector v, String name, int depth) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = (Element)this.children.elementAt(i);
                if (depth > 0) {
                    child.getDescendantsByTagNameInternal(v, name, depth - 1);
                }
                if (child.textElement || !child.getTagName().equalsIgnoreCase(name)) continue;
                v.addElement(child);
            }
        }
    }

    public Vector getDescendantsByTagName(String name, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return null;
        }
        Vector v = new Vector();
        this.getDescendantsByTagNameInternal(v, name, depth);
        return v;
    }

    public Vector getDescendantsByTagName(String name) {
        return this.getDescendantsByTagName(name, Integer.MAX_VALUE);
    }

    public Vector getChildrenByTagName(String name) {
        return this.getDescendantsByTagName(name, 1);
    }

    private void getTextDescendantsInternal(Vector v, String text, boolean caseSensitive, int depth) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Element child = (Element)this.children.elementAt(i);
            if (depth > 0) {
                child.getTextDescendantsInternal(v, text, caseSensitive, depth - 1);
            }
            if (!child.textElement) continue;
            if (text != null) {
                int index;
                String childText = child.getText();
                if (!caseSensitive) {
                    childText = childText.toLowerCase();
                }
                if ((index = childText.indexOf(text)) == -1) continue;
                v.addElement(child);
                continue;
            }
            v.addElement(child);
        }
    }

    public Vector getTextDescendants(String text, boolean caseSensitive, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.children == null) {
            return null;
        }
        if (!caseSensitive && text != null) {
            text = text.toLowerCase();
        }
        Vector v = new Vector();
        this.getTextDescendantsInternal(v, text, caseSensitive, depth);
        return v;
    }

    public Vector getTextDescendants(String text, boolean caseSensitive) {
        return this.getTextDescendants(text, caseSensitive, Integer.MAX_VALUE);
    }

    public Vector getTextChildren(String text, boolean caseSensitive) {
        return this.getTextDescendants(text, caseSensitive, 1);
    }

    public boolean contains(Element element) {
        if (this == element) {
            return true;
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element child = (Element)this.children.elementAt(i);
                if (!child.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    public int setAttribute(String attribute, String value) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have attributes");
        }
        this.setAttribute((Object)attribute, value);
        return -1;
    }

    public void removeAttribute(String attribute) {
        this.removeAttribute((Object)attribute);
    }

    protected void removeAttribute(Object id) {
        if (this.attributes != null) {
            this.attributes.remove(id);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    private void setChildParent(Element child) {
        if (this.textElement) {
            throw new IllegalStateException("Text elements cannot have children");
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("An Element can't have two parents.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        child.setParent(this);
    }

    public void removeChildAt(int index) {
        if (index < 0 || this.children == null || index >= this.children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Element child = (Element)this.children.elementAt(index);
        child.setParent(null);
        this.children.removeElementAt(index);
    }

    public int getChildIndex(Element child) {
        int result = -1;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (child != this.children.elementAt(i)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public void insertChildAt(Element child, int index) {
        this.setChildParent(child);
        this.children.insertElementAt(child, index);
    }

    public void replaceChild(Element oldChild, Element newChild) {
        if (this.children != null) {
            this.setChildParent(newChild);
            int index = this.children.indexOf(oldChild);
            if (index != -1) {
                this.children.insertElementAt(newChild, index);
                this.removeChildAt(index + 1);
                return;
            }
        }
        throw new IllegalArgumentException("The oldChild element specified must be this element's child");
    }

    public String getText() {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can get text");
        }
        return this.name;
    }

    public void setText(String str) {
        if (!this.textElement) {
            throw new IllegalStateException("Only text elements can set text");
        }
        this.name = str;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String spacing) {
        String str = spacing;
        if (!this.textElement) {
            str = str + "<" + this.getTagName();
            if (this.attributes != null) {
                Enumeration e = this.attributes.keys();
                while (e.hasMoreElements()) {
                    String attrStr = (String)e.nextElement();
                    String val = (String)this.attributes.get(attrStr);
                    str = str + " " + attrStr + "='" + val + "'";
                }
            }
            str = str + ">\n";
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    str = str + ((Element)this.children.elementAt(i)).toString(spacing + ' ');
                }
            }
            str = str + spacing + "</" + this.getTagName() + ">\n";
        } else {
            str = str + "'" + this.name + "'\n";
        }
        return str;
    }
}

