/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Main.Main;
import Main.RMSUtil;
import gui.Editor;
import gui.LangWindows;
import gui.Panel;
import gui.TextWindows;
import javax.microedition.lcdui.Displayable;

public final class Interface
extends Panel {
    private int selectedIndex;
    private final int max;
    private TextWindows text_windows;
    protected LangWindows lang_windows;
    public int columns;
    public String translate_from;
    public String translate_to;

    public Interface() {
        super("GTranslateTool", Main.interface_panelicons);
        this.max = 2;
        this.setFullScreenMode(true);
        this.selectedIndex = 0;
        this.translate_from = RMSUtil.getRecord(1);
        this.translate_to = RMSUtil.getRecord(2);
        this.columns = Integer.parseInt(RMSUtil.getRecord(3));
        this.lang_windows = new LangWindows(this.sw, this.sh, this.panel_getHeight() + 2, this.translate_from, this.translate_to, this.gr);
        this.text_windows = new TextWindows(this.sw, this.sh, this.panel_getHeight() + 4 + this.lang_windows.getHeight(), "", "", this.gr, this.columns);
        if (!this.hasPointerEvents()) {
            this.panel_setActive(true);
        }
    }

    protected void showNotify() {
        this.clearScreen();
        this.panel_draw();
        this.lang_windows.draw();
        this.text_windows.draw();
    }

    public void setLang(String lang, char what) {
        if (what == 'f') {
            this.translate_from = lang;
            this.lang_windows.lw1.setText(lang);
            RMSUtil.setRecord(1, lang);
        } else if (what == 't') {
            this.translate_to = lang;
            this.lang_windows.lw2.setText(lang);
            RMSUtil.setRecord(2, lang);
        }
        Main.main.translate(this.text_windows.tw1.getText());
        this.showNotify();
    }

    public void setText(int window, String text) {
        switch (window) {
            case 1: {
                this.text_windows.tw1.setText(text);
                break;
            }
            case 2: {
                this.text_windows.tw2.setText(text);
            }
        }
        this.showNotify();
        this.flushGraphics();
    }

    private void swap() {
        String temp = this.translate_from;
        if (temp.equals("auto")) {
            temp = "\u0440\u0443\u0441\u0441\u043a\u0438\u0439";
        }
        this.translate_from = this.translate_to;
        this.translate_to = temp;
        this.lang_windows.lw1.setText(this.translate_from);
        this.lang_windows.lw2.setText(this.translate_to);
        if (this.columns == 2) {
            temp = this.text_windows.tw2.getText();
            temp = this.check_before_translate(temp);
            this.text_windows.tw1.setText(temp);
            if (temp.length() > 0) {
                Main.main.translate(temp);
            }
        }
        RMSUtil.setRecord(1, this.translate_from);
        RMSUtil.setRecord(2, this.translate_to);
        this.showNotify();
        this.flushGraphics();
    }

    private String check_before_translate(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            return text.substring(0, i);
        }
        return text;
    }

    private void reinit_text_windows() {
        String txt = this.text_windows.tw1.getText();
        this.text_windows = new TextWindows(this.sw, this.sh, this.panel_getHeight() + 4 + this.lang_windows.getHeight(), "", "", this.gr, this.columns);
        this.text_windows.tw1.setText(txt);
    }

    private void showFrom() {
        Main.reinit_fromList();
        Main.fromList.setCursor(this.translate_from);
        Main.main.setCurrent((Displayable)Main.fromList);
    }

    private void showTo() {
        Main.reinit_toList();
        Main.toList.setCursor(this.translate_to);
        Main.main.setCurrent((Displayable)Main.toList);
    }

    public final void keyPressed(int kc) {
        if (kc == 48) {
            if (this.columns == 1) {
                this.columns = 2;
            } else if (this.columns == 2) {
                this.columns = 1;
            }
            this.reinit_text_windows();
            RMSUtil.setRecord(3, Integer.toString(this.columns));
            this.showNotify();
            this.flushGraphics();
            return;
        }
        kc = this.getGameAction(kc);
        block0 : switch (kc) {
            case 2: {
                if (this.panel_getActive()) {
                    this.panel_moveleft();
                }
                if (!this.lang_windows.getActive() && !this.text_windows.getActive()) break;
                this.lang_windows.moveLeft();
                this.text_windows.moveLeft();
                break;
            }
            case 5: {
                if (this.panel_getActive()) {
                    this.panel_moveright();
                }
                if (!this.lang_windows.getActive() && !this.text_windows.getActive()) break;
                this.lang_windows.moveRight();
                this.text_windows.moveRight();
                break;
            }
            case 6: {
                ++this.selectedIndex;
                if (this.selectedIndex <= 2) break;
                this.selectedIndex = 2;
                break;
            }
            case 1: {
                --this.selectedIndex;
                if (this.selectedIndex >= 0) break;
                this.selectedIndex = 0;
                break;
            }
            case 8: {
                if (this.panel_getActive()) {
                    switch (this.panel_getPos()) {
                        case 0: {
                            Main.main.showMessage("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", "GTranslateTool - \u043a\u043b\u0438\u0435\u043d\u0442 Google Translate\nv " + Main.main.getAppProperty("MIDlet-Version") + "\n\u0414\u043b\u044f \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430 \u0434\u0432\u0443\u0445 \u043f\u0430\u043d\u0435\u043b\u0435\u0439 \u0432 \u0440\u0435\u0436\u0438\u043c \u043e\u0434\u043d\u043e\u0439 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e \u043d\u0430\u0436\u043c\u0438\u0442\u0435 0.\n \u041f\u043e\u0441\u043b\u0435 \u0432\u0432\u043e\u0434\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0438\u0442\u044c\u0441\u044f.\n\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0435 socket \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u0444\u0438\u043a\u0430.\n\u0417\u0430\u044e\u0437\u0430\u043d\u044b \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043b\u0438\u0431\u044b GUI 0.1 \u043e\u0442 G@sh!sh\nhttp://www.neo-soft.net.ru/\n\nDoctor Drive (2011)\nhttp://docd.zx6.ru");
                            break;
                        }
                        case 1: {
                            Main.main.destroyApp(true);
                        }
                    }
                    break;
                }
                if (this.lang_windows.getActive()) {
                    switch (this.lang_windows.getSelectedIndex()) {
                        case 0: {
                            this.showFrom();
                            break;
                        }
                        case 2: {
                            this.showTo();
                            break;
                        }
                        case 1: {
                            this.swap();
                        }
                    }
                    break;
                }
                if (!this.text_windows.getActive()) break;
                switch (this.text_windows.getSelectedIndex()) {
                    case 0: {
                        new Editor("\u0422\u0435\u043a\u0441\u0442:", this.text_windows.tw1.getText(), true);
                        break block0;
                    }
                    case 1: {
                        new Editor("\u041f\u0435\u0440\u0435\u0432\u043e\u0434:", this.text_windows.tw2.getText(), false);
                    }
                }
            }
        }
        switch (this.selectedIndex) {
            case 0: {
                if (!this.panel_getActive()) {
                    this.panel_setActive(true);
                }
                if (this.lang_windows.getActive()) {
                    this.lang_windows.setActive(false);
                }
                if (!this.text_windows.getActive()) break;
                this.text_windows.setActive(false);
                break;
            }
            case 1: {
                if (this.panel_getActive()) {
                    this.panel_setActive(false);
                }
                if (!this.lang_windows.getActive()) {
                    int ind = this.text_windows.getSelectedIndex();
                    if (ind == 1) {
                        ind = 2;
                    }
                    this.lang_windows.setCursor(ind);
                    this.lang_windows.setActive(true);
                }
                if (!this.text_windows.getActive()) break;
                this.text_windows.setActive(false);
                break;
            }
            case 2: {
                if (this.panel_getActive()) {
                    this.panel_setActive(false);
                }
                if (this.lang_windows.getActive()) {
                    this.lang_windows.setActive(false);
                }
                if (this.text_windows.getActive()) break;
                this.text_windows.setActive(true);
            }
        }
        this.showNotify();
        this.flushGraphics();
    }

    public void pointerPressed(int px, int py) {
        if (this.hasPointerEvents()) {
            if (this.panel_getActive()) {
                this.panel_setActive(false);
            }
            if (this.lang_windows.getActive()) {
                this.lang_windows.setActive(false);
            }
            if (this.text_windows.getActive()) {
                this.text_windows.setActive(false);
            }
            int panel_h = this.panel_getHeight();
            int langs_h = this.lang_windows.getHeight();
            if (py >= 0 && py <= panel_h) {
                int[] cells = this.panel_getCells();
                int action = -1;
                for (int i = 0; i < cells.length; ++i) {
                    if (px < cells[i] || px >= cells[i] + 18) continue;
                    action = i;
                    break;
                }
                if (action != -1) {
                    switch (action) {
                        case 0: {
                            Main.main.showMessage("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", "GTranslateTool - \u043a\u043b\u0438\u0435\u043d\u0442 Google Translate\nv " + Main.main.getAppProperty("MIDlet-Version") + "\n\u0414\u043b\u044f \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430 \u0434\u0432\u0443\u0445 \u043f\u0430\u043d\u0435\u043b\u0435\u0439 \u0432 \u0440\u0435\u0436\u0438\u043c \u043e\u0434\u043d\u043e\u0439 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e \u043d\u0430\u0436\u043c\u0438\u0442\u0435 0.\n \u041f\u043e\u0441\u043b\u0435 \u0432\u0432\u043e\u0434\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0438\u0442\u044c\u0441\u044f.\n\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0435 socket \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u0444\u0438\u043a\u0430.\n\u0417\u0430\u044e\u0437\u0430\u043d\u044b \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043b\u0438\u0431\u044b GUI 0.1 \u043e\u0442 G@sh!sh\nhttp://www.neo-soft.net.ru/\n\nDoctor Drive (2011)\nhttp://docd.zx6.ru");
                            break;
                        }
                        case 1: {
                            Main.main.destroyApp(true);
                        }
                    }
                }
            } else if (py > panel_h + 2 && py < panel_h + langs_h + 2) {
                int action = -1;
                int[] pos = this.lang_windows.getPositions();
                if (px > pos[0] && px < pos[1]) {
                    action = 0;
                } else if (px > pos[1] && px < pos[2]) {
                    action = 1;
                } else if (px > pos[2] && px < pos[3]) {
                    action = 2;
                }
                if (action != -1) {
                    switch (action) {
                        case 0: {
                            this.showFrom();
                            break;
                        }
                        case 2: {
                            this.showTo();
                            break;
                        }
                        case 1: {
                            this.swap();
                        }
                    }
                }
            } else if (py > panel_h + langs_h + 4 && py < this.sh - 2) {
                int action = -1;
                int[] pos = this.text_windows.getPositions();
                switch (pos.length) {
                    case 4: {
                        if (px > pos[0] && px < pos[1]) {
                            action = 0;
                            break;
                        }
                        if (px <= pos[2] || px >= pos[3]) break;
                        action = 1;
                        break;
                    }
                    case 2: {
                        if (px <= pos[0] || px >= pos[1]) break;
                        action = 0;
                    }
                }
                if (action != -1) {
                    switch (action) {
                        case 0: {
                            new Editor("\u0422\u0435\u043a\u0441\u0442:", this.text_windows.tw1.getText(), true);
                            break;
                        }
                        case 1: {
                            new Editor("\u041f\u0435\u0440\u0435\u0432\u043e\u0434:", this.text_windows.tw2.getText(), false);
                        }
                    }
                }
            }
            this.showNotify();
            this.flushGraphics();
        }
    }
}

