/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.DM;

import com.inodesoft.DM.GameCanvas;
import com.inodesoft.DM.GameEngine;
import com.inodesoft.utils.SSFunctions;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private static Player[] a = null;
    private static Player[] b = null;
    public static int currentMidi = -1;
    public static int currentWav = -1;
    public static int lastMidi = -1;
    public static int lastWav = -1;
    public static boolean haveVolume = false;

    public Sound() {
        System.out.println("*** Sound() ***");
        a = new Player[5];
        for (int i = 0; i < 5; ++i) {
            this.loadSound(i, 5);
        }
    }

    public static boolean playMidi(int n, int n2) {
        if (n == -1 || !GameEngine.configSound) {
            return false;
        }
        if (n >= 5) {
            return false;
        }
        try {
            if (currentMidi != n) {
                a[n].setLoopCount(n2);
            }
            if (currentMidi != -1 && a[currentMidi].getState() == 400) {
                if (currentMidi == n) {
                    return true;
                }
                Sound.stopMidi(currentMidi);
            }
            switch (a[n].getState()) {
                case 100: {
                    a[n].realize();
                }
                case 200: {
                    a[n].prefetch();
                }
            }
            a[n].start();
            if (currentMidi != -1) {
                lastMidi = currentMidi;
            }
            currentMidi = n;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.playMidi(): " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean stopMidi(int n) {
        if (n == -1) {
            return false;
        }
        if (n >= 5) {
            return false;
        }
        try {
            if (a[n].getState() != 400) {
                return false;
            }
            if (n != -1) {
                a[n].stop();
            }
            lastMidi = currentMidi;
            currentMidi = -1;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.stopMidi(): " + exception.toString());
            return false;
        }
        return true;
    }

    public static void stopAll() {
        if (a == null || b == null) {
            return;
        }
        try {
            int n;
            lastMidi = currentMidi;
            lastWav = currentWav;
            for (n = 0; n < a.length; ++n) {
                if (a[n].getState() != 400) continue;
                a[n].stop();
            }
            for (n = 0; n < b.length; ++n) {
                if (b[n].getState() != 400) continue;
                b[n].stop();
            }
            currentMidi = -1;
            currentWav = -1;
            return;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.stopAll(): " + exception.toString());
            return;
        }
    }

    public static boolean playAmr(int n, int n2) {
        if (n == -1 || !GameEngine.configSound) {
            return false;
        }
        if (n >= 4) {
            return false;
        }
        try {
            if (currentWav != n) {
                b[n].setLoopCount(n2);
            }
            if (currentWav != -1 && b[currentWav].getState() == 400) {
                if (currentWav == n) {
                    return true;
                }
                Sound.stopAmr(currentWav);
            }
            switch (b[n].getState()) {
                case 100: {
                    b[n].realize();
                }
                case 200: {
                    b[n].prefetch();
                }
            }
            Sound.setVolumeWav(n, GameEngine.soundVolume);
            b[n].start();
            if (currentWav != -1) {
                lastWav = currentWav;
            }
            currentWav = n;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.playAMR(" + n + "): " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean stopAmr(int n) {
        if (n == -1) {
            return false;
        }
        if (n >= 4) {
            return false;
        }
        try {
            if (b[n].getState() != 400) {
                return false;
            }
            if (n != -1) {
                b[n].stop();
            }
            lastWav = currentWav;
            currentWav = -1;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.stopWav(): " + exception.toString());
            return false;
        }
        return true;
    }

    public static void setVolumeMidi(int n, int n2) {
        try {
            VolumeControl volumeControl = (VolumeControl)a[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n2);
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.setVolumeMidi(): " + exception.toString());
            return;
        }
    }

    public static void setVolumeWav(int n, int n2) {
        try {
            VolumeControl volumeControl = (VolumeControl)b[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n2);
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.setVolumeWav(): " + exception.toString());
            return;
        }
    }

    public boolean loadSound(int n, int n2) {
        switch (n2) {
            case 5: {
                try {
                    System.out.println("   Load res" + n + ".mid");
                    switch (n) {
                        case 0: {
                            Sound.a[n] = Manager.createPlayer((InputStream)GameCanvas.resManager.getResourceAsStream("menu.mid"), (String)"audio/midi");
                            break;
                        }
                        case 1: {
                            Sound.a[n] = Manager.createPlayer((InputStream)GameCanvas.resManager.getResourceAsStream("options.mid"), (String)"audio/midi");
                            break;
                        }
                        case 2: {
                            Sound.a[n] = Manager.createPlayer((InputStream)GameCanvas.resManager.getResourceAsStream("win.mid"), (String)"audio/midi");
                            break;
                        }
                        case 3: {
                            Sound.a[n] = Manager.createPlayer((InputStream)GameCanvas.resManager.getResourceAsStream("lose.mid"), (String)"audio/midi");
                            break;
                        }
                        case 4: {
                            Sound.a[n] = Manager.createPlayer((InputStream)GameCanvas.resManager.getResourceAsStream("check.mid"), (String)"audio/midi");
                        }
                    }
                    if (a[n] == null) break;
                    a[n].realize();
                    a[n].prefetch();
                    VolumeControl volumeControl = (VolumeControl)a[n].getControl("VolumeControl");
                    if (volumeControl == null) break;
                    volumeControl.setLevel(50);
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Can't load res" + n + ".mid");
                    return false;
                }
                catch (MediaException mediaException) {
                    System.out.println("Media problem with res" + n + ".mid");
                    return false;
                }
            }
            case 6: {
                try {
                    System.out.println("   Load res" + n + ".wav");
                    switch (n) {
                        case 0: {
                            Sound.b[n] = Manager.createPlayer((InputStream)SSFunctions.getResourceAsStream("/crash.amr"), (String)"audio/amr");
                            break;
                        }
                        case 1: {
                            Sound.b[n] = Manager.createPlayer((InputStream)SSFunctions.getResourceAsStream("/start.amr"), (String)"audio/amr");
                            break;
                        }
                        case 2: {
                            Sound.b[n] = Manager.createPlayer((InputStream)SSFunctions.getResourceAsStream("/end.amr"), (String)"audio/amr");
                            break;
                        }
                        case 3: {
                            Sound.b[n] = Manager.createPlayer((InputStream)SSFunctions.getResourceAsStream("/check.amr"), (String)"audio/amr");
                        }
                    }
                    if (b[n] == null) break;
                    b[n].realize();
                    b[n].prefetch();
                    VolumeControl volumeControl = (VolumeControl)b[n].getControl("VolumeControl");
                    if (volumeControl == null) break;
                    volumeControl.setLevel(50);
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Can't load res" + n + ".wav");
                    return false;
                }
                catch (MediaException mediaException) {
                    System.out.println("Media problem with res" + n + ".wav");
                    return false;
                }
            }
        }
        return true;
    }

    public boolean unloadSound(int n, int n2) {
        switch (n2) {
            case 5: {
                try {
                    a[n].deallocate();
                    a[n].close();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: Sound.unloadSound(): " + exception.toString());
                    return false;
                }
            }
            case 6: {
                try {
                    b[n].deallocate();
                    b[n].close();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: Sound.unloadSound(): " + exception.toString());
                    return false;
                }
            }
        }
        return true;
    }
}

