/*
 * Decompiled with CFR 0.152.
 */
final class cEntity {
    int _type;
    boolean _alive;
    int _state;
    int _enemyIndex;
    short[] _carParams;
    int _nbPalettesAvailable;
    int _accelCoef;
    int _breakCoef;
    int[] _speedCoef;
    int[] _gearValues;
    boolean _isABike;
    int _accelMode;
    int _speed;
    int _speedToReach;
    private int _deltaSpeed;
    private int _deltaDepth;
    int _turnMax;
    int _deltaLat;
    int _latState;
    private int _oldLatState;
    private int _driftDirection;
    private boolean _driftStart;
    private boolean _driftEnd;
    int _segOn;
    private int _segOld;
    int _segXOn;
    private int _segXOld;
    int _segYOn;
    private int _segYOld;
    int _segZOn;
    private int _segZOnMax;
    int _lapOn;
    int _lapOld;
    int _drawX;
    int _drawY;
    private int _drawZoom;
    private int _inc;
    private int _incState;
    private int _zSpeed;
    private boolean _hitGround;
    private int _offRoadStatus;
    private int _offRoadSide;
    boolean _collisionOccured;
    int _collisionTime;
    boolean _collisionIsTakeDown;
    private boolean _duel_active;
    private int _stickyTimer;
    static byte[][] s_playerPointsData;
    private static int s_playerShakeY;
    private static int s_playerShakeTimer;
    static int s_playerBurnTimer;
    static int s_objectBreakTimer;
    private static int s_objectBreakSpriteId;
    private static int s_objectBreakAnimId;
    private static int s_objectBreakDx;
    private static int s_speedReduction;
    static int s_playerCarGear;
    private static int s_fxAnim;
    private static int s_fxTime;
    private static int s_fxTotalTime;
    private static boolean s_fxLoop;
    private static int s_fxPriority;
    static int s_driftAnim;
    private static int s_driftTimer;
    static int[][] s_enemiesAttributes;
    static ASprite s_playerCarSprite;
    static ASprite s_playerWheelsSprite;
    static ASprite s_copCarSprite;
    static ASprite s_startingAnimSprite;
    static ASprite s_carsFxSprite;
    static ASprite s_carsFxBoostSprite;
    static ASprite s_babeStartSprite;
    static ASprite s_copterSprite;
    private static int s_playerDeltaLatFromTurn;
    static int s_outlawInvertLaneTimer;
    static int s_outlawHighSpeedTimer;
    static int s_boostTimer;
    private static int[] s_smokeLifeTime;
    private static int[] s_smokeTotalLifeTime;
    private static int[] s_smokeX;
    private static int[] s_smokeY;
    private static int s_smokeTimer;
    private static int s_smokeNextIndex;

    cEntity(int type) {
        this._type = (byte)type;
        this._speedCoef = new int[4];
        this._isABike = false;
    }

    final void copyCarData(cEntity car) {
        int i;
        this.reInit(0, 0, 0, 0);
        this._isABike = car._isABike;
        this._breakCoef = car._breakCoef;
        this._accelCoef = car._accelCoef;
        for (i = 0; i < 4; ++i) {
            this._speedCoef[i] = car._speedCoef[i];
        }
        this._gearValues = new int[car._gearValues.length];
        for (i = 0; i < car._gearValues.length; ++i) {
            this._gearValues[i] = car._gearValues[i];
        }
        this._carParams = new short[12];
        for (i = 0; i < 12; ++i) {
            this._carParams[i] = car._carParams[i];
        }
        this._turnMax = car._turnMax;
        this._nbPalettesAvailable = car._nbPalettesAvailable;
    }

    final void updateBonus(int n) {
        if (!this._alive) {
            return;
        }
        if (this._collisionOccured) {
            this._segXOn = cGame.s_playerCar._segXOn;
            this._segYOn = cGame.s_playerCar._segYOn + (cGame.s_playerCar._carParams[9] >> 1);
            this._segOn = cGame.s_playerCar._segOn;
            this._lapOn = cGame.s_playerCar._lapOn;
            if (this._stickyTimer > 0) {
                this._stickyTimer -= n;
                if (this._stickyTimer < 0) {
                    this._stickyTimer = 0;
                }
                this._segXOn -= this._inc * this._stickyTimer / 1228;
                this.yMove(-(this._turnMax * this._stickyTimer) / 1228);
                return;
            }
            this._alive = false;
            this._collisionIsTakeDown = false;
            return;
        }
        this._segYOld = this._segYOn;
        this._segOld = this._segOn;
        this._segXOld = this._segXOn;
        this._lapOld = this._lapOn;
        this._deltaLat = 0;
        if (this.carDist(cGame.s_playerCar) < -1024) {
            this._alive = false;
        }
    }

    final boolean checkCollisionWithPlayer() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this._collisionOccured) {
            return false;
        }
        cEntity cEntity2 = cGame.s_playerCar;
        if (cGame.s_raceEnded) {
            return false;
        }
        if (Math.abs(this._segZOn - cEntity2._segZOn) > 100) {
            return false;
        }
        if (this._type == 4) {
            n5 = 150;
            n4 = 150;
            n3 = 200;
        } else {
            n5 = this._carParams[6 + this._latState];
            n4 = this._carParams[6 - this._latState];
            n3 = this._carParams[9];
        }
        short s = cEntity2._carParams[6 + cEntity2._latState];
        short s2 = cEntity2._carParams[6 - cEntity2._latState];
        int n6 = cEntity2._carParams[9];
        int n7 = this.carDist(cEntity2);
        cEntity cEntity3 = cEntity2;
        cEntity cEntity4 = this;
        int n8 = cEntity.GetDist(cEntity4._lapOld, cEntity4._segOld, cEntity4._segYOld, cEntity3._lapOld, cEntity3._segOld, cEntity3._segYOld);
        int n9 = n6;
        if (n8 > n7) {
            n2 = n7;
            n3 = n8 + n3;
        } else {
            n2 = n8;
            n3 = n7 + n3;
        }
        if (n9 < n2 || n3 < 0) {
            return false;
        }
        n3 = this._segXOn - n5;
        n2 = this._segXOn + n4;
        if (cEntity2._segXOn < cEntity2._segXOld) {
            n9 = cEntity2._segXOn - s;
            n = cEntity2._segXOld + s2;
        } else {
            n9 = cEntity2._segXOld - s;
            n = cEntity2._segXOn + s2;
        }
        if (n < n3 || n2 < n9) {
            return false;
        }
        if (this._type == 6) {
            return true;
        }
        if (this._type == 4) {
            this._collisionOccured = true;
            switch (this._incState) {
                case 2: {
                    cGame.s_raceCash += cGame.s_moneyValues[11];
                    cGame.s_raceStat[13] = cGame.s_raceStat[13] + cGame.s_moneyValues[11];
                    cGame.s_interfaceIgFlags |= 0x40;
                    cGame.Outlaw_launchCashAnim(11, cGame.s_copter._alive);
                    break;
                }
                case 1: {
                    if (cGame.s_boostValue >= 4096) break;
                    if ((cGame.s_boostValue += 1024 * cGame.s_boostTuningCoef >> 12) > 4096) {
                        cGame.s_boostValue = 4096;
                    }
                    cGame.s_interfaceIgFlags |= 0x80000;
                    break;
                }
                case 0: {
                    if (cGame.s_outLawValue <= 0) break;
                    cGame.s_outLawValue = 0;
                    cGame.s_interfaceIgFlags |= 2;
                    break;
                }
                case 3: {
                    cGame.s_raceCash += cGame.s_moneyValues[8];
                    cGame.s_raceStat[13] = cGame.s_raceStat[13] + cGame.s_moneyValues[8];
                    cGame.s_interfaceIgFlags |= 0x40;
                    cGame.Outlaw_launchCashAnim(8, cGame.s_copter._alive);
                }
            }
            this._stickyTimer = 1228;
            this._inc = cEntity2._segXOn - this._segXOn;
            this._turnMax = -this.carDist(cEntity2);
            return true;
        }
        if (this._speedToReach < 0) {
            cEntity2.setCollision(0);
            return true;
        }
        n3 = this._segXOn - this._segXOld;
        n2 = this._deltaDepth;
        n9 = cEntity2._segXOn - cEntity2._segXOld;
        n = cEntity2._deltaDepth;
        n3 -= n9;
        n2 -= n;
        if (this._type == 3) {
            n2 = 0;
            if ((n3 = Math.abs(n3)) == 0) {
                n3 = 1;
            }
            if (this._segXOld > cEntity2._segXOld) {
                n3 = -n3;
            }
        }
        if ((n9 = n3 * n3 + n2 * n2) == 0) {
            n2 = 1;
            n9 = 1;
        }
        n = (n3 * n3 << 12) / n9;
        n9 = (n2 * n2 << 12) / n9;
        n = Math.abs(this._deltaLat - (cEntity2._deltaLat + s_playerDeltaLatFromTurn)) * n >> 12;
        if ((n = n << 11 >> 12) < 500) {
            n = 500;
        }
        if (n3 < 0) {
            n = -n;
        }
        n3 = Math.abs(this._speed - cEntity2._speed) * n9 >> 12;
        n3 = n3 << 12 >> 12;
        if (n2 != 0 && n3 < 11377) {
            n3 = 11377;
        }
        if (n2 < 0) {
            n3 = -n3;
        }
        if (n3 < -79644) {
            n3 = -79644;
        }
        this._deltaLat -= n;
        cEntity2._deltaLat += n;
        this._speed -= n3;
        cEntity2._speed += n3;
        if (n3 < 0 && cEntity2._speed > this._speed) {
            this._speed = cEntity2._speed + 22755;
        }
        n3 = 0;
        if (n9 > 1024) {
            if (this._segXOn + n4 > cEntity2._segXOn - s && this._segXOn - n5 < cEntity2._segXOn + s2) {
                if (n8 > 0 && n7 < n6) {
                    this.yMove(n6 - n7);
                } else if (n8 < 0 && n7 > 0) {
                    this.yMove(-n7);
                }
            }
        } else if (n7 >= 0 && n7 <= n6) {
            this._segXOn = this._segXOld < cEntity2._segXOld ? cEntity2._segXOn - s - n4 : cEntity2._segXOn + s2 + n5;
            n3 = 1;
        }
        if (cEntity2._accelMode == 2) {
            this.reduceLife(6);
        } else if (cEntity2._accelMode == 3) {
            this.reduceLife(9);
        } else {
            this.reduceLife(3);
        }
        n5 = this.getLife();
        if (this._segXOn < cEntity2._segXOn) {
            if (n5 <= 0) {
                this.setCollision(0);
            } else if (n3 != 0) {
                this.setCollision(2);
            } else {
                this.setCollision(3);
            }
            cEntity2.setCollision(1);
        } else {
            if (n5 <= 0) {
                this.setCollision(0);
            } else if (n3 != 0) {
                this.setCollision(1);
            } else {
                this.setCollision(3);
            }
            cEntity2.setCollision(2);
        }
        return true;
    }

    final void checkCollisionWithTunnelsAndOffroads() throws Exception {
        int n;
        int n2;
        if (cGame.s_raceEnded) {
            return;
        }
        if (this._collisionIsTakeDown) {
            return;
        }
        short s = this._carParams[6 + this._latState];
        short s2 = this._carParams[6 - this._latState];
        int n3 = this._segXOn - s;
        int n4 = this._segXOn + s2;
        int n5 = this._segOld;
        block0: while (n5 != this._segOn) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            n2 = cGame.s_offRoadItem[n5 = (n5 + 1) % cGame.s_trackNbSegment];
            n = n2 & 0xF000;
            if (n == 28672 && this._segZOn == 0) {
                n10 = n2 & 0xFFF;
                this._zSpeed = this._speed < 227555 ? n10 * this._speed / 227555 << 12 : n10 << 12;
                this._segZOn = 1;
            }
            if (this._type != 0) continue;
            if ((cGame.s_offRoadType[n5] & 0xFF) == 208 && this._offRoadStatus != 0) {
                this.setCollision(0);
            }
            if (n == 12288) {
                n10 = n2 & 0x7FF;
                short[] sArray = cGame.s_f3dObjectsCollision[n10];
                if (sArray == null) {
                    return;
                }
                n2 &= 0x800;
                n10 = sArray.length;
                for (int i = 0; i < n10; i += 2) {
                    n9 = sArray[i];
                    n8 = sArray[i + 1];
                    if (n2 != 0) {
                        n7 = n9;
                        n9 = -n8;
                        n8 = -n7;
                    }
                    n7 = n8 - n3;
                    n6 = n4 - n9;
                    if (n7 <= 0 || n6 <= 0) continue;
                    if (n7 < 100) {
                        this._segXOld = this._segXOn = n8 + s;
                        this.setCollision(1);
                        continue;
                    }
                    if (n6 < 100) {
                        this._segXOld = this._segXOn = n9 - s2;
                        this.setCollision(2);
                        continue;
                    }
                    this.yMove(-this._segYOn + (this._segOn - n5 << 10));
                    this.setCollision(0);
                }
                continue;
            }
            if (n == 4096) {
                n10 = n2 & 0x7FF;
                n = cGame.s_offRoadItemPos[n10];
                n2 = cGame.s_offRoadItemNum[n10] & 0xFF;
                if ((n10 = cGame.s_offRoadItemDefCollWidth[n2]) == 0) {
                    return;
                }
                n9 = n - (n10 >> 1);
                n8 = n + (n10 >> 1);
                n7 = n8 - n3;
                n6 = n4 - n9;
                if (n7 <= 0 || n6 <= 0) continue;
                if (cGame.s_offRoadItemDefBreak[n2] == null) {
                    if (n7 < 100) {
                        this._segXOld = this._segXOn = n8 + s;
                        this.setCollision(1);
                        continue;
                    }
                    if (n6 < 100) {
                        this._segXOld = this._segXOn = n9 - s2;
                        this.setCollision(2);
                        continue;
                    }
                    this.yMove(-this._segYOn + (this._segOn - n5 << 10));
                    this.setCollision(0);
                    continue;
                }
                if (cGame.s_gameMode == 3) {
                    cGame.s_playerCar._speed >>= 1;
                    ++cGame.s_punishTime;
                }
                s_objectBreakSpriteId = cGame.s_offRoadItemDefBreak[n2][0];
                s_objectBreakAnimId = cGame.s_offRoadItemDefBreak[n2][1];
                s_objectBreakTimer = 1638;
                s_objectBreakDx = (n - this._segXOn) * cGame.s_camFocale / 840;
                cGame.OutLaw_increase(6);
                cGame.VibrateAndShake_start(1638, 0, 1, 2);
                continue;
            }
            if (n == 16384) {
                n10 = n2 & 0x7FF;
                n = cGame.s_offRoadItemPos[n10];
                n2 = cGame.s_offRoadItemNum[n10] & 0xFF;
                if (this._lapOn >= cGame.s_maxLap && n5 + 20 >= cGame.s_trackNbSegment) continue;
                for (n9 = 0; n9 < 2; ++n9) {
                    cEntity cEntity2 = cGame.s_bonusElements[n9];
                    if (cEntity2._alive) continue;
                    cEntity2._alive = true;
                    cEntity2._collisionOccured = false;
                    cEntity2._segOn = n5 + 20;
                    cEntity2._lapOn = this._lapOn;
                    if (cEntity2._segOn >= cGame.s_trackNbSegment) {
                        cEntity2._segOn -= cGame.s_trackNbSegment;
                    }
                    cEntity2._segYOn = 0;
                    cEntity2._segXOn = n;
                    cEntity2._segZOn = cGame.s_offRoadItemDefPosHeight[n2];
                    cEntity2._segOld = cEntity2._segOn;
                    cEntity2._segYOld = cEntity2._segYOn;
                    cEntity2._segXOld = cEntity2._segXOn;
                    cEntity2._lapOld = ++cEntity2._lapOn;
                    cEntity2._latState = n2 + 10;
                    cEntity2._incState = cGame.s_offRoadItemDefInfo[n2][1];
                    cEntity2._turnMax = n5;
                    continue block0;
                }
                continue;
            }
            if (n == 32768) {
                if (this._segZOn != 0) continue;
                this.setCollision(4);
                continue;
            }
            if (n == 20480) {
                if (this._lapOn != 2 || cGame.s_gameMode == 5 || cGame.s_gameMode == 4) continue;
                cGame.OutLaw_increase(5);
                continue;
            }
            if (n == 24576) {
                if (this._lapOn > cGame.s_maxLap) continue;
                n10 = n2 & 0xFFF;
                cGame.OnScreenBuffer_set(n10);
                continue;
            }
            if (n != 36864 || cGame.s_gameMode == 2 || cGame.s_gameMode == 3) continue;
            n10 = n2 & 0xFFF;
            if (n10 == 4095) {
                cGame.s_trackTouristGenerationEnabled = false;
            } else {
                cGame.s_trackTouristGenerationEnabled = true;
                cGame.s_trackTouristGenerationTimer = n10 * 1000;
            }
            if (cGame.s_gameMode == 5) {
                if (cGame.s_enemyCar._alive) continue;
                cGame.s_touristGenerationEnabled = cGame.s_trackTouristGenerationEnabled;
                continue;
            }
            if (cGame.s_copCar._alive) continue;
            cGame.s_touristGenerationEnabled = cGame.s_trackTouristGenerationEnabled;
        }
        if (!this._collisionIsTakeDown && this._offRoadStatus != 0) {
            int n11 = cGame.s_trackTabFlags[this._segOn] & 3;
            n = n11 == 3 || n11 == 1 ? 1 : 0;
            int n12 = n2 = n11 == 3 || n11 == 2 ? 1 : 0;
            if (this._type == 0) {
                if (this._offRoadSide == 1 && n != 0) {
                    this._segXOn = this.getOffRoadLimitLeft() + s;
                    this.setCollision(1);
                }
                if (this._offRoadSide == 2 && n2 != 0) {
                    this._segXOn = this.getOffRoadLimitRight() - s2;
                    this.setCollision(2);
                    return;
                }
            } else if (this._collisionOccured && (this._offRoadStatus == 1 && this._offRoadSide == 1 && n != 0 || this._offRoadStatus == 1 && this._offRoadSide == 2 && n2 != 0 || this._offRoadStatus == 2)) {
                this.reduceLife(this.getLife());
                this.setCollision(0);
            }
        }
    }

    private void setCollision(int colType) {
        this._collisionOccured = true;
        this._collisionIsTakeDown = false;
        if (this._type == 0) {
            this.resetDrift();
        }
        if (colType == 1) {
            if (this._type == 0) {
                if (this._deltaLat + s_playerDeltaLatFromTurn < 50) {
                    this._deltaLat = 50 - s_playerDeltaLatFromTurn;
                }
                cEntity.FxAnim_launch(4, 819, false, 10);
                cGame.VibrateAndShake_start(1638, 1, 0, 2);
            } else {
                this._latState = -1;
            }
            this._collisionTime = 1638;
        } else if (colType == 2) {
            if (this._type == 0) {
                if (this._deltaLat + s_playerDeltaLatFromTurn > -50) {
                    this._deltaLat = -50 - s_playerDeltaLatFromTurn;
                }
                cEntity.FxAnim_launch(5, 819, false, 10);
                cGame.VibrateAndShake_start(1638, 1, 0, 2);
            } else {
                this._latState = 1;
            }
            this._collisionTime = 1638;
        } else if (colType == 0) {
            this._collisionIsTakeDown = true;
            this._collisionTime = 12288;
            this._deltaLat = (-(this._segXOn << 1) << 12) / this._collisionTime;
            if (this._segZOn == 0) {
                this._zSpeed = Util.Math_rand(600, 1000) << 12;
                this._segZOn = 1;
            }
            if (this._type == 0) {
                this._accelMode = 1;
                cGame.s_camEffectTimer = 6144;
                s_boostTimer = 0;
                cGame.VibrateAndShake_start(1638, 0, 1, 4);
            } else {
                cGame.Outlaw_launchSlowMotion();
                cGame.VibrateAndShake_start(2457, Util.Math_rand(-1, 2), Util.Math_rand(-1, 2), 4);
            }
        } else if (colType == 4) {
            this._collisionIsTakeDown = true;
            this._collisionTime = 12288;
        } else {
            this._collisionTime = 1638;
        }
        if (this._type != 0) {
            cGame.OutLaw_collide(this, colType);
        }
    }

    static void AddCopCar() throws Exception {
        if (cGame.s_busted || cGame.s_playerCar._collisionIsTakeDown) {
            return;
        }
        cEntity cop = cGame.s_copCar;
        cEntity player = cGame.s_playerCar;
        if (!cop._alive) {
            cop.reInit(player._lapOn, player._segOn, player._segYOn, -1500);
            cop._alive = true;
            cop._segXOn = 0;
            cop._enemyIndex = 7;
            cop._speed = player._speed;
            cop._speedToReach = player._speed;
            cEntity.s_enemiesAttributes[7][1] = 50 * cGame.s_trackDifficultyFactor >> 7;
            cEntity.s_enemiesAttributes[7][0] = s_enemiesAttributes[7][1];
            cop._state = 2;
            cGame.s_copLifetime = 0;
            if (cGame.s_gameMode != 5) {
                cGame.s_touristGenerationEnabled = false;
            }
        }
    }

    static void RemoveCopCar() {
        cGame.s_copCar._alive = false;
        if (cGame.s_gameMode != 5) {
            cGame.s_touristGenerationEnabled = cGame.s_trackTouristGenerationEnabled;
        }
    }

    final void updateCopCar(int n) throws Exception {
        if (!this._alive) {
            return;
        }
        if (cGame.s_raceEnded) {
            this._speed = this._speedToReach = cGame.s_playerCar._speed;
            this._deltaLat = 0;
            this._latState = 0;
            this.update(n, 0, false);
            return;
        }
        if (this._collisionIsTakeDown) {
            this.update(n, 0, false);
            return;
        }
        cGame.s_copLifetime += n;
        cEntity cEntity2 = cGame.s_playerCar;
        cEntity cEntity3 = cGame.s_enemyCar;
        int n2 = 0;
        n2 = 0;
        int n3 = 0;
        n2 = cEntity2._speedCoef[2];
        int n4 = cEntity2._segXOn;
        int n5 = cEntity2._speed;
        int n6 = n2;
        n3 = 0;
        if (cEntity3._alive && !cEntity3._collisionIsTakeDown && Math.abs(cEntity3.carDist(cEntity2)) < 2000) {
            n3 = 1;
        }
        int n7 = cEntity2._collisionIsTakeDown;
        n2 = cEntity2._offRoadStatus == 2 ? 1 : 0;
        boolean bl = cEntity2._speed <= 79644;
        int n8 = Math.abs(this._segXOn - cEntity2._segXOn);
        int n9 = this.carDist(cEntity2);
        n9 = Math.abs(n9);
        if (n7 != 0) {
            this._speed = this._speedToReach = cEntity2._speed;
            n2 = this._segXOn < n4 ? n4 - 500 : n4 + 500;
            n2 = this.computeTurnMaxToGoToX(n2);
            this.update(n, n2, false);
            n9 = this.carDist(cEntity2);
            this.setRelativeYPos(cEntity2, n9 + (Math.min(Math.max(n << 1, 0), 4096) * (0 - n9) >> 12));
            return;
        }
        if ((n8 <= 500 || n2 != 0) && n9 <= 150 && bl) {
            cGame.Outlaw_setBusted();
            return;
        }
        switch (this._state) {
            case 1: {
                if (this._stickyTimer >= 0) {
                    this._stickyTimer -= n;
                    n2 = this._segXOn > n4 ? n4 + 500 : n4 - 500;
                } else {
                    n2 = n4;
                }
                n2 = this.computeTurnMaxToGoToX(n2);
                if (!this._collisionOccured) {
                    if (n5 <= n6) {
                        this._speedToReach = this._speed = n5;
                        this.update(n, n2, false);
                        this._segOn = cEntity2._segOn;
                        this._segYOn = cEntity2._segYOn;
                        this._deltaDepth = cEntity2._deltaDepth;
                    } else {
                        this._speedToReach = this._speed = n6;
                        this.update(n, n2, false);
                    }
                } else {
                    this._stickyTimer = 2048;
                    this.update(n, n2, false);
                }
                if (n3 == 0 && this.carDist(cEntity2) >= 0) break;
                this._state = 2;
                return;
            }
            case 2: {
                n3 = n3 != 0 || Math.abs(this._segXOn - n4) < 300 ? -220 : 10;
                n7 = cEntity.GetDist(this._lapOn, this._segOn, this._segYOn, cEntity2._lapOld, cEntity2._segOld, cEntity2._segYOld);
                if (!this._collisionOccured) {
                    this._speed = n5;
                    this._speed = n7 > -220 ? (this._speed += 22755 * (n3 - n7) / 220) : (this._speed += 22755);
                    if (this._speed > n6) {
                        this._speed = n6;
                    }
                    this._speedToReach = this._speed;
                }
                n2 = this.computeTurnMaxToGoToX(n4 + (n4 < 0 ? 400 : -400));
                this.update(n, n2, false);
                n7 = this.carDist(cEntity2);
                if (n7 < 0 || n3 < 0 || Math.abs(this._segXOn - n4) < 200) break;
                this.yMove(-n7);
                this._stickyTimer = 2048;
                this._state = 1;
            }
        }
    }

    static void AddCopter() throws Exception {
        cEntity copter = cGame.s_copter;
        if (!copter._alive) {
            copter._alive = true;
            copter._state = 1;
            copter._segXOn = -20;
            copter._segYOn = -20;
            copter._segXOld = copter._segXOn;
            copter._segYOld = copter._segYOn;
            copter._segZOn = 0;
            copter._stickyTimer = 4096;
            copter._collisionIsTakeDown = true;
            copter._enemyIndex = 0;
        }
    }

    static void RemoveCopter() {
        cGame.s_copter._alive = false;
        cGame.s_interfaceIgFlags |= 0x400;
    }

    final void updateCopter(int n) throws Exception {
        int n2;
        int n3;
        if (!this._alive) {
            return;
        }
        if (cGame.s_busted) {
            return;
        }
        if (cGame.s_raceEnded) {
            if (this._state != 2) {
                this._state = 2;
                this._segXOld = this._segXOn;
                this._segYOld = this._segYOn;
                this._stickyTimer = 4096;
                this._inc = 0;
                cGame.s_interfaceIgFlags |= 0x400;
            }
        } else if ((cGame.s_game_totalExecutionTime & 0x800L) == 0L) {
            if (this._segZOn == 0) {
                cGame.s_interfaceIgFlags |= 0x200;
                this._segZOn = 1;
            }
        } else if (this._segZOn == 1) {
            cGame.s_interfaceIgFlags |= 0x400;
            this._segZOn = 0;
        }
        boolean bl = false;
        for (n3 = 0; n3 < 7; ++n3) {
            n2 = (cGame.s_playerCar._segOn + n3) % cGame.s_trackNbSegment;
            if (((n2 = cGame.s_offRoadType[n2]) & 0xC0) != 192) continue;
            bl = true;
            break;
        }
        if (this._stickyTimer > 0) {
            this._stickyTimer -= n;
            if (this._stickyTimer < 0) {
                this._stickyTimer = 0;
            }
        }
        n3 = cGame.s_roadX1[2] + (cGame.s_roadL1[2] >> 1);
        n2 = cGame.s_roadX1[3] + (cGame.s_roadL1[3] >> 1);
        n3 += (n2 - n3) * cGame.s_camPosOn >> 10;
        switch (this._state) {
            case 1: {
                this._segXOn = n3 + (this._segXOld - n3) * this._stickyTimer / 4096;
                this._segYOn = 62 + (this._segYOld - 62) * this._stickyTimer / 4096;
                if (this._stickyTimer != 0) break;
                this._segOn = 0;
                this._inc = 1;
                this._state = 0;
                break;
            }
            case 2: {
                this._segXOn = -20 + (this._segXOld - -20) * this._stickyTimer / 4096;
                this._segYOn = -20 + (this._segYOld - -20) * this._stickyTimer / 4096;
                if (this._stickyTimer > 0) break;
                cEntity.RemoveCopter();
                break;
            }
            case 3: {
                this._segXOn = -20 + (this._segXOld - -20) * this._stickyTimer / 4096;
                this._segYOn = -20 + (this._segYOld - -20) * this._stickyTimer / 4096;
                if (bl) break;
                this._segXOld = this._segXOn;
                this._segYOld = this._segYOn;
                this._stickyTimer = 4096;
                this._state = 1;
                break;
            }
            case 0: {
                if (bl) {
                    this._state = 3;
                    this._segXOld = this._segXOn;
                    this._segYOld = this._segYOn;
                    this._stickyTimer = 4096;
                    this._inc = 0;
                    break;
                }
                this._segOn += n >> 2;
                this._segOn &= 0x3FFF;
                this._segXOn = n3 + (10 * (Util.s_math_cosTable[512 - (this._segOn >> 2) & 0x7FF] * Util.s_math_cosTable[this._segOn >> 1 & 0x7FF] >> 12) >> 12);
                this._segYOn = 62 + (10 * Util.s_math_cosTable[512 - (this._segOn >> 1) & 0x7FF] >> 12);
            }
        }
        this._enemyIndex -= n;
        this._collisionIsTakeDown = false;
        if (this._enemyIndex <= 0) {
            this._collisionIsTakeDown = true;
            this._enemyIndex = Util.Math_rand(4096, 32768);
        }
    }

    final void drawCopter() {
        s_copterSprite.paintAFrame(cGame.s_g, 0, cGame.s_gameFrameCpt & 1, this._segXOn, this._segYOn, 0);
        if (this._collisionIsTakeDown) {
            s_copterSprite.paintFrame(cGame.s_g, 2, this._segXOn, this._segYOn, 0);
        }
    }

    final boolean compute2dProjection(int n) {
        int n2 = (cGame.s_worldVecY[n] * this._segYOn >> 12) + cGame.s_worldPosY[n];
        if (n2 <= 0) {
            return false;
        }
        int n3 = (cGame.s_worldVecX[n] * this._segYOn >> 12) + this._segXOn + cGame.s_worldPosX[n];
        n = (cGame.s_worldVecZ[n] * this._segYOn >> 12) + cGame.s_worldPosZ[n];
        n3 = 320 + n3 * cGame.s_camFocale / n2;
        int n4 = cGame.s_viewProjCenter - n * cGame.s_camFocale / n2;
        if (this._segZOn == 0) {
            n = n4;
        } else {
            n += this._segZOn;
            n = cGame.s_viewProjCenter - n * cGame.s_camFocale / n2;
        }
        n2 = 3440640 / n2;
        this._drawX = n3;
        this._drawY = n;
        this._drawZoom = n2;
        return true;
    }

    final void draw() throws Exception {
        switch (this._type) {
            case 0: {
                int n;
                int n2 = this._drawY;
                int n3 = this._drawX;
                if (cGame.s_busted && cGame.s_menuData[4] != 1) {
                    cGame.s_spriteLib[21].paintFrame(cGame.s_g, this._segXOn < 0 ? 2 : 1, n3, n2, 0);
                }
                if (s_objectBreakTimer > 0) {
                    cEntity.DrawAnimUsingDt$7a999b6a(cGame.s_spriteLib[s_objectBreakSpriteId], s_objectBreakAnimId, n3 + s_objectBreakDx, n2, 1638 - s_objectBreakTimer, 1638);
                }
                n2 += s_playerShakeY;
                if (this._collisionIsTakeDown) {
                    this.drawCarTakedown(n3, n2);
                } else {
                    if (this._segZOn == 0 && (s_playerBurnTimer > 0 || s_driftAnim >= 0)) {
                        this.drawPlayerEffectsOnPoint(16, 0);
                    }
                    if (s_driftAnim >= 0) {
                        n = n3 - 15 * this._deltaLat / this._turnMax;
                        cEntity.DrawAnimUsingDt$7a999b6a(s_carsFxSprite, s_driftAnim, n, n2, s_driftTimer & 0x3FF, 1024);
                    }
                    if (this._isABike) {
                        this._incState = 0;
                        n = 2;
                        if (this._accelMode == 0) {
                            n = 2;
                        } else if (this._segZOn != 0) {
                            this._incState = 1;
                            n = 6;
                        } else if (this._latState != 0) {
                            n = 2 + this._latState;
                        } else if (20480 - s_boostTimer < 4096) {
                            this._incState = 1;
                            n = 6;
                        }
                        int n4 = this._speed > 0 ? cGame.s_gameFrameCpt & 1 : 0;
                        s_playerCarSprite.paintAFrame(cGame.s_g, n, n4, n3, n2, 0);
                    } else {
                        int n5;
                        if (this._latState == 0) {
                            n5 = this._accelMode == 0 ? 5 : 2;
                            n = 0;
                        } else {
                            n5 = 2 + this._latState;
                            n = 0;
                        }
                        this.drawPlayerCar(n3, n2, n5, -1);
                        if (this._latState == 0 && this._accelMode > 0) {
                            int n6;
                            if (this._segOn != this._segOld && (n6 = (cGame.s_offRoadType[this._segOn] & 0xC0) == 192 ? this._segOn & 3 : this._segOn & 7) == 0) {
                                this._enemyIndex = 0;
                            }
                            if (this._enemyIndex < 2) {
                                s_playerCarSprite.paintAFrame(cGame.s_g, 8, this._enemyIndex, n3, n2, 0);
                                ++this._enemyIndex;
                            }
                        }
                    }
                    n = 0;
                    if (cGame.s_gameMode == 4) {
                        n = 32;
                    }
                    if (this._accelMode > 1 && this._segZOn == 0) {
                        n |= 1;
                    }
                    this.drawPlayerEffectsOnPoint(n, s_playerShakeY);
                }
                if (this._segZOn != 0 || this._accelMode <= 1) {
                    n = n2;
                    int n7 = n3 - this._latState * 17;
                    if (s_fxAnim >= 0) {
                        cEntity.DrawAnimUsingDt$7a999b6a(s_carsFxSprite, s_fxAnim, n7, n, s_fxTime, s_fxTotalTime);
                    }
                }
                if (!cGame.s_isFlashed && !cGame.s_busted) {
                    cGame.Outlaw_drawAndUpdateCashAnim(n3, n2 - 30);
                }
                return;
            }
            case 1: {
                int n = this._drawZoom;
                int n8 = this._drawY;
                int n9 = this._drawX;
                int n10 = 0;
                int n11 = 0;
                if (this._collisionIsTakeDown) {
                    this.drawCarTakedown(n9, n8);
                    if (this._collisionTime > 11469) {
                        cEntity.DrawAnimUsingDt$7a999b6a(s_carsFxSprite, 19, n9, n8, 12288 - this._collisionTime, 819);
                        return;
                    }
                } else {
                    n10 = this._latState == 0 ? 0 : 1;
                    n11 = this._latState < 0 ? 0 : 1;
                    cGame.DrawZoomedSprite(n10, n, n9, n8, n11);
                    if (!cGame.s_raceEnded && this._enemyIndex >= 0) {
                        this.drawPositionAndArrow(n9, n8, n);
                    }
                }
                return;
            }
            case 3: {
                int n = this._drawZoom;
                int n12 = this._drawY;
                int n13 = this._drawX;
                if (this._collisionIsTakeDown) {
                    this.drawCarTakedown(n13, n12);
                    return;
                }
                s_copCarSprite.paintAFrame(cGame.s_g, 2 + (this._latState << 1), 0, n13, n12, 0);
                if (!cGame.s_raceEnded) {
                    this.drawPositionAndArrow(n13, n12, n);
                }
                return;
            }
            case 4: {
                int n = this._drawY;
                int n14 = this._drawX;
                cGame.DrawZoomedSprite(this._latState, 4096, n14, n, 0);
                return;
            }
            case 2: {
                int n = this._drawZoom;
                int n15 = this._drawY;
                int n16 = this._drawX;
                if (this._speedToReach < 0) {
                    cGame.DrawZoomedSprite(3, n, n16, n15, 0);
                    return;
                }
                cGame.DrawZoomedSprite(2, n, n16, n15, 0);
                return;
            }
            case 6: {
                int n = this._drawZoom;
                int n17 = this._drawY;
                int n18 = this._drawX;
                if (this._state == 0) {
                    cGame.DrawZoomedSprite(4, n, n18, n17, 0);
                    int n19 = n;
                    int n20 = 36;
                    n20 = 8;
                    n20 = 37;
                    n20 = 4;
                    n20 = 38;
                    n20 = -1;
                    n20 = 38;
                    n = -3;
                    n20 = n17;
                    int n21 = n18;
                    int n22 = n19;
                    n18 = n22 * -3 >> 12;
                    n17 = n22 * 38 >> 12;
                    s_carsFxSprite.paintAFrame(cGame.s_g, 9, cGame.s_gameFrameCpt % 3, n21 - n18, n20 - n17, 0);
                    n18 = n22 * -1 >> 12;
                    n17 = n22 * 38 >> 12;
                    s_carsFxSprite.paintAFrame(cGame.s_g, 10, cGame.s_gameFrameCpt % 4, n21 - n18, n20 - n17, 0);
                    n18 = n22 * 4 >> 12;
                    n17 = n22 * 37 >> 12;
                    s_carsFxSprite.paintAFrame(cGame.s_g, 10, (cGame.s_gameFrameCpt + 2) % 4, n21 - n18, n20 - n17, 0);
                    n18 = n22 * 8 >> 12;
                    n17 = n22 * 36 >> 12;
                    s_carsFxSprite.paintAFrame(cGame.s_g, 9, (cGame.s_gameFrameCpt + 1) % 3, n21 - n18, n20 - n17, 0);
                    return;
                }
                if (this._state == 2) {
                    s_carsFxSprite.paintAFrame(cGame.s_g, this._segXOn > 0 ? 0 : 2, this._collisionTime > 0 ? 0 : 1, n18, n17, 0);
                    if (this._collisionTime > 0) {
                        cEntity.DrawAnimUsingDt$7a999b6a(s_carsFxSprite, 19, n18, n17, 2867 - this._collisionTime, 2867);
                    }
                }
                return;
            }
            case 7: {
                int n = this._drawZoom;
                int n23 = this._drawY;
                int n24 = this._drawX;
                int n25 = -((this._segXOn << 1) * n >> 12);
                cGame.DrawZoomedSprite(0, 4096, n24 + n25, n23, 0);
                ((ASprite)null).paintFrame(cGame.s_g, 0, n24, n23, 0);
                cEntity.DrawAnimUsingDt$7a999b6a(null, this._incState, n24, n23, this._stickyTimer, 2457);
                return;
            }
        }
    }

    static boolean DrawAnimUsingDt$7a999b6a(ASprite aSprite, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        int n6 = aSprite.getAFrames(n);
        if ((n4 = n4 * n6 / n5) > n6 - 1) {
            n4 = n6 - 1;
            bl = true;
        }
        aSprite.paintAFrame(cGame.s_g, n, n4, n2, n3, 0);
        return bl;
    }

    private void drawPositionAndArrow(int n, int n2, int n3) {
        int n4 = this.carDist(cGame.s_playerCar);
        if (this._type == 1) {
            cGame.s_g.setColor(0xFF0000);
        } else {
            cGame.s_g.setColor(255);
        }
        if (!cGame.s_busted) {
            if (n4 > -300) {
                boolean bl = false;
                if (n4 < 1000) {
                    if (n >= 640) {
                        bl = true;
                        cGame.FillTriangleWrapper(628, 379, 628, 367, 640, 373);
                    } else if (n <= 0) {
                        bl = true;
                        cGame.FillTriangleWrapper(12, 379, 12, 367, 0, 373);
                    }
                }
                if (!bl && this._type == 1) {
                    if (cGame.s_gameMode == 4 || cGame.s_gameMode == 5) {
                        n4 = this._enemyIndex == 0 ? 22 : 21;
                    } else {
                        n4 = 9 + this._enemyIndex;
                        if (cGame.s_playerRank == this._enemyIndex) {
                            ++n4;
                        }
                    }
                    cGame.s_interfaceSprite.paintFrame(cGame.s_g, n4, n, n2 + (n3 * -32 >> 12), 0);
                }
                return;
            }
            if (n3 > 8192) {
                n = (n << 13) / n3;
            }
            cGame.FillTriangleWrapper(n, 480, n + 6, 474, n - 6, 474);
        }
    }

    static void FxAnim_launch(int anim, int totalTime, boolean loop, int priority) {
        if (s_fxAnim == -1 || s_fxPriority > priority) {
            s_fxAnim = anim;
            s_fxTime = 0;
            s_fxTotalTime = totalTime;
            s_fxLoop = false;
            s_fxPriority = priority;
        }
    }

    static void FxAnim_update(int n) {
        if (s_fxAnim >= 0 && (s_fxTime += n) > s_fxTotalTime) {
            if (s_fxLoop) {
                s_fxTime -= s_fxTotalTime;
                return;
            }
            cEntity.FxAnim_stop();
        }
    }

    static void FxAnim_stop() {
        s_fxAnim = -1;
        s_fxTime = 0;
        s_fxPriority = 100;
    }

    private void drawCarTakedown(int n, int n2) {
        int n3;
        int n4 = 1;
        if (this._isABike) {
            n3 = 0;
            if (this._collisionTime > 10240) {
                n3 = 0;
                if (this._segXOn > 0) {
                    n3 = 4;
                }
            } else if (this._collisionTime > 5120) {
                n3 = 4;
                if (this._segXOn > 0) {
                    n3 = 0;
                }
            } else {
                n3 = 7;
            }
        } else if (this._collisionTime > 10752) {
            n3 = this._segXOn < 0 ? 4 : 0;
        } else if (this._collisionTime > 6144) {
            n3 = 2;
            if (this._segXOn < 0) {
                n3 = 0;
            }
            n4 = 0;
        } else {
            n3 = this._segXOn < 0 ? 6 : 7;
        }
        if (n4 != 0) {
            if (this._type == 0) {
                if (this._isABike) {
                    s_playerCarSprite.paintAFrame(cGame.s_g, n3, 0, n, n2, 0);
                    return;
                }
                this.drawPlayerCar(n, n2, n3, -1);
                return;
            }
            if (this._type == 3) {
                s_copCarSprite.paintAFrame(cGame.s_g, n3, 0, n, n2, 0);
                return;
            }
            n4 = 0;
            if (!this._isABike) {
                if (n3 == 6 || n3 == 7) {
                    n4 = 2;
                }
                if (n3 == 6 || n3 == 0) {
                    n4 |= 1;
                }
            }
            cGame.DrawZoomedSprite(1, 4096, n, n2, n4);
            return;
        }
        cEntity.DrawAnimUsingDt$7a999b6a(s_carsFxSprite, n3, n, n2, 10752 - this._collisionTime, 4608);
    }

    final void setRelativeYPos(cEntity e, int relY) {
        this._segOn = e._segOn;
        this._segYOn = e._segYOn;
        this._lapOn = e._lapOn;
        this.yMove(relY);
    }

    final int getLife() {
        if (this._type == 1 || this._type == 3) {
            return s_enemiesAttributes[this._enemyIndex][0];
        }
        return 100;
    }

    private void reduceLife(int value) {
        if (this._type == 1 || this._type == 3 && this._collisionTime <= 0) {
            int[] nArray = s_enemiesAttributes[this._enemyIndex];
            nArray[0] = nArray[0] - value;
            if (s_enemiesAttributes[this._enemyIndex][0] < 0) {
                cEntity.s_enemiesAttributes[this._enemyIndex][0] = 0;
            }
        }
    }

    final void setInitialLife() {
        cEntity.s_enemiesAttributes[this._enemyIndex][0] = s_enemiesAttributes[this._enemyIndex][1];
    }

    private int computeTurnMaxToGoToX(int n) {
        int n2 = this._carParams[6];
        int n3 = this.getOffRoadLimitLeft() + n2;
        n2 = this.getOffRoadLimitRight() - n2;
        if (n < n3) {
            n = n3;
        } else if (n > n2) {
            n = n2;
        }
        this._turnMax = (n -= this._segXOn) >> 6;
        return n;
    }

    static void PositionEnemyCars() throws Exception {
        cEntity cEntity2 = cGame.s_enemyCar;
        int n = cGame.s_gameMode;
        if (n == 0 || n == 1 || n == 4) {
            cEntity2.reInit(cGame.s_playerCar._lapOn, cGame.s_playerCar._segOn, cGame.s_playerCar._segYOn, 4608);
            cEntity2._enemyIndex = cGame.s_trackNbOpponents - 1;
            cEntity2._alive = true;
            cEntity2._segXOn = 0;
            cEntity2._state = 0;
            cEntity2._speed = 0;
            cEntity2.setInitialLife();
            if (n == 4) {
                cEntity.s_enemiesAttributes[0][1] = 20;
                cEntity.s_enemiesAttributes[0][0] = s_enemiesAttributes[0][1];
                return;
            }
        } else if (n == 5) {
            cGame.s_trackNbOpponents = 1;
            cEntity2._alive = false;
            cEntity2._enemyIndex = 0;
            cEntity2._duel_active = false;
            cEntity.s_enemiesAttributes[0][1] = 130;
            cEntity.s_enemiesAttributes[0][0] = 130;
            cEntity2.setInitialLife();
        }
    }

    private void generateNextEnemyCar(boolean bl, boolean n) throws Exception {
        if (cGame.s_gameMode == 0 || cGame.s_gameMode == 1 || cGame.s_gameMode == 4) {
            if (n != 0) {
                if (cGame.s_gameMode == 1) {
                    int[] nArray = s_enemiesAttributes[this._enemyIndex];
                    for (n = this._enemyIndex + 1; n < cGame.s_trackNbOpponents; ++n) {
                        cEntity.s_enemiesAttributes[n - 1] = s_enemiesAttributes[n];
                    }
                    cEntity.s_enemiesAttributes[--cGame.s_trackNbOpponents] = nArray;
                    if (cGame.s_trackNbOpponents == 0) {
                        this._alive = false;
                        return;
                    }
                }
                if (this._enemyIndex != 0) {
                    bl = true;
                    --this._enemyIndex;
                } else {
                    bl = false;
                }
            } else {
                this._enemyIndex += bl ? -1 : 1;
            }
            this.reInit(cGame.s_playerCar._lapOld, cGame.s_playerCar._segOld, cGame.s_playerCar._segYOld, bl ? 9216 : -1000);
            this._state = bl ? 0 : 3;
            this._segXOn = 0;
            this._alive = true;
            this._speed = cGame.s_playerCar._speed;
            this.setInitialLife();
        }
    }

    private static int avoidX(int x) {
        return x + (x > 0 ? -500 : 500) * 3;
    }

    final void updateEnemyCar(int n) throws Exception {
        if (!this._alive) {
            return;
        }
        if (cGame.s_raceEnded) {
            this._speed = this._speedToReach = cGame.s_playerCar._speed;
            this._deltaLat = 0;
            this.update(n, 0, false);
            this._latState = 0;
            return;
        }
        if (this._collisionIsTakeDown) {
            this.update(n, 0, false);
            return;
        }
        cEntity cEntity2 = cGame.s_playerCar;
        int n2 = cEntity2._segXOn;
        int n3 = cGame.s_touristCar._segXOn;
        int n4 = cEntity.GetDist(this._lapOn, this._segOn, this._segYOn, cEntity2._lapOld, cEntity2._segOld, cEntity2._segYOld);
        int n5 = this._duel_active ? cGame.s_playerCar._speedCoef[2] : cGame.s_playerCar._speedCoef[1] * (28 - (this._enemyIndex >> 1)) >> 5;
        if (cGame.s_touristCar._alive && Math.abs(n3 - this._segXOn) < 500) {
            int n6 = Math.abs(n2 - n3);
            n2 = n2 + n3 >> 1;
            if (n6 < 1000) {
                n2 = cEntity.avoidX(n2);
            }
        } else if (n4 < 0) {
            n2 = cEntity.avoidX(n2);
        }
        if (n4 > 9716) {
            if (this._enemyIndex == cGame.s_trackNbOpponents - 1) {
                this._state = 2;
                n5 >>= 4;
            } else {
                this.generateNextEnemyCar(false, false);
            }
        } else if (n4 > 2048) {
            this._duel_active = false;
        } else if (n4 > -1000) {
            this._state = 1;
        } else if (n4 < -1500) {
            this._state = 3;
            if (this._enemyIndex == 0) {
                this._speedToReach = cEntity2._speed;
            } else {
                this.generateNextEnemyCar(true, false);
            }
        }
        if (this._enemyIndex == 0 && n4 < 0 && cGame.s_gameMode == 4) {
            this._speed = this._speedToReach = cGame.s_playerCar._speed;
            this._segYOn = cGame.s_playerCar._segYOld;
            this._lapOn = cGame.s_playerCar._lapOld;
        }
        if (this._enemyIndex == 0 && n4 < 0 && cGame.s_gameMode == 5) {
            this._duel_active = true;
        }
        if (!this._collisionOccured) {
            this._segXOn += n * (-this._segXOn * 12 >> 4) >> 12;
            this._speedToReach = n5;
        }
        this.update(n, this.computeTurnMaxToGoToX(n2), false);
    }

    static void AddHarrow() throws Exception {
        cEntity cEntity2 = cGame.s_harrowCar;
        if (cEntity2._alive) {
            return;
        }
        int n = 20;
        if (cGame.s_gameMode == 5) {
            n = cGame.s_menuData[3];
            n += 20;
        }
        cEntity2.setRelativeYPos(cGame.s_playerCar, n << 10);
        n = cGame.s_trackTabFlags[cEntity2._segOn] >> 2 & 3;
        int n2 = cGame.s_trackTabFlags[cEntity2._segOn] >> 4 & 3;
        if (n + n2 >= cGame.s_trackLaneCount) {
            return;
        }
        n = Util.Math_rand(0, 2) == 0 ? (n << 3) + 3 : (cGame.s_trackLaneCount - n2 - 1 << 3) - 3;
        cEntity2._segXOn = cGame.s_trackLaneBase + (cGame.s_trackLaneWidth * n >> 3);
        cEntity2._alive = true;
        cEntity2._segXOld = cEntity2._segXOn;
        cEntity2._segYOld = cEntity2._segYOn;
        cEntity2._segOld = cEntity2._segOn;
        cEntity2._lapOld = cEntity2._lapOn;
        cEntity2._state = 0;
    }

    final void updateHarrow(int n) throws Exception {
        if (!this._alive) {
            return;
        }
        if (this._state == 0) {
            if (this.checkCollisionWithPlayer()) {
                if (cGame.s_playerCar._accelMode >= 3) {
                    this._state = 2;
                    this._inc = 100;
                    this._collisionTime = 2867;
                    return;
                }
                cGame.s_playerCar.setCollision(0);
                this._state = 1;
                return;
            }
            n = this.carDist(cGame.s_playerCar);
            if (n < 0) {
                this._alive = false;
            }
            return;
        }
        if (this._state == 2) {
            if (this._collisionTime > 0) {
                this._collisionTime -= n;
            }
            this.setRelativeYPos(cGame.s_playerCar, this._inc);
            this._segXOn = this._segXOn > 0 ? (this._segXOn += Math.min(Math.max(n, 0), 4096) * (this.getOffRoadLimitRight() + 200 - this._segXOn) >> 12) : (this._segXOn += Math.min(Math.max(n, 0), 4096) * (this.getOffRoadLimitLeft() - 200 - this._segXOn) >> 12);
            this._inc -= n * 200 >> 12;
            if (this._inc < -1000) {
                this._alive = false;
            }
        }
    }

    final void reInit(int lapOn, int segOn, int segYOn, int yOffset) {
        this._segXOld = this._segXOn = 200;
        this._lapOn = lapOn;
        this._segOn = segOn;
        this._segYOn = segYOn;
        this.yMove(yOffset);
        this._lapOld = this._lapOn;
        this._segYOld = this._segYOn;
        this._segOld = this._segOn;
        this._segZOn = 0;
        this._zSpeed = 0;
        this._inc = 0;
        this._incState = 0;
        this._speed = 0;
        this._deltaSpeed = 0;
        this._deltaDepth = 0;
        this._accelMode = 1;
        this._speedToReach = this._speedCoef[this._accelMode];
        this._collisionOccured = false;
        this._collisionTime = 0;
        this._collisionIsTakeDown = false;
        this._deltaLat = 0;
        this._oldLatState = this._latState = 0;
        if (this._type == 0) {
            s_playerShakeY = 0;
            s_playerShakeTimer = 1228;
            this._enemyIndex = 2;
        }
        this._state = -1;
        this._offRoadStatus = 0;
    }

    final void free() {
        this._speedCoef = null;
        this._carParams = null;
        System.gc();
    }

    final void updatePlayerCar(int n) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        block105: {
            int n7;
            block107: {
                block106: {
                    this._oldLatState = this._latState;
                    cEntity.FxAnim_update(n);
                    if (s_objectBreakTimer > 0) {
                        s_objectBreakTimer -= n;
                    }
                    if (cGame.s_raceEnded) {
                        this._deltaLat = 0;
                        s_boostTimer = 0;
                        this._speed -= n * 113777 >> 12;
                        if (this._speed < 0) {
                            this._speed = 0;
                        }
                        this._speedToReach = this._speed;
                        this.update(n, 0, false);
                        s_driftTimer += n;
                        if (!this._collisionIsTakeDown) {
                            if (this._isABike || this._lapOn <= cGame.s_maxLap && (cGame.s_gameMode == 1 || cGame.s_gameMode == 4)) {
                                this._accelMode = 0;
                                s_driftAnim = -1;
                                this._latState = 0;
                            } else {
                                this._accelMode = 1;
                                if (this._speed > 68266) {
                                    int n8;
                                    if (this._latState == 0) {
                                        if (s_driftTimer > 1228) {
                                            this._latState = this._segXOn > 0 ? -1 : 1;
                                            s_driftTimer = 0;
                                        }
                                        n8 = -1;
                                    } else if (s_driftTimer > 819) {
                                        s_driftTimer = 0;
                                        if (this._latState < 0) {
                                            if (this._latState > -2) {
                                                --this._latState;
                                            }
                                        } else if (this._latState > 0 && this._latState < 2) {
                                            ++this._latState;
                                        }
                                        n8 = s_driftAnim = this._latState < 0 ? 11 : 13;
                                    }
                                    if (this._segZOn == 0) {
                                        int n9 = n;
                                        boolean bl2 = this._latState != 0 || s_playerBurnTimer > 2048;
                                        n = 1;
                                        n = 2048;
                                        n = n9;
                                        cEntity cEntity2 = this;
                                        for (int i = 0; i < 5; ++i) {
                                            if (s_smokeLifeTime[i] <= 0) continue;
                                            int n10 = i;
                                            s_smokeLifeTime[n10] = s_smokeLifeTime[n10] - n;
                                        }
                                        if (bl2) {
                                            if (s_smokeTimer > 0) {
                                                s_smokeTimer -= n;
                                            }
                                            if (s_smokeTimer <= 0) {
                                                cEntity.s_smokeLifeTime[cEntity.s_smokeNextIndex] = 2048;
                                                cEntity.s_smokeTotalLifeTime[cEntity.s_smokeNextIndex] = 2048;
                                                s_smokeTimer = 409;
                                                cEntity.s_smokeX[cEntity.s_smokeNextIndex] = cEntity2._drawX + Util.Math_rand(-1, 2);
                                                cEntity.s_smokeY[cEntity.s_smokeNextIndex] = cEntity2._drawY;
                                                s_smokeNextIndex = (s_smokeNextIndex + 1) % 5;
                                            }
                                        }
                                    }
                                } else {
                                    for (int i = 0; i < 5; ++i) {
                                        cEntity.s_smokeLifeTime[i] = 0;
                                    }
                                    s_smokeTimer = 0;
                                    s_smokeNextIndex = 0;
                                    s_driftAnim = -1;
                                }
                            }
                        }
                        cGame.s_interfaceIgFlags |= 0x10000;
                        while (s_playerCarGear > 1 && this._speed < this._gearValues[s_playerCarGear - 1]) {
                            --s_playerCarGear;
                        }
                        return;
                    }
                    bl = this._segZOn == 0;
                    n6 = bl ? 0 : this._deltaLat + ((this._deltaLat >> 4) * n >> 12);
                    n5 = cGame.s_keyState[15];
                    n4 = cGame.s_keyState[11];
                    n3 = cGame.s_keyState[6];
                    n2 = cGame.s_keyState[3];
                    boolean bl3 = n5 == 1 || n4 == 1 || n3 == 1 || n2 == 1;
                    int n11 = n5 = n5 > 0 || n4 > 0 || n3 > 0 || n2 > 0 ? 1 : 0;
                    if (!this._collisionIsTakeDown && this._accelMode != -1) {
                        n4 = 0;
                        if (cGame.s_keyState[13] > 0 || cGame.s_keyState[5] > 0) {
                            n4 = 1;
                        }
                        if (n4 != 0) {
                            n6 = -this._turnMax;
                        } else {
                            n4 = 0;
                            if (cGame.s_keyState[14] > 0 || cGame.s_keyState[7] > 0) {
                                n4 = 1;
                            }
                            if (n4 != 0) {
                                n6 = this._turnMax;
                            } else if (cGame.s_keyState[2] > 0) {
                                this.startDrift(1);
                            } else if (cGame.s_keyState[4] > 0) {
                                this.startDrift(2);
                            }
                        }
                        if (cGame.s_keyState[12] > 0 || cGame.s_keyState[9] > 0) {
                            if (this._accelMode != 0 && this._driftDirection == 0) {
                                s_playerBurnTimer = 3276;
                                if (this._accelMode > 1) {
                                    s_boostTimer = 0;
                                }
                                this._accelMode = 0;
                                cGame.s_camEffectTimer = 6144;
                            }
                        } else if (n5 != 0 && cGame.s_boostValue >= 1024 * cGame.s_boostTuningCoef >> 12) {
                            if (bl3) {
                                if (this._accelMode < 2) {
                                    this.startBoost(2);
                                } else if (this._accelMode == 2) {
                                    this.startBoost(3);
                                }
                            } else if (n5 != 0 && this._accelMode == 2 && s_boostTimer < 12288) {
                                this.startBoost(3);
                            }
                        } else if (s_boostTimer <= 0) {
                            this._accelMode = 1;
                        }
                    }
                    if ((cGame.s_gameMode == 3 || cGame.s_gameMode == 2 || cGame.s_gameMode == 1 || cGame.s_gameMode == 4) && this._accelMode == -1 && this._segOn >= 0 && this._lapOn == 1) {
                        this._accelMode = 1;
                        cGame.s_touristGenerationEnabled = false;
                        cGame.s_game_refreshAll = true;
                    }
                    if (s_boostTimer > 0 && (s_boostTimer -= n) <= 0) {
                        if (n5 != 0 && cGame.s_boostValue >= 1024 * cGame.s_boostTuningCoef >> 12) {
                            s_boostTimer = 20480;
                            cGame.s_boostValue -= 1024 * cGame.s_boostTuningCoef >> 12;
                            cGame.s_interfaceIgFlags |= 0x80000;
                        } else {
                            this._accelMode = 1;
                            cGame.s_camEffectTimer = 6144;
                        }
                    }
                    if (this._accelMode != -1) {
                        this._speedToReach = !bl ? this._speed : this._speedCoef[this._accelMode];
                    }
                    if (this._offRoadStatus != 0 && this._accelMode != 0 && bl) {
                        this._speedToReach = this._accelMode >= 2 ? this._speedToReach * 3 >> 2 : (this._offRoadStatus == 1 ? 136533 : 56888);
                    }
                    if (this._accelMode > 0 && this._speed == 0) {
                        s_playerBurnTimer = 3276;
                    }
                    if (s_playerBurnTimer > 0) {
                        s_playerBurnTimer -= n;
                        if (this._accelMode < 1 && this._speed < 56888) {
                            s_playerBurnTimer = 0;
                        }
                    }
                    this.update(n, n6, bl && !this._collisionIsTakeDown);
                    if (this._lapOld != this._lapOn) {
                        cGame.s_interfaceIgFlags |= 8;
                    }
                    boolean bl4 = bl = this._segZOn == 0;
                    if (this._speed <= 0 || !bl) break block105;
                    if (this._offRoadStatus != 2) break block106;
                    n7 = 17;
                    break block107;
                }
                if (this._offRoadStatus != 1) break block105;
                n7 = this._offRoadSide == 1 ? 15 : 16;
            }
            cEntity.FxAnim_launch(n7, 2048, false, 10);
        }
        if (this._accelMode == 0 || this._speed == 0) {
            this._latState = 0;
        } else if (this._driftDirection != 0) {
            if (cGame.s_gameMode == 2) {
                cGame.s_gameTime += cGame.s_game_frameDT;
            }
            this._latState = this._driftDirection == 1 ? (this._driftStart || this._driftEnd ? -1 : -2) : (this._driftStart || this._driftEnd ? 1 : 2);
            if (this._driftStart) {
                this._driftStart = false;
            }
            if (this._driftEnd) {
                this.resetDrift();
            }
            cGame.OutLaw_increase(4);
        } else {
            n2 = this._deltaLat;
            n6 = this._turnMax * 200 >> 10;
            n5 = this._turnMax * 800 >> 10;
            n4 = this._turnMax * 150 >> 10;
            n3 = this._turnMax * 700 >> 10;
            if (n2 <= -n5 || n2 <= -n3 && this._oldLatState == -2) {
                this._latState = -2;
            } else if (n2 >= n5 || n2 >= n3 && this._oldLatState == 2) {
                this._latState = 2;
            } else if (n2 <= -n6 || n2 <= -n4 && this._oldLatState == -1) {
                this._latState = -1;
            } else if (n2 >= n6 || n2 >= n4 && this._oldLatState == 1) {
                this._latState = 1;
            } else if (this._latState > 0) {
                --this._latState;
            } else if (this._latState < 0) {
                ++this._latState;
            }
        }
        if (this._hitGround) {
            if (this._collisionIsTakeDown) {
                if (this._segZOn == 0) {
                    cEntity.FxAnim_launch(20, 6144, false, 0);
                } else {
                    cEntity.FxAnim_launch(19, 2457, false, 1);
                }
            } else {
                n6 = (this._segZOnMax << 12) / 300;
                if (n6 > 4096) {
                    n6 = 4096;
                }
                cGame.VibrateAndShake_start(819 + (n6 * 1638 >> 12), 0, 1, n6 * 6 >> 12);
                cGame.OutLaw_increase(3);
                cEntity.FxAnim_launch(8, 2048, false, 10);
            }
        }
        if (this._speed << 1 >> 12 != this._speed - this._deltaSpeed << 1 >> 12) {
            cGame.s_interfaceIgFlags |= 0x10000;
        }
        if (this._segXOn >= cGame.s_trackRoadWidth + cGame.s_trackOffRoadWidth) {
            this._segXOn = cGame.s_trackRoadWidth + cGame.s_trackOffRoadWidth;
            if (this._driftDirection != 0) {
                this._driftEnd = true;
            }
        } else if (this._segXOn <= -(cGame.s_trackRoadWidth + cGame.s_trackOffRoadWidth)) {
            this._segXOn = -(cGame.s_trackRoadWidth + cGame.s_trackOffRoadWidth);
            if (this._driftDirection != 0) {
                this._driftEnd = true;
            }
        }
        while (s_playerCarGear < this._gearValues.length - 1 && this._speed > this._gearValues[s_playerCarGear]) {
            ++s_playerCarGear;
        }
        while (s_playerCarGear > 1 && this._speed < this._gearValues[s_playerCarGear - 1]) {
            --s_playerCarGear;
        }
        if (this._speed > 0) {
            if (this._speed > 227555 && (s_outlawHighSpeedTimer -= n) < 0) {
                s_outlawHighSpeedTimer += 4096;
                cGame.OutLaw_increase(this._speed > 341333 ? 1 : 0);
            }
            n6 = (n6 = this._segXOn + cGame.s_trackRoadWidth) < 0 ? n6 / cGame.s_trackLaneWidth - 1 : (n6 /= cGame.s_trackLaneWidth);
            if (n6 < cGame.s_trackLaneCount && n6 >= 0 && (cGame.s_trackLaneSide >> cGame.s_trackLaneCount - n6 - 1 & 1) == 0 && (s_outlawInvertLaneTimer -= n) < 0) {
                s_outlawInvertLaneTimer += 4096;
                cGame.OutLaw_increase(2);
            }
            this.updatePlayerCarShake(n);
        }
        if (!this._isABike) {
            if (bl) {
                if (this._oldLatState != this._latState || this._hitGround) {
                    if (Math.abs(this._latState) == 2) {
                        s_driftAnim = this._latState < 0 ? 11 : 13;
                        s_driftTimer = 0;
                        this.startDrift(this._latState < 0 ? 1 : 2);
                        this._driftStart = false;
                    } else if (Math.abs(this._oldLatState) == 2) {
                        s_driftAnim = -1;
                    }
                }
            } else if (s_driftAnim >= 0) {
                s_driftAnim = -1;
            }
        }
        if (s_driftAnim >= 0) {
            s_driftTimer += n;
        }
    }

    private void startBoost(int accel) {
        this._accelMode = accel;
        cGame.s_camEffectTimer = 6144;
        if (this._accelMode == 2) {
            cGame.s_camDistOffset = 250;
            cGame.VibrateAndShake_start(6144, 0, 1, 2);
        } else {
            cGame.s_camDistOffset = 150;
            cGame.VibrateAndShake_start(6144, 0, 1, 3);
        }
        s_boostTimer = 20480;
        cGame.s_boostValue -= 1024 * cGame.s_boostTuningCoef >> 12;
        cGame.s_interfaceIgFlags |= 0x80000;
    }

    final void updatePlayerCarShake(int n) {
        if ((s_playerShakeTimer -= n) <= 0) {
            s_playerShakeY = Util.Math_rand(-1, 2);
            if (this._latState == 0) {
                s_playerShakeTimer += 1228;
                return;
            }
            if (Math.abs(this._latState) == 1) {
                s_playerShakeTimer += 819;
                return;
            }
            s_playerShakeTimer += 409;
        }
    }

    private void drawPlayerCar(int n, int n2, int n3, int n4) {
        n4 = cGame.s_gameFrameCpt & 1;
        if (this._speed == 0) {
            n4 = 0;
        }
        s_playerCarSprite.paintAFrame(cGame.s_g, n3, n4, n, n2, 0);
    }

    private void drawPlayerEffectsOnPoint(int n, int n2) {
        byte[] byArray = this._incState == 0 ? s_playerPointsData[this._latState + 2] : s_playerPointsData[5];
        if (byArray == null) {
            return;
        }
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6;
            boolean bl;
            byte by = byArray[n4++];
            int n7 = byArray[n4++] + n2;
            boolean bl2 = bl = ((n6 = byArray[n4++]) & 0x80) != 0;
            if (((n6 &= n) & 1) != 0) {
                n5 = 0;
                if (this._accelMode == 3) {
                    ++n5;
                }
                s_carsFxBoostSprite.paintAFrame(cGame.s_g, n5, cGame.s_gameFrameCpt & 1, this._drawX + by, this._drawY + n7, bl ? 1 : 0);
            }
            if ((n6 & 0x10) != 0) {
                n5 = 0;
                n5 = by * 17 >> 4;
                cGame.s_g.setColor(cGame.s_trackShadowColor);
                int n8 = this._drawX + by;
                int n9 = this._drawY + n7;
                for (int i = -2; i < 2; ++i) {
                    cGame.s_g.drawLine(n8 + i, n9, n8 + i + n5, n9 + 50);
                }
            }
            if ((n6 & 0x20) == 0) continue;
            s_carsFxSprite.paintAFrame(cGame.s_g, 21, cGame.s_gameFrameCpt & 1, this._drawX + by, this._drawY + n7, bl ? 1 : 0);
        }
    }

    final void updateTouristCar(int n) throws Exception {
        if (this._alive) {
            int n2;
            this._segXOld = this._segXOn;
            this._segOld = this._segOn;
            this._segYOld = this._segYOn;
            this._lapOld = this._lapOn;
            if ((cGame.s_offRoadItem[(this._segOn + 5) % cGame.s_trackNbSegment] & 0xF000) == 32768) {
                this._state = 2;
            }
            if (this._collisionOccured) {
                this._state = 1;
            } else {
                if (this._speed != this._speedToReach) {
                    n2 = n * 34133 >> 12;
                    if (this._speed < this._speedToReach) {
                        this._speed += n2;
                        if (this._speed > this._speedToReach) {
                            this._speed = this._speedToReach;
                        }
                    } else {
                        this._speed -= n2;
                        if (this._speed < this._speedToReach) {
                            this._speed = this._speedToReach;
                        }
                    }
                }
                if (this._state != 0) {
                    int n3;
                    n2 = cGame.s_trackTabFlags[this._segOn] & 3;
                    if (cGame.s_playerCar._segXOn - this._segXOn < 0) {
                        n3 = (n2 = n2 == 3 || n2 == 2 ? 1 : 0) != 0 ? this.getOffRoadLimitRight() - this._carParams[6] - 50 : this.getOffRoadLimitRight() + 200;
                    } else {
                        n2 = n2 == 3 || n2 == 1 ? 1 : 0;
                        n3 = n2 != 0 ? this.getOffRoadLimitLeft() + this._carParams[6] + 50 : this.getOffRoadLimitLeft() - 200;
                    }
                    if (this._speedToReach < 0) {
                        this._speedToReach += 79644;
                        if (this._speedToReach > 0) {
                            this._speedToReach = 0;
                        }
                    } else if (this._speedToReach > 0) {
                        this._speedToReach -= 79644;
                        if (this._speedToReach < 0) {
                            this._speedToReach = 0;
                        }
                    }
                    n2 = n3 - this._segXOn;
                } else {
                    n2 = this._incState - this._segXOn;
                }
                this._deltaLat += Math.min(Math.max(n << 2, 0), 4096) * (n2 - this._deltaLat) >> 12;
            }
            this._segXOn += this._deltaLat * n >> 12;
            this._deltaDepth = (this._speed * n >> 12) / 40;
            this.yMove(this._deltaDepth);
            n2 = this.carDist(cGame.s_playerCar);
            if (n2 < -5620 || n2 > 15860) {
                this._alive = false;
            }
            return;
        }
        if (cGame.s_touristGenerationEnabled && (cGame.s_touristGenerationTimer -= n) <= 0) {
            cGame.s_touristGenerationTimer = cGame.s_trackTouristGenerationTimer;
            int n4 = Util.Math_rand(0, 100) < 20 ? 1 : 0;
            int n5 = cGame.s_playerCar._speed > cGame.s_playerCar._speedCoef[1] >> 2 ? 1 : 0;
            int n6 = n4;
            n4 = n5;
            n = n6;
            if (!cGame.s_raceEnded) {
                int n7;
                block28: {
                    int n8;
                    this._deltaLat = 0;
                    this._deltaSpeed = 0;
                    this._deltaDepth = 0;
                    this._segZOn = 0;
                    this._collisionOccured = false;
                    this._collisionTime = 0;
                    this._collisionIsTakeDown = false;
                    n4 = n != 0 || n4 != 0 ? 10240 : -1000;
                    this.setRelativeYPos(cGame.s_playerCar, n4);
                    this._segYOld = this._segYOn;
                    this._segOld = this._segOn;
                    this._segXOld = this._segXOn;
                    this._lapOld = this._lapOn;
                    if (n != 0) {
                        n8 = cGame.s_trackLaneCount - cGame.s_trackLaneSameSideNb;
                        n5 = ~cGame.s_trackLaneSide;
                    } else {
                        n8 = cGame.s_trackLaneSameSideNb;
                        n5 = cGame.s_trackLaneSide;
                    }
                    n4 = Util.Math_rand(1, n8 + 1);
                    this._speed = 147911 - n4 * 45511 / n8;
                    if (n != 0) {
                        this._speed = -(this._speed >> 3);
                    }
                    this._speedToReach = this._speed;
                    int n9 = n5;
                    n5 = this._segOn;
                    n = n9;
                    n8 = cGame.s_trackLaneCount;
                    int n10 = cGame.s_trackTabFlags[n5] >> 2 & 3;
                    int n11 = cGame.s_trackTabFlags[n5] >> 4 & 3;
                    for (n5 = 0; n5 < n8; ++n5) {
                        if ((n >> n8 - n5 - 1 & 1) == 1) {
                            --n4;
                        }
                        if (n4 > 0 || n5 <= n10 - 1 || n5 >= n8 - n11) continue;
                        n7 = n5;
                        break block28;
                    }
                    for (n5 = 0; n5 < cGame.s_trackLaneCount; ++n5) {
                        if ((n >> n8 - n5 - 1 & 1) != 1 || n5 <= n10 - 1 || n5 >= n8 - n11) continue;
                        n7 = n5;
                        break block28;
                    }
                    n7 = n4 = -1;
                }
                if (n7 >= 0) {
                    this._incState = this._segXOn = cGame.s_trackLaneBase + cGame.s_trackLaneWidth * n4;
                    this._deltaLat = 0;
                    this._state = 0;
                    this._alive = true;
                }
            }
        }
    }

    final int carDist(cEntity c2) {
        return cEntity.GetDist(this._lapOn, this._segOn, this._segYOn, c2._lapOn, c2._segOn, c2._segYOn);
    }

    private static int GetDist(int n, int n2, int n3, int n4, int n5, int n6) {
        n = (n - n4) * cGame.s_trackNbSegment;
        return ((n += n2 - n5) << 10) + n3 - n6;
    }

    final void yMove(int ydelta) {
        this._segYOn += ydelta;
        while (this._segYOn >= 1024) {
            if (this._type == 0) {
                cGame.s_camCumuledCap += cGame.s_trackTabAng[this._segOn];
                cGame.s_camCumuledHeight += cGame.s_trackTabInc[this._segOn];
            }
            this._segYOn -= 1024;
            ++this._segOn;
            if (this._segOn != cGame.s_trackNbSegment) continue;
            ++this._lapOn;
            this._segOn = 0;
        }
        while (this._segYOn < 0) {
            this._segYOn += 1024;
            --this._segOn;
            if (this._segOn >= 0) continue;
            this._segOn = cGame.s_trackNbSegment - 1;
            --this._lapOn;
        }
    }

    private void update(int n, int n2, boolean n3) throws Exception {
        int n4;
        int n5;
        int n6;
        this._segXOld = this._segXOn;
        this._segYOld = this._segYOn;
        this._segOld = this._segOn;
        this._lapOld = this._lapOn;
        if (!this._collisionOccured) {
            if (this._speedToReach == 0) {
                this._deltaSpeed = -(this._breakCoef * n >> 12);
                if (this._accelMode == -1) {
                    this._deltaSpeed = 0;
                }
                this._speed += this._deltaSpeed;
                if (this._speed < 0) {
                    this._speed = 0;
                }
            } else if (this._accelMode != -1) {
                n6 = this._accelCoef;
                this._deltaSpeed = this._speed;
                this._speed += Math.min(Math.max(n * n6 >> 12, 0), 4096) * (this._speedToReach - this._speed) >> 12;
                this._deltaSpeed = this._speed - this._deltaSpeed;
                this._speed += n * 2000 >> 12;
                if (this._driftDirection != 0 && this._speed < 102400) {
                    this._driftEnd = true;
                }
            }
            if (this._speed == 0) {
                this._deltaLat = 0;
                if (this._type == 0) {
                    s_playerDeltaLatFromTurn = 0;
                }
            } else {
                if (this._driftDirection != 0) {
                    n6 = this._segOn - 1;
                    if (n6 < 0) {
                        n6 += cGame.s_trackNbSegment;
                    }
                    n5 = cGame.s_trackTabAng[this._segOn];
                    n4 = cGame.s_trackTabAng[n6];
                    if (n5 == 0 || ((n5 ^ n4) & Integer.MIN_VALUE) != 0) {
                        this._driftEnd = true;
                    }
                }
                if (n2 == 0) {
                    n6 = n * this._turnMax / this._carParams[1];
                    if (Math.abs(n6) >= Math.abs(this._deltaLat)) {
                        this._deltaLat = 0;
                    } else if (this._deltaLat < 0) {
                        this._deltaLat += n6;
                    } else if (this._deltaLat > 0) {
                        this._deltaLat -= n6;
                    }
                } else {
                    if (this._driftDirection != 0) {
                        n2 >>= 4;
                    }
                    n6 = n * (n2 - this._deltaLat) / this._carParams[0];
                    if (this._deltaLat != n2 && n6 == 0) {
                        int n7 = n6 = n2 >= 0 ? 1 : -1;
                    }
                    if (this._segZOn != 0) {
                        n6 <<= 1;
                    }
                    this._deltaLat += n6;
                }
            }
        }
        n6 = this._speed;
        if (this._type == 0) {
            s_speedReduction = n6 > 261688 ? n6 - 261688 - (n6 - 261688 >> 1) : 0;
        }
        n6 -= s_speedReduction;
        if (n3 != 0 && this._driftDirection == 0) {
            n5 = (cGame.s_trackTabAng[this._segOn] << 12) / 91;
            n4 = (n6 << 12) / 91022;
            n2 = n4 * 1100 >> 12;
            n2 = n2 * n5 >> 12;
            this._segXOn += n2 * n >> 12;
            s_playerDeltaLatFromTurn = n2;
        }
        this._segXOn = this._segZOn == 0 ? (this._segXOn += this._deltaLat * n >> 12) : (this._segXOn += (this._deltaLat >> 1) * n >> 12);
        this._deltaDepth = (n6 * n >> 12) / 40;
        n3 = cGame.s_trackTabInc[this._segOn];
        this.yMove(this._deltaDepth);
        this._inc = cGame.s_trackTabInc[this._segOn];
        this._hitGround = false;
        if (this._segZOn == 0) {
            n2 = n3 - this._inc;
            if (n2 > 22) {
                this._zSpeed = Util.s_math_cosTable[512 - n3 & 0x7FF] * this._deltaDepth / n;
                this._segZOn = (this._zSpeed >> 12) * n >> 12;
                this._segZOn -= Util.s_math_cosTable[512 - this._inc & 0x7FF] * this._segYOn >> 12;
                this._segZOnMax = this._segZOn;
            }
        } else {
            this._segZOn += (this._zSpeed >> 12) * n >> 12;
            this._segZOn -= Util.s_math_cosTable[512 - this._inc & 0x7FF] * this._deltaDepth >> 12;
            if (this._segZOn > this._segZOnMax) {
                this._segZOnMax = this._segZOn;
            }
            this._zSpeed -= n * 2200;
            if (this._segZOn <= 0) {
                this._hitGround = true;
                if (this._collisionIsTakeDown && this._speed > 0 && this._zSpeed < -4915200) {
                    this._zSpeed = -this._zSpeed / 4;
                    this._segZOn = 1;
                } else if (this._zSpeed < -4915200 && this._inc == 0) {
                    this._zSpeed = -(this._zSpeed / 3);
                    this._segZOn = 1;
                } else {
                    this._zSpeed = 0;
                    this._segZOn = 0;
                }
            }
        }
        v1._offRoadStatus = 0;
        n2 = this._segXOn - this._carParams[6 + this._latState];
        n3 = this._segXOn + this._carParams[6 - this._latState];
        n = this.getOffRoadLimitLeft();
        if (n2 < n) {
            this._offRoadSide = 1;
            this._offRoadStatus = n3 < n ? 2 : 1;
        }
        if (n3 > (n = this.getOffRoadLimitRight())) {
            this._offRoadSide = 2;
            if (n2 > n) {
                this._offRoadStatus = 2;
                return;
            }
            this._offRoadStatus = 1;
        }
    }

    private int getOffRoadLimitLeft() {
        int laneCloseLeft = cGame.s_trackTabFlags[this._segOn] >> 2 & 3;
        return -cGame.s_trackRoadWidth + laneCloseLeft * cGame.s_trackLaneWidth;
    }

    private int getOffRoadLimitRight() {
        int laneCloseRight = cGame.s_trackTabFlags[this._segOn] >> 4 & 3;
        return cGame.s_trackRoadWidth - laneCloseRight * cGame.s_trackLaneWidth;
    }

    private void resetDrift() {
        this._driftDirection = 0;
        this._driftStart = false;
        this._driftEnd = false;
    }

    private void startDrift(int driftType) {
        if (this._speed < 102400 || this._collisionOccured || !cGame.s_driftEnable || this._segZOn > 0 || this._driftDirection != 0) {
            return;
        }
        if (cGame.s_trackTabAng[this._segOn] > 0 && driftType == 2 || cGame.s_trackTabAng[this._segOn] < 0 && driftType == 1) {
            return;
        }
        this._driftDirection = driftType;
        this._driftStart = true;
        this._driftEnd = false;
        this._deltaLat = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void updateCollisions(int n) throws Exception {
        if (!this._collisionIsTakeDown) {
            if (this._collisionTime <= 0) return;
            this._collisionTime -= n;
            if (this._collisionTime > 0) return;
            this._collisionOccured = false;
            if (this._type == 0) return;
            this._latState = 0;
            return;
        }
        this._collisionTime = this._collisionTime > n ? (this._collisionTime -= n) : 0;
        if (this._type == 0) {
            this._speed += Math.min(Math.max(n * 3 >> 1, 0), 4096) * (0 - this._speed) >> 12;
            this._deltaLat += Math.min(Math.max(n * 3 >> 1, 0), 4096) * (0 - this._deltaLat) >> 12;
            if (this._speed >= 11377) return;
            if (Math.abs(this._deltaLat) >= 50) return;
            if (this._segZOn != 0) return;
            if (this._collisionTime != 0) return;
            if (cGame.s_raceEnded) return;
            if (cGame.s_gameMode != 2 && cGame.s_gameMode != 3 && (cGame.s_copCar._alive && !cGame.s_copCar._collisionIsTakeDown || cGame.s_harrowCar._alive && cGame.s_harrowCar._state == 1)) {
                cGame.Outlaw_setBusted();
                return;
            }
            cGame.s_playerCarRespawnTimer = 819;
            cGame.Game_setState(52, 48);
            return;
        }
        if (cGame.s_raceEnded) return;
        n = (cGame.s_playerCar._speed * 28 >> 5) - 5688;
        if (n < this._speed) {
            this._speed = n;
        }
        if (this._speed <= 0) {
            this._speed = 0;
            this._deltaLat = 0;
        }
        if (this.carDist(cGame.s_playerCar) >= -1024) return;
        this._collisionOccured = false;
        this._collisionIsTakeDown = false;
        if (this._type == 1) {
            this.generateNextEnemyCar(true, true);
            return;
        }
        if (this._type != 3) return;
        cEntity.RemoveCopCar();
    }

    static {
        s_playerCarSprite = null;
        s_playerWheelsSprite = null;
        s_copCarSprite = null;
        s_startingAnimSprite = null;
        s_carsFxSprite = null;
        s_carsFxBoostSprite = null;
        s_babeStartSprite = null;
        s_copterSprite = null;
        s_smokeLifeTime = new int[5];
        s_smokeTotalLifeTime = new int[5];
        s_smokeX = new int[5];
        s_smokeY = new int[5];
        s_smokeTimer = 0;
        s_smokeNextIndex = 0;
    }
}

