/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Sprite {
    static int _int1;
    static int _int2;
    static int _int3;
    static byte[] _buff8;
    Sprite[] _scaled;
    int _scale_min;
    int _scale_max;
    static int[] _buffer;
    byte[] _data;
    short[] _data_offset;
    int[][] _pal;
    int[] _pal_current;
    Image[][] _precalc_images_pal;
    Image[] _precalc_images;
    long _flags;
    int _rebuild_width;
    int _rebuild_height;
    int _data_size;
    int _count;
    int _mask;
    byte[] _modules;
    int _module_count;
    byte[] _refModules;
    int _refModule_count;
    short[] _frames_start;
    byte[] _frames_size;
    byte[] _frames_width;
    byte[] _frames_height;
    byte[] _aframes;
    int _aframes_count;
    short[] _anim_start;
    byte[] _anim_size;
    int _data_offset_size;
    static Graphics _g;
    static int _width;
    static int _height;
    static int _current_anim;
    static int _current_frame;
    static int _current_aframe;
    static Image _image_temp;

    void buildRLE8bfrm(int offset, int size) {
        int crash;
        int pos = 0;
        if (this._data_offset == null) {
            System.out.println("Sprite.buildRLE8bfrm error:");
            System.out.println("_data_offset == null");
            crash = 1;
            crash /= 0;
        }
        if (offset >= this._data_offset.length) {
            System.out.println("Sprite.buildRLE8bfrm warning:");
            System.out.println("Trying to display an out of bound frame(" + offset + "/" + this._data_offset.length + ")");
            offset = 0;
        }
        if (_buffer == null) {
            System.out.println("Sprite.buildRLE8bfrm error:");
            System.out.println("_buffer == null");
            crash = 1;
            crash /= 0;
        }
        if (this._data == null) {
            System.out.println("Sprite.buildRLE8bfrm error:");
            System.out.println("_data == null");
            crash = 1;
            crash /= 0;
        }
        if (this._pal_current == null) {
            System.out.println("Sprite.buildRLE8bfrm error:");
            System.out.println("_pal_current == null");
            crash = 1;
            crash /= 0;
        }
        offset = this._data_offset[offset];
        while (pos < size) {
            int count = (this._data[offset] & 0xFF) >> this._count;
            if (count == 0) {
                Sprite._buffer[pos++] = this._pal_current[this._data[offset++] & this._mask];
                continue;
            }
            int color = this._pal_current[this._data[offset++] & this._mask];
            count += pos;
            while (count >= pos) {
                Sprite._buffer[pos++] = color;
            }
        }
    }

    Sprite() {
        if (_buffer == null) {
            _buffer = new int[8500];
        }
    }

    void draw(int frame, int x, int y, int flags, int scale) {
        if (this._scaled != null && (scale < this._scale_min || scale > this._scale_max)) {
            _int2 = this._scaled.length;
            for (_int1 = 0; _int1 < _int2; ++_int1) {
                if (scale < this._scaled[Sprite._int1]._scale_min || scale > this._scaled[Sprite._int1]._scale_max) continue;
                this._scaled[_int1].draw(frame, x, y, flags, scale);
                return;
            }
            if (scale < this._scale_min) {
                this._scaled[this._scaled.length - 1].draw(frame, x, y, flags, scale);
                return;
            }
        }
        if (this._modules == null) {
            this.initSize(frame);
            if (this._precalc_images == null) {
                this.buildRLE8bfrm(frame, _width * _height);
                if ((flags & 0xC0) != 0) {
                    _image_temp = Image.createRGBImage((int[])_buffer, (int)_width, (int)_height, ((this._flags & 0x10000L) != 0L ? 1 : 0) != 0);
                    _g.drawRegion(_image_temp, 0, 0, _width, _height, Sprite.transform(flags), x, y, 20);
                } else {
                    _g.drawRGB(_buffer, 0, _width, x, y, _width, _height, (this._flags & 0x10000L) != 0L);
                }
            } else {
                if (this._precalc_images[frame] == null) {
                    this.precalcImage(frame, flags);
                }
                if ((flags & 0xC0) != 0) {
                    _g.drawRegion(this._precalc_images[frame], 0, 0, _width, _height, Sprite.transform(flags), x, y, 20);
                } else {
                    _g.drawImage(this._precalc_images[frame], x, y, 20);
                }
            }
            return;
        }
        if (frame >= this._data_offset_size) {
            return;
        }
        this.initSize(frame);
        if (_width <= 1 || _height <= 1) {
            return;
        }
        _int2 = this._frames_start[frame];
        for (_int1 = 0; _int1 < this._frames_size[frame]; ++_int1) {
            _int3 = (this._refModules[_int2 * 4 + 0] & 0xFF) + ((this._refModules[_int2 * 4 + 1] & 0x1F) << 8);
            int mflags = 0;
            int drawx = x + this._refModules[_int2 * 4 + 2];
            int drawy = y + this._refModules[_int2 * 4 + 3];
            if ((flags & 0x80) != 0) {
                drawx = x - this._refModules[_int2 * 4 + 2] - this._modules[_int3 * 2 + 0];
                mflags ^= 0x80;
            }
            if ((flags & 0x40) != 0) {
                drawy = y - this._refModules[_int2 * 4 + 3] - this._modules[_int3 * 2 + 1];
                mflags ^= 0x40;
            }
            if ((this._refModules[_int2 * 4 + 1] & 0xE0 & 0x20) != 0) {
                mflags ^= 0x80;
            }
            if ((this._refModules[_int2 * 4 + 1] & 0xE0 & 0x40) != 0) {
                mflags ^= 0x40;
            }
            int w = this._modules[_int3 * 2 + 0] & 0xFF;
            int h = this._modules[_int3 * 2 + 1] & 0xFF;
            if (w > 1 && h > 1) {
                if (this._precalc_images == null) {
                    this.buildRLE8bfrm(_int3, w * h);
                    if ((mflags & 0xC0) != 0) {
                        _image_temp = Image.createRGBImage((int[])_buffer, (int)w, (int)h, ((this._flags & 0x10000L) != 0L ? 1 : 0) != 0);
                        _g.drawRegion(_image_temp, 0, 0, w, h, Sprite.transform(mflags), drawx, drawy, 20);
                    } else {
                        _g.drawRGB(_buffer, 0, w, drawx, drawy, w, h, (this._flags & 0x10000L) != 0L);
                    }
                } else {
                    if (this._precalc_images[_int3] == null) {
                        this.precalcImage(_int3, flags);
                    }
                    if ((mflags & 0xC0) != 0) {
                        _g.drawRegion(this._precalc_images[_int3], 0, 0, w, h, Sprite.transform(mflags), drawx, drawy, 20);
                    } else {
                        _g.drawImage(this._precalc_images[_int3], drawx, drawy, 20);
                    }
                }
            }
            ++_int2;
        }
    }

    int getFrame(int anim, int aframe) {
        aframe = this._anim_start[anim] + aframe;
        return this._aframes[aframe * 5 + 0] & 0xFF | (this._aframes[aframe * 5 + 1] & 0x1F) << 8;
    }

    void initScale(int number, int scale_min, int scale_max, int color) {
        if (number <= 1) {
            return;
        }
        this._scale_min = 306 - 255 / (number + 1) * 4;
        this._scale_max = scale_max;
        this._scaled = new Sprite[number - 1];
        for (int i = 1; i < number; ++i) {
            System.out.println("" + (255 / (i + 4) * 6 - 255 / (number + 1) * 4));
            this._scaled[i - 1] = new Sprite(this, 255 / (i + 4) * 6 - 255 / (number + 1) * 4, color);
            this._scaled[i - 1]._scale_max = 255 / (i + 4) * 6 - 255 / (number + 1) * 4;
            this._scaled[i - 1]._scale_min = 255 / (i + 1 + 4) * 6 - 255 / (number + 1) * 4;
        }
    }

    void initSize(int frame) {
        if (frame >= this._data_offset_size) {
            return;
        }
        if ((this._flags & 0x400L) != 0L) {
            _width = this._rebuild_width;
            _height = this._rebuild_height;
        } else {
            _width = this._frames_width[frame] & 0xFF;
            _height = this._frames_height[frame] & 0xFF;
        }
    }

    void load(String name) {
        try {
            InputStream is = name.getClass().getResourceAsStream(name + ".gli");
            this.load(is);
            is.close();
        }
        catch (Exception e) {
            System.out.println(e + ": Error while loading " + name);
        }
        System.gc();
    }

    void load(InputStream is) {
        try {
            int _int1;
            this._flags = is.read() & 0xFF | (is.read() & 0xFF) << 8 | ((is.read() & 0xFF) << 16 | (is.read() & 0xFF) << 24);
            try {
                if ((this._flags & 0x40A00L) == 0L) {
                    this._rebuild_width = is.read() & 0xFF;
                    this._rebuild_height = is.read() & 0xFF;
                    this._data_offset_size = is.read() & 0xFF;
                }
                if ((this._flags & 0x40018L) != 0L) {
                    this._count = is.read() & 0xFF;
                }
                this._data_size = is.read() & 0xFF | (is.read() & 0xFF) << 8;
                this._mask = 255 >> 8 - this._count;
                this._pal = new int[is.read() & 0xFF][];
                _int3 = is.read() & 0xFF;
                for (_int1 = 0; _int1 < this._pal.length; ++_int1) {
                    this._pal[_int1] = new int[_int3];
                    for (int _int2 = 0; _int2 < _int3; ++_int2) {
                        this._pal[_int1][_int2] = is.read() & 0xFF | (is.read() & 0xFF) << 8;
                        this._pal[_int1][_int2] = ((this._pal[_int1][_int2] & 0xF000) >>> 12) * 0x11000000 | ((this._pal[_int1][_int2] & 0xF00) >>> 8) * 0x110000 | ((this._pal[_int1][_int2] & 0xF0) >>> 4) * 4352 | (this._pal[_int1][_int2] & 0xF) * 17;
                    }
                }
                if ((this._flags & 4L) == 0L) {
                    this._data = new byte[this._data_size];
                    is.read(this._data);
                }
            }
            catch (Exception e) {
                System.out.println(e + ": Error while loading image");
            }
            System.gc();
            if ((this._flags & 0xA00L) != 0L) {
                System.out.println("LOAD SIZE ");
                Sprite._int1 = is.read() & 0xFF | (is.read() & 0xFF) << 8;
                this._frames_width = new byte[Sprite._int1];
                this._frames_height = new byte[Sprite._int1];
                this._frames_start = new short[Sprite._int1];
                this._frames_size = new byte[Sprite._int1];
                _buff8 = new byte[Sprite._int1 * 2];
                is.read(_buff8);
                for (int _int2 = 0; _int2 < Sprite._int1; ++_int2) {
                    this._frames_width[_int2] = _buff8[_int2 * 2];
                    this._frames_height[_int2] = _buff8[_int2 * 2 + 1];
                }
                _buff8 = null;
                this._data_offset_size = this._frames_width.length;
            }
            if ((this._flags & 0x10L) != 0L) {
                this._data_offset = new short[this._data_offset_size];
                for (_int1 = 0; _int1 < this._data_offset_size; ++_int1) {
                    this._data_offset[_int1] = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                }
            }
            short start = 0;
            if ((this._flags & 0x40000L) != 0L) {
                int _int12;
                try {
                    this._data_offset_size = is.read() & 0xFF | (is.read() & 0xFF) << 8;
                    this._data_offset = new short[this._data_offset_size];
                    for (_int12 = 0; _int12 < this._data_offset_size; ++_int12) {
                        this._data_offset[_int12] = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                    }
                }
                catch (Exception e) {
                    System.out.println(e + ": Error while loading offsets");
                }
                try {
                    Sprite._int1 = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                    this._modules = new byte[Sprite._int1 * 2];
                    this._module_count = Sprite._int1;
                    is.read(this._modules);
                    _int2 = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                    this._refModules = new byte[_int2 * 4];
                    this._refModule_count = _int2;
                    is.read(this._refModules);
                    this._data_offset_size = _int2 = is.read() & 0xFF | (is.read() & 0xFF) << 8;
                    this._frames_width = new byte[_int2];
                    this._frames_height = new byte[_int2];
                    this._frames_start = new short[_int2];
                    this._frames_size = new byte[_int2];
                    is.read(this._frames_size);
                    for (_int12 = 0; _int12 < _int2; ++_int12) {
                        int size = this._frames_size[_int12];
                        this._frames_start[_int12] = start;
                        if (size > 0) {
                            _int3 = (this._refModules[start * 4 + 0] & 0xFF) + ((this._refModules[start * 4 + 1] & 0x1F) << 8);
                            int x3 = this._refModules[start * 4 + 2];
                            int y3 = this._refModules[start * 4 + 3];
                            int x1 = x3 + this._modules[_int3 * 2 + 0];
                            int y1 = y3 + this._modules[_int3 * 2 + 1];
                            for (int i = 1; i < size; ++i) {
                                _int3 = (this._refModules[(start + i) * 4 + 0] & 0xFF) + ((this._refModules[(start + i) * 4 + 1] & 0x1F) << 8);
                                int x2 = this._refModules[(start + i) * 4 + 2];
                                int y2 = this._refModules[(start + i) * 4 + 3];
                                if (x2 < x3) {
                                    x3 = x2;
                                }
                                if (y2 < y3) {
                                    y3 = y2;
                                }
                                y2 += this._modules[_int3 * 2 + 1];
                                if ((x2 += this._modules[_int3 * 2 + 0]) > x1) {
                                    x1 = x2;
                                }
                                if (y2 <= y1) continue;
                                y1 = y2;
                            }
                            start = (short)(start + size);
                            this._frames_width[_int12] = (byte)(x1 - x3);
                            this._frames_height[_int12] = (byte)(y1 - y3);
                            continue;
                        }
                        this._frames_width[_int12] = 0;
                        this._frames_height[_int12] = 0;
                    }
                    _int2 = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                    this._aframes = new byte[_int2 * 5];
                    this._aframes_count = _int2;
                    is.read(this._aframes);
                    _int2 = (short)(is.read() & 0xFF | (is.read() & 0xFF) << 8);
                    this._anim_start = new short[_int2];
                    this._anim_size = new byte[_int2];
                    is.read(this._anim_size);
                    start = 0;
                    for (_int12 = 0; _int12 < _int2; ++_int12) {
                        this._anim_start[_int12] = start;
                        start = (short)(start + this._anim_size[_int12]);
                    }
                    this._flags = 512L;
                }
                catch (Exception e) {
                    System.out.println(e + ": Error while loading anim data ");
                }
                System.gc();
            }
            this.setPalette(0);
        }
        catch (Exception e) {
            System.out.println(e + ": Error while loading input stream image");
        }
        System.gc();
    }

    void setPalette(int palette) {
        if (palette >= this._pal.length) {
            return;
        }
        if (this._pal_current != this._pal[palette] && this._precalc_images_pal != null) {
            if (this._precalc_images_pal[palette] == null) {
                int size = this._modules == null ? this._data_offset_size : this._module_count;
                this._precalc_images_pal[palette] = new Image[size];
            }
            this._precalc_images = this._precalc_images_pal[palette];
        }
        this._pal_current = this._pal[palette];
    }

    void setPalette(int[] pal, int[][] pal_ext) {
        if (pal == null) {
            return;
        }
        this._pal_current = pal;
        this._precalc_images = null;
    }

    void enablePrecalcImage() {
        if (this._precalc_images_pal == null) {
            this._precalc_images_pal = new Image[this._pal.length][];
        }
        this._pal_current = null;
        this.setPalette(0);
    }

    void precalcAllImages(boolean reset_after_precalc, int user_flags) {
        this.enablePrecalcImage();
        for (int i = 0; i < this._data_offset_size; ++i) {
            this.precalcImage(i, 0);
            int flags = user_flags;
            if (this._aframes != null) {
                int f = this._aframes[i * 5 + 1] & 0xF8;
                flags = 0;
                if ((f & 0x40) != 0) {
                    flags |= 0x40;
                }
                if ((f & 0x20) != 0) {
                    flags |= 0x80;
                }
                flags = user_flags ^ flags;
            }
            if ((flags & 0x80) != 0) {
                System.gc();
                this.precalcImage(i, 128);
            }
            if ((flags & 0x40) != 0) {
                System.gc();
                this.precalcImage(i, 64);
            }
            if ((flags & 0xC0) == 0) continue;
            System.gc();
            this.precalcImage(i, 192);
        }
        System.gc();
        if (reset_after_precalc) {
            this.resetAfterPrecalc();
        }
    }

    void removePrecalcImgPals() {
        for (int i = 0; i < this._precalc_images_pal.length; ++i) {
            this._precalc_images_pal[i] = null;
        }
        this._precalc_images_pal = null;
        this._precalc_images = null;
    }

    void resetAfterPrecalc() {
        this._data = null;
        this._pal = null;
        this._pal_current = null;
        this._data_offset = null;
        _buffer = null;
        this.removePrecalcImgPals();
        System.gc();
    }

    void removeUnusedPrecalc() {
        if (this._precalc_images == null) {
            return;
        }
        this._precalc_images_pal = null;
        this._precalc_images = null;
    }

    void precalcImage(int frame, int flags) {
        this.initSize(frame);
        if (this._modules == null) {
            this.buildRLE8bfrm(frame, _width * _height);
            this._precalc_images[frame] = Image.createRGBImage((int[])_buffer, (int)_width, (int)_height, ((this._flags & 0x10000L) != 0L ? 1 : 0) != 0);
        } else {
            this.buildRLE8bfrm(frame, (this._modules[frame * 2 + 0] & 0xFF) * (this._modules[frame * 2 + 1] & 0xFF));
            this._precalc_images[frame] = Image.createRGBImage((int[])_buffer, (int)(this._modules[frame * 2 + 0] & 0xFF), (int)(this._modules[frame * 2 + 1] & 0xFF), (boolean)true);
        }
    }

    void resetScale(int anim) {
        _int2 = (this._refModules[this._frames_start[this.getFrame(anim, 0)] * 4 + 0] & 0xFF) + ((this._refModules[this._frames_start[this.getFrame(anim, 0)] * 4 + 1] & 0x1F) << 8);
        this._precalc_images[Sprite._int2] = null;
        for (int _int3 = 0; _int3 < this._scaled.length; ++_int3) {
            this._scaled[_int3]._precalc_images[Sprite._int2] = null;
        }
    }

    Sprite(Sprite parent, int scale, int color) {
        this._flags = parent._flags;
        this._data_offset_size = parent._data_offset_size;
        this._frames_width = new byte[parent._frames_width.length];
        this._frames_height = new byte[parent._frames_width.length];
        this._frames_start = new short[parent._frames_width.length];
        this._frames_size = new byte[parent._frames_width.length];
        System.arraycopy(parent._frames_start, 0, this._frames_start, 0, this._frames_width.length);
        System.arraycopy(parent._frames_size, 0, this._frames_size, 0, this._frames_width.length);
        for (_int1 = 0; _int1 < this._frames_width.length; ++_int1) {
            this._frames_width[Sprite._int1] = (byte)((parent._frames_width[_int1] & 0xFF) * scale >> 8);
            this._frames_height[Sprite._int1] = (byte)((parent._frames_height[_int1] & 0xFF) * scale >> 8);
            if ((this._frames_width[_int1] & 0xFF) < 1) {
                this._frames_width[Sprite._int1] = 1;
            }
            if ((this._frames_height[_int1] & 0xFF) >= 1) continue;
            this._frames_height[Sprite._int1] = 1;
        }
        this._modules = new byte[parent._module_count * 2];
        this._module_count = parent._module_count;
        for (_int1 = 0; _int1 < this._module_count; ++_int1) {
            for (_int2 = 0; _int2 < 2; ++_int2) {
                this._modules[Sprite._int1 * 2 + Sprite._int2] = (byte)(parent._modules[_int1 * 2 + _int2] * scale >> 8);
            }
        }
        this._refModules = new byte[parent._refModule_count * 4];
        this._refModule_count = parent._refModule_count;
        System.arraycopy(parent._refModules, 0, this._refModules, 0, this._refModules.length);
        for (_int1 = 0; _int1 < this._refModule_count; ++_int1) {
            this._refModules[Sprite._int1 * 4 + 2] = (byte)(this._refModules[_int1 * 4 + 2] * scale >> 8);
            this._refModules[Sprite._int1 * 4 + 3] = (byte)(this._refModules[_int1 * 4 + 3] * scale >> 8);
        }
        this._precalc_images = new Image[this._module_count];
        int old_pal = 0;
        if (color != 0) {
            for (_int1 = 0; _int1 < parent._pal.length; ++_int1) {
                if (parent._pal[_int1] != parent._pal_current) continue;
                old_pal = _int1;
                break;
            }
            this._pal_current = new int[parent._pal[0].length];
            _int2 = scale * 3 / 2;
            if (_int2 > 100) {
                _int2 = 100;
            }
            for (_int1 = 0; _int1 < this._pal_current.length; ++_int1) {
                this._pal_current[Sprite._int1] = cGame.colorGradient(color & 0xFFFFFF | parent._pal[0][_int1] & 0xFF000000, parent._pal[0][_int1], _int2);
            }
            parent.setPalette(this._pal_current, null);
        }
        for (_int1 = 0; _int1 < this._module_count; ++_int1) {
            int size = parent._modules[_int1 * 2 + 0] * parent._modules[_int1 * 2 + 1];
            parent.buildRLE8bfrm(_int1, size);
            if (this._modules[_int1 * 2 + 0] < 1) {
                this._modules[Sprite._int1 * 2 + 0] = 1;
            }
            if (this._modules[_int1 * 2 + 1] < 1) {
                this._modules[Sprite._int1 * 2 + 1] = 1;
            }
            block7: for (_int2 = 0; _int2 < this._modules[_int1 * 2 + 1]; ++_int2) {
                for (_int3 = 0; _int3 < this._modules[_int1 * 2 + 0]; ++_int3) {
                    int offset = (_int2 << 8) / scale * parent._modules[_int1 * 2 + 0] + (_int3 << 8) / scale;
                    if (offset > size) {
                        System.out.println("overflow");
                        continue block7;
                    }
                    Sprite._buffer[Sprite._int2 * this._modules[Sprite._int1 * 2 + 0] + Sprite._int3] = _buffer[offset];
                }
            }
            this._precalc_images[Sprite._int1] = Image.createRGBImage((int[])_buffer, (int)this._modules[_int1 * 2 + 0], (int)this._modules[_int1 * 2 + 1], (boolean)true);
        }
        if (color != 0) {
            parent.setPalette(old_pal);
        }
    }

    void setGlobalAlpha(int pal, int alpha) {
        int pal_pos = this._pal[pal].length;
        for (int i = 0; i < pal_pos; ++i) {
            if ((this._pal[pal][i] & 0xFF000000) == 0) continue;
            this._pal[pal][i] = this._pal[pal][i] & 0xFFFFFF | alpha << 24;
        }
    }

    static final void setGraphics(Graphics g) {
        _g = g;
    }

    void setPaletteColor(int palette, int color_index, int color) {
        this._pal_current = null;
        this._precalc_images_pal[palette] = null;
        this._pal[palette][color_index] = color;
        this.setPalette(palette);
    }

    static final int transform(int flags) {
        switch (flags & 0xC0) {
            case 192: {
                return 3;
            }
            case 128: {
                return 2;
            }
            case 64: {
                return 1;
            }
        }
        return 0;
    }
}

