/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Cache;
import cocos2d.extensions.cc3d.CC3Math;
import cocos2d.extensions.cc3d.CC3Node;
import cocos2d.extensions.cc3d.CC3Renderer;
import cocos2d.extensions.cc3d.CC3Utils;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.VertexBuffer;

public class CC3Mesh
extends CC3Node {
    public String filename;
    public int filenameId;
    protected Node[] a = new Node[2];
    public int lodLevels = 1;
    public int currentLod = -2;
    public int lodDistance = 180;
    public int hideDistance = this.lodDistance * 10;

    public static CC3Mesh meshWithFile(String string, String string2) {
        return new CC3Mesh(string, CC3Utils.GenerateID(string2));
    }

    public static CC3Mesh meshWithFile(String string, int n2) {
        return new CC3Mesh(string, n2);
    }

    public static CC3Mesh meshWithMesh(String string, int n2, Mesh object) {
        object = new CC3Mesh((Mesh)object);
        v0.filename = string;
        object.filenameId = n2;
        return object;
    }

    protected CC3Mesh() {
    }

    private CC3Mesh(Mesh mesh) {
        this.m3gObject = mesh;
        this.m3gObject.setScale(1.0f, 1.0f, 1.0f);
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.a[0] = this.m3gObject;
    }

    public CC3Mesh(VertexBuffer vertexBuffer, IndexBuffer[] indexBufferArray, Appearance[] appearanceArray) {
        this.m3gObject = new Mesh(vertexBuffer, indexBufferArray, appearanceArray);
        this.m3gObject.setScale(1.0f, 1.0f, 1.0f);
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.a[0] = this.m3gObject;
    }

    public CC3Mesh(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance) {
        this.m3gObject = new Mesh(vertexBuffer, indexBuffer, appearance);
        this.m3gObject.setScale(1.0f, 1.0f, 1.0f);
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.a[0] = this.m3gObject;
    }

    public CC3Mesh(String string, int n2) {
        this.filename = string;
        this.filenameId = n2;
        this.m3gObject = new Mesh(((Mesh)CC3Cache.get(string, n2)).getVertexBuffer(), CC3Utils.getIndexBuffers((Mesh)CC3Cache.get(string, n2)), CC3Utils.getAppearances((Mesh)CC3Cache.get(string, n2)));
        this.m3gObject.setScale(1.0f, 1.0f, 1.0f);
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.a[0] = this.m3gObject;
        string = this.filename.substring(0, this.filename.length() - 4).concat("_hd.m3g");
        if (CC3Cache.get(string, n2) != null) {
            this.lodLevels = 2;
            this.a[1] = new Mesh(((Mesh)CC3Cache.get(string, n2)).getVertexBuffer(), CC3Utils.getIndexBuffers((Mesh)CC3Cache.get(string, n2)), CC3Utils.getAppearancesPointer((Mesh)this.m3gObject));
            this.a[1].setScale(1.0f, 1.0f, 1.0f);
        }
    }

    public void removeFromCache() {
        CC3Cache.remove(this.filename, this.filenameId);
    }

    public void update(float f2, CC3Renderer cC3Renderer) {
        if (this.lodLevels > 1) {
            int n2 = CC3Math.distance_squared((int)(cC3Renderer.camera.position.x - this.position.x), (int)(cC3Renderer.camera.position.z - this.position.z));
            if (n2 < this.lodDistance) {
                this.switchToLod(1);
            } else if (n2 < this.hideDistance) {
                this.switchToLod(0);
            } else {
                this.switchToLod(-1);
            }
        }
        super.update(f2, cC3Renderer);
    }

    public void switchToLod(int n2) {
        if (this.currentLod == n2) {
            return;
        }
        this.currentLod = n2;
        if (n2 == -1) {
            this.m3gObject.setRenderingEnable(false);
            return;
        }
        Node node = this.a[n2];
        Group group = (Group)this.m3gObject.getParent();
        group.removeChild(this.m3gObject);
        group.addChild(node);
        node.setRenderingEnable(this.visible);
        this.m3gObject = node;
        this.objTransform.isUpdated = true;
    }

    public void setTexture(Texture2D texture2D) {
        int n2 = ((Mesh)this.m3gObject).getSubmeshCount();
        while (n2-- != 0) {
            this.setTexture(n2, texture2D);
        }
    }

    public void setTexture(int n2, Texture2D texture2D) {
        this.getAppearance(n2).setTexture(0, texture2D);
    }

    public void setTexture(String string) {
        int n2 = ((Mesh)this.m3gObject).getSubmeshCount();
        while (n2-- != 0) {
            this.setTexture(n2, string);
        }
    }

    public void setTexture(Image image) {
        int n2 = ((Mesh)this.m3gObject).getSubmeshCount();
        while (n2-- != 0) {
            this.setTexture(n2, image);
        }
    }

    public void setFog(Fog fog) {
        int n2 = ((Mesh)this.m3gObject).getSubmeshCount();
        while (n2-- != 0) {
            this.getAppearance(n2).setFog(fog);
        }
    }

    public void setAppearance(int n2, Appearance appearance) {
        ((Mesh)this.m3gObject).setAppearance(n2, appearance);
    }

    public Appearance getAppearance(int n2) {
        return ((Mesh)this.m3gObject).getAppearance(n2);
    }

    public void setTexture(int n2, Image image) {
        try {
            Appearance appearance = (Appearance)this.getAppearance(n2).duplicate();
            if (image != null) {
                appearance.setTexture(0, new Texture2D(new Image2D(100, (Object)image)));
            } else {
                appearance.setTexture(0, null);
            }
            this.setAppearance(n2, appearance);
            return;
        }
        catch (Exception exception) {
            cocos2d.CCLog("cannot set " + image + " as texture to submesh " + n2 + ": " + exception.toString());
            return;
        }
    }

    public void setTexture(int n2, String string) {
        try {
            Appearance appearance = (Appearance)this.getAppearance(n2).duplicate();
            if (string != null) {
                appearance.setTexture(0, (Texture2D)CC3Cache.get(string, n2, this.isTransparent));
            } else {
                appearance.setTexture(0, null);
            }
            this.setAppearance(n2, appearance);
            return;
        }
        catch (Exception exception) {
            cocos2d.CCLog("cannot set " + string + " as texture to submesh " + n2 + ": " + exception.toString());
            return;
        }
    }

    public void setAlpha(int n2) {
        if (n2 > 255) {
            n2 = 255;
        } else if (n2 < 0) {
            n2 = 0;
        }
        CompositingMode compositingMode = null;
        int n3 = ((Mesh)this.m3gObject).getSubmeshCount();
        while (n3-- != 0) {
            CompositingMode compositingMode2 = this.getAppearance(n3).getCompositingMode();
            if (compositingMode2 == null) {
                if (compositingMode == null) {
                    compositingMode = new CompositingMode();
                }
                compositingMode2 = compositingMode;
            }
            if (n2 == 255) {
                this.m3gObject.setRenderingEnable(this.visible);
                compositingMode2.setBlending(68);
            } else if (n2 <= 0) {
                this.m3gObject.setRenderingEnable(false);
            } else {
                this.m3gObject.setRenderingEnable(this.visible);
                compositingMode2.setBlending(64);
            }
            this.getAppearance(n3).setCompositingMode(compositingMode2);
        }
        super.setAlpha(n2);
    }

    public CC3Node duplicate() {
        CC3Mesh cC3Mesh = new CC3Mesh();
        for (int i2 = 0; i2 < this.lodLevels; ++i2) {
            cC3Mesh.a[i2] = (Mesh)this.a[i2].duplicate();
        }
        cC3Mesh.filename = this.filename;
        cC3Mesh.filenameId = this.filenameId;
        cC3Mesh.m3gObject = cC3Mesh.a[0];
        cC3Mesh.scale.set(this.scale);
        cC3Mesh.position.set(this.position);
        cC3Mesh.viewVector.set(this.viewVector);
        cC3Mesh.sideVector.set(this.sideVector);
        cC3Mesh.upVector.set(this.upVector);
        cC3Mesh.objTransform.set(this.objTransform);
        cC3Mesh.lodLevels = this.lodLevels;
        cC3Mesh.lodDistance = this.lodDistance;
        cC3Mesh.isTransparent = this.isTransparent;
        return cC3Mesh;
    }

    public String toString() {
        return super.toString() + ":" + this.filename + ":" + this.filenameId;
    }
}

