/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Event {
    public static final int TYPE_BODY_POSITION = 0;
    public static final int TYPE_BODY_VELOCITY = 1;
    public static final int TYPE_BODY_ROTATION = 2;
    public static final int TYPE_BODY_ANGULARVELOCITY = 3;
    public static final int TYPE_BODY_COLLISION = 4;
    public static final int TYPE_BODY_COLLISION_RELATIVE = 6;
    public static final int TYPE_BODY_SENSOR = 5;
    public static final int TYPE_CONSTRAINT_FORCE = 10;
    private int b;
    int a = -1;
    private boolean c = false;
    private int d;
    private int e;
    private int f;
    private int g;
    private Object h;
    private Body i;
    private Shape j;
    private Constraint k;
    private Script l;
    private Vector m = null;
    private UserData n = null;
    private static FXMatrix o = new FXMatrix();
    private static FXVector p = new FXVector();
    private static FXVector q = new FXVector();

    public static Event createBodyEvent(Body body, Shape shape, int n2, int n3, int n4, int n5, int n6) {
        return new Event(body, shape, null, n2, n3, n4, n5, n6, null);
    }

    public static Event createCollisionRelativeEvent(Body body, Shape shape, int n2, int n3) {
        long l2 = (long)n2 * 52707178L / 180L;
        n2 = FXUtil.wrapAngleFX((int)((long)n3 * 52707178L / 180L - l2) / 2);
        n2 = FXUtil.wrapAngleFX((int)(l2 + (long)n2));
        o.setRotationMatrix(n2);
        o.mult(FXVector.M_UNITY, p);
        o.setRotationMatrix((int)l2);
        o.mult(FXVector.M_UNITY, q);
        n3 = (int)((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12);
        return new Event(body, shape, null, 6, n2, n3, 0, 0, null);
    }

    public static Event createBodySensorEvent(Body body, Shape shape, Body body2) {
        body2.a(0);
        return new Event(body, shape, null, 5, 0, 0, 0, 0, body2);
    }

    public static Event createConstraintEvent(Constraint constraint, int n2, int n3, int n4) {
        return new Event(null, null, constraint, n2, n3, n4, 0, 0, null);
    }

    private Event(Body body, Shape shape, Constraint constraint, int n2, int n3, int n4, int n5, int n6, Object object) {
        this.a = -1;
        this.b = n2;
        this.h = object;
        switch (n2) {
            case 2: 
            case 3: {
                this.d = n3 * 52707178 / 180;
                this.e = n4 * 52707178 / 180;
                break;
            }
            case 1: {
                this.d = n3 * n3 << 12;
                this.e = n4 * n4 << 12;
                break;
            }
            case 6: {
                this.d = n3;
                this.e = n4;
                break;
            }
            default: {
                this.d = n3 << 12;
                this.e = n4 << 12;
                this.f = n5 << 12;
                this.g = n6 << 12;
            }
        }
        this.i = body;
        this.j = shape;
        this.k = constraint;
    }

    private Event(Event event, Body[] bodyArray) {
        this(bodyArray != null && event.i != null ? bodyArray[event.i.o] : event.i, event.j, event.k, event.b, 0, 0, 0, 0, event.h != null && event.h instanceof Body && bodyArray != null && ((Body)event.h).o >= 0 ? bodyArray[((Body)event.h).o] : event.h);
        this.d = event.d;
        this.e = event.e;
        this.f = event.f;
        this.g = event.g;
        if (event.n != null) {
            this.n = event.n.copy();
        }
        this.setTriggerOnce(event.c);
    }

    private Event(int n2) {
        this.b = n2;
    }

    public Event copy(Body[] bodyArray) {
        return new Event(this, bodyArray);
    }

    public static Event loadEvent(PhysicsFileReader physicsFileReader, World world, UserData userData) {
        int n2;
        int n3 = physicsFileReader.next();
        int n4 = physicsFileReader.getVersion();
        if ((n4 & 0xFF00) < 1024) {
            physicsFileReader.next();
        }
        Event event = new Event(n3);
        if ((n4 & 0xFF00) >= 1024) {
            event.setTriggerOnce(physicsFileReader.next() > 0);
        }
        if ((n2 = physicsFileReader.next()) >= 0 && n2 != 255) {
            event.i = world.getBodies()[n2];
        }
        if ((n2 = physicsFileReader.next()) >= 0 && n2 != 255) {
            event.j = (Shape)world.getShapeSet().getShapes().elementAt(n2);
        }
        if ((n4 & 0xFF00) >= 1024 && (n4 = physicsFileReader.next()) >= 0 && n4 != 255) {
            event.k = world.getConstraints()[n4];
        }
        event.d = physicsFileReader.nextIntFX();
        event.e = physicsFileReader.nextIntFX();
        event.f = physicsFileReader.nextIntFX();
        event.g = physicsFileReader.nextIntFX();
        if (event.b == 5) {
            Body body = Body.loadBody(physicsFileReader, world.a.getShapes(), userData);
            event.h = body;
        }
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                event.n = userData.createNewUserData(string, 3);
            }
        }
        return event;
    }

    public int getIdentifier() {
        return this.a;
    }

    public int type() {
        return this.b;
    }

    public void setScript(Script script) {
        this.l = script;
    }

    public void setBodyFilter(Body body) {
        this.i = body;
    }

    public Body getBodyFilter() {
        return this.i;
    }

    public void setShapeFilter(Shape shape) {
        this.j = shape;
    }

    public Shape getShapeFilter() {
        return this.j;
    }

    public Object getTargetObject() {
        return this.h;
    }

    public Constraint getConstraintFilter() {
        return this.k;
    }

    public void setTriggerOnce(boolean bl) {
        this.c = bl;
        if (bl) {
            this.m = new Vector();
            return;
        }
        this.m = null;
    }

    public boolean getTriggerOnce() {
        return this.c;
    }

    public boolean checkEvent(World world, PhysicsEventListener physicsEventListener) {
        if (physicsEventListener == null) {
            return false;
        }
        boolean bl = false;
        switch (this.b) {
            case 10: {
                if (this.k != null) {
                    bl = this.a(this.k, physicsEventListener);
                    break;
                }
                for (int i2 = 0; i2 < world.h; ++i2) {
                    bl |= this.a(world.i[i2], physicsEventListener);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                for (int i3 = 0; i3 < world.b; ++i3) {
                    bl |= this.a(world, world.c[i3], physicsEventListener);
                }
                break;
            }
            case 5: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                Body[] bodyArray = world.c;
                Body body = (Body)this.h;
                for (int i4 = 0; i4 < world.b; ++i4) {
                    if (!bodyArray[i4].e || bodyArray[i4].l > body.m || body.l > bodyArray[i4].m || bodyArray[i4].j > body.k || body.j > bodyArray[i4].k) continue;
                    bl |= this.a(world, bodyArray[i4], physicsEventListener);
                }
                break;
            }
        }
        return bl;
    }

    private final boolean a(World world, Body body, PhysicsEventListener physicsEventListener) {
        if (this.j != null && body.h != this.j) {
            return false;
        }
        Object object = null;
        boolean bl = false;
        block0 : switch (this.b) {
            case 0: {
                if (this.d > body.a.xFX || body.a.xFX > this.f || this.e > body.a.yFX || body.a.yFX > this.g) break;
                bl = true;
                object = body;
                break;
            }
            case 1: {
                int n2 = body.b.lengthSquareFX();
                if (this.d > n2 || n2 > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 2: {
                if (this.d > body.c || body.c > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 3: {
                if (this.d > body.d || body.d > this.e) break;
                bl = true;
                object = body;
                break;
            }
            case 4: {
                Contact[] contactArray = body.getContacts();
                for (int i2 = 0; i2 < contactArray.length && contactArray[i2] != null; ++i2) {
                    if (!(this.d > 0 && contactArray[i2].e.yFX < body.a.yFX || this.e > 0 && contactArray[i2].e.xFX > body.a.xFX || this.f > 0 && contactArray[i2].e.yFX > body.a.yFX) && (this.g <= 0 || contactArray[i2].e.xFX >= body.a.xFX)) continue;
                    bl = true;
                    object = contactArray[i2];
                    break block0;
                }
                break;
            }
            case 6: {
                int n3 = FXUtil.wrapAngleFX(this.d + body.rotation2FX());
                o.setRotationMatrix(n3);
                o.mult(FXVector.M_UNITY, p);
                Contact[] contactArray = body.getContacts();
                for (n3 = 0; n3 < contactArray.length && contactArray[n3] != null; ++n3) {
                    q.assignDiff(body.a, contactArray[n3].e);
                    q.normalize();
                    if ((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12 >= (long)this.e) {
                        bl = true;
                        object = contactArray[n3];
                        break block0;
                    }
                    if (contactArray[n3].isSingle()) continue;
                    q.assignDiff(body.a, contactArray[n3].f);
                    q.normalize();
                    if ((long)Event.p.xFX * (long)Event.q.xFX + (long)Event.p.yFX * (long)Event.q.yFX >> 12 < (long)this.e) continue;
                    bl = true;
                    object = contactArray[n3];
                    break block0;
                }
                break;
            }
            case 5: {
                if (Collision.detectCollision(body, (Body)this.h) == null) break;
                bl = true;
                object = body;
            }
        }
        if (bl) {
            if (!this.c || this.a(object)) {
                if (this.l == null) {
                    physicsEventListener.eventTriggered(this, object);
                } else {
                    this.l.applyToBody(body, world);
                }
            }
        } else if (this.c) {
            this.b(object);
        }
        return bl;
    }

    private final boolean a(Constraint constraint, PhysicsEventListener physicsEventListener) {
        switch (this.b) {
            case 10: {
                int n2 = constraint.getImpulseFX();
                if (this.d <= n2 && n2 <= this.e) {
                    if (!this.c || this.a(constraint)) {
                        physicsEventListener.eventTriggered(this, constraint);
                    }
                    return true;
                }
                if (!this.c) break;
                this.b(constraint);
            }
        }
        return false;
    }

    private boolean a(Object object) {
        if (this.m.contains(object)) {
            return false;
        }
        this.m.addElement(object);
        return true;
    }

    private void b(Object object) {
        this.m.removeElement(object);
    }

    public UserData getUserData() {
        return this.n;
    }

    public void setUserData(UserData userData) {
        this.n = userData;
    }
}

