/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu
extends TXCanvas
implements CommandListener {
    public static final int IDC_STARTGAME = 0;
    public static final int IDC_OPTIONS = 1;
    public static final int IDC_EXIT = 2;
    public static final int IDC_NEWGAME = 3;
    public static final int IDC_SELECTLEVEL = 4;
    public static final int IDC_LEVEL1 = 5;
    public static final int IDC_LEVEL2 = 6;
    public static final int IDC_LEVEL3 = 7;
    public static final int IDC_ABOUT = 8;
    public static final int IDC_CREDITS = 9;
    public static final int IDC_CONTINUE = 10;
    public static final int IDC_RESTART = 11;
    public static final int IDC_EXITMENU = 12;
    public static final int IDC_HIGHSCORE = 13;
    public static final int IDC_HELP = 14;
    public static final int IDC_DIFFICULTY = 15;
    public static final int IDC_NORMAL = 16;
    public static final int IDC_ADVANCED = 17;
    public static final int IDC_XXXTREME = 18;
    public static final int IDC_RECORD1 = 19;
    public static final int IDC_RECORD2 = 20;
    public static final int IDC_RECORD3 = 21;
    public static final int IDC_RECORD0 = 22;
    public static final int IDC_FULLGAME = 23;
    public static final int IDC_LEVELS = 24;
    public static final int IDC_EXITBACK = 25;
    public static final int IDC_INGAMEHELP = 26;
    private static Command[] commands1 = new Command[]{new Command("EXIT", 7, 2), new Command("SELECT", 8, 1)};
    private static Command[] commands2 = new Command[]{new Command("BACK", 2, 2), new Command("SELECT", 8, 1)};
    public Item[] menuItems;
    private Item[] nextItems;
    public Item[] mainMenuItems;
    public Item[] ingameMenuItems;
    public Item[] stMenuItems;
    private int callID = -1;
    private static Menu instance = new Menu();
    private int menuItemsY;
    private int menuItemsX;
    private int menuHeaderX;
    private int menuHeaderY;
    private int flag;
    private final int mIVS;
    private final int menuItemsHSpeed;
    private final int mHVS;
    private final int menuHeaderHSpeed;
    private long timeToPressNine;
    private boolean starPressed = false;
    private boolean eraseBkgnd = true;
    private boolean initialized = false;

    public static Menu getInstance() {
        return instance;
    }

    public Menu() {
        this.mIVS = 512;
        this.menuItemsHSpeed = 512;
        this.mHVS = 64;
        this.menuHeaderHSpeed = 512;
        Item[] itemArray = new Item[]{new Item(0, 93, 185, 0, 0), new Item(0, 66, 132, 1, 1), new Item(0, 37, 73, 2, 14), new Item(132, 165, 196, 1, 2)};
        Item[] itemArray2 = new Item[]{new Item(82, 146, 210, 3, 3), new Item(0, 81, 160, 4, 4), new Item(0, 78, 156, 7, 13), new Item(102, 128, 153, 6, 25)};
        Item[] itemArray3 = new Item[]{new Item(0, 115, 228, 11, 5), new Item(0, 112, 222, 12, 6), new Item(0, 102, 202, 13, 7)};
        Item[] itemArray4 = new Item[]{new Item(0, 115, 228, 11, 19), new Item(0, 112, 222, 12, 20), new Item(0, 102, 202, 13, 21)};
        Item[] itemArray5 = new Item[]{new Item(136, 187, 238, 8, 16), new Item(0, 67, 130, 9, 17), new Item(0, 64, 126, 10, 18)};
        Item[] itemArray6 = new Item[]{new Item(0, 68, 136, 8, 15), new Item(0, 42, 82, 3, 8)};
        Item[] itemArray7 = new Item[]{new Item(0, 61, 120, 5, 10), new Item(0, 52, 102, 6, 11), new Item(121, 153, 184, 5, 26), new Item(102, 129, 153, 6, 12)};
        Item[] itemArray8 = new Item[]{new Item(0, 67, 129, 14, 23), new Item(0, 43, 83, 16, 24)};
        itemArray[0].xH = 0;
        itemArray[0].wH = 92;
        itemArray[0].numberH = 0;
        itemArray[1].xH = 0;
        itemArray[1].wH = 67;
        itemArray[1].numberH = 1;
        itemArray2[1].xH = 0;
        itemArray2[1].wH = 81;
        itemArray2[1].numberH = 4;
        itemArray2[2].xH = 0;
        itemArray2[2].wH = 78;
        itemArray2[2].numberH = 7;
        itemArray8[1].xH = 0;
        itemArray8[1].wH = 78;
        itemArray8[1].numberH = 7;
        itemArray6[0].xH = 0;
        itemArray6[0].wH = 68;
        itemArray6[0].numberH = 8;
        itemArray8[0].parent = itemArray2;
        itemArray2[0].parent = itemArray;
        itemArray3[0].parent = itemArray2;
        itemArray6[0].parent = itemArray;
        itemArray5[0].parent = itemArray6;
        itemArray4[0].parent = itemArray8;
        itemArray[0].children = itemArray2;
        itemArray[1].children = itemArray6;
        itemArray2[1].children = itemArray3;
        itemArray6[0].children = itemArray5;
        itemArray2[2].children = itemArray8;
        itemArray8[1].children = itemArray4;
        this.mainMenuItems = itemArray;
        this.ingameMenuItems = itemArray7;
        this.stMenuItems = itemArray2;
        this.menuItems = itemArray;
    }

    protected int getItemsHeight() {
        if (TripleX.imageItems[0] == null) {
            return this.menuItems.length * 16;
        }
        return this.menuItems.length * (TripleX.imageItems[this.menuItems[0].image].getHeight() + 4);
    }

    protected void onStart() {
        this.menuItemsX = 0;
        this.menuItemsY = 256 * (this.getHeight() + this.getItemsHeight());
        this.menuHeaderX = -this.getWidth() * 128;
        this.flag = ~this.flag & 1;
        this.menuHeaderX = -this.getWidth() * 128;
        this.menuHeaderY = 0;
        this.timeToPressNine = System.currentTimeMillis() - 4000L;
        if (this.menuItems[0].ID == 16) {
            this.menuItems[0].selected = TripleX.difLevel;
        }
    }

    protected void onInit() {
        TripleX tripleX = TripleX.getInstance();
        this.initialized = true;
    }

    protected void onDone() {
        this.initialized = false;
        TripleX tripleX = TripleX.getInstance();
        if (tripleX != null) {
            // empty if block
        }
    }

    protected void onPaint(Graphics graphics) {
        int n;
        Object object;
        if (!this.initialized) {
            return;
        }
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(TripleX.imageMenu, this.getWidth() / 2, 3, 17);
        int n6 = this.menuItems[0].selected;
        int n7 = this.menuItemsY / 256;
        int n8 = 0;
        while (n8 < this.menuItems.length) {
            int n9;
            int n10;
            int n11;
            Item item = this.menuItems[n8];
            object = TripleX.imageItems[item.image];
            n = this.menuItemsX / 256;
            if ((n8 & 1) == this.flag) {
                n = -n;
            }
            if (n6 == n8) {
                n11 = item.wS;
                n10 = item.xS;
            } else {
                n11 = item.wN;
                n10 = item.xN;
            }
            if (TripleX.maxLevel < 2 && item.ID == 4) {
                n11 = 81;
                n10 = 0;
                n9 = n + (this.getWidth() - n11) / 2;
                Image image = TripleX.imageItems[15];
                graphics.setClip(n9, n7, n11, image.getHeight());
                graphics.drawImage(image, n9 - n10, n7, 20);
            } else {
                n9 = n + (this.getWidth() - n11) / 2;
                graphics.setClip(n9, n7, n11, object.getHeight());
                graphics.drawImage(object, n9 - n10, n7, 20);
            }
            n7 += object.getHeight() + 4;
            ++n8;
        }
        if (this.menuItems[0].parent != null) {
            int n12 = 12;
            if (this.menuItems[0].ID == 23 || this.menuItems[0].ID == 19) {
                graphics.setClip(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), 33);
                n12 = 4;
                object = Font.getFont((int)32, (int)0, (int)8);
                graphics.setFont((Font)object);
                graphics.drawString("menuItemsX " + this.menuItemsX / 256, 0, 0, 0x10 | 4);
                graphics.setColor(0xFFFFFF);
                if (this.menuItems[0].ID == 23) {
                    graphics.drawString("Select full game", this.getWidth() / 2, 21, 0x10 | 1);
                    graphics.drawString("or separate levels", this.getWidth() / 2, 34, 0x10 | 1);
                } else {
                    graphics.drawString("Select a level", this.getWidth() / 2, 21, 0x10 | 1);
                    graphics.drawString("to view scores", this.getWidth() / 2, 34, 0x10 | 1);
                }
            }
            object = this.menuItems[0].parent[this.menuItems[0].parent[0].selected];
            if (object.xH != -1) {
                n = this.menuHeaderX / 256 + (this.getWidth() - object.wH) / 2;
                Image image = TripleX.imageItems[object.numberH];
                graphics.setClip(n, n12, object.wH, image.getHeight());
                graphics.drawImage(image, n - object.xH, n12 + this.menuHeaderY / 256, 20);
            }
        }
        graphics.setClip(n2, n3, n4, n5);
        this.eraseBkgnd = true;
    }

    protected void keyPressed(int n) {
        switch (this.getKeyAction(n)) {
            case 1: {
                int n2 = this.menuItems[0].selected;
                do {
                    if (--n2 >= 0) continue;
                    n2 = this.menuItems.length - 1;
                } while (TripleX.maxLevel < 2 && this.menuItems[n2].ID == 4);
                this.menuItems[0].selected = n2;
                this.eraseBkgnd = false;
                this.repaint();
                break;
            }
            case 49: {
                this.menuItems[0].selected = 0;
                this.eraseBkgnd = false;
                this.repaint();
                this.goNext();
                break;
            }
            case 50: {
                if (this.menuItems.length <= 1 || TripleX.maxLevel < 2 && this.menuItems[1].ID == 4) break;
                this.menuItems[0].selected = 1;
                this.eraseBkgnd = false;
                this.repaint();
                this.goNext();
                break;
            }
            case 51: {
                if (this.menuItems.length <= 2) break;
                this.menuItems[0].selected = 2;
                this.eraseBkgnd = false;
                this.repaint();
                this.goNext();
                break;
            }
            case 55: {
                if (this.timeToPressNine <= System.currentTimeMillis() || this.menuItems[this.menuItems[0].selected].ID != 3 || !this.starPressed) break;
                this.clearCommands();
                if (this.nextItems == null) {
                    this.callID = 7;
                }
                this.step();
                this.repaint();
                break;
            }
            case 57: {
                if (this.timeToPressNine > System.currentTimeMillis()) {
                    if (this.starPressed) {
                        if (this.menuItems[this.menuItems[0].selected].ID != 3) break;
                        this.clearCommands();
                        if (this.nextItems == null) {
                            this.callID = 6;
                        }
                        this.step();
                        this.repaint();
                        break;
                    }
                    this.timeToPressNine = System.currentTimeMillis() + 5000L;
                    break;
                }
                this.timeToPressNine = System.currentTimeMillis() + 5000L;
                break;
            }
            case 48: {
                if (this.timeToPressNine <= System.currentTimeMillis() || this.menuItems[this.menuItems[0].selected].ID != 3) break;
                this.starPressed = true;
                break;
            }
            case 52: {
                if (this.menuItems.length <= 3) break;
                this.menuItems[0].selected = 3;
                this.eraseBkgnd = false;
                this.repaint();
                this.goNext();
                break;
            }
            case 6: {
                int n3 = this.menuItems[0].selected;
                do {
                    if (++n3 < this.menuItems.length) continue;
                    n3 = 0;
                } while (TripleX.maxLevel < 2 && this.menuItems[n3].ID == 4);
                this.menuItems[0].selected = n3;
                this.eraseBkgnd = false;
                this.repaint();
            }
        }
    }

    private void goNext() {
        this.nextItems = this.menuItems[this.menuItems[0].selected].children;
        if (this.nextItems == null) {
            if (this.menuItems[0].ID == 16) {
                this.nextItems = this.menuItems[0].parent;
                TripleX.difLevel = this.menuItems[0].selected;
            } else {
                this.callID = this.menuItems[this.menuItems[0].selected].ID;
            }
        } else if (this.nextItems[0].ID == 16) {
            this.nextItems[0].selected = TripleX.difLevel;
        }
        this.clearCommands();
        this.step();
        this.repaint();
    }

    private int getKeyAction(int n) {
        if (n == 50 || n == 52 || n == 53 || n == 51 || n == 49 || n == 55 || n == 54 || n == 57 || n == 48 || n == 35 || n == 56) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return n2;
    }

    protected void onTick(long l) {
        Item item;
        int n = 26;
        if (this.menuItems[0].parent != null && (item = this.menuItems[0].parent[this.menuItems[0].parent[0].selected]) != null && item.xH != -1) {
            n += TripleX.imageItems[0].getHeight();
        }
        int n2 = 256 * (n + (this.getHeight() - n - this.getItemsHeight()) / 2);
        if (this.nextItems == null && this.callID == -1 && (this.menuItemsY > n2 || this.menuHeaderX < 0)) {
            this.menuItemsY = (int)((long)this.menuItemsY - l * 512L * 256L / 1000L);
            this.menuHeaderX = (int)((long)this.menuHeaderX + l * 512L * 256L / 1000L);
            if (this.menuItemsY < n2) {
                this.menuItemsY = n2;
            }
            if (this.menuHeaderX > 0) {
                this.menuHeaderX = 0;
            }
            this.step();
            if (this.menuItemsY == n2 && this.menuHeaderX == 0) {
                this.updateCommands();
            }
        } else if (this.nextItems != null || this.callID != -1) {
            if (this.menuItemsX >= 256 * this.getWidth()) {
                if (this.callID != -1) {
                    this.exit(this.callID);
                    this.callID = -1;
                    return;
                }
                this.menuItems = this.nextItems;
                this.nextItems = null;
                this.onStart();
            } else {
                this.menuItemsX = (int)((long)this.menuItemsX + l * 512L * 256L / 1000L);
                this.menuHeaderY = (int)((long)this.menuHeaderY - l * 64L * 256L / 1000L);
                if (this.menuItemsY < n2) {
                    this.menuItemsY = n2;
                }
            }
            if (TripleX.getInstance() != null) {
                this.step();
            }
        }
        this.repaint();
    }

    void updateCommands() {
        Command[] commandArray = this.menuItems[0].parent == null && this.menuItems != this.ingameMenuItems ? commands1 : commands2;
        int n = 0;
        while (n < commandArray.length) {
            this.addCommand(commandArray[n]);
            ++n;
        }
        this.setCommandListener(this);
    }

    void clearCommands() {
        Command[] commandArray = this.menuItems[0].parent == null && this.menuItems != this.ingameMenuItems ? commands1 : commands2;
        int n = 0;
        while (n < commandArray.length) {
            this.removeCommand(commandArray[n]);
            ++n;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        boolean bl = false;
        switch (command.getCommandType()) {
            case 7: {
                this.callID = 2;
                bl = true;
                break;
            }
            case 8: {
                this.goNext();
                break;
            }
            case 2: {
                if (this.menuItems == this.ingameMenuItems) {
                    this.callID = 2;
                    bl = true;
                    break;
                }
                this.nextItems = this.menuItems[0].parent;
                if (this.nextItems == null) break;
                this.clearCommands();
                bl = true;
            }
        }
        if (bl) {
            this.step();
            this.repaint();
        }
    }

    public class Item {
        public int xN;
        public int wN;
        public int xS;
        public int wS;
        public Item[] children;
        public Item[] parent;
        public int image;
        public int selected;
        public int xH = -1;
        public int wH = -1;
        public int numberH = 0;
        public int ID = 0;

        public Item(int n, int n2, int n3, int n4, int n5) {
            this.xS = n;
            this.wS = n2 - n;
            this.xN = n2;
            this.wN = n3 - n2;
            this.image = n4;
            this.ID = n5;
        }
    }
}

