/*
 * Decompiled with CFR 0.152.
 */
package Coral.Util;

import Coral.Graphics2D.crlImagePacked;
import Coral.UI.crlUI;
import Coral.Util.cCacheProcObj;
import Coral.Util.cResProcessObj;
import Coral.Util.cStringLoaderProcObj;
import Coral.Util.crlBinArray;
import Coral.Util.crlInt;
import Coral.Util.crlManagerBase;
import Coral.Util.crlString;
import Coral.Util.crlUtil;
import Coral.crlCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class crlResourceManager
extends crlManagerBase {
    private static byte[] mScratchBuffer;
    private static String sSpongeName;
    private static int iUserScratchSize;
    private static int iObj3DBaseID;
    private static final byte[] _tempArray;
    private static int mScratchSize;
    private static String _pngExtension;
    private static String _resDirectory;
    private static String _spgExtension;
    private static String _binExtension;
    private static final int FNAME_BUFFER_LENGTH = 128;
    private static StringBuffer _mFnameBuffer;
    private long[] currentPack;
    private int currentPackPos;
    private InputStream mInputStream;
    private DataInputStream mDataStream;
    private boolean mCacheReady;
    private byte[] mCache;
    private cResProcessObj[] mProcObjMap;
    private static final int PROCOBJ_MARKER = -1;
    private static final int INITIAL_PROC_OBJS = 4;
    private static final byte EXTERNAL_REFERENCE = -128;
    private static final byte REMOVE_EXTERNAL_REFERENCE = 127;
    private static final byte ENCRYPTED_DATA = 64;
    private static final byte REMOVE_ENCRYPTED_DATA = -65;
    private boolean mEncrypted;
    private byte _mKey = (byte)22;
    private Hashtable mResource;
    private crlInt mIntObject;
    private static final int MAX_RETRIES = 3;
    private int mRetry;
    private long mPrevID = -1L;
    private int mCacheBytesRead = 0;
    private int mCacheProgress = -1;
    private static final int CACHE_BLOCK_SIZE = 65536;
    public static int mNumStrings;
    public static int mStrAboutID;
    public static int mStrCreditStartID;
    public static int mStrCreditEndID;
    protected static crlString _tString;
    public static crlString[] mLocaleText;
    private int locale = crlUI.mLocale;

    public int open() {
        return this.init(0, 768, 16384, sSpongeName);
    }

    public int open(int n) {
        return this.init(n, 768, 16384, sSpongeName);
    }

    public int open(int n, int n2) {
        return this.init(n, n2, 16384, sSpongeName);
    }

    public int open(int n, int n2, int n3) {
        return this.init(n, n2, n3, sSpongeName);
    }

    public int open(int n, int n2, int n3, String string) {
        return this.init(n, n2, n3, string);
    }

    private int init(int n, int n2, int n3, String string) {
        sSpongeName = string;
        this.mCache = (byte[])(n > 0 ? new byte[n] : null);
        this.mProcObjMap = new cResProcessObj[4];
        this.addResProcessObj(1, new cStringLoaderProcObj());
        this.addResProcessObj(0, new cCacheProcObj());
        _mFnameBuffer = new StringBuffer(128);
        _mFnameBuffer.insert(0, _resDirectory);
        this.mResource = new Hashtable(n2);
        this.mIntObject = new crlInt(0);
        mScratchBuffer = new byte[n3];
        this._mStatus = 2;
        this.mRetry = 3;
        return 0;
    }

    public int close() {
        for (int i = 0; i < this.mProcObjMap.length; ++i) {
            this.mProcObjMap[i] = null;
        }
        this.mProcObjMap = null;
        mLocaleText = null;
        this.mResource = null;
        this.mIntObject = null;
        _mFnameBuffer = null;
        this.mCache = null;
        return 0;
    }

    public String report(int n) {
        return null;
    }

    public final int update() {
        int n = 0;
        if (this._mStatus == 6) {
            n = this._updatePack();
        }
        return n;
    }

    public final int destroyScratchBuffer() {
        if (this._mStatus == 6) {
            return -1;
        }
        mScratchBuffer = null;
        return 0;
    }

    public final int createScratchBuffer(int n) {
        if (this._mStatus != 2) {
            return -1;
        }
        try {
            iUserScratchSize = n;
            mScratchBuffer = new byte[iUserScratchSize];
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    public final Image getImageByID(long l) {
        this.mIntObject.setValue((int)l);
        return (Image)this.mResource.get(this.mIntObject);
    }

    public final Image createImageFromIDs(long l, long l2) {
        int n = 33;
        this.mIntObject.setValue((int)l);
        crlBinArray crlBinArray2 = (crlBinArray)this.mResource.get(this.mIntObject);
        System.arraycopy(crlBinArray2.getArray(), crlBinArray2.getOffset(), mScratchBuffer, n, crlBinArray2.getLength());
        int n2 = crlBinArray2.getLength();
        this.mIntObject.setValue((int)l2);
        crlBinArray crlBinArray3 = (crlBinArray)this.mResource.get(this.mIntObject);
        System.arraycopy(crlBinArray3.getArray(), crlBinArray3.getOffset(), mScratchBuffer, n += n2, crlBinArray3.getLength());
        int n3 = crlBinArray3.getLength();
        System.arraycopy(mScratchBuffer, n += n3 - 33, mScratchBuffer, 0, 33);
        return Image.createImage((byte[])mScratchBuffer, (int)0, (int)n);
    }

    public final crlImagePacked getIMPByID(long l) {
        this.mIntObject.setValue((int)l);
        return (crlImagePacked)this.mResource.get(this.mIntObject);
    }

    public final int loadPack(long[] lArray) {
        if (this._mStatus == 0) {
            return -1;
        }
        if (this._mStatus != 2) {
            return -1;
        }
        crlUtil.garbageWait();
        this.currentPack = lArray;
        this.currentPackPos = 0;
        this._mStatus = 6;
        return 0;
    }

    public final crlBinArray getBinBySpongeID(long l) {
        this.mIntObject.setValue((int)l);
        return (crlBinArray)this.mResource.get(this.mIntObject);
    }

    private final boolean alreadyLoaded(long l) {
        this.mIntObject.setValue((int)l);
        return this.mResource.containsKey(this.mIntObject);
    }

    public final void cacheSponge() {
        if (this.mCache == null) {
            return;
        }
        try {
            int n;
            if (this.mInputStream == null) {
                this.mInputStream = this.getClass().getResourceAsStream(_resDirectory + sSpongeName + _spgExtension);
                if (this.mInputStream == null) {
                    // empty if block
                }
            }
            int n2 = 65536;
            if (this.mCache.length - this.mCacheBytesRead < 65536) {
                n2 = this.mCache.length - this.mCacheBytesRead;
            }
            if ((n = this.mInputStream.read(this.mCache, this.mCacheBytesRead, n2)) == -1 || n == 0) {
                this.mCacheProgress = 100;
                this.mCacheBytesRead = this.mCache.length;
                this.mInputStream.close();
                this.mCacheReady = true;
            } else {
                this.mCacheBytesRead += n;
                this.mCacheProgress = 10000 / (100 * (this.mCache.length - 1) / this.mCacheBytesRead);
                --this.currentPackPos;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final int _updatePack() {
        long l;
        if (crlCanvas.mLoadInterrupted) {
            if (this.currentPackPos > 0 && (int)(this.currentPack[this.currentPackPos] >> 32) != -1) {
                --this.currentPackPos;
                this.unloadObject(this.currentPack[this.currentPackPos]);
                this.mPrevID = this.currentPackPos > 0 ? this.currentPack[this.currentPackPos - 1] : -1L;
            }
            crlCanvas.mLoadInterrupted = false;
        }
        if ((l = this.currentPack[this.currentPackPos]) != 0L) {
            if ((int)(l >> 32) == -1) {
                int n = (int)l;
                this.processObject(this.mPrevID, n);
                this.mPrevID = -1L;
            } else if (!this.alreadyLoaded(l)) {
                System.gc();
                this.mRetry = 3;
                boolean bl = false;
                while (!bl) {
                    this.loadObject(l);
                    this.mIntObject.setValue((int)l);
                    if (this.mResource.get(this.mIntObject) != null) {
                        bl = true;
                        this.mPrevID = l;
                        continue;
                    }
                    --this.mRetry;
                    if (this.mRetry < 0) {
                        return -1;
                    }
                    crlUtil.garbageWait();
                }
            } else {
                this.mPrevID = l;
            }
        }
        if (crlCanvas.mLoadInterrupted) {
            if (this.currentPackPos >= 0 && (int)(this.currentPack[this.currentPackPos] >> 32) != -1) {
                this.unloadObject(this.currentPack[this.currentPackPos]);
                crlUtil.garbageWait();
                --this.currentPackPos;
                this.mPrevID = this.currentPackPos > 0 ? this.currentPack[this.currentPackPos - 1] : -1L;
            }
            crlCanvas.mLoadInterrupted = false;
        }
        ++this.currentPackPos;
        if (this.currentPackPos == this.currentPack.length) {
            this._mStatus = 2;
            crlUtil.garbageWait();
        }
        return 0;
    }

    private final void processObject(long l, int n) {
        cResProcessObj cResProcessObj2 = this.mProcObjMap[n];
        try {
            cResProcessObj2.process(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadObjectFromStream(byte by, DataInputStream dataInputStream, int n, long l) throws IOException {
        switch (by) {
            case 1: {
                this.loadObjectPNG(dataInputStream, n, l);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 15: {
                this.loadObjectBIN(dataInputStream, n, l);
                break;
            }
            case 9: {
                this.loadObjectSPG(dataInputStream, n, l);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.loadObjectIMP(dataInputStream, n, l);
                break;
            }
        }
    }

    private final void loadObjectFromMemory(byte by, int n, int n2, long l) throws Exception {
        switch (by) {
            case 1: {
                this.loadObjectPNGmemory(n, n2, l);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                this.loadObjectBINmemory(n, n2, l);
                break;
            }
            case 9: {
                this.loadObjectSPGmemory(n, n2, l);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.loadObjectIMPmemory(n, n2, l);
                break;
            }
        }
    }

    private final byte loadObject(long l) {
        byte by = -1;
        try {
            if (this.mCacheReady) {
                int n = (int)(l >> 32);
                int n2 = crlUtil.toInt(this.mCache, n);
                int n3 = crlUtil.toInt(this.mCache, n += 4);
                by = this.mCache[n += 4];
                ++n;
                if ((by & 0x40) == 64) {
                    by = (byte)(by & 0xFFFFFFBF);
                    this.mEncrypted = true;
                } else {
                    this.mEncrypted = false;
                }
                if ((by & 0xFFFFFF80) == -128) {
                    by = (byte)(by & 0x7F);
                    int n4 = crlUtil.toInt(this.mCache, n);
                    n += 4;
                    int n5 = _resDirectory.length();
                    for (int i = 0; i < n2 - 4; ++i) {
                        _mFnameBuffer.append((char)this.mCache[n++]);
                    }
                    this.loadObjectFromFile(by, _mFnameBuffer.toString(), n4, n3);
                    _mFnameBuffer.delete(n5, 128 - n5);
                } else {
                    this.loadObjectFromMemory(by, n, n2, n3);
                }
            } else {
                this.mInputStream = this.getClass().getResourceAsStream(_resDirectory + sSpongeName + _spgExtension);
                if (this.mInputStream == null) {
                    crlUtil.garbageWait();
                    return -1;
                }
                this.mDataStream = new DataInputStream(this.mInputStream);
                int n = (int)(l >> 32);
                this.mDataStream.skip(n);
                int n6 = this.mDataStream.readInt();
                int n7 = this.mDataStream.readInt();
                by = this.mDataStream.readByte();
                this.loadObjectFromStream(by, this.mDataStream, n6, n7);
                this.mInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return by;
    }

    private final void loadObjectFromFile(byte by, String string, int n, int n2) throws IOException {
        this.mInputStream = this.getClass().getResourceAsStream(string);
        if (this.mInputStream == null) {
            crlUtil.garbageWait();
        }
        this.mDataStream = new DataInputStream(this.mInputStream);
        this.loadObjectFromStream(by, this.mDataStream, n, n2);
        this.mInputStream.close();
    }

    private final int loadObjectIMP(DataInputStream dataInputStream, int n, long l) throws IOException {
        int n2 = dataInputStream.readInt();
        n -= 4;
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        byte[] byArray2 = new byte[n -= n2];
        dataInputStream.readFully(byArray2, 0, n);
        Image image = Image.createImage((byte[])byArray2, (int)0, (int)n);
        short[] sArray = new short[n2 / 2];
        for (int i = 0; i < n2 / 2; ++i) {
            sArray[i] = crlUtil.toShort(byArray, i * 2);
        }
        crlImagePacked crlImagePacked2 = new crlImagePacked();
        crlImagePacked2.open(image, sArray);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlImagePacked2);
        return 0;
    }

    private final int loadObjectIMPmemory(int n, int n2, long l) throws IOException {
        int n3 = crlUtil.toInt(this.mCache, n);
        n2 -= 4;
        n += 4;
        short[] sArray = new short[n3 / 2];
        for (int i = 0; i < n3 / 2; ++i) {
            sArray[i] = crlUtil.toShort(this.mCache, n);
            n += 2;
        }
        Image image = Image.createImage((byte[])this.mCache, (int)n, (int)(n2 -= n3));
        crlImagePacked crlImagePacked2 = new crlImagePacked();
        crlImagePacked2.open(image, sArray);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlImagePacked2);
        return 0;
    }

    private final int loadObjectSPG(DataInputStream dataInputStream, int n, long l) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        n2 += 4;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            byte by = dataInputStream.readByte();
            this.loadObjectFromStream(by, dataInputStream, n3, n4);
            n2 += n3 + 9;
        }
        return 0;
    }

    private final int loadObjectSPGmemory(int n, int n2, long l) throws Exception {
        int n3 = 4;
        n += 4;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = crlUtil.toInt(this.mCache, n);
            int n6 = crlUtil.toInt(this.mCache, n += 4);
            byte by = this.mCache[n += 4];
            this.loadObjectFromMemory(by, ++n, n5, n6);
            n3 += n5 + 9;
            n += n5;
            ++n4;
        }
        return 0;
    }

    private final int loadObjectBIN(DataInputStream dataInputStream, int n, long l) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        this.mIntObject.setValue((int)l);
        crlBinArray crlBinArray2 = new crlBinArray();
        crlBinArray2.set(byArray, 0, n);
        this.mResource.put(this.mIntObject, crlBinArray2);
        return 0;
    }

    private final int loadObjectBINmemory(int n, int n2, long l) throws IOException {
        this.mIntObject.setValue((int)l);
        crlBinArray crlBinArray2 = new crlBinArray();
        crlBinArray2.set(this.mCache, n, n2);
        this.mResource.put(this.mIntObject, crlBinArray2);
        return 0;
    }

    private final int loadObjectPNG(DataInputStream dataInputStream, int n, long l) throws IOException {
        dataInputStream.readFully(mScratchBuffer, 0, n);
        Image image = Image.createImage((byte[])mScratchBuffer, (int)0, (int)n);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, image);
        return 0;
    }

    private final int loadObjectPNGmemory(int n, int n2, long l) throws Exception {
        Image image = Image.createImage((byte[])this.mCache, (int)n, (int)n2);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, image);
        return 0;
    }

    public final void insertPack(long[] lArray) {
        long[] lArray2 = new long[this.currentPack.length + lArray.length];
        System.arraycopy(this.currentPack, 0, lArray2, 0, this.currentPack.length);
        int n = this.currentPack.length;
        System.arraycopy(lArray, 0, lArray2, this.currentPack.length, lArray.length);
        this.currentPack = lArray2;
    }

    public final int destroyPack(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            if ((int)(lArray[i] >> 32) == -1) continue;
            this.unloadObject(lArray[i]);
        }
        return 0;
    }

    public final int unloadObject(long l) {
        this.mIntObject.setValue((int)l);
        if (this.mResource.remove(this.mIntObject) == null) {
            return -1;
        }
        return 0;
    }

    public final long[] getCurrentPack() {
        return this.currentPack;
    }

    public final int getCurrentPackProgress() {
        if (this._mStatus == 2) {
            return 100;
        }
        if (this._mStatus == 6 && this.currentPack.length > 0 && this.currentPackPos > 0) {
            int n = 10000 / (100 * (this.currentPack.length - 1) / this.currentPackPos);
            n /= 4;
            int n2 = this.mCacheProgress / 4;
            return n2 + (n *= 3);
        }
        return 0;
    }

    public final void initStrings(int n, int n2, int n3, int n4) {
        mNumStrings = n;
        mStrAboutID = n2;
        mStrCreditStartID = n3;
        mStrCreditEndID = n4;
    }

    public void setLocale(int n) {
        this.locale = n;
    }

    public final void loadStrings() {
        mLocaleText = new crlString[mNumStrings];
        String[] stringArray = new String[]{"en", "fr", "it", "de", "es", "nl", "pt"};
        int n = 0;
        int n2 = 0;
        short s = 0;
        int n3 = this.resourceLoad(mScratchBuffer, "cUItext_" + stringArray[this.locale] + _binExtension);
        try {
            for (n = 0; n < mNumStrings; ++n) {
                s = crlUtil.toShortIntel(mScratchBuffer, n2);
                crlResourceManager.mLocaleText[n] = new crlString(mScratchBuffer, n2 += 2, s);
                n2 += s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = new byte[]{35};
        mLocaleText[mStrAboutID].insert(crlCanvas._mVersion.getBytes(), byArray);
        crlUtil.garbageWait();
    }

    private final int resourceLoad(byte[] byArray, String string) {
        int n;
        try {
            DataInputStream dataInputStream;
            InputStream inputStream = this.getClass().getResourceAsStream(_resDirectory + string);
            if (null == inputStream) {
                n = -1;
            }
            if (null == (dataInputStream = new DataInputStream(inputStream))) {
                n = -2;
            }
            try {
                dataInputStream.read(byArray);
                n = 0;
            }
            catch (Exception exception) {
                n = -3;
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            n = -4;
        }
        return n;
    }

    public void addResProcessObj(int n, cResProcessObj cResProcessObj2) {
        this.mProcObjMap[n] = cResProcessObj2;
    }

    public void delResProcessObj(int n) {
        this.mProcObjMap[n] = null;
    }

    public void setNumProcessObjs(int n) {
        if (this.mProcObjMap.length == n || n < 2) {
            return;
        }
        cResProcessObj[] cResProcessObjArray = new cResProcessObj[n];
        if (this.mProcObjMap.length > n) {
            System.arraycopy(this.mProcObjMap, 0, cResProcessObjArray, 0, n);
        } else {
            System.arraycopy(this.mProcObjMap, 0, cResProcessObjArray, 0, this.mProcObjMap.length);
        }
        this.mProcObjMap = cResProcessObjArray;
    }

    public boolean saveData(String string, byte[] byArray) {
        try {
            if (this.saveDataExists(string)) {
                RecordStore.deleteRecordStore((String)string);
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
            return true;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteSaveData(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        return true;
    }

    public boolean saveDataExists(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            recordStore.closeRecordStore();
            return true;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            return false;
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadData(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            int n = recordStore.getNumRecords();
            int n2 = 1;
            int n3 = recordStore.getRecordSize(n2);
            byte[] byArray = recordStore.getRecord(n2);
            recordStore.closeRecordStore();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            byte[] byArray = null;
            return byArray;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException) {}
        }
        catch (RecordStoreException recordStoreException) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException2) {}
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException) {}
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException) {}
        }
        return null;
    }

    public void setKey(byte by) {
        this._mKey = by;
    }

    public void decodeBuffer(byte[] byArray) {
        this.decodeBuffer(byArray, 0, byArray.length);
    }

    public void decodeBuffer(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = n3 < 100 ? 10 + n3 % 10 : (n3 < 200 ? 50 + n3 % 20 : (n3 < 300 ? 80 + n3 % 20 : 100 + n3 % 50));
        for (int i = 0; i < n4; ++i) {
            int n5 = i + n;
            int n6 = n3 - i - 1 + n;
            int n7 = n5;
            byArray[n7] = (byte)(byArray[n7] ^ this._mKey);
            int n8 = n6;
            byArray[n8] = (byte)(byArray[n8] ^ this._mKey);
            int n9 = n5;
            byArray[n9] = (byte)(byArray[n9] ^ byArray[n6]);
            int n10 = n6;
            byArray[n10] = (byte)(byArray[n10] ^ byArray[n5]);
            int n11 = n5;
            byArray[n11] = (byte)(byArray[n11] ^ byArray[n6]);
        }
    }

    static {
        sSpongeName = "M_3D";
        iUserScratchSize = 16384;
        iObj3DBaseID = 65535;
        _tempArray = new byte[4];
        _pngExtension = ".png";
        _resDirectory = "/res/";
        _spgExtension = ".spg";
        _binExtension = ".bin";
    }

    public static interface resType {
        public static final int NDEF = 0;
        public static final int PNG = 1;
        public static final int PAL = 2;
        public static final int IMG = 3;
        public static final int BIN = 4;
        public static final int M3G = 5;
        public static final int MID = 6;
        public static final int AMR = 7;
        public static final int I2D = 8;
        public static final int SPG = 9;
        public static final int STR = 10;
        public static final int IMP = 11;
        public static final int APP = 12;
        public static final int BMP = 13;
        public static final int FIG = 14;
        public static final int WAV = 15;
        public static final int TRA = 16;
    }

    public static interface procObj {
        public static final long BASE_ID = -4294967294L;
        public static final long PO_CACHE = -4294967296L;
        public static final long PO_LOAD_STRINGS = -4294967295L;
    }
}

