/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

class Sound
implements ISound {
    static int TOTAL_SOUNDS = 0;
    static int SFX_SOUNDS = 0;
    static boolean done_setup = false;
    private com.nokia.mid.sound.Sound[] fxPlayer = null;
    private boolean _isSoundOn = true;
    int currentSound = -1;
    SoundBank soundBank;
    static int lastsoundIndex = -1;
    static int lastbLoop = -1;
    static int lastTime = -1;
    static int lasttune = -1;

    Sound() {
    }

    void setup() {
        TOTAL_SOUNDS = this.soundBank.getNumberOfSounds();
        SFX_SOUNDS = TOTAL_SOUNDS++;
        this.fxPlayer = new com.nokia.mid.sound.Sound[TOTAL_SOUNDS];
        done_setup = true;
    }

    public void setSoundBank(SoundBank soundBank) {
        this.soundBank = soundBank;
    }

    public void setSoundOn(boolean bl) {
        this.stopAllSounds();
        this._isSoundOn = bl;
    }

    public void playSound(int n) {
        this.playSound(n, 1);
    }

    public void playSound(int n, int n2) {
        if (n == 0) {
            lastTime = (int)(System.currentTimeMillis() & 0xFFFFL);
        }
        lastsoundIndex = -2;
        if (!done_setup) {
            return;
        }
        if (this.fxPlayer[n] == null) {
            return;
        }
        int n3 = n2;
        if (n3 < 0 || n3 > 255) {
            n3 = 0;
        }
        if (n == 0) {
            lastTime = (int)(System.currentTimeMillis() & 0xFFFFL) + 131072;
        }
        lastsoundIndex = -3;
        if (!this._isSoundOn || n == -1) {
            return;
        }
        lastsoundIndex = -4;
        if (n == 0) {
            lastTime = (int)(System.currentTimeMillis() & 0xFFFFL) + 262144;
        }
        try {
            if (n == 0) {
                lastTime = (int)(System.currentTimeMillis() & 0xFFFFL) + 393216;
            }
            this.fxPlayer[n].stop();
            this.fxPlayer[n].play(n3);
            lastsoundIndex = n;
            lastbLoop = n2;
            if (n == 0) {
                lastTime = (int)(System.currentTimeMillis() & 0xFFFFL) + 524288;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSounds() {
        if (!done_setup) {
            this.setup();
        }
        for (int i = 0; i < TOTAL_SOUNDS; ++i) {
            try {
                int n;
                String string = null;
                string = i < SFX_SOUNDS ? this.soundBank.getSound(i) : this.soundBank.getTune(i - SFX_SOUNDS);
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                inputStream.close();
                if (string.endsWith(".wav")) {
                    this.fxPlayer[i] = new com.nokia.mid.sound.Sound(byteArrayOutputStream.toByteArray(), 5);
                    this.fxPlayer[i].init(byteArrayOutputStream.toByteArray(), 5);
                } else if (string.endsWith(".ott")) {
                    this.fxPlayer[i] = new com.nokia.mid.sound.Sound(byteArrayOutputStream.toByteArray(), 1);
                }
                byteArrayOutputStream.close();
                System.out.println("Loaded sound: " + string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to load SFX " + exception);
            }
        }
        this.stopAllSounds();
    }

    public void stopSound(int n) {
        if (this.fxPlayer[n] != null) {
            try {
                this.fxPlayer[n].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopAllSounds() {
        for (int i = 0; i < TOTAL_SOUNDS; ++i) {
            this.stopSound(i);
        }
    }

    public void playTune(int n) {
        this.playTune(n, 1);
    }

    public void playTune(int n, int n2) {
        if (n >= 1 || n < 0) {
            return;
        }
        this.playSound(n + SFX_SOUNDS, -1);
        lasttune = n + SFX_SOUNDS;
    }

    public void stopTune() {
        if (lasttune == -1) {
            return;
        }
        this.stopSound(lasttune);
        lasttune = -1;
    }
}

