/*
 * Decompiled with CFR 0.152.
 */
package wt.game.hero;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wt.game.hero.Enemy;
import wt.game.hero.Game;
import wt.game.hero.Pool;

public class MapManager {
    int width;
    int height;
    Image[] image;
    int tiledWidth;
    int tiledHeight;
    byte[] flag;
    int collidesLeft;
    int collidesRight;
    boolean ridarDelay;
    static int WIDTH;
    static int HEIGHT;

    MapManager(int width, int height, Image[] image, int tiledWidth, int tiledHeight) {
        this.width = width;
        this.height = height;
        this.image = image;
        this.tiledWidth = tiledWidth;
        this.tiledHeight = tiledHeight;
        this.flag = new byte[width * height];
        WIDTH = width * tiledWidth;
        HEIGHT = height * tiledHeight;
    }

    void paint(Graphics g2, int x, int y) {
        int jEnd;
        int jStart;
        int iEnd;
        int iStart = x / this.tiledWidth;
        if (iStart < 0) {
            iStart = 0;
        }
        if ((iEnd = (x + 240) / this.tiledWidth) >= this.width) {
            iEnd = this.width - 1;
        }
        if ((jStart = y / this.tiledHeight) < 0) {
            jStart = 0;
        }
        if ((jEnd = (y + 304) / this.tiledHeight) >= this.height) {
            jEnd = this.height - 1;
        }
        int i2 = 0;
        int j2 = 0;
        int xTemp = 0;
        int yTemp = 0;
        byte temp = 0;
        for (i2 = iEnd; i2 >= iStart; --i2) {
            for (j2 = jEnd; j2 >= jStart; --j2) {
                temp = this.flag[j2 * this.width + i2];
                if (temp == 0) continue;
                xTemp = i2 * this.tiledWidth - x;
                yTemp = j2 * this.tiledHeight - y;
                g2.drawImage(this.image[temp - 1], xTemp, yTemp, 0);
            }
        }
    }

    boolean collidesWith(Enemy enemy) {
        int jEnd;
        int jStart;
        int iEnd;
        int iStart = (enemy.x + Enemy.COLLIDES[enemy.style][4]) / this.tiledWidth;
        if (iStart < 0) {
            iStart = 0;
        }
        if ((iEnd = (enemy.x + Enemy.COLLIDES[enemy.style][6]) / this.tiledWidth) >= this.width) {
            iEnd = this.width - 1;
        }
        if ((jStart = (enemy.y + Enemy.COLLIDES[enemy.style][5]) / this.tiledHeight) < 0) {
            jStart = 0;
        }
        if ((jEnd = (enemy.y + Enemy.COLLIDES[enemy.style][7]) / this.tiledHeight) >= this.height) {
            jEnd = this.height - 1;
        }
        int i2 = 0;
        int j2 = 0;
        for (i2 = iStart; i2 <= iEnd; ++i2) {
            for (j2 = jStart; j2 <= jEnd; ++j2) {
                if ((this.flag[i2 + j2 * this.width] < this.collidesLeft || this.flag[i2 + j2 * this.width] >= this.collidesRight) && this.flag[i2 + j2 * this.width] != 0) continue;
                return true;
            }
        }
        return false;
    }

    void setCollidesRange(int left, int right) {
        Object var3_3 = null;
        if (Game._a1()) {
            return;
        }
        this.collidesLeft = left;
        this.collidesRight = right;
    }

    void drawMap(Graphics g2, Pool pool, Game game) {
        game.drawK(g2, 66, 70, 100, 100);
        int x = 70 + (100 - this.width) / 2;
        int y = 76 + (100 - this.height) / 2;
        g2.setColor(354570);
        g2.fillRect(x, y, this.width, this.height);
        for (int i2 = pool.enemys.length - 1; i2 >= 0; --i2) {
            if (pool.enemys[i2].style >= 0 && pool.enemys[i2].style < 4) {
                g2.setColor(0xFF0000);
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 1, 1);
                continue;
            }
            if (pool.enemys[i2].style == 4) {
                if ((1 << Game.mission & 0x156) == 0) {
                    g2.setColor(0xFF0000);
                } else if (this.ridarDelay) {
                    g2.setColor(0xFF0000);
                } else {
                    g2.setColor(0xFF9900);
                }
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
                continue;
            }
            if (pool.enemys[i2].style == 5) {
                if ((1 << Game.mission & 0x1156) == 0) {
                    g2.setColor(0xFF0000);
                } else if (this.ridarDelay) {
                    g2.setColor(0xFF0000);
                } else {
                    g2.setColor(0xFF9900);
                }
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
                continue;
            }
            if (pool.enemys[i2].style == 6 || pool.enemys[i2].style == 7 || pool.enemys[i2].style == 9) {
                if (pool.enemys[i2].life <= 0) continue;
                if ((1 << Game.mission & 0x146) == 0) {
                    g2.setColor(58623);
                } else if (this.ridarDelay) {
                    g2.setColor(58623);
                } else {
                    g2.setColor(20223);
                }
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
                continue;
            }
            if (pool.enemys[i2].style == 8) {
                if (pool.enemys[i2].life <= 0) continue;
                if ((1 << Game.mission & 0x8146) == 0) {
                    g2.setColor(58623);
                } else if (this.ridarDelay) {
                    g2.setColor(58623);
                } else {
                    g2.setColor(20223);
                }
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
                continue;
            }
            if (pool.enemys[i2].style == 10) {
                if (pool.enemys[i2].life <= 0) continue;
                if ((1 << Game.mission & 0x1CE) == 0) {
                    g2.setColor(16742400);
                } else if (this.ridarDelay) {
                    g2.setColor(16742400);
                } else {
                    g2.setColor(0xFFFF00);
                }
                g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
                continue;
            }
            if (pool.enemys[i2].style < 13 || pool.enemys[i2].style >= 16) continue;
            g2.setColor(0);
            g2.fillRect(pool.enemys[i2].x / 16 + x, pool.enemys[i2].y / 16 + y, 2, 2);
        }
        if (Game.mission != 5 && Game.mission != 11 && Game.mission != 17 && Game.mission != 20 && Game.mission != 41) {
            int t1 = (Game.PASS[Game.mission << 2] + Game.PASS[(Game.mission << 2) + 1]) / 32 + x;
            int t2 = (Game.PASS[(Game.mission << 2) + 2] + Game.PASS[(Game.mission << 2) + 3]) / 32 + y;
            g2.setColor(65280);
            g2.drawLine(t1 - 2, t2, t1 + 2, t2);
            g2.drawLine(t1, t2 - 2, t1, t2 + 2);
        }
        g2.setColor(0xFFFFFF);
        int xt = Game.actor.x / 16 + x;
        int yt = Game.actor.y / 16 + y;
        g2.fillRect(xt, yt, 1, 1);
        if (this.ridarDelay) {
            g2.drawRect(xt - 2, yt - 2, 4, 4);
        }
        for (int j2 = 2; j2 < Pool.ENEMY_INFO.length; j2 += 3) {
            if (Pool.ENEMY_INFO[j2] < 0) continue;
            if (Pool.ENEMY_INFO[j2] == 0 || Pool.ENEMY_INFO[j2] == 1 || Pool.ENEMY_INFO[j2] == 3) {
                if ((1 << Game.mission & 0x146) == 0) {
                    g2.setColor(58623);
                } else if (this.ridarDelay) {
                    g2.setColor(58623);
                } else {
                    g2.setColor(20223);
                }
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] == 4) {
                if ((1 << Game.mission & 0x1CE) == 0) {
                    g2.setColor(16742400);
                } else if (this.ridarDelay) {
                    g2.setColor(16742400);
                } else {
                    g2.setColor(0xFFFF00);
                }
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] == 2) {
                if ((1 << Game.mission & 0x8146) == 0) {
                    g2.setColor(58623);
                } else if (this.ridarDelay) {
                    g2.setColor(58623);
                } else {
                    g2.setColor(20223);
                }
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] > 6 && Pool.ENEMY_INFO[j2] < 16) {
                if ((1 << Game.mission & 0x156) == 0) {
                    g2.setColor(0xFF0000);
                } else if (this.ridarDelay) {
                    g2.setColor(0xFF0000);
                } else {
                    g2.setColor(0xFF9900);
                }
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] > 15 && Pool.ENEMY_INFO[j2] < 25) {
                if ((1 << Game.mission & 0x156) == 0) {
                    g2.setColor(0xFF0000);
                } else if (this.ridarDelay) {
                    g2.setColor(0xFF0000);
                } else {
                    g2.setColor(0xFF9900);
                }
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] > 24 && Pool.ENEMY_INFO[j2] < 50) {
                g2.setColor(0xFF0000);
                g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 1, 1);
                continue;
            }
            if (Pool.ENEMY_INFO[j2] <= 49 || Pool.ENEMY_INFO[j2] >= 53) continue;
            g2.setColor(0);
            g2.fillRect(Pool.ENEMY_INFO[j2 - 2] / 16 + x, Pool.ENEMY_INFO[j2 - 1] / 16 + y, 2, 2);
        }
        this.ridarDelay = !this.ridarDelay;
    }
}

