/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import game.Game;
import handson.Handson;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.Tinlet;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.mmapi.Sound;

public final class Menu {
    public static Game game$486afe46;
    private static String[] midletInfo;
    protected static byte[][] menus;
    protected static byte[][][] menuItems;
    private static long splashStartTime;
    private static int splashMaxTime;
    private static int currentSplash;
    private static int currentSplashTime;
    private static int currentSplashFrame;
    public static int mode;
    private static int splashMode;
    private static int currentMenu;
    private static int selectedItem;
    private static int menuItemPosition;
    private static int menuItemEase;
    private static byte[] menuCaller;
    private static byte[] menuSelection;
    private static int[] menuItemWidths;
    private static int menuItemOverlayWidth;
    private static boolean paused;
    private static int menuClipTop;
    private static int menuClipHeight;
    private static int menuItemPositionMax;
    private static boolean showUpArrow;
    private static boolean showDownArrow;
    private static boolean lskEnabled;
    private static boolean rskEnabled;
    private static byte[][] textScreenItems;
    private static int delayedMenu;
    private static int delayedMenuCountDown;
    private static int MENU_ITEM_BOTTOM;
    private static int MENU_SCROLLTEXT_TOP;
    private static int MENU_SCROLLTEXT_BOTTOM;
    public static int MENU_SEPERATOR_TOP;
    private static int MENU_SEPERATOR_HEIGHT;
    private static int MENU_TEXT_WIDTH;
    public static int MENU_LEFT;
    private static String statusText;
    private static int menuCaptionImage;
    private static int menuCaptionOffset;
    private static final int[][] scrInfo;
    protected static int[] options;
    private static volatile boolean showLoading;
    private static int loadingFrame;
    private static boolean titleMusicStarted;
    private static Sound sound$2c4aeb41;
    private static int currentTranslationString;
    private static int progressBarMax;
    private static int progressCurrent;
    private static int crossHairTargetX;
    private static int crossHairTargetY;
    private static boolean crossHairVisible;
    private static int numHotspotsActive;
    private static int[] hotspots;
    private static int[] rcHotspot;
    private static final int[] dirtyRect;
    private static int sResumeMusicAfterInterruptDelay;
    private static int sOldItemBottom;
    private static boolean sInitialized;
    public static int sCurrentDrawnItem;
    private static final int[] sCustomItemPositionArray;
    private static int sNextCaptionOffset;
    private static int mCurrentTouchScreenEvent;
    private static int mInternalTouchSelection;
    private static int sSwipeStartY;
    private static int sSwipeLastY;
    private static int sSwipeSpeedY;
    private static int sSwipeDirection;
    private static boolean sSwiping;
    private static int sClickStartFrame;
    private static boolean sShowUpDownArrows;

    private Menu() {
    }

    public static void start() {
        game$486afe46 = new Game();
        Thread thread = new Thread(new GCanvas());
        thread.start();
    }

    public static void stop() {
        if (GCanvas.isRunning) {
            Menu.stopMusic();
            if (splashMode >= 7) {
                Menu.startLoading(79);
                Menu.flushRMS();
            }
            GCanvas.isRunning = false;
        }
    }

    private static void flushRMS() {
        RM.flushRMS();
    }

    protected static final void onDraw(Graphics graphics) {
        if (GCanvas.isTouchscreenEnabled()) {
            numHotspotsActive = 0;
        }
        if (showLoading) {
            Menu.drawLoading(graphics);
            return;
        }
        switch (mode) {
            case 0: {
                Menu.drawSplash(graphics);
                break;
            }
            case 1: {
                Menu.drawMenu(graphics, currentMenu);
                break;
            }
            case 2: {
                game$486afe46.onDraw(graphics);
            }
        }
        if (GCanvas.isTouchscreenEnabled() && mode != 2) {
            Menu.drawTouchScreenFeatures(graphics);
        }
        Game.instance.demoHandleDemoMode(graphics);
    }

    private static final void handleSplash() {
        if (splashMode == 0) {
            currentSplash = -1;
            Menu.advanceSplashMode();
        }
        if (splashMode == 1) {
            Menu.loadRMS();
            Menu.advanceSplashMode();
        }
        if (splashMode == 3) {
            GCanvas.initResources();
            Menu.init();
            Menu.advanceSplashMode();
        }
        if (splashMode == 4) {
            if (Handson.getForcedLocale() == null) {
                Menu.changeMenu(28, false);
                return;
            }
            Menu.advanceSplashMode();
        }
        if (splashMode == 2) {
            if (RM.getNumResources() == 0) {
                RM.load();
            }
            return;
        }
        if (splashMode == 5) {
            game$486afe46.init();
            Menu.initSound();
            Menu.advanceSplashMode();
        }
        if (splashMode < 7) {
            Menu.updateSplashSequence();
            return;
        }
        if (splashMode == 7) {
            Menu.changeMenu(0, false);
        }
    }

    public static final void scheduleMenuRefresh() {
        RM.setRectEmpty(dirtyRect);
    }

    private static final void advanceSplashMode() {
        GCanvas.resetKeys();
        ++splashMode;
    }

    protected static final void onInput() {
        int n;
        if (GCanvas.isTouchscreenEnabled()) {
            Menu.handleTouchScreenInput();
        }
        if (showLoading) {
            return;
        }
        Menu.resumeMusicAfterInterrupt();
        if (mode == 0) {
            Menu.handleSplash();
            return;
        }
        if (sound$2c4aeb41 != null) {
            sound$2c4aeb41.tick();
        }
        if (Menu.processSoftKeys() || Handson.menuProcessActions()) {
            return;
        }
        if (mode == 2 && delayedMenuCountDown < 0) {
            game$486afe46.onInput();
        }
        if (--delayedMenuCountDown == 0) {
            Menu.changeMenu(delayedMenu, false);
        }
        if (mode == 1 && !game$486afe46.peekInput() && (n = Menu.getMenuType(currentMenu)) != 3) {
            if (GCanvas.consumeUP()) {
                sSwipeDirection = 0;
                Menu.setSelection(currentMenu, selectedItem - 1, -1, false);
            }
            if (GCanvas.consumeDOWN()) {
                sSwipeDirection = 0;
                Menu.setSelection(currentMenu, selectedItem + 1, 1, false);
            }
            if (GCanvas.consumeFIRE()) {
                int n2 = GCanvas.getLSK();
                if (n2 < 0 || n2 == 3) {
                    n2 = GCanvas.getRSK();
                }
                if (n2 >= 0 && n2 != 3) {
                    Menu.menuItemSelected();
                }
            }
            if (game$486afe46.isCycleMenu$134632() && !GCanvas.consumeLEFT()) {
                GCanvas.consumeRIGHT();
            }
            if (currentMenu == 14) {
                if (GCanvas.consumeLEFT()) {
                    Menu.performMenuAction(19, -1);
                }
                if (GCanvas.consumeRIGHT()) {
                    Menu.performMenuAction(19, 1);
                }
            }
            if (currentMenu == 18 || currentMenu == 15) {
                if (GCanvas.consumeLEFT()) {
                    Menu.performMenuAction(27, -1);
                }
                if (GCanvas.consumeRIGHT()) {
                    Menu.performMenuAction(28, -1);
                }
            }
        }
    }

    private static final boolean splashSkippable() {
        return currentSplash >= 0 && RM.getValue(20, currentSplash, 2) == 1;
    }

    private static final boolean skipSplash() {
        if (Menu.splashSkippable()) {
            return GCanvas.consumeKey(1040);
        }
        return false;
    }

    private static final void startSplash(int n) {
        int n2;
        splashStartTime = GCanvas.getUptimeMillis();
        splashMaxTime = RM.getValue(20, n, 3);
        currentSplash = n;
        int n3 = Menu.getSplashID(currentSplash - 1);
        if (n3 >= 0) {
            RM.forget(n3);
        }
        if ((n2 = Menu.getSplashID(currentSplash)) >= 0) {
            RM.preload(n2);
        }
        GCanvas.redraw();
    }

    private static final void updateSplashSequence() {
        boolean bl = Menu.skipSplash();
        if (bl || (currentSplashTime = (int)(GCanvas.getUptimeMillis() - splashStartTime)) > splashMaxTime) {
            Menu.splashFinished();
        }
    }

    public static void splashFinished() {
        if (currentSplash >= 0) {
            int n = Menu.getSplashID(currentSplash);
            if (n >= 0) {
                RM.forget(n);
            }
            if (++currentSplash == 4) {
                Menu.changeMenu(10, false);
                return;
            }
            if (Handson.mrcUse() && currentSplash == 3) {
                Menu.changeMenu(26, false);
            }
            if (currentSplash == 6) {
                Menu.advanceSplashMode();
                currentSplash = -1;
                return;
            }
            Menu.startSplash(currentSplash);
        }
    }

    private static final void setInitialOptions(boolean bl) {
        if (options == null) {
            options = new int[7];
        }
        if (bl) {
            Menu.options[4] = -1;
        }
        if (bl) {
            Menu.options[0] = 0;
            Menu.options[1] = 50;
            Menu.options[2] = 50;
            Menu.options[3] = 1;
        }
        for (int i = 6; i < 7; ++i) {
            Menu.options[6] = 0;
        }
    }

    public static final int getOption(int n) {
        return options[n];
    }

    private static final void loadRMS() {
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        stringArray[0] = midletInfo[0] + "_opt";
        stringArray2[1] = midletInfo[0] + "_his";
        stringArray2[2] = midletInfo[0] + "_sav";
        RM.initRMS(stringArray2);
        options = RM.getRMSInts(0);
        if (options == null || RM.getRMSError() == 1) {
            Menu.setInitialOptions(true);
        } else if (options.length != 7) {
            RM.deleteRecordStore(0);
            options = null;
            Menu.setInitialOptions(true);
            RM.setStoreDirty(0);
        }
        int n = options[4];
        if (Handson.getForcedLocale() != null) {
            RM.setLocale(Handson.getForcedLocale());
            Menu.options[4] = RM.languageIndex;
            return;
        }
        if (n == 5 || n == -1) {
            n = 0;
        }
        RM.setLocale(n);
    }

    protected static final void doPause() {
        GCanvas.resetKeys();
        if (!paused) {
            paused = true;
            if (mode != 0 && (mode == 2 || Menu.getMenuType(currentMenu) != 4)) {
                Menu.userPause$1385ff();
            }
        }
    }

    private static void userPause$1385ff() {
        if (mode == 2) {
            int n;
            if (delayedMenuCountDown > 0) {
                delayedMenuCountDown = -1;
                n = delayedMenu;
            } else {
                n = 1;
            }
            Menu.changeMenu(n, false);
        }
    }

    private static final void resumeMusicAfterInterrupt() {
        if (GCanvas.isRunning && sResumeMusicAfterInterruptDelay >= 0) {
            if (sResumeMusicAfterInterruptDelay == 0 && options != null && Menu.getOption(0) == 1 && (Menu.getMode() == 1 || Menu.getMode() == 0) && game$486afe46.resumeMusicAfterInterrupt()) {
                Menu.playMusic(true);
            }
            --sResumeMusicAfterInterruptDelay;
        }
    }

    public static final void resumeFromInterrupt() {
        sResumeMusicAfterInterruptDelay = 20;
    }

    private static int getMenuType(int n) {
        return menus[n][2];
    }

    private static int getMenuCaption(int n) {
        return RM.getShortFromBytes(menus[n], 0);
    }

    private static final void menuItemSelected() {
        if (selectedItem >= 0) {
            if (Menu.countEnabledItems(currentMenu) > 0) {
                int n = Menu.getMenuType(currentMenu);
                int n2 = n == 2 ? 0 : selectedItem;
                byte[] byArray = menuItems[currentMenu][n2];
                int n3 = byArray[2] & 0xFF;
                int n4 = byArray[3] & 0xFF;
                Menu.performMenuAction(n3, n4);
                return;
            }
        } else {
            Menu.performMenuAction(3);
        }
    }

    private static final void toggleSound(int n) {
        int n2 = options[n];
        if (n == 0) {
            Menu.options[n] = n2 == 0 ? 1 : 0;
        }
        Menu.updateVolume();
        if (menuCaller[currentMenu] == 1) {
            Menu.playSound(game$486afe46.getSoundConfirmation());
        } else {
            Menu.playMusic(true);
        }
        Menu.refreshMenu();
    }

    private static final void prepareVolumeText() {
        String string = null;
        int n = options[0];
        string = RM.t(n == 0 ? 51 : 50);
        RM.prepareVarText(2, string);
    }

    public static final void performMenuAction(int n) {
        Menu.performMenuAction(n, 255);
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 0: {
                return;
            }
            case 6: {
                Menu.changeMenu(n2, true);
                return;
            }
            case 7: {
                Menu.changeMenu(n2, false);
                return;
            }
            case 8: {
                Menu.changeMenu(n2, false);
                return;
            }
            case 11: {
                Menu.performMenuAction(8, 0);
                return;
            }
            case 1: {
                Menu.menuItemSelected();
                return;
            }
            case 2: {
                Menu.performMenuAction(3);
                return;
            }
            case 3: {
                if (menuCaller[currentMenu] != -2) {
                    if (menuCaller[currentMenu] == -3) {
                        Menu.changeMode(0, -1);
                        return;
                    }
                    Menu.changeMenu(menuCaller[currentMenu], false);
                    return;
                }
                Menu.performMenuAction(4);
                return;
            }
            case 9: {
                GCanvas.setSoftButton(-1, -1);
                game$486afe46.initGame(true);
                Menu.changeMode(2, -1);
                return;
            }
            case 10: {
                game$486afe46.restart(true);
                Menu.changeMode(2, -1);
                return;
            }
            case 4: {
                Menu.changeMode(2, -1);
                return;
            }
            case 5: {
                Menu.userPause$1385ff();
                return;
            }
            case 13: {
                Menu.startLoading(80);
                RM.deleteAllRecordStores();
                Menu.setInitialOptions(false);
                game$486afe46.onGameReset();
                Menu.stopLoadingRefresh();
                Menu.performMenuAction(3);
                return;
            }
            case 15: {
                int n3 = options[n2];
                Menu.options[n2] = n3 == 0 ? 1 : 0;
                Menu.refreshMenu();
                return;
            }
            case 18: {
                Menu.openDebugMenu(14);
                return;
            }
            case 19: {
                String string;
                do {
                    if ((currentTranslationString += n2) < 0) {
                        currentTranslationString = RM.getNumStrings() - 1;
                    }
                    if (currentTranslationString < RM.getNumStrings()) continue;
                    currentTranslationString = 0;
                } while ((string = RM.getRawString(currentTranslationString)) == null || string.trim().length() <= 0);
                RM.setString(98, RM.getRawString(currentTranslationString));
                Menu.updateTranslationStringCounter();
                Menu.refreshMenu();
                return;
            }
            case 12: {
                Menu.stop();
                return;
            }
        }
        if (n == 41) {
            Menu.shellOut(Handson.moreGamesGetUrl());
            return;
        }
        if (n == 39) {
            RM.loadLocale(n2);
            Menu.startLoading(78);
            Menu.options[4] = RM.languageIndex;
            Menu.saveOptions();
            Menu.onLanguageChanged();
            Menu.stopLoadingRefresh();
            if (splashMode >= 7) {
                Menu.performMenuAction(3);
                return;
            }
            Menu.advanceSplashMode();
            Menu.changeMode(0, -1);
            return;
        }
        if (n == 14) {
            Menu.toggleSound(n2);
            return;
        }
        if (n == 23) {
            Menu.options[0] = 1;
            Menu.splashFinished();
            Menu.changeMode(0, -1);
            Menu.saveOptions();
            Menu.playMusic(true);
            return;
        }
        if (n == 24) {
            Menu.options[0] = 0;
            Menu.splashFinished();
            Menu.changeMode(0, -1);
            Menu.saveOptions();
            return;
        }
        if (n == 16) {
            Menu.toggleVibra();
            Menu.saveOptions();
            return;
        }
        game$486afe46.performMenuAction(n, n2);
        boolean bl = false;
    }

    private static final void openDebugMenu(int n) {
        byte by;
        Menu.menus[n][4] = by = (byte)(mode == 2 ? 6 : 3);
        int n2 = Menu.getMenuItemCount(n) - 1;
        if (Menu.getMenuItemCaption(n, n2) == 27) {
            byte by2;
            Menu.menuItems[n][n2][2] = by2 = (byte)(mode == 2 ? 4 : 3);
        }
        Menu.changeMenu(n, true);
    }

    private static void shellOut(String string) {
        Menu.doShellOut(string);
    }

    private static void doShellOut(String string) {
        try {
            Menu.stopMusic();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            MIDP20Proxy.platformRequest(Tinlet.instance, string);
            boolean bl = false;
            Menu.stop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void refreshMenu() {
        if (mode == 1) {
            int n = selectedItem;
            Menu.changeMenu(currentMenu, false);
            boolean bl = true;
            int n2 = Menu.getMenuType(currentMenu);
            if (n2 != 2 && n2 != 5) {
                boolean bl2 = bl = n < menuItems[currentMenu].length && menuItems[currentMenu][n][4] != 0;
            }
            if (bl) {
                Menu.setSelection(currentMenu, n, 0, false);
            }
        }
    }

    private static final void toggleVibra() {
        int n = options[3];
        Menu.options[3] = n = n == 0 ? 1 : 0;
        GCanvas.vibrate(550);
        Menu.refreshMenu();
    }

    public static final int getSplashID(int n) {
        if (n >= 0) {
            return RM.getValue(20, n, 0);
        }
        return -1;
    }

    private static final void drawSplash(Graphics graphics) {
        if (currentSplash >= 0) {
            if (RM.getValue(20, currentSplash, 4) == 1) {
                if (currentSplash == 5) {
                    game$486afe46.drawFinalSplash$11c44857(graphics, currentSplashTime);
                }
            } else {
                Menu.drawSplashImage(graphics, currentSplash);
            }
        }
        boolean bl = Menu.splashSkippable();
        if (splashMode >= 2 && !bl) {
            Menu.drawLoadingBar(graphics);
        } else if (bl) {
            Menu.drawSkipSplashMessage(graphics);
        }
        ++currentSplashFrame;
    }

    public static void drawSplashImage(Graphics graphics, int n) {
        int n2;
        int n3 = Menu.getSplashID(n);
        int n4 = 0;
        if (RM.isLoaded(n3)) {
            graphics.setColor(RM.getValue(20, n, 1));
            graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
            if (RM.getHeight(n3) < GCanvas.height) {
                GCanvas.drawImage(graphics, n3, GCanvas.width >> 1, GCanvas.height >> 1, 3);
                return;
            }
            GCanvas.drawImage(graphics, n3, GCanvas.width >> 1, 0, 17);
            return;
        }
        graphics.setColor(-16771840);
        graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        if (n >= 0 && (n4 = RM.getValue(20, n, 5)) >= 0 && (n2 = GCanvas.getFontDef(0)) >= 0) {
            GCanvas.drawString(graphics, 0, RM.t(n4), GCanvas.getWidth() >> 1, GCanvas.getHeight() >> 1, 33);
        }
    }

    public static int getCurrentSplashScreen() {
        return currentSplash;
    }

    private static void drawLoadingBar(Graphics graphics) {
        if (RM.getCurrentLoading() < RM.getNumResources() - 1) {
            int n = GCanvas.width * 900 >> 10;
            int n2 = GCanvas.height * 0 >> 10;
            int n3 = GCanvas.width * 62 >> 10;
            int n4 = GCanvas.height * 1000 >> 10;
            int n5 = GCanvas.width * 900 >> 10;
            int n6 = GCanvas.height * 1 >> 10;
            if ((n & 1) != 0) {
                --n;
            }
            if ((n2 & 1) != 0) {
                --n2;
            }
            if ((n5 & 1) != 0) {
                --n5;
            }
            if ((n6 & 1) != 0) {
                --n6;
            }
            if (n6 < 1) {
                n6 = 1;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            int n7 = n3 + (n - n5 >> 1);
            int n8 = n4 + (n2 - n6 >> 1);
            int n9 = (n5 << 10) / progressBarMax;
            int n10 = n9 * progressCurrent >> 10;
            if (n10 > 0) {
                graphics.setColor(-15643869);
                graphics.fillRect(n3, n4, n, n2);
                graphics.setColor(-16732353);
                graphics.fillRect(n7, n8, n10, n6);
            }
        }
    }

    private static void drawSkipSplashMessage(Graphics graphics) {
        int n = GCanvas.getHeight() - GCanvas.getFontHeight(7) - 5;
        String string = RM.t(91);
        int n2 = GCanvas.getWidth() >> 1;
        Menu.drawSplashMessage(graphics, string, n2, n += 0, 17);
    }

    private static void drawSplashMessage(Graphics graphics, String string, int n, int n2, int n3) {
        GCanvas.drawString(graphics, 7, string, n, n2, n3);
    }

    public static final void resetItemBottom() {
        MENU_ITEM_BOTTOM = sOldItemBottom;
    }

    private static int getItemBottom() {
        int n = game$486afe46.menuGetCustomItemBottom(currentMenu);
        if (n != -1) {
            return n;
        }
        return MENU_ITEM_BOTTOM;
    }

    public static final void setupLayout() {
        MENU_SEPERATOR_HEIGHT = GCanvas.getSpriteHeight(0) + 3;
        MENU_SEPERATOR_TOP = 3 + GCanvas.getFontHeight(2) + 3 + Math.abs(0);
        MENU_SCROLLTEXT_BOTTOM = GCanvas.getSoftKeyAreaTop();
        MENU_SCROLLTEXT_TOP = MENU_SCROLLTEXT_BOTTOM = Math.min(MENU_SCROLLTEXT_BOTTOM, GCanvas.height - RM.getHeight(7) - 2 - 1);
        sOldItemBottom = MENU_ITEM_BOTTOM = MENU_SCROLLTEXT_TOP - MENU_SEPERATOR_HEIGHT;
        MENU_TEXT_WIDTH = GCanvas.width - 8;
    }

    private static int getTextSpacingByType(int n, int n2, int n3) {
        int n4;
        if (n3 == -1) {
            n3 = currentMenu;
        }
        if ((n4 = game$486afe46.menuGetTextSpacingForMenu(n3, n)) != -1) {
            return n4;
        }
        int n5 = GCanvas.getFontHeight(n);
        if (GCanvas.isSpacingNeeded(n)) {
            if (n2 == 2) {
                // empty if block
            }
            return n5 + 0;
        }
        return n5;
    }

    private static void init() {
        Menu.setupLayout();
        menuCaller = new byte[menus.length];
        Menu.setMenuCaller(0, 9);
        menuSelection = new byte[menus.length];
        menuItemWidths = new int[40];
        Menu.onLanguageChanged();
        sInitialized = true;
    }

    private static boolean initialized() {
        return sInitialized;
    }

    public static final boolean isInitialized() {
        return splashMode > 5;
    }

    private static final void onLanguageChanged() {
        RM.prepareVarText(0, midletInfo);
        String string = null;
        string = RM.t(90);
        RM.prepareVarText(3, string);
        game$486afe46.onLanguageChanged();
    }

    public static final void addMenuItem(int n, int n2, int n3, int n4, int n5) {
        Menu.addMenuItem(n, Menu.getMenuItemCount(n), n2, n3, n4, n5);
    }

    private static void addMenuItem(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[][] byArray = menuItems[n];
        int n7 = byArray.length;
        byte[][] byArray2 = new byte[n7 + 1][6];
        for (int i = 0; i < n7; ++i) {
            System.arraycopy(byArray[i], 0, byArray2[i < n2 ? i : i + 1], 0, 6);
        }
        byte[] byArray3 = byArray2[n2];
        byte[] byArray4 = byArray3;
        byArray3[2] = (byte)n4;
        byArray4[3] = (byte)n5;
        byArray4[5] = (byte)n6;
        byArray4[4] = 1;
        Menu.setMenuItemCaption(byArray4, n3);
        Menu.menuItems[n] = byArray2;
    }

    public static final void replaceMenuItem(int n, int n2, int n3, int n4, int n5, int n6) {
        Menu.menuItems[n][n2][2] = (byte)n4;
        Menu.menuItems[n][n2][3] = (byte)n5;
        Menu.menuItems[n][n2][5] = (byte)n6;
        Menu.menuItems[n][n2][4] = 1;
        Menu.setMenuItemCaption(menuItems[n][n2], n3);
    }

    public static final int findMenuItem(int n, int n2) {
        int n3 = -1;
        int n4 = Menu.getMenuItemCount(n);
        for (int i = 0; i < n4; ++i) {
            if (Menu.getMenuItemCaption(n, i) != n2) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private static final void initSound() {
        if (sound$2c4aeb41 == null) {
            sound$2c4aeb41 = new Sound();
        }
    }

    private static void playMusic(boolean bl) {
        Menu.playSound(25, true, bl);
        titleMusicStarted = true;
    }

    public static final void playSound(int n) {
        if (Menu.getOption(0) != 0) {
            Menu.playSound(n, false, false);
        }
    }

    private static final void playSound(int n, boolean bl, boolean bl2) {
        if (sound$2c4aeb41 != null) {
            Menu.updateVolume();
            if (n >= 0) {
                sound$2c4aeb41.play(n, bl, bl2);
            }
        }
    }

    public static final void stopMusic() {
        try {
            if (sound$2c4aeb41 != null) {
                sound$2c4aeb41.stop();
            }
        }
        catch (Exception exception) {}
        titleMusicStarted = false;
    }

    private static final void updateVolume() {
        if (sound$2c4aeb41 != null) {
            int[] nArray = options;
            int n = options[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            sound$2c4aeb41.setVolume(n2 * n, n3 * n);
        }
    }

    private static final void drawLoading(Graphics graphics) {
        GCanvas.pushClip(graphics);
        graphics.setClip(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        if (mode != 0 && Menu.isInitialized()) {
            game$486afe46.drawCustomMenuBackground$26c5358c(graphics, -1);
        } else {
            graphics.setColor(-16771840);
            graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        }
        ++loadingFrame;
        if (statusText != null) {
            Menu.drawMenuItem(graphics, 11, statusText, 5, GCanvas.height - GCanvas.getFontHeight(11) - 5, 20, 5);
        }
        GCanvas.popClip(graphics);
    }

    private static final void drawMenu(Graphics graphics, int n) {
        int n2;
        int n3;
        GCanvas.pushClip(graphics);
        if (!Menu.isInitialized()) {
            graphics.setColor(-16771840);
            graphics.fillRect(0, 0, GCanvas.width, GCanvas.height);
        }
        int n4 = Menu.getMenuType(n);
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray == null) {
            return;
        }
        int n5 = byArray.length;
        MENU_LEFT = 0;
        int n6 = MENU_TEXT_WIDTH;
        int n7 = GCanvas.getWidth() >> 1;
        if (menuCaptionImage >= 0) {
            GCanvas.drawImage(graphics, menuCaptionImage, GCanvas.width - RM.getWidth(menuCaptionImage) - 4, Menu.getMenuSeperatorTop() - RM.getHeight(menuCaptionImage) - 4, 20);
        }
        if (Menu.isInitialized()) {
            game$486afe46.drawCustomMenuBackground$26c5358c(graphics, n);
        }
        int n8 = 0;
        if (Menu.isInitialized()) {
            n8 = 0 | Handson.drawCustomMenu$26c5357f(n);
            n8 |= game$486afe46.drawCustomMenu$26c5357f(graphics, n);
        }
        if ((n8 & 2) == 0) {
            n3 = Menu.getMenuCaption(n);
            n2 = MENU_LEFT + 2;
            if (n3 != -1) {
                if (scrInfo[0][0] != 0) {
                    n2 = GCanvas.width - Menu.updateScrolling(scrInfo[0]);
                }
                Menu.drawMenuItem(graphics, 2, RM.t(n3), n2, 3, 20, 1);
            }
        }
        if (n5 > 0 && (n8 & 1) == 0 && (n3 = Menu.countEnabledItems(n)) > 0) {
            Menu.setMenuItemPosition(currentMenu, true, false);
            n2 = Menu.getMenuDrawingTop();
            GCanvas.pushClip(graphics);
            if (GCanvas.clipRect(graphics, MENU_LEFT + 4, menuClipTop, n6, menuClipHeight + 1)) {
                Menu.drawMenuItemsCentered(graphics, n4, byArray, n5, MENU_LEFT, n2);
            }
            GCanvas.popClip(graphics);
            int n9 = menuClipTop - 0 - GCanvas.getSpriteHeight(0);
            int n10 = menuClipTop + menuClipHeight + 0;
            if (Menu.isMenuWrappable(n) && sShowUpDownArrows) {
                GCanvas.drawSprite(graphics, 0, n7, n9, 2);
                if (GCanvas.isTouchscreenEnabled()) {
                    Menu.addArrowVerticalHotspot(n7, n9, 1);
                }
                GCanvas.drawSprite(graphics, 0, n7, n10, 3);
                if (GCanvas.isTouchscreenEnabled()) {
                    Menu.addArrowVerticalHotspot(n7, n10, 4);
                }
            }
            if (showUpArrow) {
                GCanvas.drawSprite(graphics, 0, n7, n9, 0);
                if (GCanvas.isTouchscreenEnabled()) {
                    Menu.addArrowVerticalHotspot(n7, n9, 1);
                }
            }
            if (showDownArrow) {
                GCanvas.drawSprite(graphics, 0, n7, n10, 1);
                if (GCanvas.isTouchscreenEnabled()) {
                    Menu.addArrowVerticalHotspot(n7, n10, 4);
                }
            }
        }
        GCanvas.popClip(graphics);
    }

    private static boolean isMenuWrappable(int n) {
        int n2 = Menu.getMenuType(n);
        int n3 = Menu.countEnabledItems(n);
        if (n3 < 2) {
            return false;
        }
        boolean bl = n2 != 2 && n2 != 3 && n2 != 5 && Menu.countEnabledItems(n, n3) > 0 && game$486afe46.menuHighlightSelection$134632();
        return bl;
    }

    private static void addArrowVerticalHotspot(int n, int n2, int n3) {
        int n4 = GCanvas.getSpriteWidth(0);
        int n5 = GCanvas.getSpriteHeight(0);
        int n6 = n - n4;
        int n7 = n + n4;
        int n8 = n2 - 2;
        int n9 = n2 + n5 + 2;
        Menu.addHotspot(n6, n8, n7, n9, 0x4000000, n3);
    }

    private static int getMenuDrawingTop() {
        int n = (menuItemEase + 512 >> 10) + menuClipTop;
        return n;
    }

    private static int countEnabledItems(int n) {
        byte[][] byArray = menuItems[n];
        return Menu.countEnabledItems(n, byArray.length);
    }

    private static int countEnabledItems(int n, int n2) {
        byte[][] byArray = menuItems[n];
        n2 = GCanvas.clamp(n2, 0, byArray.length);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i][4] == 0) continue;
            ++n3;
        }
        return n3;
    }

    private static int countVisibleItems(int n, int n2) {
        byte[][] byArray = menuItems[n];
        n2 = GCanvas.clamp(n2, 0, byArray.length);
        int n3 = 0;
        int n4 = Menu.getMenuType(n);
        for (int i = 0; i < n2; ++i) {
            if (!Menu.isMenuItemVisible(n4, byArray[i])) continue;
            ++n3;
        }
        return n3;
    }

    private static final void setMenuItemPosition(int n, int n2) {
        if (selectedItem != -1) {
            menuItemPosition = -(n2 == 1 ? Menu.countEnabledItems(currentMenu, selectedItem) : selectedItem) * n;
            if (menuItemPosition < -menuItemPositionMax) {
                menuItemPosition = -menuItemPositionMax;
            }
            if (menuItemPosition > 0) {
                menuItemPosition = 0;
            }
        }
        if (menuItemPosition < -menuItemPositionMax) {
            menuItemPosition = -menuItemPositionMax;
        }
        if (menuItemPosition > 0) {
            menuItemPosition = 0;
        }
    }

    private static final boolean handleMenuSwipe(int n) {
        if (!GCanvas.isTouchscreenEnabled()) {
            return false;
        }
        if ((sSwipeSpeedY = sSwipeSpeedY * 95 / 100) != 0 || sSwiping) {
            int n2;
            int n3;
            byte[][] byArray = Menu.getMenuItems(n);
            int n4 = Menu.getMenuType(n);
            if (byArray == null) {
                return false;
            }
            int n5 = Menu.getMenuItemHeight(byArray[0], n4, -1);
            menuItemPosition = ((menuItemEase -= sSwipeSpeedY << 10) >> 10) / n5 * n5;
            if (menuItemEase > 0) {
                menuItemPosition = 0;
                menuItemEase = 0;
            }
            if (menuItemEase < -((n3 = (n2 = Menu.getMenuHeight(n)) - menuClipHeight) << 10)) {
                menuItemPosition = -n3;
                menuItemEase = menuItemPosition << 10;
            }
            selectedItem = -1;
            return true;
        }
        return false;
    }

    private static boolean menuNeedsScrolling(int n) {
        int n2;
        int n3 = Menu.getItemBottom() - Menu.getMenuItemTop() - 0;
        return n3 < (n2 = Menu.getMenuHeight(n));
    }

    private static final void setMenuItemPosition(int n, boolean bl, boolean bl2) {
        block18: {
            int n2;
            int n3;
            block20: {
                int n4;
                block22: {
                    block23: {
                        int n5;
                        int n6;
                        block21: {
                            int n7;
                            int n8;
                            block19: {
                                n8 = Menu.getMenuType(n);
                                if (GCanvas.isTouchscreenEnabled() && GCanvas.getPointerState(1) == 2 && n8 != 2 && !game$486afe46.menuEnableDragInMenu(currentMenu)) {
                                    return;
                                }
                                showUpArrow = false;
                                showDownArrow = false;
                                byte[][] byArray = Menu.getMenuItems(n);
                                if (byArray == null) {
                                    return;
                                }
                                int n9 = byArray.length;
                                int n10 = Menu.getItemBottom() - Menu.getMenuItemTop() - 0;
                                int n11 = Menu.getMenuHeight(n);
                                menuClipTop = Menu.getMenuItemTop() + 0;
                                menuClipHeight = Menu.getItemBottom() - 0 - menuClipTop;
                                n3 = Menu.getMenuItemHeight(byArray[0], n8, n);
                                if (n10 >= n11) {
                                    menuItemPosition = 0;
                                    menuClipTop = Menu.getMenuItemTop() + (n10 - n11) / 2;
                                    menuClipHeight = n11;
                                    menuItemEase = menuItemPosition << 10;
                                    menuItemPositionMax = n11 - menuClipHeight;
                                    return;
                                }
                                int n12 = menuClipHeight;
                                n7 = menuClipHeight / n3;
                                menuClipHeight = n7 * n3;
                                menuClipTop += (n12 - menuClipHeight) / 2;
                                menuItemPositionMax = n11 - menuClipHeight;
                                if (Menu.handleMenuSwipe(n)) break block18;
                                if (n8 != 2 && n8 != 5) break block19;
                                if (selectedItem > n9 - n7) {
                                    selectedItem = n9 - n7;
                                }
                                Menu.setMenuItemPosition(n3, n8);
                                break block20;
                            }
                            if (bl2) {
                                Menu.setMenuItemPosition(n3, n8);
                            }
                            n2 = selectedItem;
                            if (n8 == 1) {
                                n2 = Menu.countEnabledItems(currentMenu, selectedItem);
                            }
                            if (n2 == -1) break block20;
                            n4 = -menuItemPosition;
                            n6 = n4 / n3;
                            n5 = n6 + n7;
                            if (n7 <= 2) break block21;
                            if (n2 <= n6) {
                                n4 -= n3;
                            }
                            if (n2 < n5 - 1) break block22;
                            break block23;
                        }
                        if (n2 < n6) {
                            n4 -= n3;
                        }
                        if (n2 <= n5 - 1) break block22;
                    }
                    n4 += n3;
                }
                if (n4 > menuItemPositionMax) {
                    n4 = menuItemPositionMax;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                menuItemPosition = -n4;
            }
            if (bl) {
                int n13;
                int n14;
                if (GCanvas.isTouchscreenEnabled() && sSwipeSpeedY == 0 && sSwipeDirection == 1 && menuItemEase < menuItemPosition << 10) {
                    menuItemPosition -= n3;
                }
                if ((n2 = (menuItemPosition << 10) - menuItemEase) < -3 || n2 > 3) {
                    n14 = menuItemEase;
                    n13 = n2 / 4;
                } else {
                    n14 = menuItemEase;
                    n13 = n2;
                }
                menuItemEase = n14 + n13;
            } else {
                menuItemEase = menuItemPosition << 10;
            }
            showUpArrow = menuItemPosition < 0;
            showDownArrow = menuItemPosition > -menuItemPositionMax;
        }
    }

    private static final void drawMenuItemsCentered(Graphics graphics, int n, byte[][] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2;
        int n6 = n3 + (GCanvas.getWidth() - n3 >> 1);
        int n7 = n4;
        int n8 = n != 2 ? 3 : 6;
        int n9 = GCanvas.getFontHeight(n8);
        int[] nArray = scrInfo[1];
        boolean bl = false;
        int n10 = Menu.getTextSpacingByType(n8, n, -1);
        int n11 = 0;
        if (!game$486afe46.menuItemsCustomDrawn(Menu.getCurrentMenu())) {
            n11 = n10 - n9 >> 1;
        }
        int n12 = graphics.getClipY();
        int n13 = n12 + graphics.getClipHeight();
        if (selectedItem != -1 && game$486afe46.menuHighlightSelection$134632() && n != 2 && Menu.getMenuItemCaption(byArray2 = byArray[selectedItem]) != -1 && Menu.isMenuItemVisible(n, byArray2)) {
            n5 = Menu.countVisibleItems(Menu.getCurrentMenu(), selectedItem);
            Menu.showSelection(graphics, n3, n4 + n10 * n5, n10);
        }
        n5 = Menu.getMenuItemHeight(byArray[0], n, -1);
        for (int i = 0; i < n2; ++i) {
            block6: {
                block7: {
                    int n14;
                    int n15;
                    block8: {
                        int n16;
                        int n17;
                        int n18;
                        int n19;
                        Graphics graphics2;
                        block10: {
                            int n20;
                            int n21;
                            boolean bl2;
                            block9: {
                                byArray2 = byArray[i];
                                sCurrentDrawnItem = i;
                                bl2 = byArray2[4] != 0;
                                bl = Menu.isMenuItemVisible(n, byArray2);
                                if (!bl) break block6;
                                int n22 = n21 = bl2 ? n8 : 5;
                                if (game$486afe46.menuHighlightSelection$134632()) {
                                    int n23 = n21 = i == selectedItem ? 4 : n21;
                                }
                                if (n7 <= n12 - n5) break block7;
                                n15 = n7 + n11;
                                n14 = Menu.getMenuItemCaption(byArray2);
                                if (n14 == -1) break block7;
                                if (n == 2) break block8;
                                if (i == selectedItem && nArray[0] != 0) break block9;
                                int n24 = GCanvas.getStringWidth(RM.getFittedString(i), n21);
                                n20 = n6 - (n24 >> 1);
                                Menu.drawMenuItem(graphics, n21, RM.getFittedString(i), n20, n15, 20, i == selectedItem ? 2 : 0);
                                if (!GCanvas.isTouchscreenEnabled() || !bl2 || !game$486afe46.menuHotspotPerItem(currentMenu)) break block7;
                                graphics2 = graphics;
                                n19 = n20;
                                n18 = n7;
                                n17 = n20;
                                n16 = GCanvas.getStringWidth(RM.getFittedString(i), n21);
                                break block10;
                            }
                            n20 = GCanvas.width - Menu.updateScrolling(nArray);
                            Menu.drawMenuItem(graphics, n21, RM.t(n14), n20, n15, 20, 2);
                            if (!GCanvas.isTouchscreenEnabled() || !bl2 || !game$486afe46.menuHotspotPerItem(currentMenu)) break block7;
                            graphics2 = graphics;
                            n19 = n20;
                            n18 = n7;
                            n17 = n20;
                            n16 = GCanvas.getTextWidth(n14, n21);
                        }
                        Menu.addHotspot(graphics2, n19, n18, n17 + n16, n15 + n10, 0x2000000, i);
                        break block7;
                    }
                    Menu.drawMenuItemSimple(graphics, 6, RM.dt(n14), n6, n15, 17, 0);
                }
                n7 += n10;
            }
            if (n7 >= n13) break;
        }
        sCurrentDrawnItem = -1;
    }

    private static void showSelection(Graphics graphics, int n, int n2, int n3) {
        if (game$486afe46.menuDrawSelectionBar(graphics, n, n2, n3)) {
            return;
        }
        GCanvas.pushClip(graphics);
        graphics.setClip(n, graphics.getClipY(), GCanvas.width - n, graphics.getClipHeight());
        graphics.setColor(-16764928);
        graphics.fillRect(n, n2 + 1, GCanvas.width - n, n3 - 2);
        GCanvas.popClip(graphics);
    }

    private static final boolean isDynamicType(int n) {
        return n == 1 || n == 4;
    }

    private static final boolean isMenuItemVisible(int n, byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = byArray[4] != 0;
        return !Menu.isDynamicType(n) || bl;
    }

    private static final int updateScrolling(int[] nArray) {
        int n = nArray[1];
        int n2 = n >> 10;
        nArray[4] = nArray[4] - 1;
        if (nArray[4] < 0) {
            int n3 = nArray[2];
            int n4 = nArray[3];
            nArray[1] = n += 1536 * nArray[5];
            if (n >= n3 || n < n4) {
                nArray[5] = nArray[5] * -1;
            }
        }
        return n2;
    }

    public static final void setMenuItemOverlayWith(int n) {
        menuItemOverlayWidth = n;
    }

    private static void drawMenuItem(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (game$486afe46.menuHighlightSelection$134632()) {
            Menu.sCustomItemPositionArray[0] = n2;
            Menu.sCustomItemPositionArray[1] = n3;
            if (game$486afe46.getCustomMenuItemPosition$1c96c319(n5)) {
                n2 = sCustomItemPositionArray[0];
                n3 = sCustomItemPositionArray[1];
            }
        }
        if (!game$486afe46.menuDrawItem$3971e4ba(graphics, n, string, n3, n4, n5)) {
            GCanvas.drawString(graphics, n, string, n2, n3, n4);
        }
    }

    private static void drawMenuItemSimple(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (game$486afe46.menuHighlightSelection$134632()) {
            Menu.sCustomItemPositionArray[0] = n2;
            Menu.sCustomItemPositionArray[1] = n3;
            if (game$486afe46.getCustomMenuItemPosition$1c96c319(n5)) {
                n2 = sCustomItemPositionArray[0];
                n3 = sCustomItemPositionArray[1];
            }
        }
        if (!game$486afe46.menuDrawItemSimple$276ff40f()) {
            GCanvas.drawString(graphics, n, string, n2, n3, n4);
        }
    }

    private static final void setMenuItemCaption(byte[] byArray, int n) {
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
    }

    public static final int getMenuItemCount(int n) {
        return menuItems[n].length;
    }

    private static final int getMenuItemCaption(byte[] byArray) {
        return RM.getShortFromBytes(byArray, 0);
    }

    public static final int getMenuItemCaption(int n, int n2) {
        if (n2 == -1) {
            return -1;
        }
        return RM.getShortFromBytes(menuItems[n][n2], 0);
    }

    public static final int getMenuItemIndex(int n, String string) {
        if (n == -1) {
            n = currentMenu;
        }
        int n2 = Menu.getMenuItemCount(n);
        for (int i = 0; i < n2; ++i) {
            int n3 = Menu.getMenuItemCaption(n, i);
            if (!RM.t(n3).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static void setMenuCaller(int n, int n2) {
        Menu.menuCaller[n] = (byte)n2;
    }

    public static final int getCurrentMenu() {
        return currentMenu;
    }

    private static int getMenuItemHeight(int n) {
        return Menu.getMenuItemHeight(menuItems[n][0], Menu.getMenuType(n), n);
    }

    private static final int getMenuItemHeight(byte[] byArray, int n, int n2) {
        int n3 = n == 2 || n == 5 ? 6 : 3;
        int n4 = Menu.getTextSpacingByType(n3, n, n2);
        int n5 = 0;
        n5 = n4;
        return n5;
    }

    private static final byte[][] getMenuItems(int n) {
        if (Menu.getMenuType(n) != 2) {
            return menuItems[n];
        }
        return textScreenItems;
    }

    private static int getMenuHeight(int n) {
        byte[][] byArray = Menu.getMenuItems(n);
        if (byArray != null && byArray.length > 0) {
            int n2 = Menu.getMenuType(n);
            if (Menu.isDynamicType(n2)) {
                int n3 = byArray.length;
                int n4 = Menu.getMenuItemHeight(byArray[0], n2, n);
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (byArray[i][4] == 0) continue;
                    n5 += n4;
                }
                return n5;
            }
            return Menu.getMenuItemHeight(byArray[0], n2, n) * byArray.length;
        }
        return GCanvas.getFontHeight(3);
    }

    public static final int getMenuItemTop() {
        return Menu.getMenuSeperatorTop() + MENU_SEPERATOR_HEIGHT;
    }

    private static int getMenuSeperatorTop() {
        return Menu.getMenuSeperatorTop(currentMenu);
    }

    public static final int getMenuSeperatorTop(int n) {
        int n2 = game$486afe46.menuGetCustomItemTop(n);
        if (n2 == -1) {
            n2 = MENU_SEPERATOR_TOP;
        }
        int n3 = n2 + menuCaptionOffset;
        if (menuCaptionImage >= 0) {
            n3 += RM.getHeight(menuCaptionImage);
            n3 += 4;
        }
        return n3;
    }

    private static final void updateMenuItemsWidths(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        int n3 = Menu.getMenuType(n);
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            int n4 = 4;
            if (Menu.isMenuItemVisible(n3, byArray2)) {
                n4 = menuItemOverlayWidth << 1;
                String string = RM.t(Menu.getMenuItemCaption(byArray2));
                RM.fitString(string, i, MENU_TEXT_WIDTH - MENU_LEFT - n4, 3);
                n4 += GCanvas.getStringWidth(string, 3);
            }
            Menu.menuItemWidths[i] = n4;
        }
    }

    private static final boolean processSoftKeys() {
        int n;
        if (mode != 0 && (n = GCanvas.getSoftkeys()) != 0) {
            int n2;
            byte by;
            int n3;
            int n4 = -1;
            if (n == 131072 && lskEnabled) {
                n4 = 3;
            }
            if (n == 262144 && rskEnabled) {
                n4 = 4;
            }
            if (n == 524288) {
                if (rskEnabled && (n3 = GCanvas.getRSK()) >= 0 && ((by = GCanvas.softkeys[n3][3]) == 3 || by == 4 || by == 12 || n3 == 10)) {
                    n4 = 4;
                }
                if (lskEnabled && GCanvas.getLSK() == 10) {
                    n4 = 3;
                }
            }
            n3 = -1;
            if (n4 == 3) {
                n2 = GCanvas.getLSK();
            } else if (n4 == 4) {
                n2 = n3 = GCanvas.getRSK();
            }
            if (n3 != -1) {
                by = GCanvas.softkeys[n3][3];
                Menu.performMenuAction(by);
            }
            return true;
        }
        return false;
    }

    public static final void changeMode(int n, int n2) {
        GCanvas.resetKeys();
        if (n == 2) {
            paused = false;
            if (currentMenu != 1) {
                Menu.stopMusic();
            }
            Menu.menuSelection[1] = 0;
            lskEnabled = true;
            rskEnabled = true;
            Menu.notifyGame(true);
        } else if (n == 1) {
            if (mode == 2) {
                if (game$486afe46.musicShouldStop(n2)) {
                    Menu.stopMusic();
                }
                Menu.notifyGame(false);
            }
        } else if (n == 0) {
            GCanvas.setSoftButton(-1, -1);
        }
        GCanvas.hideSoftKeys = n == 0;
        mode = n;
    }

    private static final void notifyGame(boolean bl) {
        game$486afe46.notify(bl);
        if (bl) {
            game$486afe46.prepareSounds$4a224d26(sound$2c4aeb41);
            return;
        }
        game$486afe46.freeSounds$4a224d26(sound$2c4aeb41);
    }

    private static int getTextWidth() {
        return MENU_TEXT_WIDTH - MENU_LEFT - 2 * GCanvas.getCharWidth('X', 6);
    }

    public static final void changeMenu(int n, boolean bl) {
        GCanvas.resetKeys();
        menuCaptionImage = -1;
        menuCaptionOffset = sNextCaptionOffset;
        sNextCaptionOffset = 0;
        if (bl) {
            if (Menu.getMenuType(currentMenu) != 2) {
                Menu.menuSelection[Menu.currentMenu] = (byte)selectedItem;
            }
            if (n != currentMenu) {
                Menu.setMenuCaller(n, currentMenu);
            }
        } else {
            byte by;
            byte bl2 = (byte)(currentMenu != n ? 0 : selectedItem);
            if (menus[currentMenu][2] == 4) {
                by = 0;
            }
            Menu.menuSelection[Menu.currentMenu] = by;
        }
        boolean bl2 = n != currentMenu || mode != 1;
        Menu.prepareMenuChange(currentMenu, n);
        if (mode != 1) {
            Menu.changeMode(1, n);
        }
        boolean bl3 = false;
        if (n == 0 && currentMenu != 0) {
            bl3 = true;
        }
        textScreenItems = null;
        RM.flushDynamicStrings(0);
        int n2 = Menu.getMenuType(n);
        if (n2 == 2) {
            boolean bl4 = n == 4 || n == 5 || n == 6 || n == 7;
            Menu.prepareScrollText(n, 6, Menu.getTextWidth(), bl4);
        }
        Menu.updateMenuItemsWidths(n);
        Menu.setSelection(n, menuSelection[n], 1, bl2);
        Menu.setMenuItemPosition(n, false, false);
        Menu.initMenuCaptionScroller(n);
        currentMenu = n;
        if (bl3 && !titleMusicStarted) {
            Menu.playMusic(true);
        }
    }

    public static final void setMenuCaptionImage(int n) {
        menuCaptionImage = n;
    }

    public static final void setMenuCaptionOffset(int n) {
        if (n != menuCaptionOffset) {
            menuCaptionOffset = n;
            Menu.setMenuItemPosition(currentMenu, true, true);
        }
    }

    private static final void setBooleanOptionText(int n, int n2) {
        RM.prepareVarText(n, RM.t(options[n2] == 0 ? 51 : 50));
    }

    private static final void prepareMenuChange(int n, int n2) {
        if (n2 == 28) {
            int n3 = Menu.getOption(4);
            if (n3 < 0) {
                n3 = -(n3 + 1);
            }
            Menu.menuSelection[28] = (byte)n3;
        }
        if (n2 == 2) {
            Menu.setBooleanOptionText(4, 3);
        }
        if (n2 == 14 && n2 != n) {
            currentTranslationString = -1;
            Menu.performMenuAction(19, 1);
        }
        if (n == 2 && n2 == menuCaller[2]) {
            Menu.saveOptions();
        }
        if (n2 == 2) {
            Menu.prepareVolumeText();
        }
        game$486afe46.onPrepareMenuChange(n2, n);
        Menu.evaluateMenuConditions(n2);
    }

    private static void evaluateMenuConditions(int n) {
        byte[][] byArray = menuItems[n];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            byte by = byArray2[5];
            int n3 = byArray2[3] & 0xFF;
            boolean bl = Menu.evaluateCondition(by, n3);
            byArray2[4] = (byte)(bl ? 1 : 0);
        }
    }

    private static final void updateTranslationStringCounter() {
        RM.prepareVarText(9, String.valueOf(currentTranslationString + 1), String.valueOf(RM.getNumStrings()));
    }

    private static final void saveRMS(int n) {
        RM.saveStore(n);
    }

    public static final void saveOptions() {
        RM.setRMS(0, options);
        Menu.saveRMS(0);
    }

    private static boolean evaluateCondition(int n, int n2) {
        switch (n) {
            case -1: 
            case 0: {
                return true;
            }
            case 2: 
            case 3: {
                return menuCaller[2] == 0;
            }
            case 5: {
                return GCanvas.isLandscape();
            }
        }
        int n3 = game$486afe46.evaluateCondition(n, n2);
        if (n3 < 0) {
            return false;
        }
        if (n3 > 0) {
            return true;
        }
        if (n == 8) {
            return menuCaller[2] == 0;
        }
        return true;
    }

    public static final void setDefaultSelection(int n, int n2) {
        Menu.menuSelection[n] = (byte)n2;
    }

    public static final int getSelection() {
        return selectedItem;
    }

    public static final void setSelection(int n) {
        selectedItem = n;
        Menu.setMenuItemPosition(currentMenu, false, false);
    }

    private static void setSelection(int n, int n2, int n3, boolean bl) {
        Menu.setSelection(n, n2, n3, bl, false);
    }

    /*
     * Unable to fully structure code
     */
    private static final void setSelection(int var0, int var1_1, int var2_2, boolean var3_3, boolean var4_4) {
        block23: {
            block22: {
                var5_5 = Menu.menuItems[var0];
                var6_6 = -1;
                if (!var3_3) {
                    var6_6 = Menu.selectedItem;
                }
                if (var8_8 = (var7_7 = Menu.getMenuType(var0)) == 2) {
                    var5_5 = Menu.textScreenItems;
                }
                var9_9 = var5_5.length;
                if (var8_8 && !var3_3) {
                    var10_10 = Menu.menuClipHeight / Menu.getMenuItemHeight(var0);
                    var1_1 -= var2_2;
                    var1_1 = GCanvas.clamp(var1_1 + (var10_10 - 1) * var2_2, 0, var9_9 - 1);
                }
                if ((var10_10 = var8_8 == false && var7_7 != 5 && (var1_1 < 0 || var1_1 >= var9_9) ? 1 : 0) != 0) {
                    if (var1_1 < 0) {
                        var1_1 = var9_9 - 1;
                    }
                    if (var1_1 >= var9_9) {
                        v0 = 0;
                    }
                } else {
                    if (var1_1 < 0) {
                        var1_1 = 0;
                    }
                    if (var1_1 >= var9_9) {
                        v0 = var1_1 = var9_9 - 1;
                    }
                }
                if ((var11_11 = Menu.countEnabledItems(var0, var9_9)) != 0) break block22;
                v1 = 0;
                ** GOTO lbl42
            }
            if (var8_8 || var1_1 < 0) break block23;
            while (var5_5[var1_1][4] == 0) {
                if (var2_2 == 0) {
                    var2_2 = 1;
                }
                if ((var1_1 += var2_2) < 0) {
                    if (var3_3) {
                        var1_1 = 0;
                        var2_2 = -var2_2;
                    } else {
                        var1_1 = var9_9 - 1;
                    }
                }
                if (var1_1 < var9_9) continue;
                if (var3_3) {
                    var1_1 = 0;
                    var2_2 = -var2_2;
                    continue;
                }
                v1 = var6_6;
lbl42:
                // 2 sources

                var1_1 = v1;
                break;
            }
        }
        Menu.selectedItem = var1_1;
        if ((var10_10 != 0 || var3_3) && !var4_4) {
            Menu.setMenuItemPosition(var0, false, true);
        }
        Menu.lskEnabled = true;
        Menu.rskEnabled = true;
        if (!GCanvas.hideSoftKeys) {
            var12_12 = 0;
            if (var0 == 28 && Menu.menuCaller[var0] != 2) {
                var12_12 = 2;
            }
            v2 = ((var12_12 |= Menu.game$486afe46.updateSoftButtonState$134621()) & 1) == 0;
            var13_13 = Menu.menus[var0];
            var14_14 = (Menu.lskEnabled &= v2) != false ? var13_13[3] : -1;
            var15_15 = (Menu.rskEnabled &= (var12_12 & 2) == 0) != false ? var13_13[4] : -1;
            GCanvas.setSoftButton(var14_14, var15_15);
        }
        Menu.initMenuScroller(var0);
    }

    private static final void initMenuCaptionScroller(int n) {
        int n2 = Menu.getMenuCaption(n);
        if (n2 != -1) {
            int n3 = GCanvas.getTextWidth(n2, 2);
            Menu.setMenuScrollData(scrInfo[0], n3, 2);
            return;
        }
        Menu.scrInfo[0][0] = 0;
    }

    private static final void initMenuScroller(int n) {
        int n2 = Menu.getMenuType(n);
        if (n2 != 2 && n2 != 5) {
            int n3 = 0;
            n3 = menuItemOverlayWidth;
            if (selectedItem != -1) {
                Menu.setMenuScrollData(scrInfo[1], menuItemWidths[selectedItem], n3);
            }
            return;
        }
        Menu.scrInfo[1][0] = 0;
    }

    private static final void setMenuScrollData(int[] nArray, int n, int n2) {
        nArray[0] = 0;
        if (n > MENU_TEXT_WIDTH) {
            nArray[0] = 1;
            nArray[2] = n + 2 + 8 - n2 << 10;
            nArray[3] = GCanvas.width - 4 - n2 << 10;
            nArray[4] = 20;
            nArray[1] = nArray[3];
            nArray[5] = 1;
        }
    }

    public static final void startLoading(int n) {
        showLoading = true;
        statusText = RM.t(n);
        GCanvas.setSoftButton(-1, -1);
        GCanvas.hideSoftKeys = true;
        loadingFrame = 0;
        if (mode == 2) {
            Menu.notifyGame(false);
        }
        GCanvas.redraw();
        try {
            Thread.sleep(50L);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void stopLoadingRefresh() {
        showLoading = false;
        statusText = null;
        GCanvas.resetKeys();
        boolean bl = GCanvas.hideSoftKeys = mode == 2;
        if (mode == 2) {
            Menu.notifyGame(true);
            return;
        }
        Menu.refreshMenu();
    }

    public static final void stopLoading() {
        showLoading = false;
        statusText = null;
        GCanvas.hideSoftKeys = mode == 2;
        GCanvas.resetKeys();
        if (mode == 2) {
            Menu.notifyGame(true);
        }
    }

    private static final int nextBreak(int n, String string, int n2, int n3) {
        int n4 = n;
        int n5 = string.length();
        if (n >= n5) {
            return -1;
        }
        int n6 = n;
        while (true) {
            int n7;
            if (n4 < n5) {
                n7 = string.charAt(n4);
                if (n7 > 32 || n7 == 147) {
                    ++n4;
                    continue;
                }
                if (n4 < n5 - 1) {
                    char c = string.charAt(n4 + 1);
                    n7 = c;
                    if (c == '!' || n7 == 63 || n7 == 58 || n7 == 187) {
                        n4 += 2;
                        continue;
                    }
                    if (n4 > 0) {
                        char c2 = string.charAt(n4 - 1);
                        n7 = c2;
                        if (c2 == '\u00ab') {
                            ++n4;
                            continue;
                        }
                    }
                }
            }
            n7 = GCanvas.getSubstringWidth(string, n6, n4 - n6, n2);
            if (n == n6 && n7 > n3) {
                while (GCanvas.getSubstringWidth(string, n6, --n4 - n6, n2) >= n3) {
                    char c = string.charAt(n4);
                    if (c != '.' && c != ',' && c != '\u3002') continue;
                    --n4;
                }
                n = n4;
                break;
            }
            if (n7 <= n3) {
                n = n4;
            }
            if (n7 > n3 || n4 >= n5 || string.charAt(n4) == '\n') break;
            ++n4;
        }
        if (n < n5) {
            ++n;
        }
        return n;
    }

    private static final int multiLineGetNonEmptyLines(Vector vector) {
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            String string = (String)vector.elementAt(i);
            if (string.length() <= 0) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    private static final void prepareScrollText(int n, int n2, int n3, boolean bl) {
        Object object;
        int n4;
        if (bl) {
            Menu.startLoading(78);
        }
        Vector<String> vector = new Vector<String>(10, 2);
        byte[][] byArray = menuItems[n];
        int n5 = byArray.length;
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            int n7;
            n4 = 0;
            String string = RM.t(Menu.getMenuItemCaption(byArray[i]));
            while (n4 >= 0 && (n7 = Menu.nextBreak(n4, string, n2, n3)) >= 0) {
                object = string.substring(n4, n7).trim();
                int n8 = ((String)object).length();
                if (n8 > 0 || n6 > 0) {
                    vector.addElement(((String)object).replace('\u0093', ' '));
                }
                n6 = n8;
                n4 = n7;
            }
            if (n6 <= 0) continue;
            vector.addElement("");
            n6 = 0;
        }
        byte[] byArray2 = menuItems[n][0];
        n4 = byArray2.length;
        int n9 = Menu.multiLineGetNonEmptyLines(vector);
        byte[][] byArray3 = new byte[n9][n4];
        RM.flushDynamicStrings(n9);
        for (int i = 0; i < n9; ++i) {
            object = byArray3[i];
            System.arraycopy(byArray2, 0, object, 0, n4);
            String string = (String)vector.elementAt(i);
            int n10 = RM.createDynamicString(string);
            Menu.setMenuItemCaption((byte[])object, n10);
        }
        textScreenItems = byArray3;
        if (bl) {
            Menu.stopLoading();
        }
    }

    public static int breakLine(int[] nArray, int n, String string, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = 0;
        while (n6 >= 0 && (n3 = Menu.nextBreak(n4, string, n, n2)) >= 0) {
            nArray[n5] = n4;
            nArray[n5 + 1] = n3;
            n5 += 2;
            n6 = n3;
        }
        return n5 >> 1;
    }

    protected static final void onLoadingStart(int n) {
        progressBarMax = n;
        GCanvas.redraw();
    }

    public static final void onLoadingStep(int n) {
        progressCurrent = n;
        if (RM.getCurrentLoading() > 20 && currentSplash < 0) {
            Menu.startSplash(0);
        }
        if ((n & 0x1F) == 0) {
            GCanvas.redraw();
        }
        GCanvas.idleTick();
    }

    protected static final void onLoadingDone() {
        Menu.advanceSplashMode();
    }

    public static final void loadJadParams() {
        Menu.midletInfo[0] = Menu.readJad("MIDlet-Name") + "";
        Menu.midletInfo[0] = midletInfo[0].toUpperCase();
        Menu.midletInfo[1] = Menu.readJad("MIDlet-Version") + "";
        int n = GCanvas.getEnforcedSize(GCanvas.width, GCanvas.height);
        int n2 = n & 0xFFFF;
        int n3 = (n & 0xFFFF0000) >> 16;
        int n4 = Menu.readJadInt("FORCEDSCREENWIDTH", n3);
        int n5 = Menu.readJadInt("FORCEDSCREENHEIGHT", n2);
        GCanvas.setForcedSize(n4, n5);
    }

    public static final String readJad(String string) {
        String string2 = Tinlet.instance.getAppProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private static int readJadInt(String string, int n) {
        int n2;
        block5: {
            String string2 = Menu.readJad(string);
            n2 = n;
            if (string2 != null) {
                try {
                    int n3;
                    n2 = n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    int n4;
                    if ("Y".equals(string2)) {
                        n4 = 1;
                    } else {
                        if (!"N".equals(string2)) break block5;
                        n4 = 0;
                    }
                    n2 = n4;
                }
            }
        }
        return n2;
    }

    public static int getMode() {
        return mode;
    }

    /*
     * Unable to fully structure code
     */
    private static final void handleTouchScreenInput() {
        if (Menu.mCurrentTouchScreenEvent == -1) {
            Menu.mCurrentTouchScreenEvent = GCanvas.sCurrentTouchscreenEvent;
        }
        if (Menu.mCurrentTouchScreenEvent == -1) {
            return;
        }
        while (Menu.mCurrentTouchScreenEvent != GCanvas.sCurrentTouchscreenEvent) {
            if (++Menu.mCurrentTouchScreenEvent >= 40) {
                Menu.mCurrentTouchScreenEvent = 0;
            }
            var2_1 = Menu.mCurrentTouchScreenEvent * 3;
            var1 = GCanvas.sTouchscreenEvents[var2_1];
            Menu.crossHairTargetX = GCanvas.sTouchscreenEvents[var2_1 + 1];
            Menu.crossHairTargetY = GCanvas.sTouchscreenEvents[var2_1 + 2];
            switch (var1) {
                case 0: {
                    Menu.crossHairTargetX = -1;
                    Menu.crossHairTargetY = -1;
                    break;
                }
                case 1: {
                    Menu.sSwipeStartY = Menu.sSwipeLastY = Menu.crossHairTargetY;
                    Menu.sSwipeSpeedY = 0;
                    Menu.sClickStartFrame = GCanvas.getGlobalFrameCount();
                    Menu.crossHairVisible = true;
                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x2000000);
                    if (var2_1 >= 0) {
                        Menu.mInternalTouchSelection = var2_1;
                    }
                    if ((var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x8000000)) > 0) {
                        Menu.mInternalTouchSelection = var2_1;
                    }
                    if ((var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x10000000)) >= 0) {
                        v0 = var2_1;
                        break;
                    }
                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x20000000);
                    if (var2_1 < 0) break;
                    v0 = var2_1;
                    break;
                }
                case 2: {
                    if (!Menu.sSwiping && GCanvas.getGlobalFrameCount() - Menu.sClickStartFrame <= 5 && Math.abs(Menu.sSwipeStartY - Menu.crossHairTargetY) <= 10) break;
                    Menu.sSwiping = true;
                    Menu.sSwipeSpeedY = Menu.sSwipeLastY - Menu.crossHairTargetY;
                    Menu.sSwipeLastY = Menu.crossHairTargetY;
                    Menu.sSwipeDirection = Menu.sSwipeSpeedY < 0 ? -1 : 1;
                    Menu.mInternalTouchSelection = -1;
                    Menu.crossHairVisible = false;
                    break;
                }
                case 3: {
                    Menu.crossHairVisible = false;
                    Menu.sSwipeLastY = -1;
                    Menu.sSwipeStartY = -1;
                    Menu.sSwiping = false;
                    Menu.crossHairVisible = false;
                    if (GCanvas.getGlobalFrameCount() - Menu.sClickStartFrame > 5) break;
                    Menu.sClickStartFrame = -1;
                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x1000000);
                    if (var2_1 > 0) {
                        switch (var2_1) {
                            case 1: {
                                v1 = -6;
                                break;
                            }
                            case 3: {
                                v1 = -7;
                                break;
                            }
                            case 2: {
                                v1 = 0;
                                break;
                            }
                            default: {
                                v1 = 0;
                            }
                        }
                        var3_2 = v1;
                        GCanvas.simulateKeyPress(v1);
                        break;
                    }
                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x2000000);
                    if (var2_1 < 0 || var2_1 != Menu.mInternalTouchSelection) ** GOTO lbl74
                    if (var2_1 != Menu.selectedItem) {
                        Menu.setSelection(Menu.currentMenu, var2_1, 0, false, true);
                    }
                    Menu.menuItemSelected();
                    ** GOTO lbl91
lbl74:
                    // 1 sources

                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x4000000);
                    if (var2_1 <= 0 || var2_1 != Menu.mInternalTouchSelection) ** GOTO lbl78
                    v2 = var2_1;
                    ** GOTO lbl90
lbl78:
                    // 1 sources

                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x10000000);
                    if (var2_1 < 0 || var2_1 != Menu.mInternalTouchSelection) ** GOTO lbl82
                    Menu.performMenuAction(var2_1);
                    ** GOTO lbl91
lbl82:
                    // 1 sources

                    var2_1 = Menu.pickHotspots(Menu.crossHairTargetX, Menu.crossHairTargetY, 0x20000000);
                    if (var2_1 >= 0 && var2_1 == Menu.mInternalTouchSelection) {
                        if (var2_1 != Menu.selectedItem) {
                            Menu.setSelection(Menu.currentMenu, var2_1, 0, false, true);
                        } else {
                            Menu.menuItemSelected();
                        }
                    }
                    if (Menu.mode != 0) ** GOTO lbl91
                    v2 = 1040;
lbl90:
                    // 2 sources

                    GCanvas.simulateVKeyPress(v2);
lbl91:
                    // 4 sources

                    v0 = Menu.mInternalTouchSelection = -1;
                }
            }
            if (!Menu.initialized() || !Menu.menuNeedsScrolling(Menu.currentMenu)) continue;
            Menu.handleMenuSwipe(Menu.currentMenu);
        }
    }

    private static final void drawTouchScreenFeatures(Graphics graphics) {
        if (splashMode < 7) {
            return;
        }
        boolean bl = crossHairVisible;
        if (bl) {
            int n = GCanvas.getWidth();
            int n2 = GCanvas.getHeight();
            int n3 = crossHairTargetX;
            int n4 = crossHairTargetY;
            int n5 = n3;
            int n6 = n4;
            int n7 = n3;
            int n8 = n4;
            boolean bl2 = false;
            if (Menu.pickHotspots(n3, n4, 0x2000000, rcHotspot) >= 0) {
                RM.inflateRect(rcHotspot, 4, 2, 4, 2);
                n5 = Math.min(n5, rcHotspot[0]);
                n6 = Math.min(n6, rcHotspot[1]);
                n7 = Math.max(n7, rcHotspot[2]);
                n8 = Math.max(n8, rcHotspot[3]);
                bl2 = true;
            }
            graphics.setColor(-10436512);
            graphics.drawLine(0, n4, n5, n4);
            graphics.drawLine(n3, 0, n3, n6);
            graphics.drawLine(n7, n4, n, n4);
            graphics.drawLine(n3, n8, n3, n2);
            if (bl2) {
                int n9 = rcHotspot[0];
                int n10 = rcHotspot[2];
                int n11 = rcHotspot[1];
                int n12 = rcHotspot[3];
                graphics.setColor(-1138688);
                graphics.drawLine(n9, n11, n9, n12);
                graphics.drawLine(n10, n11, n10, n12);
                graphics.drawLine(n9, n11, n9 + 6, n11);
                graphics.drawLine(n9, n12, n9 + 6, n12);
                graphics.drawLine(n10 - 6, n11, n10, n11);
                graphics.drawLine(n10 - 6, n12, n10, n12);
            }
        }
    }

    public static final void addHotspotAligned(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        if ((n7 & 1) != 0) {
            n8 = n3 - n >> 1;
            n -= n8;
            n3 -= n8;
        }
        if ((n7 & 8) != 0) {
            n8 = n3 - n;
            n -= n8;
            n3 -= n8;
        }
        if ((n7 & 2) != 0) {
            n8 = n4 - n2 >> 1;
            n2 -= n8;
            n4 -= n8;
        }
        if ((n7 & 0x20) != 0) {
            n8 = n4 - n2;
            n2 -= n8;
            n4 -= n8;
        }
        if (n5 == 0x1000000) {
            n -= 12;
            n2 -= 12;
            n3 += 12;
            n4 += 12;
        }
        Menu.addHotspot(n, n2, n3, n4, n5, n6);
    }

    public static final void addHotspot(int n, int n2, int n3, int n4, int n5, int n6) {
        Menu.addHotspot(null, n, n2, n3, n4, n5, n6);
    }

    private static void addHotspot(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        block3: {
            block2: {
                int n7 = numHotspotsActive;
                int n8 = n7 * 5;
                Menu.hotspots[n8 + 0] = n;
                Menu.hotspots[n8 + 1] = n2;
                Menu.hotspots[n8 + 2] = n3;
                Menu.hotspots[n8 + 3] = n4;
                Menu.hotspots[n8 + 4] = n5 | n6;
                if (graphics == null) break block2;
                RM.intersectRect(hotspots, n8, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
                if (RM.isRectEmpty(hotspots, n8)) break block3;
            }
            ++numHotspotsActive;
        }
    }

    public static final int pickHotspots(int n, int n2, int n3) {
        return Menu.pickHotspots(n, n2, n3, null);
    }

    private static final int pickHotspots(int n, int n2, int n3, int[] nArray) {
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < numHotspotsActive; ++i) {
            if (RM.rectContains(hotspots, n5, n, n2)) {
                int n6 = hotspots[n5 + 4];
                if (n3 != 0 && (n6 & 0xFF000000) != n3) break;
                n4 = n6 & 0xFFFFFF;
                if (nArray == null) break;
                nArray[0] = hotspots[n5 + 0];
                nArray[1] = hotspots[n5 + 1];
                nArray[2] = hotspots[n5 + 2];
                nArray[3] = hotspots[n5 + 3];
                break;
            }
            n5 += 5;
        }
        return n4;
    }

    public static final void setSoftkeys(int n, int n2, int n3) {
        byte[] byArray = menus[n];
        byte[] byArray2 = byArray;
        byArray[3] = (byte)n2;
        byArray2[4] = (byte)n3;
    }

    public static void showUpDownArrows(boolean bl) {
        sShowUpDownArrows = bl;
    }

    public static String getMidletInfo(int n) {
        if (n < 2) {
            return midletInfo[n];
        }
        return null;
    }

    public static void setMenuOption(int n, int n2, byte by) {
        Menu.menus[n][n2] = by;
    }

    static {
        midletInfo = new String[2];
        currentSplash = -1;
        currentMenu = 7;
        scrInfo = new int[2][6];
        titleMusicStarted = false;
        progressBarMax = 87;
        dirtyRect = new int[4];
        sResumeMusicAfterInterruptDelay = -1;
        sOldItemBottom = 0;
        sInitialized = false;
        sCurrentDrawnItem = -1;
        sCustomItemPositionArray = new int[2];
        sNextCaptionOffset = 0;
        mCurrentTouchScreenEvent = -1;
        mInternalTouchSelection = -1;
        sSwipeStartY = -1;
        sSwipeLastY = -1;
        sSwipeSpeedY = 0;
        sSwipeDirection = 0;
        sSwiping = false;
        sClickStartFrame = -1;
        sShowUpDownArrows = true;
    }
}

