/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.GameSprite;
import game.Tank;
import game.dirtfield.DirtFieldBase;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.Point2D;

public final class Weapon {
    public int x;
    public int y;
    public int xv;
    public int yv;
    public int blastRadius;
    public int maxDamageRadius;
    public int maxDamage;
    public int minDamage;
    public Tank source;
    private int phase;
    public int mLaunchSound;
    private int mType;
    public boolean exploding;
    public int currentRadius;
    public int scorchWidth;
    public boolean finished;
    public boolean smokeEnabled;
    public boolean createDirt;
    public int dirtClods;
    public short dirtRed;
    public short dirtGreen;
    public short dirtBlue;
    public GameSprite sprite;
    private int[] mSmokePuffs;
    private int mExplosionSound;
    private static int ballisticshell_render_frames = 0;
    public int submunitionCount = 0;
    public int submunitionType = -1;
    public int delayFuse = -1;
    public boolean apexFuse;
    public int duration = -1;
    public int burstPowerX;
    public int burstPowerY;
    public int burstPower;
    public int angle;
    public int power;
    public int munition;
    public int groups;
    public int shotsPerGroup;
    public int delayBetweenGroups;
    public int frameCount;
    public int angleVariance;
    public int powerVariance;
    private static int whiteout_alpha = 0;
    private static int whiteout_holdFrames = 0;
    private static boolean whiteout_enabled = false;
    private static int[] dirtclods_clods = new int[1200];

    private Weapon(int n, int n2) {
        this.mType = n2;
    }

    private void init(int n) {
        this.maxDamage = n;
        this.minDamage = this.maxDamage >> 2;
    }

    public final void fire(int n, int n2, int n3, int n4) {
        switch (this.mType) {
            case 2: {
                this.clusterbomb_fire(n, n2, n3, n4);
                return;
            }
            case 5: {
                this.compound_fire(n, n2, n3, n4);
                return;
            }
        }
        this.weapon_fire(n, n2, n3, n4);
    }

    private void weapon_fire(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.xv = GCanvas.mul(Game.fastSin(n3), n4) / 4096;
        this.yv = GCanvas.mul(-Game.fastCos(n3), n4) / 4096;
    }

    private void weapon_update() {
        Game game = Game.instance;
        this.x += this.xv;
        this.y += this.yv;
        this.xv += game.gamestate_wind;
        this.yv += game.gamestate_gravity;
        if (game.gamefield_dirtField.isSolid(this.x, this.y)) {
            this.explode();
            return;
        }
        Object[] objectArray = game.gamefield_tanks;
        int n = Game.count(game.gamefield_tanks);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (!((Tank)object).isSolid(this.x, this.y) || ((Tank)object).hitThisFrame) continue;
            this.explode();
            ((Tank)object).hitThisFrame = true;
            return;
        }
    }

    public final void update() {
        switch (this.mType) {
            case 0: {
                this.ballisticshell_update();
                return;
            }
            case 1: {
                this.nuke_update();
                return;
            }
            case 2: {
                this.clusterbomb_update();
                return;
            }
            case 3: {
                this.clusterbomb_update();
                return;
            }
            case 4: {
                this.ballisticshell_update();
                return;
            }
            case 5: {
                this.compound_udpate();
                return;
            }
            case 6: {
                this.roller_update();
                return;
            }
            case 7: {
                this.rollerball_update();
                return;
            }
            case 8: {
                this.ballisticshell_update();
                return;
            }
        }
        this.weapon_update();
    }

    public final boolean isFinished() {
        if (this.mType == 5) {
            return this.compound_isFinished();
        }
        return this.finished;
    }

    public final void explode() {
        switch (this.mType) {
            case 0: {
                this.ballisticshell_explode();
                return;
            }
            case 2: {
                this.clusterbomb_explode();
                return;
            }
            case 3: {
                this.groundburst_explode();
                return;
            }
            case 1: {
                this.nuke_explode();
                return;
            }
            case 6: {
                this.roller_explode();
                return;
            }
            case 5: {
                return;
            }
            case 8: {
                this.ballisticshell_explode();
                return;
            }
            case 4: {
                this.skylance_explode();
                return;
            }
            case 7: {
                this.ballisticshell_explode();
                return;
            }
        }
        System.err.println("BOOM! just exploded but don't know how to do it properly.");
    }

    private void applyDamage() {
        switch (this.mType) {
            case 5: {
                this.weapon_applyDamage();
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                this.ballisticshell_applyDamage();
                return;
            }
            case 4: {
                this.skylance_applyDamage();
                return;
            }
            case 8: {
                this.kineticweapon_applyDamage();
            }
        }
    }

    private void weapon_applyDamage() {
        Game game = Game.instance;
        if (this.maxDamage > 0) {
            Tank[] tankArray = game.gamefield_tanks;
            for (int i = 0; i < tankArray.length; ++i) {
                int n;
                int n2;
                Tank tank = tankArray[i];
                if (tank == null) continue;
                int n3 = tank.x - tank.logicalWidth() / 2;
                int n4 = tank.x + tank.logicalWidth() / 2;
                int n5 = tank.y - tank.logicalHeight();
                int n6 = tank.y;
                if (this.x >= n3 && this.x <= n4 && this.y >= n5 && this.y <= n6) {
                    n2 = 0;
                } else {
                    n = GCanvas.distanceFromLineToPoint(this.x, this.y, n3, n5, n4, n5);
                    n = Math.min(n, GCanvas.distanceFromLineToPoint(this.x, this.y, n4, n5, n4, n6));
                    n = Math.min(n, GCanvas.distanceFromLineToPoint(this.x, this.y, n3, n6, n4, n6));
                    n2 = n = Math.min(n, GCanvas.distanceFromLineToPoint(this.x, this.y, n3, n5, n3, n6));
                }
                if (n2 > this.blastRadius) continue;
                int n7 = n < this.maxDamageRadius ? this.maxDamage : this.minDamage + GCanvas.mul(this.maxDamage - this.minDamage, 1024 - GCanvas.div(n - this.maxDamageRadius, this.blastRadius - this.maxDamageRadius));
                tank.applyDamage(n7, this.source);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void render(Graphics var1_1) {
        switch (this.mType) {
            case 0: {
                this.ballisticshell_render(var1_1);
            }
            case 2: {
                this.ballisticshell_render(var1_1);
            }
            case 3: {
                this.ballisticshell_render(var1_1);
            }
            case 5: {
                return;
            }
            case 1: {
                v0 = this;
                ** GOTO lbl24
            }
            case 4: {
                v0 = this;
                ** GOTO lbl24
            }
            case 6: {
                v0 = this;
                ** GOTO lbl24
            }
            case 7: {
                this.rollerball_render(var1_1);
                return;
            }
            case 8: {
                v0 = this;
lbl24:
                // 4 sources

                v0.ballisticshell_render(var1_1);
            }
        }
    }

    private void ballisticshell_init(int n, int n2, int n3) {
        this.init(n2);
        this.blastRadius = n3;
        this.maxDamageRadius = n3 >> 1;
        this.scorchWidth = 512;
        this.dirtClods = RM.getValue(82, 44, 10);
        this.dirtRed = (short)32;
        this.dirtGreen = (short)32;
        this.sprite = new GameSprite(n);
        this.mSmokePuffs = new int[80];
        for (int i = 0; i < this.mSmokePuffs.length; i += 4) {
            this.mSmokePuffs[i + 0] = -1;
        }
        this.mExplosionSound = RM.getValue(82, 44, 8);
    }

    private void ballisticshell_render(Graphics graphics) {
        int n;
        for (n = 0; n < this.mSmokePuffs.length; n += 4) {
            if (this.mSmokePuffs[n + 0] == -1) continue;
            GCanvas.drawSprite(graphics, 5, Game.instance.logicalToScreenX(this.mSmokePuffs[n + 2]), Game.instance.logicalToScreenY(this.mSmokePuffs[n + 3]), this.mSmokePuffs[n + 1]);
        }
        if (this.exploding) {
            this.ballisticshell_renderExplosion$272d79b7();
            return;
        }
        if (this.smokeEnabled && ++ballisticshell_render_frames >= 2 && this.yv < 0 && Game.instance.getRuleValueInt(4) == 1) {
            ballisticshell_render_frames = 0;
            this.smoke_add(this.x, this.y);
        }
        if (this.sprite != null) {
            n = Game.instance.logicalToScreenY(this.y);
            if (n >= Game.instance.viewportGetTop()) {
                if (this.xv == 0) {
                    this.sprite.angle = 0;
                } else {
                    Point2D point2D = Point2D.getLocal(this.xv << 10, this.yv << 10);
                    point2D.unit();
                    this.sprite.angle = Game.atan2(point2D.y, point2D.x);
                    Point2D.freeLocal(point2D);
                }
                this.sprite.x = this.x;
                this.sprite.y = this.y;
                this.sprite.render$417dcfd4(-1);
                return;
            }
            GCanvas.drawSprite(graphics, 4, Game.instance.logicalToScreenX(this.x), Game.instance.viewportGetTop(), this.yv > 0 ? 0 : 1);
        }
    }

    private void ballisticshell_renderExplosion$272d79b7() {
        Game.instance.gamefield_renderExplosion(this.x, this.y, this.currentRadius, this.phase);
    }

    private void ballisticshell_applyDamage() {
        this.weapon_applyDamage();
        if (this.createDirt) {
            Game.instance.gamefield_dirtField.createCircle(this.x, this.y, this.blastRadius);
        }
    }

    private void ballisticshell_destroyDirt() {
        if (!this.createDirt) {
            Game.instance.gamefield_dirtField.destroyCircle(this.x, this.y, this.blastRadius, this.scorchWidth);
        }
    }

    private void ballisticshell_update() {
        int n;
        int n2;
        if (!this.exploding) {
            this.weapon_update();
        } else if (!this.finished && this.currentRadius < this.blastRadius && !this.finished) {
            this.currentRadius += Math.max(1, this.blastRadius / 20);
            n2 = (this.blastRadius - this.blastRadius / 2) / 4;
            this.phase = (this.currentRadius - this.blastRadius / 2) / n2;
            this.phase = GCanvas.clamp(this.phase, 0, 3);
            if (this.currentRadius >= this.blastRadius) {
                this.finished = true;
                this.currentRadius = 0;
                this.ballisticshell_destroyDirt();
                this.applyDamage();
                if (Game.instance.getRuleValueInt(3) == 1) {
                    for (n = 0; n < this.dirtClods; ++n) {
                        int n3 = GCanvas.getRandom(0, 1024);
                        int n4 = GCanvas.getRandom(0, this.blastRadius);
                        int n5 = this.x + (GCanvas.sin(n3) * n4 >> 10);
                        int n6 = this.y + (GCanvas.cos(n3) * n4 >> 10);
                        Weapon.dirtclods_fire(n5, n6, GCanvas.getRandom(0, 1024), GCanvas.getRandom(0, 0x2EE000), this.dirtRed, this.dirtGreen, this.dirtBlue);
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.mSmokePuffs.length; n2 += 4) {
            n = this.mSmokePuffs[n2 + 0];
            if (n == -1) continue;
            this.mSmokePuffs[n2 + 0] = ++n;
            if (n == 15) {
                this.smoke_remove(n2 / 4);
                continue;
            }
            if (n != 5 && n != 10) continue;
            int n7 = n2 + 1;
            this.mSmokePuffs[n7] = this.mSmokePuffs[n7] + 1;
        }
    }

    private void ballisticshell_explode() {
        if (!this.exploding) {
            this.exploding = true;
            if (this.mExplosionSound != -1) {
                Game.instance.sfxPlayLogicSound(this.mExplosionSound, 1);
            }
            this.currentRadius = this.blastRadius / 2;
            this.phase = 0;
            if (!this.createDirt) {
                Game.instance.gamefield_dirtField.destroyCircle(this.x, this.y, this.currentRadius, this.scorchWidth);
            }
        }
    }

    private void roller_explode() {
        this.finished = true;
        this.exploding = true;
        Weapon weapon = Weapon.weapons_createWeapon(39);
        Weapon.weapons_createWeapon(39).maxDamage = this.maxDamage;
        weapon.blastRadius = this.blastRadius;
        weapon.dirtClods = this.dirtClods;
        weapon.createDirt = this.createDirt;
        weapon.x = this.x;
        weapon.y = this.y;
        int n = 0;
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        while (dirtFieldBase.isSolid(weapon.x, weapon.y)) {
            weapon.x -= this.xv / 10;
            weapon.y -= this.yv / 10;
            if (n++ <= 10) continue;
            weapon.explode();
            break;
        }
        weapon.xv = this.xv;
        weapon.rollerball_determineDirection();
        Game.instance.gamefield_addWeapon(weapon);
    }

    private void rollerball_determineDirection() {
        int n;
        Weapon weapon;
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n2 = dirtFieldBase.getAngle(this.x);
        int n3 = 102400 / dirtFieldBase.mPixelHeight;
        if (n2 == 0) {
            this.xv = this.xv > 0 ? n3 : -n3;
            return;
        }
        if (n2 > 0) {
            weapon = this;
            n = n3;
        } else {
            weapon = this;
            n = -n3;
        }
        weapon.xv = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rollerball_update() {
        if (!this.exploding) {
            int n;
            GameSprite gameSprite;
            if (this.xv > 0) {
                GameSprite gameSprite2 = this.sprite;
                gameSprite = gameSprite2;
                n = gameSprite2.angle + 10;
            } else {
                GameSprite gameSprite3 = this.sprite;
                gameSprite = gameSprite3;
                n = gameSprite3.angle - 10;
            }
            gameSprite.angle = n;
            this.x += this.xv;
            DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
            int n2 = dirtFieldBase.getAngle(this.x);
            int n3 = dirtFieldBase.getGroundLevel(this.x);
            if (n2 > 0 && this.xv < 0 || n2 < 0 && this.xv > 0 || this.x < 0 || this.x > dirtFieldBase.mWidth) {
                this.ballisticshell_explode();
                return;
            }
            this.y = n3;
            Tank[] tankArray = Game.instance.gamefield_tanks;
            for (int i = 0; i < tankArray.length; ++i) {
                Tank tank = tankArray[i];
                if (tank == null || !tank.isSolid(this.x, this.y - this.sprite.logicalHeight / 2)) continue;
                this.ballisticshell_explode();
                return;
            }
            return;
        }
        this.ballisticshell_update();
    }

    private void rollerball_render(Graphics graphics) {
        if (!this.exploding) {
            this.sprite.x = this.x;
            this.sprite.y = this.y - this.sprite.logicalHeight / 2;
            this.sprite.render$417dcfd4(-1);
            return;
        }
        this.ballisticshell_render(graphics);
    }

    private void nuke_init(int n, int n2, int n3) {
        this.ballisticshell_init(n, n2, n3);
        this.scorchWidth = 2048;
        this.dirtClods = this.maxDamage * 4;
    }

    private void nuke_update() {
        this.ballisticshell_update();
    }

    private void nuke_explode() {
        this.ballisticshell_explode();
        Weapon.whiteout_init(this.maxDamage / 4);
    }

    private void clusterbomb_init(int n, int n2, int n3) {
        this.ballisticshell_init(n3, 0, 0);
        this.submunitionType = n;
        this.submunitionCount = n2;
        this.delayFuse = RM.getValue(82, 46, 15);
        this.apexFuse = RM.getValue(82, 46, 14) == 1;
        this.burstPowerX = RM.getValue(82, 46, 16);
        this.burstPowerY = RM.getValue(82, 46, 17);
        this.mExplosionSound = RM.getValue(82, 46, 8);
    }

    private void clusterbomb_fire(int n, int n2, int n3, int n4) {
        this.weapon_fire(n, n2, n3, n4);
    }

    private void clusterbomb_explode() {
        if (!this.exploding) {
            if (this.mExplosionSound != -1) {
                Game.instance.sfxPlayLogicSound(this.mExplosionSound, 1);
            }
            this.exploding = true;
            int n = this.burstPowerX;
            int n2 = this.burstPowerY;
            for (int i = 0; i < this.submunitionCount; ++i) {
                if (Game.instance.gamestate_spawnedWeapons++ >= 250) continue;
                Weapon weapon = Weapon.weapons_createWeapon(this.submunitionType);
                Weapon.weapons_createWeapon(this.submunitionType).x = this.x - this.xv;
                weapon.y = this.y - this.yv;
                int n3 = (i << 10) / (this.submunitionCount - 1);
                int n4 = ((n3 * n >> 10) - (n >> 1)) / 4096;
                int n5 = ((GCanvas.getRandom(0, 1024) * n2 >> 10) - (n2 >> 1)) / 4096;
                weapon.xv = this.xv + n4;
                weapon.yv = this.yv + n5;
                weapon.source = this.source;
                Game.instance.gamefield_addWeapon(weapon);
            }
            this.finished = true;
        }
    }

    private void clusterbomb_update() {
        if (this.apexFuse || this.delayFuse > 0) {
            ++this.duration;
            if (!(this.apexFuse && this.yv <= 0 || this.duration < this.delayFuse || this.finished)) {
                this.clusterbomb_explode();
            }
        }
        this.ballisticshell_update();
    }

    private void roller_update() {
        this.ballisticshell_update();
    }

    private void groundburst_init(int n, int n2, int n3) {
        this.clusterbomb_init(n, n2, n3);
        this.apexFuse = false;
        this.delayFuse = 0;
        this.burstPower = 30;
    }

    private void groundburst_explode() {
        if (!this.exploding) {
            this.exploding = true;
            int n = 0;
            int n2 = 360 / this.submunitionCount;
            for (int i = 0; i < this.submunitionCount; ++i) {
                int n3;
                Weapon weapon;
                if (Game.instance.gamestate_spawnedWeapons++ >= 250) continue;
                Weapon weapon2 = Weapon.weapons_createWeapon(this.submunitionType);
                Weapon.weapons_createWeapon(this.submunitionType).x = this.x - this.xv;
                weapon2.y = this.y - this.yv;
                if (this.burstPower > 0) {
                    weapon2.xv = GCanvas.mul(this.burstPower, Game.fastSin(n)) / 4096;
                    weapon = weapon2;
                    n3 = GCanvas.mul(this.burstPower, Game.fastCos(n)) / 4096;
                } else {
                    weapon2.xv = this.xv;
                    weapon = weapon2;
                    n3 = this.yv;
                }
                weapon.yv = n3;
                weapon2.source = this.source;
                Game.instance.gamefield_addWeapon(weapon2);
                n += n2;
            }
            this.finished = true;
        }
    }

    private void compound_init(int n, int n2, int n3, int n4) {
        this.init(0);
        this.munition = n;
        this.groups = n2;
        this.shotsPerGroup = n3;
        this.delayBetweenGroups = n4;
    }

    private void compound_fire(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.angle = n3;
        this.power = n4;
    }

    private void compound_udpate() {
        if (this.frameCount++ % this.delayBetweenGroups == 0) {
            for (int i = 0; i < this.shotsPerGroup; ++i) {
                if (Game.instance.gamestate_spawnedWeapons++ >= 250) continue;
                Weapon weapon = Weapon.weapons_createWeapon(this.munition);
                Game.instance.gamefield_addWeapon(weapon);
                int n = this.angle + (GCanvas.getRandom(0, 1024) * this.angleVariance >> 10) - this.angleVariance / 2;
                int n2 = this.power + (GCanvas.getRandom(0, 1024) * this.powerVariance >> 10) - this.powerVariance / 2;
                weapon.fire(this.source.getBarrelX(), this.source.getBarrelY(), n, n2);
                weapon.source = this.source;
                if (i != 0 || this.mLaunchSound == -1) continue;
                Game.instance.sfxPlayLogicSound(this.mLaunchSound, 0);
            }
        }
    }

    private boolean compound_isFinished() {
        return this.source.health <= 0 || this.frameCount > this.delayBetweenGroups * (this.groups - 1);
    }

    private void kineticweapon_applyDamage() {
        for (int i = 0; i < Game.instance.gamefield_tanks.length; ++i) {
            Tank tank = Game.instance.gamefield_tanks[i];
            if (tank == null) continue;
            int n = tank.x - tank.logicalWidth() / 2;
            int n2 = tank.x + tank.logicalWidth() / 2;
            int n3 = tank.y - tank.logicalHeight();
            int n4 = tank.y;
            if (this.x < n || this.x > n2 || this.y < n3 || this.y > n4) continue;
            int n5 = GCanvas.sqrt(GCanvas.sqr(this.xv) + GCanvas.sqr(this.yv));
            tank.applyDamage(n5 * 50 * this.maxDamage >> 10, Game.instance.gamestate_currentPlayer());
        }
    }

    private void skylance_explode() {
        if (!this.exploding) {
            this.exploding = true;
            if (this.mExplosionSound != -1) {
                Game.instance.sfxPlayLogicSound(this.mExplosionSound, 1);
            }
            this.currentRadius = this.blastRadius / 2;
        }
    }

    private void skylance_applyDamage() {
        if (this.maxDamage > 0) {
            Tank[] tankArray = Game.instance.gamefield_tanks;
            for (int i = 0; i < tankArray.length; ++i) {
                int n;
                int n2;
                Tank tank = tankArray[i];
                int n3 = tank.x - tank.logicalWidth() / 2;
                int n4 = tank.x + tank.logicalWidth() / 2;
                if (this.x >= n3 && this.x <= n4) {
                    n2 = 0;
                } else {
                    n = GCanvas.distanceFromLineToPoint(this.x, this.y, n3, 0, n3, 1024);
                    n2 = n = Math.min(n, GCanvas.distanceFromLineToPoint(this.x, this.y, n4, 0, n4, 1024));
                }
                if (n2 > this.blastRadius) continue;
                int n5 = n < this.maxDamageRadius ? this.maxDamage : this.minDamage + ((this.maxDamage - this.minDamage) * (1024 - (n - this.maxDamageRadius << 10) / (this.blastRadius - this.maxDamageRadius)) >> 10);
                tank.applyDamage(n5, this.source);
            }
        }
        if (this.createDirt) {
            Game.instance.gamefield_dirtField.createWall(this.x, this.blastRadius * 2);
        }
    }

    public static Weapon weapons_createWeapon(int n) {
        int n2;
        Weapon weapon;
        int n3;
        int[] nArray = RM.getInts(82);
        int n4 = n * RM.getWidth(82);
        int n5 = nArray[n4 + 3];
        int n6 = nArray[n4 + 4];
        int n7 = nArray[n4 + 5];
        if (n7 != -1) {
            n7 /= 100;
        }
        int n8 = nArray[n4 + 1];
        Weapon weapon2 = new Weapon(n, n8);
        switch (n8) {
            case 0: {
                weapon2.ballisticshell_init(n5, n6, n7);
                n3 = nArray[n4 + 10];
                if (n3 != -1) {
                    weapon2.dirtClods = n3;
                }
                if ((n3 = nArray[n4 + 18]) == -1) break;
                weapon2.createDirt = n3 == 1;
                break;
            }
            case 8: {
                weapon2.ballisticshell_init(n5, n6, 1024);
                n3 = nArray[n4 + 10];
                if (n3 == -1) break;
                Weapon weapon3 = weapon2;
                int n9 = n3;
                break;
            }
            case 6: {
                weapon2.ballisticshell_init(n5, n6, n7);
                n3 = nArray[n4 + 10];
                if (n3 != -1) {
                    weapon2.dirtClods = n3;
                }
                if ((n3 = nArray[n4 + 18]) == -1) break;
                weapon2.createDirt = n3 == 1;
                break;
            }
            case 1: {
                weapon2.nuke_init(n5, n6, n7);
                break;
            }
            case 2: {
                int n10;
                int n11 = nArray[n4 + 13];
                int n12 = nArray[n4 + 6];
                weapon2.clusterbomb_init(n11, n12, n5);
                int n13 = nArray[n4 + 14];
                if (n13 != -1) {
                    boolean bl = weapon2.apexFuse = n13 == 1;
                }
                if ((n10 = nArray[n4 + 15]) != -1) {
                    weapon2.delayFuse = n10;
                }
                if ((n3 = nArray[n4 + 16]) != -1) {
                    weapon2.burstPowerX = n3;
                }
                if ((n3 = nArray[n4 + 17]) == -1) break;
                weapon2.burstPowerY = n3;
                break;
            }
            case 3: {
                int n14 = nArray[n4 + 13];
                int n15 = nArray[n4 + 6];
                weapon2.groundburst_init(n14, n15, n5);
                int n16 = nArray[n4 + 16];
                if (n16 == -1) break;
                weapon2.burstPower = n16;
                break;
            }
            case 5: {
                int n17;
                int n18 = nArray[n4 + 13];
                int n19 = nArray[n4 + 20];
                int n20 = nArray[n4 + 21];
                int n21 = nArray[n4 + 22];
                weapon2.compound_init(n18, n19, n20, n21);
                int n22 = nArray[n4 + 23];
                if (n22 != -1) {
                    weapon2.angleVariance = n22;
                }
                if ((n17 = nArray[n4 + 24]) == -1) break;
                weapon2.powerVariance = n17;
                break;
            }
            case 4: {
                weapon2.ballisticshell_init(n5, n6, n7);
                int n23 = nArray[n4 + 18];
                if (n23 == -1) break;
                weapon2.createDirt = n23 == 1;
                break;
            }
            case 11: {
                weapon2.ballisticshell_init(n5, n6, n7);
                weapon2.dirtClods = nArray[n4 + 10];
                weapon2.mExplosionSound = nArray[n4 + 8];
                weapon2.mType = 0;
                break;
            }
            case 12: {
                weapon2.ballisticshell_init(n5, n6, n7);
                weapon2.dirtClods = nArray[n4 + 10];
                weapon2.mExplosionSound = nArray[n4 + 8];
                weapon2.smokeEnabled = nArray[n4 + 11] == 1;
                weapon2.mLaunchSound = nArray[n4 + 9];
                weapon2.mType = 0;
                break;
            }
            case 7: {
                weapon2.ballisticshell_init(n5, 1, 1);
                break;
            }
            default: {
                weapon2.ballisticshell_init(n5, 1024, 10);
                weapon2.mType = 0;
                Weapon weapon3 = weapon2;
                int n9 = weapon3.dirtClods = RM.getValue(82, 40, 10);
            }
        }
        if ((n3 = nArray[n4 + 11]) != -1) {
            boolean bl = weapon2.smokeEnabled = n3 == 1;
        }
        if ((n3 = nArray[n4 + 10]) != -1) {
            weapon2.dirtClods = n3;
        }
        if ((n3 = nArray[n4 + 9]) != -1) {
            weapon = weapon2;
            n2 = n3;
        } else {
            weapon = weapon2;
            n2 = RM.getValue(82, 44, 9);
        }
        weapon.mLaunchSound = n2;
        n3 = nArray[n4 + 8];
        if (n3 != -1) {
            weapon2.mExplosionSound = n3;
        }
        return weapon2;
    }

    private void smoke_add(int n, int n2) {
        for (int i = 0; i < this.mSmokePuffs.length; i += 4) {
            if (this.mSmokePuffs[i + 0] != -1) continue;
            this.mSmokePuffs[i + 1] = 0;
            this.mSmokePuffs[i + 2] = n;
            this.mSmokePuffs[i + 3] = n2;
            this.mSmokePuffs[i + 0] = 0;
            return;
        }
    }

    private void smoke_remove(int n) {
        this.mSmokePuffs[n * 4 + 0] = -1;
    }

    private static void whiteout_init(int n) {
        whiteout_alpha = 255 - n * 10;
        whiteout_holdFrames = n;
        whiteout_enabled = true;
    }

    public static void whiteout_disable() {
        whiteout_enabled = false;
    }

    public static boolean whiteout_isEnabled() {
        return whiteout_enabled;
    }

    public static boolean whiteout_isFinished() {
        return !whiteout_enabled || whiteout_alpha <= 0 && whiteout_holdFrames == 0;
    }

    public static void whiteout_update() {
        if (!whiteout_enabled) {
            return;
        }
        if (whiteout_holdFrames > 0) {
            if ((whiteout_alpha = Math.min(whiteout_alpha + 10, 255)) == 255) {
                --whiteout_holdFrames;
                return;
            }
        } else {
            whiteout_alpha = Math.max(whiteout_alpha - 5, 0);
        }
    }

    public static void whiteout_render(Graphics graphics) {
        if (!whiteout_enabled) {
            return;
        }
        if (whiteout_holdFrames > 0) {
            graphics.setColor(65793 * whiteout_alpha);
            graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        }
    }

    public static void dirtclods_reset() {
        int n = 0;
        int n2 = 0;
        while (n < 150) {
            Weapon.dirtclods_clods[n2 + 7] = 0;
            ++n;
            n2 += 8;
        }
    }

    private static int dirtclods_getFreeIndex() {
        int n = 0;
        int n2 = 0;
        while (n < 150) {
            if (dirtclods_clods[n2 + 7] == 0) {
                return n;
            }
            ++n;
            n2 += 8;
        }
        return -1;
    }

    private static void dirtclods_fire(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = Weapon.dirtclods_getFreeIndex();
        if (n8 == -1) {
            return;
        }
        int n9 = n8 * 8;
        Weapon.dirtclods_clods[n9 + 0] = n;
        Weapon.dirtclods_clods[n9 + 1] = n2;
        Weapon.dirtclods_clods[n9 + 5] = GCanvas.mul(Game.fastSin(n3), n4) / 4096;
        Weapon.dirtclods_clods[n9 + 6] = GCanvas.mul(-Game.fastCos(n3), n4) / 4096;
        Weapon.dirtclods_clods[n9 + 2] = n5;
        Weapon.dirtclods_clods[n9 + 3] = n6;
        Weapon.dirtclods_clods[n9 + 4] = n7;
        Weapon.dirtclods_clods[n9 + 7] = 1;
    }

    public static void dirtclods_update() {
        Game game = Game.instance;
        DirtFieldBase dirtFieldBase = game.gamefield_dirtField;
        int n = 0;
        int n2 = 0;
        while (n < 150) {
            if (dirtclods_clods[n2 + 7] != 0) {
                int n3 = n2 + 0;
                dirtclods_clods[n3] = dirtclods_clods[n3] + dirtclods_clods[n2 + 5];
                int n4 = n2 + 1;
                dirtclods_clods[n4] = dirtclods_clods[n4] + dirtclods_clods[n2 + 6];
                int n5 = n2 + 6;
                dirtclods_clods[n5] = dirtclods_clods[n5] + game.gamestate_gravity;
                if (dirtclods_clods[n2 + 0] < 0 || dirtclods_clods[n2 + 0] > dirtFieldBase.mWidth || dirtFieldBase.isSolid(dirtclods_clods[n2 + 0], dirtclods_clods[n2 + 1])) {
                    dirtFieldBase.addClodAtColumn(dirtFieldBase.logicalToDirtFieldX(dirtclods_clods[n2 + 0]), dirtclods_clods[n2 + 2], dirtclods_clods[n2 + 3], dirtclods_clods[n2 + 4]);
                    Weapon.dirtclods_clods[n2 + 7] = 0;
                }
            }
            ++n;
            n2 += 8;
        }
    }

    public static void dirtclods_render(Graphics graphics) {
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n = 0;
        int n2 = 0;
        while (n < 150) {
            if (dirtclods_clods[n2 + 7] != 0) {
                graphics.setColor(dirtclods_clods[n2 + 2] << 16 | dirtclods_clods[n2 + 3] << 8 | dirtclods_clods[n2 + 4]);
                int n3 = dirtFieldBase.logicalToScreenX(dirtclods_clods[n2 + 0]);
                int n4 = dirtFieldBase.logicalToScreenY(dirtclods_clods[n2 + 1]);
                graphics.drawLine(n3, n4, n3, n4);
            }
            ++n;
            n2 += 8;
        }
    }
}

