/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;

public final class BitmapFont {
    private static byte[][] mFontData;
    private static byte[] mNumCharacterPerFont;
    private static short[][] mCharOffsets;
    private static Image[] mImages;
    private static final short[] sStringIDCache;

    public static final void init(int n) {
        int n2 = RM.getHeight(n);
        mFontData = new byte[n2][];
        mImages = new Image[n2];
        mNumCharacterPerFont = new byte[n2];
        mCharOffsets = new short[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = RM.getValue(n, i, 1);
            byte[] byArray = RM.getBytes(n3);
            BitmapFont.mFontData[i] = byArray;
            int n4 = RM.getValue(n, i, 0);
            BitmapFont.mImages[i] = RM.getImage(n4);
            int n5 = RM.getShortFromBytes(byArray, 8);
            BitmapFont.mNumCharacterPerFont[i] = (byte)n5;
            BitmapFont.mCharOffsets[i] = new short[n5];
            for (int j = 0; j < n5; ++j) {
                int n6 = 12 + (n5 + j << 1);
                BitmapFont.mCharOffsets[i][j] = (short)(12 + (n5 << 2) + RM.getShortFromBytes(byArray, n6));
            }
        }
    }

    private static int getCharacterSpacing(int n) {
        byte[] byArray = mFontData[n];
        int n2 = byArray[7];
        if (n2 > 0 && (n2 & 0x80) != 0) {
            n2 = -(256 - n2);
        }
        return n2;
    }

    public static final void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        short[] sArray;
        int n5;
        int n6;
        byte[] byArray;
        block16: {
            int n7;
            int n8;
            block21: {
                block22: {
                    block20: {
                        block19: {
                            int n9;
                            int n10;
                            block18: {
                                block17: {
                                    byArray = mFontData[n];
                                    n6 = mNumCharacterPerFont[n] & 0xFF;
                                    n5 = byArray[4];
                                    sArray = BitmapFont.cacheStringIds(n6, byArray, string);
                                    if (n4 == 0) break block16;
                                    if ((n4 & 1) == 0) break block17;
                                    n10 = n2;
                                    n9 = BitmapFont.getStringWidthInternal(n, string, sArray) >> 1;
                                    break block18;
                                }
                                if ((n4 & 8) == 0) break block19;
                                n10 = n2;
                                n9 = BitmapFont.getStringWidthInternal(n, string, sArray);
                            }
                            n2 = n10 - n9;
                        }
                        if ((n4 & 0x20) == 0) break block20;
                        n8 = n3;
                        n7 = BitmapFont.getHeight(n);
                        break block21;
                    }
                    if ((n4 & 0x40) == 0) break block22;
                    n8 = n3;
                    n7 = n5;
                    break block21;
                }
                if ((n4 & 2) == 0) break block16;
                n8 = n3;
                n7 = BitmapFont.getHeight(n) >> 1;
            }
            n3 = n8 - n7;
        }
        n3 += n5;
        int n11 = BitmapFont.getCharacterSpacing(n);
        int n12 = string.length();
        Image image = null;
        image = mImages[n];
        short[] sArray2 = mCharOffsets[n];
        GCanvas.pushClip(graphics);
        for (int i = 0; i < n12; ++i) {
            byte by;
            int n13;
            int n14;
            int n15;
            int n16;
            if (sArray == null) {
                n16 = string.charAt(i);
                n15 = BitmapFont.charID(n6, byArray, (char)n16);
            } else {
                n15 = n14 = sArray[i];
            }
            if (n15 == -2) {
                n13 = n2;
                by = byArray[6];
            } else if (n14 == -1) {
                if (GCanvas.clipRect(graphics, n2, n3 - n5, byArray[6], n5)) {
                    graphics.setColor(-65536);
                    graphics.fillRect(n2, n3 - n5, (int)byArray[6], n5);
                }
                n13 = n2;
                by = byArray[6];
            } else {
                if (n14 == -3) continue;
                n16 = sArray2[n14];
                byte by2 = byArray[n16 + 0];
                int n17 = byArray[n16 + 1];
                n16 += 2;
                for (int j = 0; j < n17; ++j) {
                    int n18 = byArray[n16 + 0] & 0xFF;
                    int n19 = byArray[n16 + 1] & 0xFF;
                    byte by3 = byArray[n16 + 2];
                    int n20 = n2 + by3;
                    int n21 = byArray[n16 + 5] & 0xFF;
                    byte by4 = byArray[n16 + 3];
                    int n22 = n3 - n21 - by4;
                    int n23 = byArray[n16 + 4] & 0xFF;
                    if (GCanvas.clipRect(graphics, n20, n22, n23, n21)) {
                        graphics.drawImage(image, n20 - n18, n22 - n19, 20);
                    }
                    n16 += 6;
                }
                n13 = n2;
                by = by2;
            }
            n2 = n13 + (by + n11);
        }
        GCanvas.popClip(graphics);
    }

    public static final int getHeight(int n) {
        byte[] byArray = mFontData[n];
        return byArray[4] + byArray[5] + byArray[3];
    }

    public static final int getStringWidth(int n, String string) {
        return BitmapFont.getSubstringWidth(n, string, 0, string.length());
    }

    public static final int getSubstringWidth(int n, String string, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 + n3;
        int n6 = string.length();
        if (n5 > n6) {
            n5 = n6;
        }
        int n7 = BitmapFont.getCharacterSpacing(n);
        n4 = 0 + n7 * (n5 - n2);
        byte[] byArray = mFontData[n];
        int n8 = mNumCharacterPerFont[n] & 0xFF;
        for (int i = n2; i < n5; ++i) {
            int n9;
            char c = string.charAt(i);
            if (c == '{' || c == '}') {
                n9 = n4 - n7;
            } else {
                int n10;
                byte[] byArray2;
                int n11;
                int n12 = BitmapFont.charID(n8, byArray, c);
                if (n12 == -1 || n12 == -2) {
                    n11 = n4;
                    byArray2 = byArray;
                    n10 = 6;
                } else {
                    if (n12 == -3) continue;
                    short s = mCharOffsets[n][n12];
                    n11 = n4;
                    byArray2 = byArray;
                    n10 = s + 0;
                }
                n9 = n11 + byArray2[n10];
            }
            n4 = n9;
        }
        return n4;
    }

    private static final int getStringWidthInternal(int n, String string, short[] sArray) {
        byte[] byArray;
        int n2 = 0;
        int n3 = string.length();
        byte[] byArray2 = byArray = mFontData[n];
        int n4 = BitmapFont.getCharacterSpacing(n);
        n2 = 0 + n4 * n3;
        if (sArray == null) {
            int n5 = mNumCharacterPerFont[n] & 0xFF;
            for (int i = 0; i < n3; ++i) {
                int n6;
                byte[] byArray3;
                int n7;
                char c = string.charAt(i);
                int n8 = BitmapFont.charID(n5, byArray, c);
                if (n8 == -1 || n8 == -2) {
                    n7 = n2;
                    byArray3 = byArray2;
                    n6 = 6;
                } else {
                    if (n8 == -3) continue;
                    short s = mCharOffsets[n][n8];
                    n7 = n2;
                    byArray3 = byArray2;
                    n6 = s + 0;
                }
                n2 = n7 + byArray3[n6];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n9;
                byte[] byArray4;
                int n10;
                short s = sArray[i];
                if (s == -1 || s == -2) {
                    n10 = n2;
                    byArray4 = byArray2;
                    n9 = 6;
                } else {
                    if (s == -3) continue;
                    short s2 = mCharOffsets[n][s];
                    n10 = n2;
                    byArray4 = byArray2;
                    n9 = s2 + 0;
                }
                n2 = n10 + byArray4[n9];
            }
        }
        return n2;
    }

    public static final int getCharWidth(int n, char c) {
        byte by;
        block4: {
            int n2;
            byte[] byArray;
            block3: {
                int n3;
                byte[] byArray2;
                block2: {
                    byArray2 = mFontData[n];
                    int n4 = mNumCharacterPerFont[n] & 0xFF;
                    by = 0;
                    n3 = BitmapFont.charID(n4, byArray2, c);
                    if (n3 != -1 && n3 != -2) break block2;
                    byArray = byArray2;
                    n2 = 6;
                    break block3;
                }
                if (n3 == -3) break block4;
                short s = mCharOffsets[n][n3];
                byArray = byArray2;
                n2 = s + 0;
            }
            by = byArray[n2];
        }
        return by;
    }

    private static final int charID(int n, byte[] byArray, char c) {
        switch (c) {
            case ' ': 
            case '\u0093': {
                return -2;
            }
            case '\u0092': {
                return -3;
            }
        }
        int n2 = n;
        int n3 = 0;
        byte[] byArray2 = byArray;
        while (n3 < n2) {
            int n4 = n2 + n3 >> 1;
            int n5 = 12 + (n4 << 1);
            int n6 = byArray2[n5++] & 0xFF;
            n6 <<= 8;
            if ((n6 |= byArray2[n5] & 0xFF) == c) {
                return n4;
            }
            if (c < n6) {
                n2 = n4;
                continue;
            }
            n3 = n4 + 1;
        }
        return -1;
    }

    private static final short[] cacheStringIds(int n, byte[] byArray, String string) {
        int n2 = string.length();
        if (n2 < 32) {
            short[] sArray = sStringIDCache;
            for (int i = 0; i < n2; ++i) {
                sArray[i] = (short)BitmapFont.charID(n, byArray, string.charAt(i));
            }
            return sStringIDCache;
        }
        return null;
    }

    public static final boolean isSpacingNeeded() {
        return false;
    }

    static {
        sStringIDCache = new short[32];
    }
}

