/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.mmapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import tinbrain.RM;

public final class Sound
implements PlayerListener {
    private Player player;
    private int activeTune;
    private int activeSfx;
    private boolean looped;
    private boolean isMenu;
    private int restartTune = -1;
    private int volumeMusic;
    private int volumeSFX;
    private int delayedTune;
    private Hashtable prefetched = new Hashtable();
    private static String[] formats = new String[11];

    public final void play(int n, boolean bl, boolean bl2) {
        this.restartTune = -1;
        this.stop();
        this.looped = bl2;
        this.isMenu = bl;
        int n2 = bl ? this.volumeMusic : this.volumeSFX;
        this.playPrefetched$3a5e6eba(n, n2, 0);
    }

    private void playPrefetched$3a5e6eba(int n, int n2, int n3) {
        if (n2 > 0) {
            if (this.player != null) {
                this.stop();
            }
            try {
                this.player = (Player)this.prefetched.get(new Integer(n));
                if (this.player == null) {
                    this.player = this.createPlayer(n, n3);
                    if (!this.isMenu && this.prefetched.size() < 4 && this.player != null) {
                        this.prefetched.put(new Integer(n), this.player);
                    }
                }
                try {
                    this.player.start();
                }
                catch (Exception exception) {}
                this.updateVolume();
                this.activeTune = this.isMenu ? n : -1;
                this.activeSfx = this.isMenu ? -1 : n;
                return;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Player createPlayer(int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = null;
        Player player = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(RM.getBytes(n));
            player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)formats[n2]);
            if (!Sound.realizePlayer(player)) {
                player = null;
            }
            if (player != null) {
                player.setLoopCount(1);
                player.addPlayerListener((PlayerListener)this);
                try {
                    player.prefetch();
                }
                catch (Exception exception) {}
            }
            RM.closeInputStream(byteArrayInputStream);
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeInputStream(byteArrayInputStream);
        }
        return player;
    }

    private static final boolean realizePlayer(Player player) {
        boolean bl = false;
        try {
            player.realize();
            bl = true;
        }
        catch (MediaException mediaException) {
            System.gc();
        }
        return bl;
    }

    public final void stop() {
        if (this.player != null) {
            try {
                this.player.stop();
                while (this.player.getState() == 400) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {}
            boolean bl = false;
            bl = this.isMenu;
            if (bl) {
                this.deallocate();
            }
        }
        this.activeTune = -1;
        this.restartTune = -1;
        this.activeSfx = -1;
        this.player = null;
    }

    private void deallocate() {
        Sound.deallocate$674805f(this.player);
        this.player = null;
    }

    private static void deallocate$674805f(Player player) {
        if (player != null) {
            try {
                player.stop();
            }
            catch (Exception exception) {}
            try {
                player.deallocate();
            }
            catch (Exception exception) {}
            try {
                player.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void setVolume(int n, int n2) {
        this.volumeMusic = n;
        this.volumeSFX = n2;
        this.updateVolume();
    }

    private void updateVolume() {
        if (this.player != null) {
            int n = this.player.getState();
            if (n != 400) {
                return;
            }
            int n2 = this.isMenu ? this.volumeMusic : this.volumeSFX;
            if (n2 > 0) {
                return;
            }
            this.stop();
        }
    }

    public final void playerUpdate(Player player, String string, Object object) {
        if (string == "endOfMedia") {
            if (this.looped) {
                this.restartTune = this.activeTune;
                return;
            }
            this.stop();
        }
    }

    public final void tick() {
        if (this.restartTune >= 0) {
            if (this.player != null) {
                this.stop();
            } else {
                this.play(this.restartTune, this.isMenu, true);
                this.restartTune = -1;
            }
        }
        if (this.delayedTune > 0) {
            this.play(this.delayedTune, this.isMenu, this.looped);
            this.delayedTune = 0;
        }
    }

    public final void prepare(int n, boolean bl) {
        Player player = null;
        Integer n2 = new Integer(n);
        if (this.prefetched.containsKey(n2)) {
            Sound.deallocate$674805f((Player)this.prefetched.remove(n2));
        }
        if (this.prefetched.size() < 4 && (player = this.createPlayer(n, 0)) != null) {
            this.prefetched.put(n2, player);
        }
    }

    public final void free(int n) {
        Integer n2;
        if (n != this.activeSfx && this.prefetched.containsKey(n2 = new Integer(n))) {
            Sound.deallocate$674805f((Player)this.prefetched.remove(n2));
        }
    }

    static {
        Sound.formats[0] = "audio/midi";
        Sound.formats[1] = "audio/x-mid";
        Sound.formats[2] = "audio/sp-midi";
        Sound.formats[4] = "audio/amr";
        Sound.formats[3] = "audio/x-wav";
        Sound.formats[6] = "audio/mmf";
        Sound.formats[9] = "audio/imelody";
        Sound.formats[10] = "audio/mpeg";
    }
}

