/*
 * Decompiled with CFR 0.152.
 */
package root;

public class CharHashtable {
    private static int[] primes = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099};
    private int tableSize;
    private int[] values;
    private char[] keys;

    public CharHashtable(int maxCapacity) {
        int i;
        int tmp = 2 * maxCapacity;
        for (i = 0; i < primes.length && tmp > primes[i]; ++i) {
        }
        if (i >= primes.length) {
            throw new RuntimeException("While creating CharHashtable: Specified capacity is too big!");
        }
        this.tableSize = primes[i];
        this.keys = new char[this.tableSize];
        this.values = new int[this.tableSize];
    }

    public void put(char key, int value) {
        int i = 0;
        int hash = key % this.tableSize;
        do {
            if (this.keys[hash] == '\u0000') {
                this.keys[hash] = key;
                this.values[hash] = value;
                return;
            }
            hash = (hash + key % (this.tableSize - 1) + 1) % this.tableSize;
        } while (++i != this.tableSize);
        throw new RuntimeException("While inserting (" + key + ", " + value + "): table is full!");
    }

    public int get(char key) {
        int i = 0;
        int hash = key % this.tableSize;
        do {
            if (this.keys[hash] != key) continue;
            return this.values[hash];
        } while (this.keys[hash = (hash + key % (this.tableSize - 1) + 1) % this.tableSize] != '\u0000' && ++i != this.tableSize);
        throw new RuntimeException("While searching for " + key + ": key not found!");
    }

    public void change(char key, int value) {
        int i = 0;
        int hash = key % this.tableSize;
        do {
            if (this.keys[hash] != key) continue;
            this.values[hash] = value;
            return;
        } while (this.keys[hash = (hash + key % (this.tableSize - 1) + 1) % this.tableSize] != '\u0000' && ++i != this.tableSize);
        throw new RuntimeException("While searching for " + key + ": key not found!");
    }
}

