/*
 * Decompiled with CFR 0.152.
 */
package world;

import math.Math;
import pixelGraphics.PixelGraphics;
import root.Util;
import world.Rozklad;
import world.Sky;
import world.Sprite2D;
import world.SpriteManager;
import world.TerrainTexture;
import world.TerrainTileMap;
import world.Tile;

public class TerrainCamera {
    int cameraX;
    int cameraY;
    int cameraXPoints;
    int cameraYPoints;
    int cameraXTile;
    int cameraYTile;
    int cameraHeight;
    int angle;
    int angleLeft;
    int pitch;
    int roll;
    int wspXLeft;
    int wspYLeft;
    int wspXRight;
    int wspYRight;
    int wspXInterval;
    int wspYInterval;
    int renderWidth;
    int renderWidthDiv2;
    int renderWidth3Div2;
    int renderHeight;
    int widthAngle;
    int heightAngle;
    int horizontLevel;
    int realHorizontLevel;
    int addToHorizontLevel;
    public int maxSlice;
    int[] maxSliceSection;
    int numberOfSections;
    int firstSlice = 3;
    int sliceInterval;
    int heightFactor;
    private short[] renderMinHeight;
    private short[] renderMaxHeight;
    private byte[] colorFactorSlice;
    private int[] targetColorSlice;
    int targetColor;
    private int[] additionHeightRay;
    private int[] heightToScreen;
    private int[] heightFactorSlice;
    public int[] sliceRayFactor;
    PixelGraphics pixelGraphics;
    TerrainTileMap map;
    Sky sky;
    private Tile[] localTilesMap;
    private int localTilesMapWidth;
    private int localTilesMapWidthDiv2;
    private int localTilesMapSize;
    private int cameraTile;
    int tileWidth;
    int tileWidthLog;
    int tileWidthLogM16;
    int mapWidth;
    int mapHeight;
    public int createViewTime;
    public int createObjectTime;
    int kafelMinX;
    int kafelMinY;
    int kafelMaxX;
    int kafelMaxY;
    int liczbaKafliX;
    int liczbaKafliY;
    int stareMinX = 1;
    int stareMaxX = 0;
    int stareMinY = 1;
    int stareMaxY = 0;

    public TerrainCamera(TerrainTileMap map, Sky sky) {
        this.sky = sky;
        this.map = map;
        this.tileWidth = map.tileWidth;
        this.tileWidthLog = map.tileWidthLog;
        this.tileWidthLogM16 = 16 - this.tileWidthLog;
        this.mapWidth = map.mapWidth;
        this.mapHeight = map.mapHeight;
        this.angle = -100;
        this.pitch = -100;
        this.roll = -100;
    }

    public void setCameraVariables(PixelGraphics pixelGraphics, int widthAngle, int heightAngle, int horizontLevel, int firstSlice, int[] maxSliceSection, int sliceInterval, int heightFactor, int color) {
        this.pixelGraphics = pixelGraphics;
        this.renderWidth = pixelGraphics.renderWidth;
        this.renderHeight = pixelGraphics.renderHeight;
        this.widthAngle = widthAngle;
        this.heightAngle = heightAngle;
        this.horizontLevel = horizontLevel;
        this.firstSlice = firstSlice;
        this.maxSliceSection = maxSliceSection;
        this.sliceInterval = sliceInterval;
        this.heightFactor = heightFactor;
        this.renderWidthDiv2 = this.renderWidth >> 1;
        this.renderWidth3Div2 = this.renderWidth * 3 >> 1;
        this.numberOfSections = maxSliceSection.length;
        this.maxSlice = maxSliceSection[this.numberOfSections - 1];
        this.targetColor = color;
        this.colorFactorSlice = new byte[this.maxSlice];
        this.targetColorSlice = new int[this.maxSlice];
        for (int i = 0; i < maxSliceSection[0]; ++i) {
            this.colorFactorSlice[i] = 16;
            this.targetColorSlice[i] = 0;
        }
        int interval = maxSliceSection[1] != maxSliceSection[0] ? 786432 / (maxSliceSection[1] - maxSliceSection[0]) : 0;
        int factor = 983040;
        for (int i = maxSliceSection[0]; i < maxSliceSection[1]; ++i) {
            this.colorFactorSlice[i] = (byte)(factor >> 16);
            this.targetColorSlice[i] = this.targetColor * (16 - (factor >> 16));
            factor -= interval;
        }
        this.additionHeightRay = new int[this.renderWidthDiv2];
        this.heightFactorSlice = new int[this.maxSlice];
        this.heightToScreen = new int[this.renderHeight];
        int tg = Math.tg(heightAngle);
        int renderHeightDiv2 = this.renderHeight >> 1;
        for (int slice = 1; slice < this.maxSlice; ++slice) {
            this.heightFactorSlice[slice] = (0x6E00000 / (tg * slice) << 6 >> 2) * heightFactor >> 4;
        }
        int screenHeightM = this.renderHeight - 1;
        for (int i = this.renderHeight - 1; i >= 0; --i) {
            this.heightToScreen[i] = (screenHeightM - i) * this.renderWidth;
        }
        this.sliceRayFactor = new int[this.maxSlice];
        int tgWidthAngle = Math.tg(widthAngle);
        for (int i = 1; i < this.maxSlice; ++i) {
            this.sliceRayFactor[i] = (this.renderWidthDiv2 << 18) / (tgWidthAngle * i);
        }
        this.localTilesMapWidth = this.maxSlice * 3 / (this.tileWidth * 2) * 2 + 3;
        this.localTilesMapWidthDiv2 = this.localTilesMapWidth >> 1;
        this.localTilesMapSize = this.localTilesMapWidth * this.localTilesMapWidth;
        this.localTilesMap = new Tile[this.localTilesMapSize];
        this.map.setLocalTiles(this.localTilesMap, this.localTilesMapWidth);
        this.cameraTile = this.localTilesMapSize >> 1;
    }

    public void setCameraPosition(int cameraX, int cameraY, int cameraHeight, int angle, int pitch, int roll) {
        this.cameraX = cameraX;
        this.cameraY = cameraY;
        this.cameraXPoints = cameraX >> 16;
        this.cameraYPoints = cameraY >> 16;
        int newCameraXTile = this.cameraXPoints >> this.tileWidthLog;
        int newCameraYTile = this.cameraYPoints >> this.tileWidthLog;
        int deltaX = this.cameraXTile - newCameraXTile;
        int deltaY = this.cameraYTile - newCameraYTile;
        int delta = deltaX + deltaY * this.localTilesMapWidth;
        this.cameraXTile = newCameraXTile;
        this.cameraYTile = newCameraYTile;
        this.map.setLocalCenter(this.cameraXTile, this.cameraYTile);
        if (deltaX >= this.localTilesMapWidthDiv2 || deltaX <= -this.localTilesMapWidthDiv2 || deltaY >= this.localTilesMapWidthDiv2 || deltaY <= -this.localTilesMapWidthDiv2) {
            for (int pointer = 0; pointer < this.localTilesMapSize; ++pointer) {
                this.removeTile(pointer);
            }
        } else if (delta != 0) {
            int x;
            int pointer2;
            int y;
            int pointer;
            int i;
            if (delta > 0) {
                for (i = this.localTilesMapSize - delta; i < this.localTilesMapSize; ++i) {
                    this.removeTile(i);
                }
                System.arraycopy(this.localTilesMap, 0, this.localTilesMap, delta, this.localTilesMapSize - delta);
            }
            if (delta < 0) {
                for (i = -delta - 1; i >= 0; --i) {
                    this.removeTile(i);
                }
                System.arraycopy(this.localTilesMap, -delta, this.localTilesMap, 0, this.localTilesMapSize + delta);
            }
            if (deltaX > 0) {
                pointer = 0;
                y = 0;
                while (y < this.localTilesMapWidth) {
                    pointer2 = pointer;
                    x = 0;
                    while (x < deltaX) {
                        this.removeTile(pointer2);
                        ++x;
                        ++pointer2;
                    }
                    ++y;
                    pointer += this.localTilesMapWidth;
                }
            }
            if (deltaX < 0) {
                pointer = this.localTilesMapWidth - 1;
                y = 0;
                while (y < this.localTilesMapWidth) {
                    pointer2 = pointer;
                    x = 0;
                    while (x > deltaX) {
                        this.removeTile(pointer2);
                        --x;
                        --pointer2;
                    }
                    ++y;
                    pointer += this.localTilesMapWidth;
                }
            }
            if (deltaY > 0) {
                for (pointer = this.localTilesMapWidth * deltaY - 1; pointer >= 0; --pointer) {
                    this.removeTile(pointer);
                }
            }
            if (deltaY < 0) {
                for (pointer = this.localTilesMapWidth * (this.localTilesMapWidth + deltaY); pointer < this.localTilesMapSize; ++pointer) {
                    this.removeTile(pointer);
                }
            }
        }
        this.cameraHeight = cameraHeight;
        this.setAngle(angle);
        this.setPitchRoll(pitch, roll);
        this.realHorizontLevel = -cameraHeight * this.heightFactorSlice[this.maxSlice - 1] >> 16;
    }

    private void setAngle(int newAngle) {
        if ((newAngle %= 360) < 0) {
            newAngle += 360;
        }
        if (this.angle == newAngle) {
            return;
        }
        this.angle = newAngle;
        this.angleLeft = this.angle + this.widthAngle;
        if (this.angleLeft >= 360) {
            this.angleLeft -= 360;
        }
        short cos = Math.cos360[this.angle];
        short sin = Math.sin360[this.angle];
        int tgWidthAngle = Math.tg(this.widthAngle);
        this.wspXLeft = cos - (sin * tgWidthAngle >> 10) << 6;
        this.wspYLeft = -(sin + (cos * tgWidthAngle >> 10) << 6);
        this.wspXRight = cos + (sin * tgWidthAngle >> 10) << 6;
        this.wspYRight = -(sin - (cos * tgWidthAngle >> 10) << 6);
        this.wspXInterval = (this.wspXRight - this.wspXLeft) / this.renderWidthDiv2;
        this.wspYInterval = (this.wspYRight - this.wspYLeft) / this.renderWidthDiv2;
    }

    public void setPitchRoll(int newPitch, int newRoll) {
        if (newPitch == this.pitch && newRoll == this.roll) {
            return;
        }
        this.pitch = newPitch;
        this.roll = newRoll;
        int tangens = Math.tg(this.roll);
        int przemieszczenie = this.renderWidthDiv2 * tangens >> 4;
        int intervalPrzemieszczenie = -(przemieszczenie * 2 / this.renderWidthDiv2);
        int czynnikPion = -this.pitch + this.horizontLevel;
        this.addToHorizontLevel = czynnikPion + (this.renderHeight >> 1);
        for (int i = this.renderWidthDiv2 - 1; i >= 0; --i) {
            int przesuniecie;
            this.additionHeightRay[i] = przesuniecie = (przemieszczenie >> 8) + czynnikPion + (this.renderHeight >> 1);
            przemieszczenie += intervalPrzemieszczenie;
        }
    }

    public void setRenderClip(short[] renderMinHeight, short[] renderMaxHeight) {
        this.renderMinHeight = renderMinHeight;
        this.renderMaxHeight = renderMaxHeight;
        for (int i = 0; i < this.renderWidthDiv2; ++i) {
            if (renderMinHeight[i] < 0) {
                renderMinHeight[i] = 0;
            }
            if (renderMaxHeight[i] < this.renderHeight) continue;
            renderMaxHeight[i] = (short)(this.renderHeight - 1);
        }
    }

    public void setRenderClip(int renderMin, int renderMax) {
        this.renderMinHeight = new short[this.renderWidthDiv2];
        this.renderMaxHeight = new short[this.renderWidthDiv2];
        if (renderMin < 0) {
            renderMin = 0;
        }
        if (renderMax >= this.renderHeight) {
            renderMax = this.renderHeight - 1;
        }
        for (int i = 0; i < this.renderWidthDiv2; ++i) {
            this.renderMinHeight[i] = (short)renderMin;
            this.renderMaxHeight[i] = (short)renderMax;
        }
    }

    public void renderView() throws Exception {
        this.wyliczPotrzebneKafle();
        long time = System.currentTimeMillis();
        this.renderSimpleView();
        this.createViewTime = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        this.drawStaticObjects();
        this.createObjectTime = (int)(System.currentTimeMillis() - time);
    }

    public void renderSimpleView() throws Exception {
        int[] renderTable = this.pixelGraphics.renderTable;
        int[] skyColor = this.sky.skyColor;
        byte[] zBuffer = this.pixelGraphics.zBuffer;
        TerrainTexture texture = this.map.terrainTexture;
        TerrainTexture waterTexture = this.map.waterTexture;
        int maskaXKafla = (this.tileWidth << 16) - 1;
        int xInterval = this.wspXLeft;
        int yInterval = this.wspYLeft;
        for (int ray = 0; ray < this.renderWidthDiv2; ++ray) {
            int skyTableIndex;
            int renderTableIndex;
            int color;
            int slice = this.firstSlice;
            int rayHeight = this.renderMinHeight[ray];
            int maxHeight = this.renderMaxHeight[ray];
            int additionHeight = this.additionHeightRay[ray];
            int xTile = this.cameraX + slice * xInterval;
            int yTile = this.cameraY + slice * yInterval;
            int tileX = xTile >> 16 + this.tileWidthLog;
            int tileY = yTile >> 16 + this.tileWidthLog;
            int tile = this.cameraTile + (tileX - this.cameraXTile) + (tileY - this.cameraYTile) * this.localTilesMapWidth;
            xTile &= maskaXKafla;
            yTile &= maskaXKafla;
            Tile currentTile = this.localTilesMap[tile];
            if (currentTile == null) {
                this.localTilesMap[tile] = this.map.createTile(tileX, tileY);
                currentTile = this.localTilesMap[tile];
            }
            byte[] terrainHeight = currentTile.terrainHeight;
            texture.setCurrentTile(tileX, tileY);
            waterTexture.setCurrentTile(tileX, tileY);
            int rayShift1 = ray << 1;
            int intervalSlice = 1;
            int xIntervalTemp = xInterval;
            int yIntervalTemp = yInterval;
            for (int section = 0; section < this.numberOfSections; ++section) {
                int maxSliceTemp = this.maxSliceSection[section];
                while (slice < maxSliceTemp) {
                    int drawPixels;
                    int tileIndex;
                    int drawHeight;
                    if (xTile > maskaXKafla || xTile < 0 || yTile > maskaXKafla || yTile < 0) {
                        if (xTile < 0) {
                            xTile &= maskaXKafla;
                            --tileX;
                            --tile;
                        }
                        if (yTile < 0) {
                            yTile &= maskaXKafla;
                            --tileY;
                            tile -= this.localTilesMapWidth;
                        }
                        if (xTile > maskaXKafla) {
                            xTile &= maskaXKafla;
                            ++tileX;
                            ++tile;
                        }
                        if (yTile > maskaXKafla) {
                            yTile &= maskaXKafla;
                            ++tileY;
                            tile += this.localTilesMapWidth;
                        }
                        if ((currentTile = this.localTilesMap[tile]) == null) {
                            this.localTilesMap[tile] = this.map.createTile(tileX, tileY);
                            currentTile = this.localTilesMap[tile];
                        }
                        terrainHeight = currentTile.terrainHeight;
                        texture.setCurrentTile(tileX, tileY);
                        waterTexture.setCurrentTile(tileX, tileY);
                    }
                    if ((drawHeight = ((terrainHeight[tileIndex = (xTile >> 16) + (yTile >> 16 << this.tileWidthLog)] - this.cameraHeight) * this.heightFactorSlice[slice] >> 16) + additionHeight) > maxHeight) {
                        drawHeight = maxHeight;
                    }
                    if ((drawPixels = drawHeight - rayHeight) > 0) {
                        byte sliceDiv2 = (byte)(slice >> 1);
                        color = terrainHeight[tileIndex] <= 0 ? waterTexture.getColor(tileIndex) : texture.getColor(tileIndex);
                        if (section != 0) {
                            color = (color & 0xF0F0F0) * this.colorFactorSlice[slice] + this.targetColorSlice[slice] >> 4;
                        }
                        rayHeight = drawHeight;
                        renderTableIndex = this.heightToScreen[drawHeight] + rayShift1;
                        while (drawPixels-- > 0) {
                            renderTable[renderTableIndex] = color;
                            renderTable[renderTableIndex + 1] = color;
                            zBuffer[renderTableIndex] = sliceDiv2;
                            zBuffer[renderTableIndex + 1] = sliceDiv2;
                            renderTableIndex += this.renderWidth;
                        }
                    }
                    slice += intervalSlice;
                    xTile += xIntervalTemp;
                    yTile += yIntervalTemp;
                }
            }
            xInterval += this.wspXInterval;
            yInterval += this.wspYInterval;
            if (this.sky.skyType != 3) continue;
            int angleT = this.angleLeft - ray;
            if (angleT < 0) {
                angleT += 360;
            }
            int indeksKoloru = 1 + (rayHeight - (this.realHorizontLevel + additionHeight) >> 1);
            renderTableIndex = this.heightToScreen[rayHeight + 1] + rayShift1;
            for (skyTableIndex = (this.sky.skyHeight - indeksKoloru - 1) * 360 + angleT; skyTableIndex >= skyColor.length; skyTableIndex -= 360) {
            }
            while (skyTableIndex >= 0 && rayHeight++ < maxHeight) {
                renderTable[renderTableIndex] = skyColor[skyTableIndex];
                renderTable[renderTableIndex + 1] = skyColor[skyTableIndex];
                renderTableIndex -= this.renderWidth;
                if (rayHeight++ >= maxHeight) continue;
                renderTable[renderTableIndex] = skyColor[skyTableIndex];
                renderTable[renderTableIndex + 1] = skyColor[skyTableIndex];
                renderTableIndex -= this.renderWidth;
                skyTableIndex -= 360;
            }
            color = skyColor[angleT];
            while (rayHeight++ < maxHeight) {
                renderTable[renderTableIndex] = color;
                renderTable[renderTableIndex + 1] = color;
                renderTableIndex -= this.renderWidth;
            }
        }
    }

    public void wyliczPotrzebneKafle() throws Exception {
        int xP1 = this.cameraX + this.wspXLeft * this.maxSlice >> 16 + this.tileWidthLog;
        int yP1 = this.cameraY + this.wspYLeft * this.maxSlice >> 16 + this.tileWidthLog;
        int xP2 = this.cameraX + this.wspXRight * this.maxSlice >> 16 + this.tileWidthLog;
        int yP2 = this.cameraY + this.wspYRight * this.maxSlice >> 16 + this.tileWidthLog;
        int xP3 = this.cameraXPoints >> this.tileWidthLog;
        int yP3 = this.cameraYPoints >> this.tileWidthLog;
        this.kafelMinX = xP1;
        this.kafelMaxX = xP1;
        if (xP2 < this.kafelMinX) {
            this.kafelMinX = xP2;
        } else {
            this.kafelMaxX = xP2;
        }
        if (xP3 < this.kafelMinX) {
            this.kafelMinX = xP3;
        }
        if (xP3 > this.kafelMaxX) {
            this.kafelMaxX = xP3;
        }
        this.kafelMinY = yP1;
        this.kafelMaxY = yP1;
        if (yP2 < this.kafelMinY) {
            this.kafelMinY = yP2;
        } else {
            this.kafelMaxY = yP2;
        }
        if (yP3 < this.kafelMinY) {
            this.kafelMinY = yP3;
        }
        if (yP3 > this.kafelMaxY) {
            this.kafelMaxY = yP3;
        }
        int liczbaKafliX = this.kafelMaxX - this.kafelMinX + 1;
        int liczbaKafliY = this.kafelMaxY - this.kafelMinY + 1;
        int maskaXMapyKafli = this.mapWidth - 1;
        int maskaYMapyKafli = this.mapHeight - 1;
        for (int kafelPoziomo = this.stareMinX; kafelPoziomo <= this.stareMaxX; ++kafelPoziomo) {
            for (int kafelPionowo = this.stareMinY; kafelPionowo <= this.stareMaxY; ++kafelPionowo) {
                if (kafelPoziomo >= this.kafelMinX && kafelPoziomo <= this.kafelMaxX && kafelPionowo >= this.kafelMinY && kafelPionowo <= this.kafelMaxY) continue;
                int deltaX = kafelPoziomo - this.cameraXTile;
                int deltaY = kafelPionowo - this.cameraYTile;
                if (deltaX >= this.localTilesMapWidthDiv2 || deltaX <= -this.localTilesMapWidthDiv2) continue;
                int tile = this.cameraTile + deltaX + deltaY * this.localTilesMapWidth;
                this.removeTile(tile);
            }
        }
        this.stareMinX = this.kafelMinX;
        this.stareMaxX = this.kafelMaxX;
        this.stareMinY = this.kafelMinY;
        this.stareMaxY = this.kafelMaxY;
    }

    public void removeTile(int index) {
        if (this.localTilesMap[index] != null) {
            this.map.removeTile(this.localTilesMap[index]);
            this.localTilesMap[index] = null;
        }
    }

    public void drawTileObjects(int tileX, int tileY) throws Exception {
        int localTileIndex = this.cameraTile + (tileX - this.cameraXTile) + (tileY - this.cameraYTile) * this.localTilesMapWidth;
        if (localTileIndex < 0 || localTileIndex >= this.localTilesMapSize || this.localTilesMap[localTileIndex] == null) {
            return;
        }
        int cosinus = Math.cos(90 - this.angle);
        int sinus = Math.sin(90 - this.angle);
        Rozklad rozklad = this.localTilesMap[localTileIndex].rozklad;
        for (int i = rozklad.liczbaObiektow - 1; i >= 0; --i) {
            int ray;
            Sprite2D sprite = SpriteManager.returnStaticSprite(rozklad.rodzajObiektu[i]);
            if (sprite == null) continue;
            int spriteX = rozklad.polozenieObiektuX[i] + (tileX << this.tileWidthLog);
            int spriteY = rozklad.polozenieObiektuY[i] + (tileY << this.tileWidthLog);
            int xTemp = spriteX - this.cameraXPoints;
            int yTemp = spriteY - this.cameraYPoints;
            int xInCameraPosition = yTemp * sinus + xTemp * cosinus;
            int yInCameraPosition = -(yTemp * cosinus - xTemp * sinus);
            int slice = yInCameraPosition >> 10;
            if (slice <= 5 || slice >= this.maxSlice || (ray = (xInCameraPosition * this.sliceRayFactor[slice] >> 18) + this.renderWidthDiv2) < -this.renderWidthDiv2 || ray > this.renderWidth3Div2) continue;
            int height = sprite.spriteHeight * this.heightFactorSlice[slice] >> 16;
            int polozenieT = ray >> 1;
            if (polozenieT < 0) {
                polozenieT = 0;
            }
            if (polozenieT >= this.renderWidthDiv2) {
                polozenieT = this.renderWidthDiv2 - 1;
            }
            int heightOnScreen = this.renderHeight - (((rozklad.wysokoscObiektu[i] - this.cameraHeight) * this.heightFactorSlice[slice] >> 16) + this.additionHeightRay[polozenieT]);
            int z = (slice >> 1) - 4;
            if (z <= 0) {
                z = 1;
            }
            sprite.draw3D(this.pixelGraphics, ray, heightOnScreen, height, z, 0, 0, this.targetColorSlice[slice], this.colorFactorSlice[slice]);
        }
    }

    public void drawStaticObjects() throws Exception {
        for (int kafelPoziomo = this.kafelMinX; kafelPoziomo <= this.kafelMaxX; ++kafelPoziomo) {
            for (int kafelPionowo = this.kafelMinY; kafelPionowo <= this.kafelMaxY; ++kafelPionowo) {
                this.drawTileObjects(kafelPoziomo & this.map.mapWidthMask, kafelPionowo & this.map.mapHeightMask);
            }
        }
    }

    public void narysujObiekt(Sprite2D sprite, int slice, int ray, int wysokosc, int kat) throws Exception {
        try {
            if (sprite == null || ray < -this.renderWidthDiv2 || ray > this.renderWidth3Div2) {
                return;
            }
            int height = sprite.spriteHeight * this.heightFactorSlice[slice] >> 16;
            int polozenieT = ray >> 1;
            if (polozenieT < 0) {
                polozenieT = 0;
            }
            if (polozenieT >= this.renderWidthDiv2) {
                polozenieT = this.renderWidthDiv2 - 1;
            }
            int heightOnScreen = this.renderHeight - (((wysokosc - this.cameraHeight) * this.heightFactorSlice[slice] >> 16) + this.additionHeightRay[polozenieT]);
            int z = (slice >> 1) - 6;
            if (z <= 0) {
                z = 1;
            }
            sprite.draw3D(this.pixelGraphics, ray, heightOnScreen, height, z, kat, 0, this.targetColorSlice[slice], this.colorFactorSlice[slice]);
        }
        catch (Exception e) {
            Util.critical(e, "Narysuj Obiekt " + slice + " " + ray + " " + wysokosc + " " + kat);
        }
    }
}

