/*
 * Decompiled with CFR 0.152.
 */
package pixelGraphics;

public class PixelGraphics {
    public int[] renderTable;
    private int[] renderTableCleaner;
    public byte[] zBuffer;
    private byte[] zBufferCleaner;
    public int renderWidth;
    public int renderHeight;
    public int renderWidthDiv2;
    public int clipMinX;
    public int clipMinY;
    public int clipMaxX;
    public int clipMaxY;

    public PixelGraphics(int renderWidth, int renderHeight) {
        this.renderTable = new int[renderWidth * renderHeight];
        this.zBuffer = new byte[renderWidth * renderHeight];
        this.renderWidth = renderWidth;
        this.renderHeight = renderHeight;
        this.renderWidthDiv2 = renderWidth >> 1;
        this.setClip(0, 0, renderWidth, renderHeight);
    }

    public void setClip(int minX, int minY, int width, int height) {
        if (width >= 0) {
            this.clipMinX = minX;
            this.clipMaxX = minX + width;
        } else {
            this.clipMaxX = minX;
            this.clipMinX = minX + width;
        }
        if (height >= 0) {
            this.clipMinY = minY;
            this.clipMaxY = minY + height;
        } else {
            this.clipMaxY = minY;
            this.clipMinY = minY + height;
        }
        if (this.clipMinX < 0) {
            this.clipMinX = 0;
        }
        if (this.clipMinY < 0) {
            this.clipMinY = 0;
        }
        if (this.clipMaxX >= this.renderWidth) {
            this.clipMaxX = this.renderWidth - 1;
        }
        if (this.clipMaxY >= this.renderHeight) {
            this.clipMaxY = this.renderHeight - 1;
        }
    }

    public void setCleaner(int renderTableCleanerValue, byte zBufferCleanerValue) {
        int i;
        if (renderTableCleanerValue >= 0) {
            if (this.renderTableCleaner == null) {
                this.renderTableCleaner = new int[this.renderWidth];
            }
            for (i = 0; i < this.renderWidth; ++i) {
                this.renderTableCleaner[i] = renderTableCleanerValue;
            }
        }
        if (zBufferCleanerValue >= 0) {
            if (this.zBufferCleaner == null) {
                this.zBufferCleaner = new byte[this.renderWidth];
            }
            for (i = 0; i < this.renderWidth; ++i) {
                this.zBufferCleaner[i] = zBufferCleanerValue;
            }
        }
    }

    public void cleanRenderTable() {
        if (this.renderTableCleaner == null) {
            return;
        }
        int pointer = 0;
        for (int y = 0; y < this.renderHeight; ++y) {
            System.arraycopy(this.renderTableCleaner, 0, this.renderTable, pointer, this.renderWidth);
            pointer += this.renderWidth;
        }
    }

    public void cleanZBuffer() {
        if (this.zBufferCleaner == null) {
            return;
        }
        int pointer = 0;
        for (int y = 0; y < this.renderHeight; ++y) {
            System.arraycopy(this.zBufferCleaner, 0, this.zBuffer, pointer, this.renderWidth);
            pointer += this.renderWidth;
        }
    }
}

