/*
 * Decompiled with CFR 0.152.
 */
package root;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.Util;

public class UtilGraphics {
    public static void drawPixelTable(Graphics g, int[] pixelTable, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        g.drawRGB(pixelTable, offset, scanlength, x, y, width, height, processAlpha);
    }

    public static void imageToPixelTable(Image image, int[] pixelTable, int offset, int scanlength, int x, int y, int width, int height) throws Exception {
        image.getRGB(pixelTable, offset, scanlength, x, y, width, height);
    }

    public static int[] createGradientColors(int[][] gradientColors, int numberOfColors) {
        int kolor;
        int[] gradient = new int[numberOfColors];
        int liczbaPrzedzialow = gradientColors.length;
        int pozycja = 0;
        int przedzialAktualny = 0;
        int kolorR = 0;
        int kolorG = 0;
        int kolorB = 0;
        while (przedzialAktualny < liczbaPrzedzialow - 1) {
            kolorR = gradientColors[przedzialAktualny][0] << 8;
            kolorG = gradientColors[przedzialAktualny][1] << 8;
            kolorB = gradientColors[przedzialAktualny][2] << 8;
            int dlugoscInterpolacji = gradientColors[przedzialAktualny + 1][3] - gradientColors[przedzialAktualny][3];
            ++przedzialAktualny;
            if (dlugoscInterpolacji <= 0) continue;
            int intervalR = ((gradientColors[przedzialAktualny][0] << 8) - kolorR) / dlugoscInterpolacji;
            int intervalG = ((gradientColors[przedzialAktualny][1] << 8) - kolorG) / dlugoscInterpolacji;
            int intervalB = ((gradientColors[przedzialAktualny][2] << 8) - kolorB) / dlugoscInterpolacji;
            while (dlugoscInterpolacji > 0) {
                kolor = (((kolorR += intervalR) & 0xFF00) << 8) + ((kolorG += intervalG) & 0xFF00) + ((kolorB += intervalB) >> 8);
                gradient[pozycja++] = kolor;
                --dlugoscInterpolacji;
            }
        }
        kolor = ((kolorR & 0xFF00) << 8) + (kolorG & 0xFF00) + (kolorB >> 8);
        while (pozycja < numberOfColors) {
            gradient[pozycja++] = kolor;
        }
        return gradient;
    }

    public static short[] createShortGradientColors(int[][] gradientColors, int numberOfColors) {
        int[] gradientInt = UtilGraphics.createGradientColors(gradientColors, numberOfColors);
        short[] gradient = new short[numberOfColors];
        for (int i = 0; i < numberOfColors; ++i) {
            int color = gradientInt[i];
            gradient[i] = UtilGraphics.convertRGBToShort(color);
        }
        return gradient;
    }

    public static short convertRGBToShort(int color) {
        return (short)(((color & 0xF00000) >> 12) + ((color & 0xF000) >> 8) + ((color & 0xF0) >> 4));
    }

    public static final Image[] loadImageTable(String fileName, int imagesExpected, int imagesInLine) {
        Image source = null;
        try {
            source = Image.createImage((String)fileName);
        }
        catch (Exception e) {
            Util.critical(e, "loadImageTable " + fileName);
        }
        return UtilGraphics.createImageTable(source, imagesExpected, imagesInLine);
    }

    public static final Image[] createImageTable(Image source, int imagesExpected, int imagesInLine) {
        Image[] result = new Image[imagesExpected];
        int imagesInColumn = imagesExpected / imagesInLine;
        if (imagesExpected % imagesInLine != 0) {
            ++imagesInColumn;
        }
        int height = source.getHeight() / imagesInColumn;
        int width = source.getWidth() / imagesInLine;
        int x = 0;
        int y = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = Image.createImage((Image)source, (int)x, (int)y, (int)width, (int)height, (int)0);
            x += width;
            if (i % imagesInLine != imagesInLine - 1) continue;
            x = 0;
            y += height;
        }
        return result;
    }
}

