/*
 * Decompiled with CFR 0.152.
 */
package jednostki;

import jednostki.JednostkaAktywna;
import math.Math;

public class JednostkaDynamiczna
extends JednostkaAktywna {
    int predkosc;
    int zwrotnosc;
    byte liczbaPunktow;
    short[] tablicaX;
    short[] tablicaY;
    boolean sprawdzX;
    boolean lotDoPrzodu;
    int znak;
    int xTemp;
    int yTemp;
    int deltaX;
    int deltaY;
    int predkoscX;
    int predkoscY;
    int katDocelowy;
    int nastepnyPunkt;
    public static final int predkoscHelikoptera = 8192;

    public JednostkaDynamiczna(byte liczbaP, short[] tabX, short[] tabY, int predkoscStandardowa, int zwrotnoscStandardowa, int wysokoscStandardowa, byte parametry) {
        super(liczbaP, tabX, tabY, wysokoscStandardowa);
        this.predkosc = 8192 * (parametry & 7) >> 3;
        this.zwrotnosc = zwrotnoscStandardowa;
        this.liczbaPunktow = liczbaP;
        this.tablicaX = tabX;
        this.tablicaY = tabY;
        this.xTemp = this.x << 8;
        this.yTemp = this.y << 8;
        this.deltaX = (this.tablicaX[this.nastepnyPunkt] << 8) - this.xTemp;
        this.deltaY = (this.tablicaY[this.nastepnyPunkt] << 8) - this.yTemp;
        this.nastepnyPunkt = 1;
        this.kat = this.katDocelowy = Math.arcTg(this.deltaX, this.deltaY);
        this.lotDoPrzodu = true;
        this.predkoscX = Math.cos(this.kat) * this.predkosc;
        this.predkoscY = Math.sin(this.kat) * this.predkosc;
        if (this.katDocelowy > 45 && this.katDocelowy < 135) {
            this.sprawdzX = false;
            this.znak = 1;
        } else if (this.katDocelowy > 225 && this.katDocelowy < 315) {
            this.sprawdzX = false;
            this.znak = -1;
        } else if (this.katDocelowy >= 135 && this.katDocelowy <= 225) {
            this.sprawdzX = true;
            this.znak = 1;
        } else {
            this.sprawdzX = true;
            this.znak = -1;
        }
    }

    public void ustawPolozenieDynamiczna(int czasAplikacji, int intervalTime) {
        this.ustawPolozenie(czasAplikacji, intervalTime, true);
        if (this.lotDoPrzodu) {
            int przesuniecieX = this.predkoscX * intervalTime >> 20;
            int przesuniecieY = this.predkoscY * intervalTime >> 20;
            this.xTemp += przesuniecieX;
            this.yTemp -= przesuniecieY;
            if (this.sprawdzX) {
                this.deltaX -= przesuniecieX;
                if (this.deltaX * this.znak > 0) {
                    this.lotDoPrzodu = false;
                }
            } else {
                this.deltaY += przesuniecieY;
                if (this.deltaY * this.znak > 0) {
                    this.lotDoPrzodu = false;
                }
            }
            if (!this.lotDoPrzodu) {
                this.nastepnyPunkt = (this.nastepnyPunkt + 1) % this.liczbaPunktow;
                this.deltaX = (this.tablicaX[this.nastepnyPunkt] << 8) - this.xTemp;
                this.deltaY = (this.tablicaY[this.nastepnyPunkt] << 8) - this.yTemp;
                this.katDocelowy = Math.arcTg(this.deltaX, this.deltaY);
                this.predkoscX = Math.cos(this.katDocelowy) * this.predkosc;
                this.predkoscY = Math.sin(this.katDocelowy) * this.predkosc;
                if (this.katDocelowy > 45 && this.katDocelowy < 135) {
                    this.sprawdzX = false;
                    this.znak = 1;
                } else if (this.katDocelowy > 225 && this.katDocelowy < 315) {
                    this.sprawdzX = false;
                    this.znak = -1;
                } else if (this.katDocelowy >= 135 && this.katDocelowy <= 225) {
                    this.sprawdzX = true;
                    this.znak = 1;
                } else {
                    this.sprawdzX = true;
                    this.znak = -1;
                }
            }
        } else {
            int roznicaKatow = this.katDocelowy - this.kat;
            if (roznicaKatow > 180) {
                roznicaKatow -= 360;
            }
            if (roznicaKatow < -180) {
                roznicaKatow += 360;
            }
            if (roznicaKatow >= 0) {
                int zmianaKata = this.zwrotnosc * intervalTime >> 4;
                if (roznicaKatow <= zmianaKata) {
                    this.kat = this.katDocelowy;
                    this.lotDoPrzodu = true;
                } else {
                    this.kat += zmianaKata;
                }
            } else if (roznicaKatow < 0) {
                int zmianaKata = this.zwrotnosc * intervalTime >> 4;
                if (roznicaKatow >= -zmianaKata) {
                    this.kat = this.katDocelowy;
                    this.lotDoPrzodu = true;
                } else {
                    this.kat -= zmianaKata;
                }
            }
        }
        this.x = this.xTemp >> 8;
        this.y = this.yTemp >> 8;
    }
}

