/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io;

import de.enough.polish.io.Serializer;
import de.enough.polish.io.Storage;
import de.enough.polish.util.HashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RmsStorage
implements Storage {
    private final RecordStore masterRecordStore;
    private final HashMap masterRecordSetIdsByName;
    private final int indexRecordId;

    public RmsStorage() {
        this.masterRecordStore = null;
        this.masterRecordSetIdsByName = null;
        this.indexRecordId = -1;
    }

    public RmsStorage(String singleRecordStoreName) throws IOException {
        if (singleRecordStoreName != null) {
            try {
                this.masterRecordStore = RecordStore.openRecordStore((String)singleRecordStoreName, (boolean)true);
                this.masterRecordSetIdsByName = new HashMap();
                RecordEnumeration enumeration = this.masterRecordStore.enumerateRecords(null, null, false);
                int firstId = Integer.MAX_VALUE;
                while (enumeration.hasNextElement()) {
                    int id = enumeration.nextRecordId();
                    if (id >= firstId) continue;
                    firstId = id;
                }
                enumeration.destroy();
                if (firstId == Integer.MAX_VALUE) {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(byteOut);
                    out.writeInt(0);
                    byte[] data = byteOut.toByteArray();
                    this.indexRecordId = this.masterRecordStore.addRecord(data, 0, data.length);
                    out.close();
                    byteOut.close();
                }
                this.indexRecordId = firstId;
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.masterRecordStore.getRecord(firstId)));
                int numberOfEntries = in.readInt();
                for (int i = 0; i < numberOfEntries; ++i) {
                    String name = in.readUTF();
                    int recordId = in.readInt();
                    this.masterRecordSetIdsByName.put(name, new Integer(recordId));
                }
                in.close();
            }
            catch (RecordStoreException e2) {
                throw new IOException(e2.toString());
            }
        } else {
            this.masterRecordStore = null;
            this.masterRecordSetIdsByName = null;
            this.indexRecordId = -1;
        }
    }

    private int getRecordSetId(String name) {
        Integer id = (Integer)this.masterRecordSetIdsByName.get(name);
        if (id != null) {
            return id;
        }
        return -1;
    }

    private void registerRecordSetId(int id, String name) throws IOException, RecordStoreException {
        this.masterRecordSetIdsByName.put(name, new Integer(id));
        Object[] keys = this.masterRecordSetIdsByName.keys();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        out.writeInt(this.masterRecordSetIdsByName.size());
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            Integer idInt = (Integer)this.masterRecordSetIdsByName.get(key);
            out.writeUTF(key);
            out.writeInt(idInt);
        }
        byte[] data = byteOut.toByteArray();
        this.masterRecordStore.setRecord(this.indexRecordId, data, 0, data.length);
        out.close();
        byteOut.close();
    }

    public void save(Object object, String name) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        Serializer.serialize(object, out);
        byte[] data = byteOut.toByteArray();
        out.close();
        byteOut.close();
        this.saveData(name, data);
    }

    private void saveData(String name, byte[] data) throws IOException {
        try {
            if (this.masterRecordStore != null) {
                int recordSetId = this.getRecordSetId(name);
                if (recordSetId != -1) {
                    this.masterRecordStore.setRecord(recordSetId, data, 0, data.length);
                } else {
                    recordSetId = this.masterRecordStore.addRecord(data, 0, data.length);
                    this.registerRecordSetId(recordSetId, name);
                }
            } else {
                RecordStore store = RecordStore.openRecordStore((String)name, (boolean)true);
                int recordSetId = -1;
                RecordEnumeration enumeration = store.enumerateRecords(null, null, false);
                if (enumeration.hasNextElement()) {
                    recordSetId = enumeration.nextRecordId();
                }
                enumeration.destroy();
                if (recordSetId == -1) {
                    store.addRecord(data, 0, data.length);
                } else {
                    store.setRecord(recordSetId, data, 0, data.length);
                }
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException e2) {
            throw new IOException(e2.toString());
        }
    }

    public Object read(String name) throws IOException {
        byte[] data;
        try {
            if (this.masterRecordStore != null) {
                int recordId = this.getRecordSetId(name);
                if (recordId == -1) {
                    throw new IOException(name + " is unknown");
                }
                data = this.masterRecordStore.getRecord(recordId);
            } else {
                RecordStore store = RecordStore.openRecordStore((String)name, (boolean)false);
                RecordEnumeration enumeration = store.enumerateRecords(null, null, false);
                data = enumeration.nextRecord();
                enumeration.destroy();
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException e2) {
            throw new IOException(e2.toString());
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        return Serializer.deserialize(in);
    }

    public Enumeration enumerate(String name) throws IOException {
        throw new IOException("Sorry, not supported - might drop this method altogether");
    }

    public String[] list() throws IOException {
        if (this.masterRecordStore == null) {
            throw new IllegalStateException();
        }
        return (String[])this.masterRecordSetIdsByName.keys(new String[this.masterRecordSetIdsByName.size()]);
    }
}

