/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class SpriteItem
extends CustomItem {
    private final Sprite sprite;
    private final long animationInterval;
    private final int defaultFrameIndex;
    private final boolean repeatAnimation;
    private boolean isFocused;
    private int currentStep;
    private int maxStep;
    private long lastAnimationTime;

    public SpriteItem(String label, Sprite sprite, long animationInterval, int defaultFrameIndex, boolean repeatAnimation) {
        super(label);
        this.sprite = sprite;
        sprite.setFrame(defaultFrameIndex);
        this.animationInterval = animationInterval;
        this.defaultFrameIndex = defaultFrameIndex;
        this.repeatAnimation = repeatAnimation;
    }

    protected int getMinContentWidth() {
        return this.sprite.getWidth();
    }

    protected int getMinContentHeight() {
        return this.sprite.getHeight();
    }

    protected int getPrefContentWidth(int height) {
        return this.sprite.getWidth();
    }

    protected int getPrefContentHeight(int width) {
        return this.sprite.getHeight();
    }

    protected void paint(Graphics g2, int w, int h) {
        this.sprite.paint(g2);
    }

    protected boolean traverse(int direction, int viewportWidth, int viewportHeight, int[] inoutRect) {
        if (this.isFocused) {
            return false;
        }
        this.currentStep = 0;
        if (!this.repeatAnimation) {
            this.maxStep = this.sprite.getFrameSequenceLength() - 1;
        }
        this.isFocused = true;
        return true;
    }

    protected void traverseOut() {
        this.isFocused = false;
        this.sprite.setFrame(this.defaultFrameIndex);
    }
}

