/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class App
extends MIDlet {
    public static final int SMS_DATA_PRICE = 0;
    public static final int SMS_DATA_PHONE = 1;
    public static final int SMS_DATA_TEXT = 2;
    static final String defaultLanguage = "en";
    static ScreenManager SM = null;
    static String[] textResources;
    static String[] SMSdata;
    static App app;
    public static String debugString;
    public static boolean debugShown;
    public static boolean debugNew;
    public static long debugTime;
    private static String HEX;

    protected void startApp() {
        if (SM == null) {
            app = this;
            SM = new ScreenManager(this);
            if (ScreenManager.localeID == -1) {
                this.loadCurrentLanguage();
            } else {
                this.loadLanguage(Const.lngID[ScreenManager.localeID]);
            }
            this.loadSMSData();
            new Thread(SM).start();
        } else {
            SM.resume();
        }
        this.setScreen(SM.getCurrentDispl());
    }

    void setScreen(Displayable displayable) {
        Display.getDisplay((MIDlet)this).setCurrent(displayable);
    }

    protected void pauseApp() {
        SM.pause();
    }

    protected void destroyApp(boolean bl) {
        if (SM != null) {
            App.SM.running = false;
            App.debugText("exit");
            Target.stopSound();
        }
    }

    void quit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public static void debugText(String string) {
    }

    public static void debugText(String string, Throwable throwable) {
    }

    public static void printStackTrace(Throwable throwable) {
    }

    void loadCurrentLanguage() {
        String string = this.getAppProperty("Locale");
        if (string != null && this.loadLanguage(string.substring(0, 2))) {
            return;
        }
        string = System.getProperty("microedition.locale");
        if (string != null && this.loadLanguage(string.substring(0, 2))) {
            return;
        }
        if (!this.loadLanguage(defaultLanguage)) {
            App.debugText("cannot load any text");
            this.notifyDestroyed();
        }
    }

    static void updatePublicity() {
        if (App.SM.hasAdvertisement) {
            App.textResources[79] = LeaderBoard.pubTitle;
            App.SM.forms[4].reload = true;
        }
    }

    void loadSMSData() {
        SMSdata = new String[3];
        App.SMSdata[0] = this.convertUnicode(this.getAppProperty("SMSPrice"));
        App.SMSdata[0] = App.getNewPriceString(SMSdata[0]);
        App.SMSdata[1] = this.getAppProperty("SMSNumber");
        App.SMSdata[2] = this.getAppProperty("SMSGameCode");
    }

    String convertUnicode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '#') {
                    stringBuffer.append('#');
                    bl = false;
                    continue;
                }
                int n3 = HEX.indexOf(c);
                if (n3 > 0) {
                    n += n3 * n2;
                }
                if ((n2 >>= 4) != 0) continue;
                stringBuffer.append((char)n);
                bl = false;
                continue;
            }
            if (c == '#') {
                bl = true;
                n = 0;
                n2 = 4096;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getNewPriceString(String string) {
        try {
            int n;
            int n2 = string.indexOf("Nagmi");
            if (n2 == -1) {
                return string;
            }
            while (string.charAt(n2 - 1) == ' ' || string.charAt(n2 - 1) == '.') {
                --n2;
            }
            int n3 = n = string.indexOf("Cena:") == -1 ? 0 : 5;
            while (string.charAt(n) == ' ') {
                ++n;
            }
            string = string.substring(n, n2);
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    boolean loadLanguage(String string) {
        String string2 = "text_" + string.toLowerCase() + ".utf";
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(Form.getResource(string2)));
            int n = dataInputStream.readShort();
            if (textResources == null) {
                textResources = new String[n];
            }
            for (int i = 0; i < n; ++i) {
                if (i == 79) continue;
                App.textResources[i] = dataInputStream.readUTF();
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            return false;
        }
        for (int i = 0; i < Const.lngID.length; ++i) {
            if (!Const.lngID[i].equals(string)) continue;
            ScreenManager.localeID = i;
        }
        return true;
    }

    public static String getString(int n) {
        if (n < 0) {
            return null;
        }
        try {
            return textResources[n];
        }
        catch (Exception exception) {
            return "STR_" + n;
        }
    }

    public static String getString(int n, String string) {
        return App.replaceParameter(App.getString(n), "%1%", string);
    }

    public static String getString(int n, String string, String string2) {
        return App.replaceParameter(App.getString(n, string), "%2%", string2);
    }

    public static String replaceParameter(String string, String string2, String string3) {
        while (string.indexOf(string2) >= 0) {
            int n = string.indexOf(string2);
            String string4 = n > 0 ? string.substring(0, n) : "";
            string4 = string4 + string3;
            if (n + string2.length() < string.length()) {
                string4 = string4 + string.substring(n + string2.length());
            }
            string = string4;
        }
        return string;
    }

    public static void delay(int n) {
        long l = System.currentTimeMillis();
        Thread.yield();
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (System.currentTimeMillis() - l < (long)n) {
            Thread.yield();
        }
    }

    static String readUTF(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i];
            if ((n3 & 0x80) != 0 && ++i < n2) {
                byte by = byArray[n + i];
                if ((by & 0x80) != 0) {
                    if (++i < n2) {
                        byte by2 = byArray[n + i];
                        n3 = (n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0;
                    }
                } else {
                    n3 = n3 << 6 & 0xFC0 | by & 0x3F;
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static {
        debugString = "";
        debugShown = true;
        debugNew = false;
        HEX = "0123456789ABCDEF";
    }
}

