/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Scores
extends Form {
    static final String DATA_NAME = "name";
    static final String DATA_VALUE = "score";
    Vector dataV = new Vector(11);
    int selection = -1;
    boolean lbd = false;
    boolean empty = true;
    long prevFrameTime;
    boolean changeColor;

    public Scores(int n) {
        super(n, 33);
    }

    void resetScore() {
        this.setButton(15, -1);
        this.selection = -1;
    }

    void setSize(int n) {
        if (n == 0) {
            this.totalLines = this.data.length;
            this.empty = true;
            this.vCenter = true;
        } else {
            this.totalLines = n;
            this.empty = false;
            this.vCenter = false;
        }
    }

    void add(String string, int n) {
        this.selection = 0;
        while (this.selection < this.dataV.size() && n <= this.getScore(this.selection)) {
            ++this.selection;
        }
        if (this.selection < 10) {
            this.addLineData(this.selection, string, n);
            while (this.dataV.size() > 10) {
                this.dataV.removeElementAt(this.dataV.size() - 1);
            }
            this.setSize(this.dataV.size());
            if (this.selection >= this.viewStart + this.viewLinesAmount) {
                this.viewStart = this.selection - this.viewLinesAmount + 1;
            }
            this.setButton(15, 18);
        } else {
            this.selection = -1;
            this.setButton(15, -1);
        }
    }

    void addLineData(int n, String string, int n2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        hashtable.put(DATA_NAME, string);
        hashtable.put(DATA_VALUE, new Integer(n2));
        this.dataV.insertElementAt(hashtable, n);
    }

    public void setSelectionName(String string) {
        Hashtable hashtable = (Hashtable)this.dataV.elementAt(this.selection);
        hashtable.put(DATA_NAME, string);
        this.repaint();
    }

    void tick() {
        if (App.SM.currentTime > this.prevFrameTime + 1000L) {
            this.prevFrameTime = App.SM.currentTime;
            this.changeColor = !this.changeColor;
            this.repaint();
        }
        super.tick();
    }

    void drawLine(Graphics graphics, int n, int n2) {
        if (this.empty) {
            super.drawLine(graphics, n, n2);
        } else {
            String[] stringArray;
            if (this.lbd) {
                stringArray = LeaderBoard.Rating[n];
            } else {
                String[] stringArray2 = new String[3];
                stringArray2[0] = String.valueOf(n + 1);
                stringArray2[1] = this.getName(n);
                stringArray = stringArray2;
                stringArray2[2] = Integer.toString(this.getScore(n));
            }
            String[] stringArray3 = stringArray;
            int n3 = graphics.getColor();
            if (this.changeColor && n == this.selection) {
                graphics.setColor(0x7FFFFF);
            }
            this.drawScoreLine(graphics, stringArray3, n2);
            graphics.setColor(n3);
        }
    }

    void drawScoreLine(Graphics graphics, String[] stringArray, int n) {
        Font font = graphics.getFont();
        int n2 = this.getMaxTextWidth();
        int n3 = (Const.SCREEN_WIDTH - n2) / 2;
        int n4 = font.stringWidth("20. ");
        graphics.drawString(stringArray[0] + ". ", n3 + n4, n, 24);
        graphics.drawString(stringArray[2], (Const.SCREEN_WIDTH + n2) / 2, n, 24);
        graphics.drawString(Form.shrinkString(stringArray[1], font, n2 - (n3 + n4 + font.stringWidth(stringArray[2]))), n3 + n4, n, 20);
    }

    int getScore(int n) {
        int n2 = 0;
        try {
            Hashtable hashtable = (Hashtable)this.dataV.elementAt(n);
            n2 = (Integer)hashtable.get(DATA_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    String getName(int n) {
        String string = "";
        try {
            Hashtable hashtable = (Hashtable)this.dataV.elementAt(n);
            string = hashtable.get(DATA_NAME).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    void save(DataOutputStream dataOutputStream) throws IOException {
        App.debugText("save scores:");
        int n = 0;
        if (this.dataV != null) {
            n = this.dataV.size();
        }
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.getScore(i);
            String string = this.getName(i);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeUTF(string);
        }
    }

    void load(DataInputStream dataInputStream) throws IOException {
        App.debugText("load scores:");
        this.dataV.removeAllElements();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            this.addLineData(i, string, n2);
        }
        this.setSize(n);
        this.setButton(15, -1);
    }

    void load() {
        this.lbd = true;
        this.selection = (int)LeaderBoard.MyPos;
        this.setSize(LeaderBoard.Rating.length);
        if (this.selection >= this.viewStart + this.viewLinesAmount) {
            this.viewStart = this.selection - this.viewLinesAmount + 1;
        }
        this.setButton(15, -1);
    }
}

