/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class Snd {
    private static boolean bEnabledSound = false;
    private static boolean bEnabledVibra = false;
    private static Player[] players = new Player[1];
    private static final int AMR = 0;
    private static final int MIDI = 1;
    private static final int EMPTY = 2;
    private static final short[] massSoundTypes = new short[]{1};
    private static final int[] massSoundDelays = new int[]{32000};
    private static final boolean[] massSoundVibra = new boolean[]{false};
    private static long lSoundDelay = 0L;
    public static int iQuerySoundId = -1;
    private static int iLastSound = -1;
    private static int iCycleSound = -1;

    public static boolean isEnableSound() {
        return bEnabledSound;
    }

    public static boolean isEnableVibra() {
        return bEnabledVibra;
    }

    public static final void setEnabledSound(boolean bl) {
        bEnabledSound = bl;
        if (!Snd.isEnableSound()) {
            Snd.stopCycleSound();
            Snd.stopAllSounds();
        }
    }

    public static final void setEnableVibra(boolean bl) {
        bEnabledVibra = bl;
    }

    public static void stopAllSounds() {
        try {
            if (iLastSound >= 0) {
                players[iLastSound].stop();
                lSoundDelay = 0L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadSounds() {
        for (int i = 0; i < 1; ++i) {
            if (massSoundTypes[i] != 1) continue;
            Snd.sndLoadMidi(i);
        }
    }

    private static final void sndLoadMidi(int n) {
        try {
            if (players[n] == null) {
                Player player;
                DataInputStream dataInputStream = Dev.getFile(n + ".mid");
                if (dataInputStream == null) {
                    return;
                }
                Snd.players[n] = player = Manager.createPlayer((InputStream)dataInputStream, (String)"audio/midi");
                Snd.players[n].realize();
                player.prefetch();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void sndPlay(int n) {
        if (System.currentTimeMillis() - lSoundDelay > 0L) {
            iQuerySoundId = n;
        }
    }

    public static void sndPlayCycle(int n) {
        iCycleSound = n;
    }

    public static void stopCycleSound() {
        iCycleSound = -1;
    }

    public static boolean isPlayCycle() {
        return iCycleSound != -1;
    }

    private static final void playSound(int n) {
        if (n < 0) {
            return;
        }
        if (Snd.isEnableSound() && massSoundTypes[n] == 1 && players[n] != null) {
            Snd.stopAllSounds();
            try {
                players[n].stop();
                players[n].prefetch();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                players[n].setMediaTime(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                players[n].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            lSoundDelay = (long)massSoundDelays[n] + System.currentTimeMillis();
            iLastSound = n;
        }
        if (Snd.isEnableVibra() && massSoundVibra[n]) {
            try {
                Display.getDisplay((MIDlet)M.instance).vibrate(500);
            }
            catch (Exception exception) {
                bEnabledVibra = false;
            }
        }
    }

    public static void update() {
        if (iCycleSound != -1) {
            Snd.sndPlay(iCycleSound);
        }
        if (iQuerySoundId >= 0) {
            Snd.playSound(iQuerySoundId);
            iQuerySoundId = -1;
        }
    }
}

