/*
 * Decompiled with CFR 0.152.
 */
package cycles;

import accessories.Ammo;
import accessories.Bumb;
import cycles.Cycles;
import cycles.Track;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import groups.Group;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TrackableEnemy
extends GNSprite {
    static final int TYPE1 = 0;
    static final int TYPE2 = 1;
    static Vector vectorEnemies;
    static Track trackTemp;
    static TrackableEnemy enemyTemp;
    static Random rndTypes;
    static int maxNotshot;
    static int notShot;
    static int ammoID;
    static int maxAmmoID;
    private static final int trackSP = 10;
    private static boolean testedLastEnemy;
    int type;
    Track track;
    boolean started = false;
    int sp = 15;
    int direction = 0;
    int IDGroup;
    int ammoDir;
    int health = 1;

    public static void create() {
        vectorEnemies = new Vector();
        rndTypes = new Random();
    }

    public static void clean() {
        vectorEnemies = null;
        rndTypes = null;
    }

    public static int randomType() {
        int r = rndTypes.nextInt() % 2;
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static int randomAmmo() {
        if (vectorEnemies.size() == 0) {
            return -1;
        }
        int r = rndTypes.nextInt() % (maxAmmoID + 1);
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static void generate() {
        if (!Cycles.canGenerate) {
            return;
        }
        notShot = 0;
        testedLastEnemy = false;
        Image img = Group.randomImage();
        int width = img.getWidth();
        int height = img.getHeight();
        int type = TrackableEnemy.randomType();
        switch (type) {
            case 0: {
                trackTemp = new Track(2, 1, 10);
                enemyTemp = new TrackableEnemy(0, -(width + 5), 0 - height, img, width, height, trackTemp, 0);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(2, 1, 10);
                enemyTemp = new TrackableEnemy(2, -3 * (width + 5), -10 - height, img, width, height, trackTemp, 0);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(2, 1, 10);
                enemyTemp = new TrackableEnemy(4, -5 * (width + 5), -20 - height, img, width, height, trackTemp, 0);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(2, 1, 10);
                enemyTemp = new TrackableEnemy(6, -7 * (width + 5), -30 - height, img, width, height, trackTemp, 0);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                break;
            }
            case 1: {
                trackTemp = new Track(3, 1, 10);
                enemyTemp = new TrackableEnemy(0, ViewPort.WIDTH + (width + 5), 0 - height, img, width, height, trackTemp, 1);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(3, 1, 10);
                enemyTemp = new TrackableEnemy(2, ViewPort.WIDTH + 3 * (width + 5), -10 - height, img, width, height, trackTemp, 1);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(3, 1, 10);
                enemyTemp = new TrackableEnemy(4, ViewPort.WIDTH + 5 * (width + 5), -20 - height, img, width, height, trackTemp, 1);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
                trackTemp = new Track(3, 1, 10);
                enemyTemp = new TrackableEnemy(6, ViewPort.WIDTH + 7 * (width + 5), -30 - height, img, width, height, trackTemp, 1);
                vectorEnemies.addElement(enemyTemp);
                Game.addElement(enemyTemp);
            }
        }
    }

    public static void cycleAll() {
        if (notShot == 0) {
            ammoID = TrackableEnemy.randomAmmo();
        }
        ++notShot;
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((TrackableEnemy)vectorEnemies.elementAt(j)).cycle();
        }
        TrackableEnemy.testLastEnemyPlace();
    }

    private static void testLastEnemyPlace() {
        if (testedLastEnemy) {
            return;
        }
        if (vectorEnemies.size() == 0) {
            return;
        }
        try {
            TrackableEnemy trackableEnemy = (TrackableEnemy)vectorEnemies.lastElement();
            if (trackableEnemy.getY() > 320) {
                Cycles.canGenerate = true;
                testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawAll(Graphics g) {
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((TrackableEnemy)vectorEnemies.elementAt(j)).draw(g);
        }
    }

    public static void removeEnemy(TrackableEnemy enemy) {
        vectorEnemies.removeElement(enemy);
        Game.removeElement(enemy);
        if (vectorEnemies.size() == 0 && !testedLastEnemy) {
            Cycles.canGenerate = true;
        }
    }

    public TrackableEnemy(int ID, int x, int y, Image img, int width, int height, Track track, int type) {
        super(img, width, height);
        this.IDGroup = ID;
        this.setPosition(x, y);
        this.track = track;
        this.type = type;
        if (type == 0) {
            this.direction = 0;
            this.ammoDir = 13;
        } else {
            this.direction = 8;
            this.ammoDir = 11;
        }
    }

    public void cycle() {
        if (!this.started) {
            if (this.type == 0 && this.getX() > -this.getWidth()) {
                this.started = true;
                this.setPosition(this.getX(), 0);
                this.track.x = this.getX();
                this.track.y = this.getY();
                this.track.tempX = this.getX() * 1000;
                this.track.tempY = this.getY() * 1000;
                maxAmmoID = this.IDGroup;
            } else if (this.type == 1 && this.getX() < ViewPort.WIDTH) {
                this.started = true;
                this.setPosition(this.getX(), 0);
                this.track.x = this.getX();
                this.track.y = this.getY();
                this.track.tempX = this.getX() * 1000;
                this.track.tempY = this.getY() * 1000;
                maxAmmoID = this.IDGroup;
            } else {
                this.move();
            }
            return;
        }
        if (this.collidesWith(Game.player, true)) {
            Game.player.hit(5);
            TrackableEnemy.removeEnemy(this);
            return;
        }
        this.track.cycle();
        this.setPosition(this.track.x, this.track.y);
        if (notShot >= maxNotshot && ammoID == this.IDGroup) {
            notShot = 0;
        }
        if (!ViewPort.isBelongToView(this)) {
            TrackableEnemy.removeEnemy(this);
        }
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generateOnCondition(Bumb.TYPE1, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY());
            TrackableEnemy.removeEnemy(this);
        }
    }

    static {
        maxNotshot = 5;
        notShot = 0;
        maxAmmoID = 0;
    }
}

