/*
 * Decompiled with CFR 0.152.
 */
package game;

import accessories.Ammo;
import accessories.Bonus;
import accessories.Bumb;
import accessories.EnemyHealth;
import cannons.OutInCanon;
import cannons.Ship;
import cycles.AngleEnemy;
import cycles.Cycles;
import cycles.PathEnemey;
import cycles.StoneEnemy;
import cycles.TrackableEnemy;
import game.Drawable;
import game.GameBackGround;
import game.Hero;
import game.Main;
import game.Player;
import game.ResourceLoader;
import game.Score;
import game.Setting;
import game.SoundsPlayer;
import game.Starter;
import game.Tasks;
import game.UpLayer;
import game.ViewPort;
import groups.Group;
import groups.GroupBehavior;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import layers.FanEnemy;
import layers.SKLayer;
import level2.Level2;
import level3.Level3;
import level4.Level4;
import menu.Menu;

public class Game
extends GameCanvas
implements Runnable {
    public static int savedEnemyHealth = -1;
    public static int enemyHealthForSave = -1;
    public static String debugInfo = "";
    public static int[] sin = new int[]{0, 383, 707, 924, 1000, 924, 707, 383, 0, -383, -707, -924, -1000, -924, -707, -383, 0};
    public static int[] cos = new int[]{1000, 924, 707, 383, 0, -383, -707, -924, -1000, -924, -707, -383, 0, 383, 707, 924, 1000};
    public static Vector GameObjects;
    public static Player player;
    public static boolean levelFinished;
    protected boolean playerStarted = true;
    byte pressFireTime = 0;
    protected boolean pressFireDraw = true;
    protected Image imgStart;
    protected Sprite pauseSprite;
    protected Image imgStop;
    public static long TickTime;
    private final int targetCycleTime;
    private long startTime;
    private long endtime;
    private long cycleTime;
    public static Image imgSquare;
    private static int objectsID;
    protected boolean running = false;
    protected boolean paused = false;
    protected boolean viewPauseScreen;
    protected Tasks taskAfterStop;
    protected Score score;
    private byte foregroundTest;
    private int lastX;
    private int lastY;
    private int dx;
    private int dy;
    int enemytype;
    Random rndEnemytype = new Random();
    Random rndGroupLayer = new Random();
    protected int gccounter = 0;
    protected int gameTime;
    boolean saved0;
    boolean saved20;
    boolean saved40;
    boolean saved60;
    boolean saved80;

    public static void addElement(Drawable drawable) {
        drawable.ID = objectsID++;
        GameObjects.addElement(drawable);
        if (objectsID > 100000) {
            objectsID = 0;
        }
    }

    public static void removeElement(Drawable drawable) {
        boolean b = GameObjects.removeElement(drawable);
        System.out.println(GameObjects.size());
    }

    public static int getFrameIndex(int direction) {
        int frame = -1;
        switch (direction) {
            case 10: {
                frame = 0;
                break;
            }
            case 12: {
                frame = 1;
                break;
            }
            case 14: {
                frame = 2;
                break;
            }
            case 4: {
                frame = 1;
                break;
            }
            case 2: {
                frame = 0;
                break;
            }
            case 6: {
                frame = 2;
            }
        }
        return frame;
    }

    public Image getImgStop() {
        return this.imgStop;
    }

    public void loadPauseItem() {
        try {
            Image imgPause = Image.createImage((String)"/pause.png");
            this.pauseSprite = new Sprite(imgPause, imgPause.getWidth() / 2, imgPause.getHeight());
            this.pauseSprite.setPosition(0, ViewPort.HEIGHT - this.pauseSprite.getHeight() + 10);
            this.pauseSprite.setPosition(0, ViewPort.HEIGHT - this.pauseSprite.getHeight());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void load(int gameTime, final int playerHealth, final int weaponBonusValue, int savedEnemy) {
        this.gameTime = gameTime;
        savedEnemyHealth = savedEnemy;
        ResourceLoader rl = new ResourceLoader(27){

            public void load() {
                try {
                    Cycles.canGenerate = true;
                    Group.canGenerate = true;
                    SKLayer.canGenerate = true;
                    Ship.canGenerate = true;
                    StoneEnemy.canGenerate = true;
                    OutInCanon.canGenerate = true;
                    Game.this.loadPauseItem();
                    ++finishedSteps;
                    UpLayer.createLevel1();
                    ++finishedSteps;
                    Bonus.create();
                    ++finishedSteps;
                    GroupBehavior.createBehaviors();
                    ++finishedSteps;
                    GameBackGround.createLevel1();
                    ++finishedSteps;
                    Group.loadLevel1();
                    ++finishedSteps;
                    StoneEnemy.create();
                    ++finishedSteps;
                    PathEnemey.create();
                    ++finishedSteps;
                    TrackableEnemy.create();
                    ++finishedSteps;
                    AngleEnemy.create();
                    ++finishedSteps;
                    Hero.createLevel1();
                    ++finishedSteps;
                    GameObjects = new Vector();
                    player = Player.create();
                    Game.player.health = playerHealth;
                    Game.player.weaponBonusValue = weaponBonusValue;
                    ++finishedSteps;
                    Ammo.createLevel1();
                    ++finishedSteps;
                    Bumb.createLevel1();
                    ++finishedSteps;
                    OutInCanon.create();
                    ++finishedSteps;
                    FanEnemy.load();
                    ++finishedSteps;
                    Ship.createLevel1();
                    ++finishedSteps;
                    SKLayer.create();
                    ++finishedSteps;
                    ++finishedSteps;
                    Game.this.score = new Score();
                    Starter.load();
                    finishedSteps += 5;
                    try {
                        imgSquare = Image.createImage((String)"/square.png");
                        ++finishedSteps;
                        Game.this.imgStart = Image.createImage((String)"/start_mission.png");
                        ++finishedSteps;
                        Game.this.imgStop = Image.createImage((String)"/stop.png");
                        ++finishedSteps;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    System.out.println("finishedSteps:" + finishedSteps);
                    Starter t = new Starter(Game.this);
                    t.start();
                    nextDisplay = t;
                    Game.this.start();
                    Game.this.pause();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        new Thread(rl).start();
    }

    public void clean() {
        this.imgStop = null;
        this.imgStart = null;
        UpLayer.cleanLevel1();
        Bonus.clean();
        GroupBehavior.cleanLevel1();
        GameBackGround.clean();
        Group.clean();
        StoneEnemy.clean();
        PathEnemey.clean();
        TrackableEnemy.clean();
        AngleEnemy.clean();
        Hero.clean();
        GameObjects = null;
        Starter.clean();
        Player.clean();
        player = null;
        Ammo.clean();
        Bumb.clean();
        OutInCanon.clean();
        this.score = null;
        System.gc();
    }

    public Game() {
        super(true);
        this.targetCycleTime = 33;
        this.setFullScreenMode(true);
        levelFinished = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Graphics g = this.getGraphics();
        try {
            while (this.running) {
                if (this.viewPauseScreen) {
                    this.pause();
                    Main.setCurrent((Displayable)Menu.getMenu(2));
                }
                if (this.paused) {
                    try {
                        Game game = this;
                        synchronized (game) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.paused) {
                    Game ex = this;
                    synchronized (ex) {
                        this.wait();
                    }
                }
                this.startTime = System.currentTimeMillis();
                if (this.getWidth() < this.getHeight()) {
                    this.input();
                    this.cycle();
                }
                this.pauseSprite.nextFrame();
                this.render(g);
                this.endtime = System.currentTimeMillis();
                this.cycleTime = this.endtime - this.startTime;
                TickTime = 33L - this.cycleTime;
                if (TickTime > 0L) {
                    Thread.sleep(TickTime);
                }
                this.foregroundTest = (byte)(this.foregroundTest + 1);
                if (this.foregroundTest <= 10) continue;
                if (!Main.isForeground()) {
                    this.viewPauseScreen = true;
                }
                this.foregroundTest = 0;
            }
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
        this.clean();
        this.taskAfterStop.execute();
    }

    public void keyPressed(int key) {
        if (key != 48 && key != 49 && key != 50 && key != 51 && key != 52 && key != 53 && key != 54 && key != 55 && key != 56 && key != 57 && key != 35 && key != 42 && key != 9 && key != 10 && key != 11 && key != 12 && key != 8 && key != 1 && key != 6 && key != 2 && key != 5) {
            this.viewPauseScreen = true;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!Main.testForSupported(this.getWidth(), this.getHeight())) {
            int xOld = x;
            int yOld = y;
            y = xOld;
            x = this.getHeight() - yOld;
            return;
        }
        player.setControlVisible(false);
        if (x >= this.pauseSprite.getX() && x <= this.pauseSprite.getX() + this.pauseSprite.getWidth() && y >= this.pauseSprite.getY() && y <= this.pauseSprite.getY() + this.pauseSprite.getHeight()) {
            this.pause();
            this.viewPauseScreen = true;
        } else {
            this.lastX = x;
            this.lastY = y;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (!Main.testForSupported(this.getWidth(), this.getHeight())) {
            return;
        }
        this.dx = x - this.lastX;
        this.dy = y - this.lastY;
        if (this.getWidth() < this.getHeight()) {
            player.move(this.dx, this.dy);
        } else {
            player.move(-this.dy, this.dx);
        }
        this.dx = 0;
        this.dy = 0;
        this.lastX = x;
        this.lastY = y;
    }

    protected void pointerReleased(int x, int y) {
        if (!Main.testForSupported(this.getWidth(), this.getHeight())) {
            return;
        }
        this.playerStarted = true;
        player.setControlVisible(true);
    }

    public void input() {
        int keyState = this.getKeyStates();
        if (this.playerStarted && !levelFinished) {
            player.input(keyState);
        } else if ((keyState & 0x100) != 0) {
            this.playerStarted = true;
        }
    }

    private void generateEnemies() {
        if (this.gameTime >= 220) {
            Hero.generate();
            return;
        }
        enemyHealthForSave = -1;
        if (this.gameTime > 5) {
            SKLayer.generate();
        }
        if (this.gameTime < 30) {
            Cycles.generate();
        } else if (this.gameTime >= 35 && this.gameTime < 60) {
            if (this.gameTime >= 35 && this.gameTime < 40) {
                Cycles.generate();
            } else {
                Cycles.generate();
                StoneEnemy.generate();
            }
        } else if (this.gameTime >= 65 && this.gameTime < 90) {
            if (this.gameTime >= 65 && this.gameTime < 70) {
                Ship.generate();
            } else {
                StoneEnemy.generate();
                Ship.generate();
            }
        } else if (this.gameTime >= 95 && this.gameTime < 120) {
            Group.generate();
        } else if (this.gameTime >= 125 && this.gameTime < 150) {
            if (this.gameTime >= 125 && this.gameTime < 130) {
                StoneEnemy.generate();
            } else {
                StoneEnemy.generate();
                Group.generate();
            }
        } else if (this.gameTime >= 155 && this.gameTime < 180) {
            if (this.gameTime >= 155 && this.gameTime < 160) {
                OutInCanon.generate();
            } else {
                OutInCanon.generate();
                Cycles.generate();
            }
        } else if (this.gameTime >= 185 && this.gameTime < 210) {
            if (this.gameTime >= 185 && this.gameTime < 190) {
                Ship.generate();
            } else {
                Ship.generate();
                Cycles.generate();
            }
        }
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public void setGameTime(int gameTime) {
        this.gameTime = gameTime;
    }

    protected void cyclePressFire() {
        this.pressFireTime = (byte)(this.pressFireTime + 1);
        if (this.pressFireTime > 5) {
            this.pressFireTime = 0;
            this.pressFireDraw = !this.pressFireDraw;
        }
    }

    public void cycle() {
        ++this.gccounter;
        if (this.gccounter == 20) {
            if (this.gameTime < 220 && this.playerStarted) {
                ++this.gameTime;
            }
            System.gc();
            this.gccounter = 0;
        }
        if (!this.playerStarted) {
            this.cyclePressFire();
        } else if (!levelFinished) {
            this.generateEnemies();
        }
        UpLayer.cycle();
        GameBackGround.cycle();
        Group.cycleAll();
        StoneEnemy.cycleAll();
        Bonus.cycleAll();
        PathEnemey.cycleAll();
        TrackableEnemy.cycleAll();
        AngleEnemy.cycleAll();
        Hero.cycleAll();
        player.cycle();
        if (this.playerStarted && !levelFinished) {
            player.fire();
        }
        OutInCanon.cycleAll();
        Ship.cycleAll();
        FanEnemy.cycleAll();
        SKLayer.cycleAll();
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        debugInfo = "" + used;
        Ammo.cycleAll();
        Bumb.cycleAll();
    }

    public void render(Graphics g) {
        if (this.getWidth() > this.getHeight()) {
            this.renderNotSupported(g);
            return;
        }
        this.setFullScreenMode(true);
        g.setClip(0, 0, ViewPort.WIDTH, ViewPort.HEIGHT);
        g.setColor(921097);
        g.fillRect(0, 0, ViewPort.WIDTH, ViewPort.HEIGHT);
        GameBackGround.draw(g);
        SKLayer.drawAll(g);
        FanEnemy.drawAll(g);
        Group.drawAll(g);
        PathEnemey.drawAll(g);
        TrackableEnemy.drawAll(g);
        AngleEnemy.drawAll(g);
        Hero.drawAll(g);
        player.draw(g);
        OutInCanon.drawAll(g);
        Ship.drawAll(g);
        StoneEnemy.drawAll(g);
        Ammo.drawAll(g);
        Bumb.drawAll(g);
        Bonus.drawAll(g);
        EnemyHealth.drawAll(g);
        UpLayer.draw(g);
        this.drawScore(g);
        if (!this.playerStarted && this.pressFireDraw) {
            g.drawImage(this.imgStart, this.getWidth() / 2 - this.imgStart.getWidth() / 2, this.getHeight() / 2, 20);
        }
        this.pauseSprite.paint(g);
        this.flushGraphics();
    }

    public void renderNotSupported(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.imgStop, this.getWidth() / 2 - this.imgStop.getWidth() / 2, this.getHeight() / 2 - this.imgStop.getHeight() / 2, 20);
        this.flushGraphics();
    }

    public void drawScore(Graphics g) {
        g.setColor(15862834);
        if (this.gameTime >= 210) {
            this.score.draw(g, 99);
        } else {
            int ss = this.gameTime * 100 / 210;
            if (ss == 0 && !this.saved0) {
                this.save();
                System.out.println("Save");
                this.saved0 = true;
            } else if (ss == 20 && !this.saved20) {
                this.save();
                System.out.println("Save");
                this.saved20 = true;
            } else if (ss == 40 && !this.saved40) {
                this.save();
                System.out.println("Save");
                this.saved40 = true;
            } else if (ss == 60 && !this.saved60) {
                this.save();
                System.out.println("Save");
                this.saved60 = true;
            } else if (ss == 80 && !this.saved80) {
                this.save();
                System.out.println("Save");
                this.saved80 = true;
            }
            this.score.draw(g, this.gameTime * 100 / 210);
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.paused = false;
        this.viewPauseScreen = false;
        Game game = this;
        synchronized (game) {
            this.notify();
        }
    }

    public void stop() {
        this.running = false;
    }

    private void save() {
        Setting.playerHealth = Game.player.health;
        Setting.gameTime = this.gameTime;
        Setting.weaponBonusValue = Game.player.weaponBonusValue;
        Setting.enemyHealth = enemyHealthForSave;
        Setting.SavedLevel = this instanceof Level2 ? (byte)1 : (this instanceof Level3 ? (byte)2 : (this instanceof Level4 ? (byte)3 : (byte)0));
        Setting.Save();
    }

    public void stopAndViewMainMenu() {
        if (this.paused) {
            this.restart();
        }
        this.taskAfterStop = Tasks.LoadMenu();
        this.stop();
    }

    public void gameOver() {
        if (this.paused) {
            this.restart();
        }
        this.taskAfterStop = Tasks.failureSplash();
        this.stop();
    }

    public void sucess() {
        SoundsPlayer.getInstance().successSound();
        if (this.paused) {
            this.restart();
        }
        this.taskAfterStop = Tasks.successSplash(this.getStringImageLevelCompleted());
        this.stop();
    }

    private String getStringImageLevelCompleted() {
        String str = null;
        if (this instanceof Level2) {
            str = "/level-2.png";
        } else if (this instanceof Level3) {
            str = "/level-3.png";
        } else if (this instanceof Level4) {
            str = "/level-4.png";
        } else if (this instanceof Game) {
            str = "/level-1.png";
        }
        return str;
    }

    static {
        levelFinished = true;
        TickTime = 50L;
        objectsID = 0;
    }
}

