/*
 * Decompiled with CFR 0.152.
 */
package level2;

import game.ViewPort;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.TiledLayer;
import level2.Level2;

public class SquaresLayerLevel2 {
    private static Vector vecLayers;
    private static int sp;
    private static int[] indexes;
    private static Random random;
    private static final int COLUMNS = 8;
    private static final int ROWS = 12;

    public static void create() {
        vecLayers = new Vector();
        random = new Random();
    }

    public static void clean() {
        vecLayers = null;
        random = null;
    }

    public static void draw(Graphics g) {
        TiledLayer temp = null;
        for (int j = 0; j < vecLayers.size(); ++j) {
            temp = (TiledLayer)vecLayers.elementAt(j);
            temp.paint(g);
        }
    }

    public static void cycle() {
        TiledLayer temp = null;
        for (int j = vecLayers.size() - 1; j >= 0; --j) {
            temp = (TiledLayer)vecLayers.elementAt(j);
            temp.setPosition(temp.getX(), temp.getY() + sp);
            if (temp.getY() <= ViewPort.HEIGHT) continue;
            vecLayers.removeElement(temp);
        }
        try {
            temp = (TiledLayer)vecLayers.lastElement();
        }
        catch (NoSuchElementException noe) {
            SquaresLayerLevel2.addLayer();
            return;
        }
        if (temp.getY() > 0) {
            SquaresLayerLevel2.addLayer();
        }
    }

    private static void addLayer() {
        TiledLayer temp = SquaresLayerLevel2.getNewLayer();
        temp.setPosition(ViewPort.WIDTH / 2 - temp.getWidth() / 2, -temp.getHeight());
        vecLayers.addElement(temp);
    }

    private static TiledLayer getNewLayer() {
        int[][] map = new int[8][12];
        TiledLayer temp = new TiledLayer(8, 12, Level2.imgSquare, Level2.imgSquare.getWidth(), Level2.imgSquare.getHeight());
        int l = random.nextInt(5);
        switch (l) {
            case 0: {
                SquaresLayerLevel2.setLayer0(temp);
                break;
            }
            case 1: {
                SquaresLayerLevel2.setLayer1(temp);
                break;
            }
            case 2: {
                SquaresLayerLevel2.setLayer2(temp);
                break;
            }
            case 3: {
                SquaresLayerLevel2.setLayer3(temp);
                break;
            }
            case 4: {
                SquaresLayerLevel2.setLayer4(temp);
            }
        }
        return temp;
    }

    private static void setLayer0(TiledLayer temp) {
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (i == 0 || i == 11) {
                    temp.setCell(j, i, 0);
                    continue;
                }
                if (j == 7) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 6) {
                    if (i == 0 || i == 9) {
                        temp.setCell(j, i, 0);
                        continue;
                    }
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 5) {
                    if (i == 3 || i == 4) {
                        temp.setCell(j, i, 1);
                        continue;
                    }
                    temp.setCell(j, i, 0);
                    continue;
                }
                if (j == 4) {
                    if (i == 4) {
                        temp.setCell(j, i, 1);
                        continue;
                    }
                    temp.setCell(j, i, 0);
                    continue;
                }
                temp.setCell(j, i, 0);
            }
        }
    }

    private static void setLayer1(TiledLayer temp) {
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (i == 0 || i == 11) {
                    temp.setCell(j, i, 0);
                }
                if (i == 1 || i == 2) {
                    if (j != 2) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (i == 3) {
                    if (j != 2 && j != 1) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (i == 4 || i == 5 || i == 6 || i == 7) {
                    if (j != 0 && j != 1) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (i == 8 || i == 9) {
                    if (j == 0 || j == 1) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (i != 10 || j != 2 && j != 3) continue;
                temp.setCell(j, i, 1);
            }
        }
    }

    private static void setLayer2(TiledLayer temp) {
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (i == 0 || i == 1 || i == 2 || i == 10 || i == 11) {
                    temp.setCell(j, i, 0);
                    continue;
                }
                if (j == 7) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 6) {
                    if (i != 4 && i != 5 && i != 6) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 5 && i == 5) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j != 4 || i != 5) continue;
                temp.setCell(j, i, 1);
            }
        }
    }

    private static void setLayer3(TiledLayer temp) {
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (i == 0 || i == 1 || i == 2 || i == 10 || i == 11) {
                    temp.setCell(j, i, 0);
                    continue;
                }
                if (j == 0) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 1) {
                    if (i != 4 && i != 5 && i != 6) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 2 && i == 5) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j != 3 || i != 5) continue;
                temp.setCell(j, i, 1);
            }
        }
    }

    private static void setLayer4(TiledLayer temp) {
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (i == 0 || i == 1 || i == 2 || i == 3 || i == 9 || i == 10 || i == 11) {
                    temp.setCell(j, i, 0);
                    continue;
                }
                if (j == 7) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 6) {
                    if (i != 7 && i != 5 && i != 6) continue;
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j == 5 && i == 6) {
                    temp.setCell(j, i, 1);
                    continue;
                }
                if (j != 4 || i != 6) continue;
                temp.setCell(j, i, 1);
            }
        }
    }

    static {
        sp = 3;
        indexes = new int[]{0, 1, 0};
    }
}

