/*
 * Decompiled with CFR 0.152.
 */
package level3;

import accessories.Ammo;
import accessories.Bumb;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CircleGroup {
    private Image[] arrImages;
    private Vector vecEnemies;
    private Random random;
    private boolean canGenerate = true;
    private boolean testedLastEnemy;

    public CircleGroup(Image[] arrImages) {
        this.arrImages = arrImages;
        this.vecEnemies = new Vector();
        this.random = new Random();
    }

    private CircleEnemy getRndEnemy() {
        CircleEnemy circleEnemy = null;
        int index = this.random.nextInt(2);
        switch (index) {
            case 0: {
                circleEnemy = new CircleEnemy(this.arrImages[0], this.arrImages[0].getWidth() / 3, this.arrImages[0].getHeight());
                break;
            }
            case 1: {
                circleEnemy = new CircleEnemy(this.arrImages[1], this.arrImages[1].getWidth() / 8, this.arrImages[1].getHeight() / 2);
            }
        }
        return circleEnemy;
    }

    public void generate() {
        if (!this.canGenerate) {
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        int rn = this.random.nextInt(2);
        rn = 1;
        CircleEnemy temp = null;
        switch (rn) {
            case 0: {
                temp = this.getRndEnemy();
                temp.setPosition(ViewPort.WIDTH / 2, -temp.getHeight());
                Game.addElement(temp);
                this.vecEnemies.addElement(temp);
                break;
            }
            case 1: {
                temp = this.getRndEnemy();
                temp.setPosition(30, -temp.getHeight());
                this.vecEnemies.addElement(temp);
                Game.addElement(temp);
                temp = this.getRndEnemy();
                temp.setPosition(ViewPort.WIDTH - temp.getWidth() - 50, -temp.getHeight());
                this.vecEnemies.addElement(temp);
                Game.addElement(temp);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void cycle() {
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
            return;
        }
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((CircleEnemy)this.vecEnemies.elementAt(j)).cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            CircleEnemy circleEnemy = (CircleEnemy)this.vecEnemies.lastElement();
            if (circleEnemy.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((CircleEnemy)this.vecEnemies.elementAt(j)).paint(g);
        }
    }

    void removeEnemy(CircleEnemy enemy) {
        Game.removeElement(enemy);
        this.vecEnemies.removeElement(enemy);
    }

    class CircleEnemy
    extends GNSprite {
        int spY = 5;
        int spX = 2;
        int dx = 0;
        int changeCounter = 0;
        private int helath = 4;

        public CircleEnemy(Image img, int width, int height) {
            super(img, width, height);
        }

        void cycle() {
            if (this.collidesWith(Game.player, true)) {
                CircleGroup.this.removeEnemy(this);
                Game.player.hit(5);
                Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
                return;
            }
            if (this.exitedView()) {
                CircleGroup.this.removeEnemy(this);
                return;
            }
            this.move();
            this.nextFrame();
        }

        boolean exitedView() {
            return this.getY() > ViewPort.HEIGHT;
        }

        public void hit(Ammo am) {
            this.helath -= am.type.healthEffect;
            if (this.helath <= 0) {
                Bumb.generate(Bumb.TYPE3, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE3.width) / 2, this.getY() + Math.abs(this.getHeight() - Bumb.TYPE3.height) / 2);
                CircleGroup.this.removeEnemy(this);
            }
        }

        void move() {
            this.setPosition(this.getX(), this.getY() + this.spY);
            if (this.changeCounter == 0) {
                this.changeCounter = 20;
                if (this.getX() < 0) {
                    this.dx = this.spX;
                    this.setPosition(0, this.getY());
                } else if (this.getX() + this.getWidth() > ViewPort.WIDTH) {
                    this.dx = -this.spX;
                    this.setPosition(ViewPort.WIDTH - this.getWidth(), this.getY());
                } else {
                    int rn = CircleGroup.this.random.nextInt(2);
                    this.dx = rn == 0 ? this.spX : -this.spX;
                }
            } else {
                --this.changeCounter;
            }
            this.setPosition(this.getX() + this.dx, this.getY());
        }
    }
}

